﻿Imports System
Imports System.Windows.Interop
Imports System.Runtime.InteropServices
Imports WCSDK2

Class MainWindow

    Enum WCS_RTN
        WCSDK_RTN_SUCESS = &H0
        WCSDK_SCANNER_INIT_ERROR = &H1
        WCSDK_KERNEL_INIT_ERROR = &H2
        WCSDK_LICENSE_CODE_ERROR = &H3
        WCSDK_RTN_LIB_MISS = &H4
        WCSDK_OVER30DAY = &H5
        WCSDK_OVER_TIME_LIMIT = &H6
        WCSDK_RECOGIN_FAIL = &H7
        WCSDK_CANCEL_BY_USER = &H8
        WCSDK_SCANNER_DEVICE_NOT_EXIST = &H9
        WCSDK_SCANNER_PAPER_NOT_EXIST = &HA
        WCSDK_SCANNER_DEVICE_NOT_FOUND = &HB
        WCSDK_SCANNER_LIB_LOAD_FAIL = &HC
        WCSDK_SCANNER_DRIVER_NOT_INSTALL = &HD
        WCSDK_SCANNER_CALIBRATE_NEEDED = &HE
        WCSDK_SCANNER_MANAGER_NOT_FOUND = &HF
        WCSDK_SCANNER_MANAGER_COM_ERROR = &H10
        WCSDK_SCANNER_MODULE_INIT_ERROR = &H11
        WCSDK_PRODUCT_NOT_SUPPORT = &H12
        WCSDK_SCANNER_BUSY = &H13
        WCSDK_SCANNER_SCAN_FINISH = &H15
        WCSDK_SCANNER_CALIBRATE_FAIL = &H16
        WCSDK_WORLDCARD_NOT_EXIST = &H17
        WCSDK_BUSY = &H18
        WCSDK_PAPER_JAM = &H19
        WCSDK_INTERNEL_ERROR = &H1A
        WCSDK_CARD_IMAGE_NOT_BE_SCANNED = &H1B
        WCSDK_KEYPRO_ERR = &H1C
        WCSDK_REGGED_ERR = &H1D
    End Enum

    Enum RecogCharset
        PP_CHARSET_CHINESE_AUTO = &H4
        PP_CHARSET_CHINESE_TAIWAN = &H404
        PP_CHARSET_CHINESE_PRC = &H804
        PP_CHARSET_CHINESE_HK = &HC04
        PP_CHARSET_JAPANESE = &H411
        PP_CHARSET_KOREAN = &H412
        PP_CHARSET_ENGLISH_AUTO = &H9
        PP_CHARSET_ENGLISH_USA = &H409
        PP_CHARSET_ENGLISH_UK = &H809
        PP_CHARSET_ENGLISH_AUSTRALIAN = &HC09
        PP_CHARSET_ENGLISH_CANADIAN = &H1009
        PP_CHARSET_ENGLISH_IRELAND = &H1809
        PP_CHARSET_ENGLISH_MEXICO = &H4009
        PP_CHARSET_ENGLISH_NORTH_AMERICA = &H4409
        PP_CHARSET_ENGLISH_EAST_ASIA = &H5009
        PP_CHARSET_ENGLISH_HONGKONG = &H5409
        PP_CHARSET_ENGLISH_TAIWAN = &H5809
        PP_CHARSET_ENGLISH_PRC = &H5C09
        PP_CHARSET_ENGLISH_JAPAN = &H6009
        PP_CHARSET_ENGLISH_KOREA = &H6409
        PP_CHARSET_ENGLISH_SIGA_MALY = &H7009
        PP_CHARSET_ENGLISH_SINGAPORE = &H7409
        PP_CHARSET_ENGLISH_MALAYSIA = &H7809
        PP_CHARSET_ENGLISH_INDONESIA = &H7C09
        PP_CHARSET_ENGLISH_INDIA = &H8009
        PP_CHARSET_ENGLISH_RUSSIA = &H8409
        PP_CHARSET_ENGLISH_TURKEY = &H8809
        PP_CHARSET_ENGLISH_THAILAND = &H8C09
        PP_CHARSET_ENGLISH_ARAB = &H9009
        PP_CHARSET_ENGLISH_IRAN = &H9409
        PP_CHARSET_ENGLISH_IRAG = &H9809
        PP_CHARSET_ENGLISH_OMAN = &H9C09
        PP_CHARSET_ENGLISH_SUDAN = &HA009
        PP_CHARSET_ENGLISH_EGYPT = &HA409
        PP_CHARSET_GERMAN_AUTO = &H7
        PP_CHARSET_GERMAN_GERMANY = &H407
        PP_CHARSET_GERMAN_SWITZERLAND = &H807
        PP_CHARSET_FRENCH_AUTO = &HC
        PP_CHARSET_FRENCH_FRANCE = &H40C
        PP_CHARSET_FRENCH_CANADA = &HC0C
        PP_CHARSET_ITALIAN_AUTO = &H10
        PP_CHARSET_ITALIAN_ITALY = &H410
        PP_CHARSET_SPANISH_AUTO = &HA
        PP_CHARSET_SPANISH_SPAIN = &H40A
        PP_CHARSET_SPANISH_MEXICO = &H80A
        PP_CHARSET_NORWEGIAN_AUTO = &H14
        PP_CHARSET_NORWEGIAN_NORWAY = &H414
        PP_CHARSET_HUNGARIAN_AUTO = &HE
        PP_CHARSET_HUNGARIAN_HUNGARY = &H40E
        PP_CHARSET_POLISH_AUTO = &H15
        PP_CHARSET_POLISH_POLAND = &H415
        PP_CHARSET_SWEDISH_AUTO = &H1D
        PP_CHARSET_SWEDISH_SWEDEN = &H41D
        PP_CHARSET_DANISH_AUTO = &H6
        PP_CHARSET_DANISH_DENMARK = &H406
        PP_CHARSET_FINNISH_AUTO = &HB
        PP_CHARSET_FINNISH_FINLAND = &H40B
        PP_CHARSET_DUTCH_AUTO = &H13
        PP_CHARSET_DUTCH_NETHERLAND = &H413
        PP_CHARSET_TURKISH_AUTO = &H1F
        PP_CHARSET_TURKISH = &H41F
        PP_CHARSET_PORTUGUESE_AUTO = &H16
        PP_CHARSET_PORTUGUESE_BRAZIL = &H416
        PP_CHARSET_PORTUGUESE_PORTUGAL = &H816
        PP_CHARSET_EASTEUROPE_AUTO = &H80
        PP_CHARSET_WESTEUROPE_AUTO = &H81
        PP_CHARSET_RUSSIAN = &H419
        PP_CHARSET_GREEK = &H408
        PP_CHARSET_CZECH = &H405
        PP_CHARSET_SLOVAK = &H41B
        PP_CHARSET_ARABIC = &H401
        PP_CHARSET_THAILAND = &H1054
    End Enum

    Dim m_App As WCSDK2.IIApplication
    Dim m_hWnd As IntPtr = IntPtr.Zero
    Private Sub SetScanFileName()
        Dim strPath As String = System.Environment.GetFolderPath(Environment.SpecialFolder.Desktop)
        Dim nIdx As Integer = 1
        Dim strFile As String

        While True

            strFile = strPath + "\" + nIdx.ToString() + ".jpg"

            If System.IO.File.Exists(strFile) = False Then
                Exit While
            End If

            nIdx += 1

        End While

        tbFile.Text = strFile
    End Sub

    Private Sub SetHWND()
        Dim helper As WindowInteropHelper = New WindowInteropHelper(MainDlg)
        m_hWnd = helper.Handle
    End Sub

    Private Sub SetErrorMsg(rtn As WCS_RTN)
        SetMessage(rtn.ToString())
    End Sub

    Private Sub SetMessage(strMsg As String)
        tbMsg.Content = "Return Msg: " + strMsg
    End Sub

    Private Sub Window_Loaded(sender As System.Object, e As System.Windows.RoutedEventArgs)
        SetHWND()
        SetScanFileName()
    End Sub

    Private Sub Window_Unloaded(sender As System.Object, e As System.Windows.RoutedEventArgs)

    End Sub

    Private Sub Window_Closed(sender As System.Object, e As System.EventArgs)

        If m_App IsNot Nothing Then

            m_App.UnInitSDK()
            While Marshal.ReleaseComObject(m_App) > 0
            End While
            m_App = Nothing
        End If

    End Sub

    Private Sub BtnStart_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)
        SetMessage("")
        If m_App Is Nothing Then

            Try
                m_App = New IApplication
            Catch
                MessageBox.Show("WCSDK2W8_CUSTOM.IApplication NOT FOUND, May be Worldcard no install")
                Return
            End Try

        End If

        If String.IsNullOrEmpty(serailBox.Text) Or serailBox.Text.Length < 30 Then
            MessageBox.Show("Please input correct serial code.", "Penpower", MessageBoxButton.OK, MessageBoxImage.Warning, MessageBoxResult.OK, MessageBoxOptions.DefaultDesktopOnly)
        Else

            Dim szCode As String = serailBox.Text
            Dim nRtn As Integer = m_App.InitSDK(szCode, "OEM_SCANX", "Your Product Name", CType(m_hWnd, Integer))
            SetErrorMsg(CType(nRtn, WCS_RTN))

        End If

    End Sub

    Private Sub BtnStartKeyPro_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)
        SetMessage("")
        If m_App Is Nothing Then

            Try
                m_App = New IApplication
            Catch
                MessageBox.Show("WCSDK2W8_CUSTOM.IApplication NOT FOUND, May be Worldcard no install")
                Return
            End Try

        End If

        Dim nRtn As Integer = m_App.InitSDKByKeyPro("OEM_SCANX", "Your Product Name", CType(m_hWnd, Integer))
        SetErrorMsg(CType(nRtn, Integer))
    End Sub

    Private Sub BtnScan_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)
        SetMessage("")
        If m_App IsNot Nothing Then

            Dim nRtn As Integer = m_App.ScanCardtoMemory(1, tbFile.Text)
            SetErrorMsg(CType(nRtn, WCS_RTN))
            SetScanFileName()

        End If
    End Sub

    Private Sub BtnScanOnWnd_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)
        SetMessage("")
        If m_App IsNot Nothing Then

            Dim left As Double = Canvas.GetLeft(rcPic)
            Dim top As Double = Canvas.GetTop(rcPic)
            Dim nRtn As Integer = m_App.ScanCardtoMemoryOnWnd(1, tbFile.Text, CType(m_hWnd, Integer), CType(left, Integer), CType(top, Integer), CType(left + rcPic.ActualWidth, Integer), CType(top + rcPic.ActualHeight, Integer))
            SetErrorMsg(CType(nRtn, WCS_RTN))
            SetScanFileName()

        End If
    End Sub

    Private Sub BtnCalibrate_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)
        If m_App IsNot Nothing Then

            Dim nRtn As Integer = m_App.CalibrateScanner()
            SetErrorMsg(CType(nRtn, WCS_RTN))

        End If
    End Sub

    Private Sub BtnEnd_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)

        SetMessage("")
        If m_App IsNot Nothing Then

            Try
                m_App.UnInitSDK()
                m_App = Nothing
                SetMessage("Success End")
            Catch
                SetMessage("Fail")
            End Try

        End If

    End Sub

    Private Sub BtnGetLang_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)

        If m_App IsNot Nothing Then

            Dim nCount As Integer = m_App.CharSetCount

            For i As UInt32 = 0 To nCount - 1 Step 1

                Dim uCharset As UShort = m_App.CharSetInSeq(i)
                Dim rc As RecogCharset = CType(uCharset, RecogCharset)
                If rc = Nothing Then
                    cbLang.Items.Add(uCharset.ToString())
                Else
                    cbLang.Items.Add(rc.ToString())
                End If

            Next

            If cbLang.Items.Count > 0 Then
                cbLang.SelectedIndex = 0
            End If

        End If

    End Sub

    Private Sub BtnRecog_Click(sender As System.Object, e As System.Windows.RoutedEventArgs)

        If m_App IsNot Nothing Then

            Dim strSel As String = CType(cbLang.SelectedValue, String)
            Dim rc As RecogCharset
            [Enum].TryParse(Of RecogCharset)(strSel, rc)

            If rc <> Nothing Then

                m_App.SetFieldLayout(6)
                tbResult.Text = ""
                Dim nRtn As WCS_RTN = CType(m_App.RecogCard("", CType(rc, UShort), 1, &H804, 1), WCS_RTN)
                Dim strResout As String = ""
                If nRtn = WCS_RTN.WCSDK_RTN_SUCESS Then

                    Dim nCount As Integer = m_App.FieldCount
                    For i As Integer = 0 To nCount - 1 Step 1
                        Dim strField As String = m_App.FieldString(i)
                        Dim nType As Integer = m_App.FieldType(i)
                        strResout += String.Format("{0}={1}\r\n", nType.ToString(), strField)
                    Next

                    tbResult.Text = strResout
                    tbResult.UpdateLayout()

                End If

            End If

        End If

    End Sub

    Private Sub serailBox_PreviewGotKeyboardFocus(sender As System.Object, e As System.Windows.Input.KeyboardFocusChangedEventArgs)
        serailBox.Text = ""
        serailBox.Foreground = Brushes.Black
    End Sub

    Private Sub CheckRegister_Click(sender As Object, e As RoutedEventArgs)
        Dim ProductRegisterKey As String

        If m_App Is Nothing Then

            Try
                m_App = New IApplication
            Catch
                MessageBox.Show("WCSDK2W8_CUSTOM.IApplication NOT FOUND, May be Worldcard no install")
                Return
            End Try

        End If
        ProductRegisterKey = "WCSDK"
        Dim nRtn As Integer = m_App.DoCheckLocalRegisterFileOK("OEM_SCANX", "Your Product Name", CType(m_hWnd, Integer), Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\Penpower\\" + ProductRegisterKey + "\\WorldCardSync.wreg")
        SetErrorMsg(CType(nRtn, WCS_RTN))



    End Sub
End Class
