﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using WCSDK2;
using System.Windows.Interop;
using WCSDKDefine;
using System.Runtime.InteropServices;
namespace VCS
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        WCSDK2.IApplication m_App;
        IntPtr m_hWnd = (IntPtr)(0);
        public MainWindow()
        {
            InitializeComponent();            
            SetScanFileName();
        }
        private void SetScanFileName()
        {
            string strPath = System.Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
            int nIdx = 1;
            string strFile;
            while (true)
            {
                strFile = strPath + "\\" + nIdx.ToString() + ".jpg";
                if (System.IO.File.Exists(strFile) == false)
                {
                    break;
                }
                nIdx++;
            }
            tbFile.Text = strFile;
        }
        protected override void OnSourceInitialized(EventArgs e)
        {
            base.OnSourceInitialized(e);
            HwndSource hSource = PresentationSource.FromVisual(this) as HwndSource;
            WindowInteropHelper helper = new WindowInteropHelper(this);
            m_hWnd = helper.Handle;
        }
        void SetErrorMsg(WCSDKDefine.WCS_RTN rtn)
        {
            SetMessage(rtn.ToString());
        }
        void SetMessage(string strMsg)
        {
            tbMsg.Content = "Return Msg: " + strMsg;
        }
        private void BtnStart_Click(object sender, RoutedEventArgs e)
        {
            SetMessage("");
            if( m_App == null)
            {
                try
                {
                    m_App = new IApplication();
                }
                catch
                {
                    MessageBox.Show("WCSDK2W8_CUSTOM.IApplication NOT FOUND, May be Worldcard no install");
                    return;
                }
            }
            if (string.IsNullOrEmpty(serailBox.Text) || serailBox.Text.Length < 30)
            {
                MessageBox.Show("Please input correct serial code.", "Penpower", MessageBoxButton.OK, MessageBoxImage.Warning, MessageBoxResult.OK, MessageBoxOptions.DefaultDesktopOnly);
            }
            else
            {
                string szCode = serailBox.Text;
                int nRtn = m_App.InitSDK(szCode, "OEM_SCANX", "Your Product Name", (int)m_hWnd);
                SetErrorMsg((WCS_RTN)nRtn);
            }
        }

        private void BtnStartKeyPro_Click(object sender, RoutedEventArgs e)
        {
            SetMessage("");
            if (m_App == null)
            {
        
                try
                {
                    m_App = new IApplication();
                }
                catch
                {
                    MessageBox.Show("WCSDK2W8_CUSTOM.IApplication NOT FOUND, May be Worldcard no install");
                    return;
                }
            }
            int nRtn = m_App.InitSDKByKeyPro("OEM_SCANX", "Your Product Name", (int)m_hWnd);
            SetErrorMsg((WCS_RTN)nRtn);
            
        }

        private void BtnScan_Click(object sender, RoutedEventArgs e)
        {
            SetMessage("");
            if (m_App != null)
            {
                int nRtn = m_App.ScanCardtoMemory(1, tbFile.Text);
                SetErrorMsg((WCS_RTN)nRtn);
                SetScanFileName();
            }
        }

        private void BtnScanOnWnd_Click(object sender, RoutedEventArgs e)
        {
            SetMessage("");
            if (m_App != null)
            {
                double left = Canvas.GetLeft(rcPic);
                double top = Canvas.GetTop(rcPic) + 50;
                int nRtn = m_App.ScanCardtoMemoryOnWnd(1, tbFile.Text, (int)m_hWnd, (int)left,(int)top, (int)(left + rcPic.ActualWidth), (int)(top + rcPic.ActualHeight));
                SetErrorMsg((WCS_RTN)nRtn);
                SetScanFileName();
            }
        }

        private void BtnCalibrate_Click(object sender, RoutedEventArgs e)
        {
            if (m_App != null)
            {

                int nRtn = m_App.CalibrateScanner();
                SetErrorMsg((WCS_RTN)nRtn);
            }
        }

        private void BtnEnd_Click(object sender, RoutedEventArgs e)
        {
            SetMessage("");
            if (m_App != null)
            {
                try
                {
                    m_App.UnInitSDK();
                    m_App = null;
                    SetMessage("Success End");
                }
                catch
                {
                    SetMessage("Fail");
                }
            }

        }

        private void BtnGetLang_Click(object sender, RoutedEventArgs e)
        {
            if (m_App != null)
            {

                int nCount = m_App.CharSetCount;
                for (uint i = 0; i < nCount; i++)
                {
                    ushort uCharset = m_App.get_CharSetInSeq(i);
                    RecogCharset rc = (RecogCharset)uCharset ;
                    if (rc == null)
                    {
                        cbLang.Items.Add(uCharset.ToString());
                    }
                    else
                        cbLang.Items.Add(rc.ToString());
                        
                }
                if (cbLang.Items.Count > 0)
                    cbLang.SelectedIndex = 0;
                

            }
        }

        private void BtnRecog_Click(object sender, RoutedEventArgs e)
        {
            if (m_App != null)
            {

                string strSel = (string)cbLang.SelectedValue;
                
                RecogCharset rc;
                Enum.TryParse<RecogCharset>(strSel, out rc);
                if (rc != null)
                {
                    m_App.SetFieldLayout(6);
                    tbResult.Text ="";
                    WCS_RTN Rtn = (WCS_RTN)m_App.RecogCard("", (ushort)rc, 1, 0x0804, 1);
                    string strResout = "";
                    if (Rtn == WCS_RTN.WCSDK_RTN_SUCESS)
                    {
                        int nCount = m_App.FieldCount;
                        for (int i = 0; i < nCount; i++)
                        {
                            string strField = m_App.get_FieldString(i);
                            int nType = m_App.get_FieldType(i);
                            strResout += string.Format("{0}={1}\r\n", nType.ToString(), strField);

//                            strResout += nType.ToString() 
                        }
                        tbResult.Text = strResout;
                        tbResult.UpdateLayout();

                    }
                }

            }
        }

        private void Window_Unloaded(object sender, RoutedEventArgs e)
        {

            
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            if (m_App != null)
            {
                m_App.UnInitSDK();
                while (Marshal.ReleaseComObject(m_App) > 0) { }
                m_App = null;
            }
        }        

        private void serailBox_PreviewGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            serailBox.Text = "";
            serailBox.Foreground = Brushes.Black;
        }
        public static string ProductRegisterKey
        {
            get
            {
                return "WCSDK";
            }
        }
        private void Initial_Regged_Click(object sender, RoutedEventArgs e)
        {
            if (m_App == null)
            {
              
                    try
                    {
                        m_App = new IApplication();
                    }
                    catch
                    {
                        MessageBox.Show("WCSDK2W8_CUSTOM.IApplication NOT FOUND, May be Worldcard no install");
                        return;
                    }
            }
            int nRtn = m_App.DoCheckLocalRegisterFileOK("OEM_SCANX", "Your Product Name", (int)m_hWnd, Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\Penpower\\" + ProductRegisterKey + "\\WorldCardSync.wreg");
            SetErrorMsg((WCS_RTN)nRtn);
          
        }
    }
}
