CREATE TABLE device
(
  guid character varying(36) NOT NULL,
  name text NOT NULL,
  platform text NOT NULL,
  CONSTRAINT device_pkey PRIMARY KEY (guid)
);

CREATE TABLE accountbindingdeviceinfo
(
  guid character varying(36) NOT NULL,
  ipconstraintenable integer NOT NULL,
  account_guid character varying(36) NOT NULL,
  device_guid character varying(36) NOT NULL,
  CONSTRAINT accountbindingdeviceinfo_pkey PRIMARY KEY (guid),
  CONSTRAINT accountbindingdeviceinfo_account_guid_fkey FOREIGN KEY (account_guid)
      REFERENCES public.account (guid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT accountbindingdeviceinfo_device_guid_fkey FOREIGN KEY (device_guid)
      REFERENCES public.device (guid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE TABLE accountsecuritysetting
(
  guid character varying(36) NOT NULL,
  iosenable integer NOT NULL,
  androidenable integer NOT NULL,
  windowsenable integer NOT NULL,
  macenable integer NOT NULL,
  webenable integer NOT NULL,
  account_guid character varying(36) NOT NULL,
  CONSTRAINT accountsecuritysetting_pkey PRIMARY KEY (guid),
  CONSTRAINT accountsecuritysetting_account_guid_fkey FOREIGN KEY (account_guid)
      REFERENCES public.account (guid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE TABLE ipallowedinfo
(
  guid character varying(36) NOT NULL,
  ipconstrainttype text NOT NULL,
  ipbegin text NOT NULL,
  ipbeginlong double precision NOT NULL,
  ipend text NOT NULL,
  ipendlong double precision NOT NULL,
  note text,
  createtime timestamp with time zone NOT NULL,
  CONSTRAINT allowedipinfo_pkey PRIMARY KEY (guid)
);

CREATE TABLE accountloginrecord
(
  guid character varying(36) NOT NULL,
  logintime timestamp with time zone NOT NULL,
  device_guid character varying(36) NOT NULL,
  account_guid character varying(36) NOT NULL,
  CONSTRAINT accountloginrecord_pkey PRIMARY KEY (guid),
  CONSTRAINT accountloginrecord_account_guid_fkey FOREIGN KEY (account_guid)
      REFERENCES public.account (guid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT accountloginrecord_device_guid_fkey FOREIGN KEY (device_guid)
      REFERENCES public.device (guid) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
);
