CREATE TABLE device
(
  guid character varying(36) NOT NULL,
  name nvarchar(2000) NOT NULL,
  platform nvarchar(256) NOT NULL,
  CONSTRAINT device_pkey PRIMARY KEY (guid)
);

CREATE TABLE accountbindingdeviceinfo
(
  guid character varying(36) NOT NULL,
  ipconstraintenable integer DEFAULT 0 NOT NULL,
  account_guid character varying(36) NOT NULL,
  device_guid character varying(36) NOT NULL,
  CONSTRAINT accountbindingdeviceinfo_pkey PRIMARY KEY (guid)
);

ALTER TABLE  accountbindingdeviceinfo
    ADD CONSTRAINT accountbindingdeviceinfo_account_guid_fkey FOREIGN KEY (account_guid) REFERENCES account(guid);

ALTER TABLE  accountbindingdeviceinfo
    ADD CONSTRAINT accountbindingdeviceinfo_device_guid_fkey FOREIGN KEY (device_guid) REFERENCES device(guid);


CREATE TABLE accountsecuritysetting
(
  guid character varying(36) NOT NULL,
  iosenable integer DEFAULT 1 NOT NULL,
  androidenable integer DEFAULT 1 NOT NULL,
  windowsenable integer DEFAULT 1 NOT NULL,
  macenable integer DEFAULT 1 NOT NULL,
  webenable integer DEFAULT 1 NOT NULL,
  account_guid character varying(36) NOT NULL,
  CONSTRAINT accountsecuritysetting_pkey PRIMARY KEY (guid)
);

ALTER TABLE  accountsecuritysetting
    ADD CONSTRAINT accountsecuritysetting_account_guid_fkey FOREIGN KEY (account_guid) REFERENCES account(guid);

CREATE TABLE ipallowedinfo
(
  guid character varying(36) NOT NULL,
  ipconstrainttype nvarchar(256) NOT NULL,
  ipbegin nvarchar(256) NOT NULL,
  ipbeginlong double precision NOT NULL,
  ipend nvarchar(256) NOT NULL,
  ipendlong double precision NOT NULL,
  note nvarchar(256),
  createtime datetimeoffset NOT NULL,
  CONSTRAINT ipallowedinfo_pkey PRIMARY KEY (guid)
);

CREATE TABLE accountloginrecord
(
  guid character varying(36) NOT NULL,
  logintime datetimeoffset NOT NULL,
  device_guid character varying(36) NOT NULL,
  account_guid character varying(36) NOT NULL,
  CONSTRAINT accountloginrecord_pkey PRIMARY KEY (guid)
);

ALTER TABLE  accountloginrecord
    ADD CONSTRAINT accountloginrecord_device_guid_fkey FOREIGN KEY (device_guid) REFERENCES device(guid);
ALTER TABLE  accountloginrecord
    ADD CONSTRAINT accountloginrecord_account_guid_fkey FOREIGN KEY (account_guid) REFERENCES account(guid);





