DECLARE @tableName VARCHAR(MAX) = 'contact'
DECLARE @columnName VARCHAR(MAX) = 'needreindexlucene'
DECLARE @ConstraintName nvarchar(200)
SELECT @ConstraintName = Name 
FROM SYS.DEFAULT_CONSTRAINTS
WHERE PARENT_OBJECT_ID = OBJECT_ID(@tableName) 
AND PARENT_COLUMN_ID = (
    SELECT column_id FROM sys.columns
    WHERE NAME = @columnName AND object_id = OBJECT_ID(@tableName))
IF @ConstraintName IS NOT NULL
    EXEC('ALTER TABLE '+@tableName+' DROP CONSTRAINT ' + @ConstraintName)

ALTER TABLE contact 
DROP COLUMN needreindexlucene;

ALTER TABLE contact 
ADD modifytimeforsearch double precision DEFAULT 1 NOT NULL;

ALTER TABLE contact 
ADD modifytimeinsearch double precision DEFAULT 0 NOT NULL;