CREATE TABLE account (
    guid character varying(36) NOT NULL,
    email nvarchar(2000) NOT NULL,
    password nvarchar(2000) NOT NULL,
    displayname nvarchar(2000) NOT NULL,
    logofilepath nvarchar(2000),
    createtime datetimeoffset NOT NULL,
    status nvarchar(256) NOT NULL,
    role nvarchar(256) NOT NULL,
    exportability integer DEFAULT 0 NOT NULL,
    boss character varying(36),
    company_guid character varying(36) NOT NULL,
    categoryorderupdatetime datetimeoffset,
    resigndate datetimeoffset,
    inheritdate datetimeoffset,
    inheritedaccount character varying(36),
    secretary integer DEFAULT 0 NOT NULL,
    printability integer DEFAULT 0 NOT NULL,
    inheritancestatus nvarchar(256),
    contactcountinprivate integer DEFAULT 0 NOT NULL
);


--
-- Name: account_can_view_activity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE account_can_view_activity (
    account_guid character varying(36) NOT NULL,
    activity_guid character varying(36) NOT NULL
);


--
-- Name: account_can_view_contact; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE account_can_view_contact (
    account_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


--
-- Name: account_can_view_task; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE account_can_view_task (
    account_guid character varying(36) NOT NULL,
    task_guid character varying(36) NOT NULL
);


--
-- Name: account_private_settings; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE account_private_settings (
    guid character varying(36) NOT NULL,
    contactsperpage bigint,
    viewmodeinpublicarea nvarchar(2000),
    mapengine nvarchar(256) DEFAULT cast('auto' as nvarchar(256)) NOT NULL,
    westernsurnameorder nvarchar(256) DEFAULT cast('firstname_lastname' as nvarchar(256)) NOT NULL,
    asiansurnameorder nvarchar(256) DEFAULT cast('lastname_firstname' as nvarchar(256)) NOT NULL,
    showownerinfo integer DEFAULT 0 NOT NULL,
    autoshare integer DEFAULT 0 NOT NULL,
    sharecontact integer DEFAULT 0 NOT NULL,
    sharetask integer DEFAULT 0 NOT NULL,
    shareactivity integer DEFAULT 0 NOT NULL,
    shareaccounts nvarchar(max),
    lastnoticecountview datetimeoffset,
    sortingorder nvarchar(256) DEFAULT cast('name' as nvarchar(256)) NOT NULL,
    identificationresult nvarchar(256) DEFAULT cast('contact_content' as nvarchar(256)) NOT NULL,
    account_guid character varying(36) NOT NULL,
    userstoredcrmtype character varying(30),
    crmexportmode character varying(30),
    usercrmaccount character varying(45),
    usercrmpassword character varying(45),
    usercrmsecrettoken character varying(250),
    consumerkey character varying(250),
    consumersecret character varying(250),
    crmlogintoken nvarchar(2000),
    usercrmtokentype character varying(45),
    modifytime datetimeoffset DEFAULT SYSDATETIMEOFFSET() NOT NULL,
    lastexportcount bigint DEFAULT 0,
    lastexporttime datetimeoffset DEFAULT SYSDATETIMEOFFSET() ,
    lastexportresult nvarchar(max),
    crmsynclastcompletedtimeforwct datetimeoffset,
    crmsynclastcompletedtimeforcrm datetimeoffset,
    lastdeeplydeletedcontacttime datetimeoffset
);


--
-- Name: account_share_to_account_items; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE account_share_to_account_items (
    guid character varying(36) NOT NULL,
    share_account_guid character varying(36) NOT NULL,
    beshared_account_guid character varying(36) NOT NULL,
    item_guid character varying(36) NOT NULL,
    item_type character varying(32) NOT NULL
);


--
-- Name: accountsharetargetsetting; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE accountsharetargetsetting (
    guid character varying(36) NOT NULL,
    shareitem nvarchar(256) NOT NULL,
    sharedaccountguid character varying(36) NOT NULL,
    account_guid character varying(36) NOT NULL
);


--
-- Name: activity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE activity (
    guid character varying(36) NOT NULL,
    property nvarchar(2000),
    discription nvarchar(max),
    createtime datetimeoffset NOT NULL,
    ownerguid character varying(36) NOT NULL,
    taskguid character varying(36)
);


--
-- Name: activity_has_contact; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE activity_has_contact (
    activity_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


--
-- Name: activityattachments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE activityattachments (
    guid character varying(36) NOT NULL,
    filepath nvarchar(2000),
    createtime datetimeoffset,
    activity_guid character varying(36) NOT NULL
);


--
-- Name: category; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE category (
    guid character varying(36) NOT NULL,
    name nvarchar(2000),
    categorytype nvarchar(256) NOT NULL,
    displayorder bigint,
    contactcount bigint NOT NULL,
    ownerguid character varying(36) NOT NULL,
    updatetime datetimeoffset,
    isdeleted integer DEFAULT 0 NOT NULL,
    secretary_account_guid character varying(36),
    inheritecategoryguid character varying(36)
);


--
-- Name: category_has_contact; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE category_has_contact (
    category_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


--
-- Name: company; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE company (
    guid character varying(36) NOT NULL,
    name nvarchar(2000)
);


--
-- Name: contact; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contact (
    guid character varying(36) NOT NULL,
    note nvarchar(max),
    birthday datetimeoffset,
    uniformnumber nvarchar(2000),
    nickname nvarchar(2000),
    recoglanguagefront bigint,
    recoglanguageback bigint,
    createtime datetimeoffset NOT NULL,
    modifytime datetimeoffset NOT NULL,
    iscorrected integer DEFAULT 0 NOT NULL,
    isdeleted integer DEFAULT 0 NOT NULL,
    textsha1 character varying(40),
    ownerguid character varying(36) NOT NULL,
    creatorguid character varying(36) NOT NULL,
    modifytimefordisplay datetimeoffset NOT NULL,
    accountscanviewsha1 character varying(40),
    editorguid character varying(36),
    modifytimeforcrmsync datetimeoffset
);


--
-- Name: contactaddress; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactaddress (
    guid character varying(36) NOT NULL,
    street nvarchar(2000),
    city nvarchar(2000),
    state nvarchar(2000),
    zip nvarchar(2000),
    countryname nvarchar(2000),
    countrycode nvarchar(2000),
    addressformat bigint DEFAULT cast('1' as bigint) NOT NULL,
    addresstype nvarchar(256) NOT NULL,
    recognizesource nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: contactcustomdata; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactcustomdata (
    guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    intvalue bigint DEFAULT 0,
    textvalue nvarchar(max),
    fieldtype nvarchar(256) NOT NULL,
    fieldsettingguid character varying(36) NOT NULL,
    floatvalue numeric(15,3) DEFAULT cast((0.0) as  float),
    datetimevalue datetimeoffset
);


--
-- Name: contactcustomfieldcontent; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactcustomfieldcontent (
    guid character varying(36) NOT NULL,
    contentname nvarchar(2000),
    contactcustomfieldname_id character varying(36) NOT NULL
);


--
-- Name: contactcustomfieldname; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactcustomfieldname (
    guid character varying(36) NOT NULL,
    fieldname nvarchar(2000)
);


--
-- Name: contactdate; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactdate (
    guid character varying(36) NOT NULL,
    datevalue datetimeoffset,
    datetype nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: contactemail; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactemail (
    guid character varying(36) NOT NULL,
    emailvalue nvarchar(2000),
    emailtype nvarchar(256) NOT NULL,
    recognizesource nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: contactfulltext; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactfulltext (
    guid character varying(36) NOT NULL,
    textcontent nvarchar(max),
    contact_guid character varying(36) NOT NULL
);


--
-- Name: contactim; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactim (
    guid character varying(36) NOT NULL,
    imvalue nvarchar(2000),
    imtype nvarchar(256) NOT NULL,
    recognizesource nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: contactimage; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactimage (
    guid character varying(36) NOT NULL,
    filepath nvarchar(2000),
    imagetype nvarchar(256) NOT NULL,
    createtime datetimeoffset,
    updatetime datetimeoffset,
    sha1 character varying(40),
    contact_guid character varying(36) NOT NULL
);


--
-- Name: contactjobinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactjobinfo (
    guid character varying(36) NOT NULL,
    companyname nvarchar(2000),
    conpanypronunce nvarchar(2000),
    jobtitle nvarchar(2000),
    department nvarchar(2000),
    recognizesource nvarchar(256) NOT NULL,
    fieldorder bigint,
    contact_guid character varying(36) NOT NULL
);


--
-- Name: contactname; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactname (
    guid character varying(36) NOT NULL,
    firstname nvarchar(2000),
    lastname nvarchar(2000),
    middlename nvarchar(2000),
    prefix nvarchar(2000),
    suffix nvarchar(2000),
    firstnamepronunce nvarchar(2000),
    lastnamepronunce nvarchar(2000),
    recognizesource nvarchar(256) NOT NULL,
    fieldorder bigint,
    contact_guid character varying(36) NOT NULL
);


--
-- Name: contactphone; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactphone (
    guid character varying(36) NOT NULL,
    phonevalue nvarchar(2000),
    phonetype nvarchar(256) NOT NULL,
    recognizesource nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: contactsimpleinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactsimpleinfo (
    guid character varying(36) NOT NULL,
    fullnameeastlastwestlast nvarchar(2000),
    company nvarchar(2000),
    department nvarchar(2000),
    jobtitle nvarchar(2000),
    createtime datetimeoffset NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fullnameeastfirstwestfirst nvarchar(2000),
    fullnameeastfirstwestlast nvarchar(2000),
    fullnameeastlastwestfirst nvarchar(2000)
);


--
-- Name: contactsocial; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactsocial (
    guid character varying(36) NOT NULL,
    socialvalue nvarchar(2000),
    socialtype nvarchar(256) NOT NULL,
    recognizesource nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: contactstatusforaccount; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contactstatusforaccount (
    guid character varying(36) NOT NULL,
    categorysha1 character varying(40),
    categoryguids nvarchar(max),
    isdeletedfromaccount integer DEFAULT 0 NOT NULL,
    statusupdatetime datetimeoffset NOT NULL,
    contact_guid character varying(36) NOT NULL,
    account_guid character varying(36) NOT NULL,
    exporttosalesforceid character varying(45) DEFAULT cast(NULL as character varying),
    exporttosugarcrmid character varying(45) DEFAULT cast(NULL as character varying),
    salesforceaccount character varying(45) DEFAULT cast(NULL as character varying),
    sugarcrmaccount character varying(45) DEFAULT cast(NULL as character varying),
    exporttosalesforceleadid character varying(45) DEFAULT cast(NULL as character varying),
    modifytimeforcrmsync datetimeoffset,
    previousmodifiedtimeforsalesforcecontact datetimeoffset,
    previousmodifiedtimeforsalesforcelead datetimeoffset
);


--
-- Name: contacturl; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE contacturl (
    guid character varying(36) NOT NULL,
    urlvalue nvarchar(2000),
    urltype nvarchar(256) NOT NULL,
    recognizesource nvarchar(256) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- Name: customfield; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE customfield (
    guid character varying(36) NOT NULL,
    customfieldcategory nvarchar(256),
    customfieldname nvarchar(2000),
    customfieldcontactattribute nvarchar(256),
    sortorder integer DEFAULT 0 NOT NULL
);


--
-- Name: forget_password_session; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE forget_password_session (
    guid character varying(36) NOT NULL,
    email nvarchar(2000),
    token nvarchar(2000),
    customfieldcontactattribute nvarchar(2000),
    createdate datetimeoffset
);


--
-- Name: globalinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE globalinfo (
    guid character varying(36) NOT NULL,
    configkey nvarchar(2000),
    configvalue nvarchar(2000)
);


--
-- Name: log_performance; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE log_performance (
    guid character varying(36) NOT NULL,
    userguid character varying(36) NOT NULL,
    commandname nvarchar(2000),
    begintime datetimeoffset,
    endtime datetimeoffset,
    consumetime numeric
);


--
-- Name: loginfailedlinfo; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE loginfailedlinfo (
    guid character varying(36) NOT NULL,
    ipaddress nvarchar(2000) NOT NULL,
    lastfailuretime datetimeoffset NOT NULL,
    useraccount nvarchar(2000) NOT NULL,
    failurecount bigint DEFAULT cast('0' as bigint) NOT NULL,
    failuretype nvarchar(256) NOT NULL
);


--
-- Name: notice; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE notice (
    guid character varying(36) NOT NULL,
    notifytype nvarchar(256),
    notifytime datetimeoffset NOT NULL,
    isviewed integer DEFAULT 0 NOT NULL,
    receiverguid character varying(36) NOT NULL,
    notifycontent nvarchar(max),
    notifycategory nvarchar(256) NOT NULL,
    senderguid character varying(36)
);


--
-- Name: picklist_content; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE picklist_content (
    guid character varying(36) NOT NULL,
    content nvarchar(2000),
    customfield_guid character varying(36),
    sortorder integer DEFAULT 0 NOT NULL
);


CREATE TABLE registry (
    guid character varying(36) NOT NULL,
    email character varying(255),
    companyname nvarchar(1000),
    updatetime datetimeoffset,
    attributekey character varying(255),
    attributevalue nvarchar(max),
    attributevalueex nvarchar(max)
);

--
-- Name: session; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE session (
    guid character varying(36) NOT NULL,
    logintoken character varying(36) NOT NULL,
    itemkey nvarchar(2000) NOT NULL,
    itemvalue nvarchar(2000) NOT NULL
);


--
-- Name: tagsfortaskandactivity; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE tagsfortaskandactivity (
    guid character varying(36) NOT NULL,
    tagtype nvarchar(2000),
    tagname nvarchar(2000)
);


--
-- Name: task; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE task (
    guid character varying(36) NOT NULL,
    title nvarchar(2000),
    description nvarchar(max),
    createtime datetimeoffset NOT NULL,
    ownerguid character varying(36) NOT NULL,
    creatorguid character varying(36) NOT NULL
);


--
-- Name: task_has_contact; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE task_has_contact (
    task_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


-- point1

--
-- Name: customfieldname_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE customfield
    ADD CONSTRAINT customfieldname_unique_constraint UNIQUE (customfieldname);


--
-- Name: displayname_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE account
    ADD CONSTRAINT displayname_unique_constraint UNIQUE (displayname);


--
-- Name: forget_password_session_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE forget_password_session
    ADD CONSTRAINT forget_password_session_primary PRIMARY KEY (guid);


--
-- Name: idx_16950_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE account
    ADD CONSTRAINT idx_16950_primary PRIMARY KEY (guid);


--
-- Name: idx_16957_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  accountsharetargetsetting
    ADD CONSTRAINT idx_16957_primary PRIMARY KEY (guid);


--
-- Name: idx_16963_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_activity
    ADD CONSTRAINT idx_16963_primary PRIMARY KEY (account_guid, activity_guid);


--
-- Name: idx_16966_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_contact
    ADD CONSTRAINT idx_16966_primary PRIMARY KEY (account_guid, contact_guid);


--
-- Name: idx_16969_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_task
    ADD CONSTRAINT idx_16969_primary PRIMARY KEY (account_guid, task_guid);


--
-- Name: idx_16972_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_private_settings
    ADD CONSTRAINT idx_16972_primary PRIMARY KEY (guid);


--
-- Name: idx_16988_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activity
    ADD CONSTRAINT idx_16988_primary PRIMARY KEY (guid);


--
-- Name: idx_16994_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activityattachments
    ADD CONSTRAINT idx_16994_primary PRIMARY KEY (guid);


--
-- Name: idx_17000_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activity_has_contact
    ADD CONSTRAINT idx_17000_primary PRIMARY KEY (activity_guid, contact_guid);


--
-- Name: idx_17003_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  category
    ADD CONSTRAINT idx_17003_primary PRIMARY KEY (guid);


--
-- Name: idx_17010_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  category_has_contact
    ADD CONSTRAINT idx_17010_primary PRIMARY KEY (category_guid, contact_guid);


--
-- Name: idx_17013_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  company
    ADD CONSTRAINT idx_17013_primary PRIMARY KEY (guid);


--
-- Name: idx_17019_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contact
    ADD CONSTRAINT idx_17019_primary PRIMARY KEY (guid);


--
-- Name: idx_17027_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactaddress
    ADD CONSTRAINT idx_17027_primary PRIMARY KEY (guid);


--
-- Name: idx_17034_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactcustomfieldcontent
    ADD CONSTRAINT idx_17034_primary PRIMARY KEY (guid);


--
-- Name: idx_17040_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactcustomfieldname
    ADD CONSTRAINT idx_17040_primary PRIMARY KEY (guid);


--
-- Name: idx_17046_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactdate
    ADD CONSTRAINT idx_17046_primary PRIMARY KEY (guid);


--
-- Name: idx_17052_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactemail
    ADD CONSTRAINT idx_17052_primary PRIMARY KEY (guid);


--
-- Name: idx_17058_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactfulltext
    ADD CONSTRAINT idx_17058_primary PRIMARY KEY (guid);


--
-- Name: idx_17064_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactim
    ADD CONSTRAINT idx_17064_primary PRIMARY KEY (guid);


--
-- Name: idx_17070_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactimage
    ADD CONSTRAINT idx_17070_primary PRIMARY KEY (guid);


--
-- Name: idx_17076_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactjobinfo
    ADD CONSTRAINT idx_17076_primary PRIMARY KEY (guid);


--
-- Name: idx_17082_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactname
    ADD CONSTRAINT idx_17082_primary PRIMARY KEY (guid);


--
-- Name: idx_17088_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactphone
    ADD CONSTRAINT idx_17088_primary PRIMARY KEY (guid);


--
-- Name: idx_17094_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactsimpleinfo
    ADD CONSTRAINT idx_17094_primary PRIMARY KEY (guid);


--
-- Name: idx_17100_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactsocial
    ADD CONSTRAINT idx_17100_primary PRIMARY KEY (guid);


--
-- Name: idx_17106_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactstatusforaccount
    ADD CONSTRAINT idx_17106_primary PRIMARY KEY (guid);


--
-- Name: idx_17113_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contacturl
    ADD CONSTRAINT idx_17113_primary PRIMARY KEY (guid);


--
-- Name: idx_17119_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  globalinfo
    ADD CONSTRAINT idx_17119_primary PRIMARY KEY (guid);


--
-- Name: idx_17125_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  log_performance
    ADD CONSTRAINT idx_17125_primary PRIMARY KEY (guid);


--
-- Name: idx_17131_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  notice
    ADD CONSTRAINT idx_17131_primary PRIMARY KEY (guid);


--
-- Name: idx_17145_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  session
    ADD CONSTRAINT idx_17145_primary PRIMARY KEY (guid);


--
-- Name: idx_17151_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  tagsfortaskandactivity
    ADD CONSTRAINT idx_17151_primary PRIMARY KEY (guid);


--
-- Name: idx_17157_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  task
    ADD CONSTRAINT idx_17157_primary PRIMARY KEY (guid);


--
-- Name: idx_17163_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  task_has_contact
    ADD CONSTRAINT idx_17163_primary PRIMARY KEY (task_guid, contact_guid);


--
-- Name: idx_26238_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  customfield
    ADD CONSTRAINT idx_26238_primary PRIMARY KEY (guid);


--
-- Name: idx_26250_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  loginfailedlinfo
    ADD CONSTRAINT idx_26250_primary PRIMARY KEY (guid);


--
-- Name: idx_account_share_to_account_items_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_share_to_account_items
    ADD CONSTRAINT idx_account_share_to_account_items_primary PRIMARY KEY (guid);


--
-- Name: idx_contactcustomdata_primary; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactcustomdata
    ADD CONSTRAINT idx_contactcustomdata_primary PRIMARY KEY (guid);


--
-- Name: picklist_content_pk; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  picklist_content
    ADD CONSTRAINT picklist_content_pk PRIMARY KEY (guid);


--
-- Name: picklist_content_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  picklist_content
    ADD CONSTRAINT picklist_content_unique_constraint UNIQUE (content, customfield_guid);


--
-- Name: registry_attributevalue_key; Type: CONSTRAINT; Schema: public; Owner: -
--

--ALTER TABLE  registry
--    ADD CONSTRAINT registry_attributevalue_key UNIQUE (attributevalue);


--
-- Name: registry_pkey; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  registry
    ADD CONSTRAINT registry_pkey PRIMARY KEY (guid);

--
-- Name: idx_16950_fk_account_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16950_fk_account_account1_idx ON account  (boss);


--
-- Name: idx_16950_fk_account_company_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16950_fk_account_company_idx ON account  (company_guid);


--
-- Name: idx_16950_unique_index; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX idx_16950_unique_index ON account  (email, company_guid);


--
-- Name: idx_16957_fk_accountsharetargetsetting_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16957_fk_accountsharetargetsetting_account1_idx ON accountsharetargetsetting  (account_guid);


--
-- Name: idx_16963_fk_account_has_activity_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16963_fk_account_has_activity_account1_idx ON account_can_view_activity  (account_guid);


--
-- Name: idx_16963_fk_account_has_activity_activity1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16963_fk_account_has_activity_activity1_idx ON account_can_view_activity  (activity_guid);


--
-- Name: idx_16966_fk_account_has_contact_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16966_fk_account_has_contact_account1_idx ON account_can_view_contact  (account_guid);


--
-- Name: idx_16966_fk_account_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16966_fk_account_has_contact_contact1_idx ON account_can_view_contact  (contact_guid);


--
-- Name: idx_16969_fk_account_has_task_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16969_fk_account_has_task_account1_idx ON account_can_view_task  (account_guid);


--
-- Name: idx_16969_fk_account_has_task_task1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16969_fk_account_has_task_task1_idx ON account_can_view_task  (task_guid);


--
-- Name: idx_16972_fk_account_private_settings_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16972_fk_account_private_settings_account1_idx ON account_private_settings  (account_guid);


--
-- Name: idx_16988_fk_activity_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16988_fk_activity_account1_idx ON activity  (ownerguid);


--
-- Name: idx_16988_fk_activity_task1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16988_fk_activity_task1_idx ON activity  (taskguid);


--
-- Name: idx_16994_fk_activityattachments_activity1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_16994_fk_activityattachments_activity1_idx ON activityattachments  (activity_guid);


--
-- Name: idx_17000_fk_activity_has_contact_activity1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17000_fk_activity_has_contact_activity1_idx ON activity_has_contact  (activity_guid);


--
-- Name: idx_17000_fk_activity_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17000_fk_activity_has_contact_contact1_idx ON activity_has_contact  (contact_guid);


--
-- Name: idx_17003_fk_category_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17003_fk_category_account1_idx ON category  (ownerguid);


--
-- Name: idx_17010_fk_category_has_contact_category1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17010_fk_category_has_contact_category1_idx ON category_has_contact  (category_guid);


--
-- Name: idx_17010_fk_category_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17010_fk_category_has_contact_contact1_idx ON category_has_contact  (contact_guid);


--
-- Name: idx_17019_fk_contact_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17019_fk_contact_account1_idx ON contact  (ownerguid);


--
-- Name: idx_17027_fk_contactaddress_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17027_fk_contactaddress_contact1_idx ON contactaddress  (contact_guid);


--
-- Name: idx_17034_fk_contactcustomfieldcontent_contactcustomfieldname1_; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17034_fk_contactcustomfieldcontent_contactcustomfieldname1_ ON contactcustomfieldcontent  (contactcustomfieldname_id);


--
-- Name: idx_17046_fk_contactdate_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17046_fk_contactdate_contact1_idx ON contactdate  (contact_guid);


--
-- Name: idx_17052_fk_contactemail_contact_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17052_fk_contactemail_contact_idx ON contactemail  (contact_guid);


--
-- Name: idx_17058_contact_guid_unique; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX idx_17058_contact_guid_unique ON contactfulltext  (contact_guid);


--
-- Name: idx_17058_fk_contactfullcontext_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17058_fk_contactfullcontext_contact1_idx ON contactfulltext  (contact_guid);


--
-- Name: idx_17064_fk_contactim_contact_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17064_fk_contactim_contact_idx ON contactim  (contact_guid);


--
-- Name: idx_17070_fk_contactimage_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17070_fk_contactimage_contact1_idx ON contactimage  (contact_guid);


--
-- Name: idx_17076_fk_contactjobinfo_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17076_fk_contactjobinfo_contact1_idx ON contactjobinfo  (contact_guid);


--
-- Name: idx_17082_fk_contactname_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17082_fk_contactname_contact1_idx ON contactname  (contact_guid);


--
-- Name: idx_17088_fk_contactphone_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17088_fk_contactphone_contact1_idx ON contactphone  (contact_guid);


--
-- Name: idx_17094_contact_guid_unique; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX idx_17094_contact_guid_unique ON contactsimpleinfo  (contact_guid);


--
-- Name: idx_17094_fk_contactsimpleinfo_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17094_fk_contactsimpleinfo_contact1_idx ON contactsimpleinfo  (contact_guid);


--
-- Name: idx_17100_fk_contactsocial_contact_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17100_fk_contactsocial_contact_idx ON contactsocial  (contact_guid);


--
-- Name: idx_17106_fk_contactstatusforaccount_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17106_fk_contactstatusforaccount_account1_idx ON contactstatusforaccount  (account_guid);


--
-- Name: idx_17106_fk_contactstatusforaccount_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17106_fk_contactstatusforaccount_contact1_idx ON contactstatusforaccount  (contact_guid);


--
-- Name: idx_17106_unique_contact_account_pair; Type: INDEX; Schema: public; Owner: -
--

CREATE UNIQUE INDEX idx_17106_unique_contact_account_pair ON contactstatusforaccount  (contact_guid, account_guid);


--
-- Name: idx_17113_fk_contacturl_contact_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17113_fk_contacturl_contact_idx ON contacturl  (contact_guid);


--
-- Name: idx_17131_fk_notice_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17131_fk_notice_account1_idx ON notice  (receiverguid);


--
-- Name: idx_17157_fk_task_account1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17157_fk_task_account1_idx ON task  (ownerguid);


--
-- Name: idx_17157_fk_task_account2_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17157_fk_task_account2_idx ON task  (creatorguid);


--
-- Name: idx_17163_fk_task_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17163_fk_task_has_contact_contact1_idx ON task_has_contact  (contact_guid);


--
-- Name: idx_17163_fk_task_has_contact_task1_idx; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_17163_fk_task_has_contact_task1_idx ON task_has_contact  (task_guid);

--
-- Name: fk_account_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account
    ADD CONSTRAINT fk_account_account1 FOREIGN KEY (boss) REFERENCES account(guid);


--
-- Name: fk_account_company; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account
    ADD CONSTRAINT fk_account_company FOREIGN KEY (company_guid) REFERENCES company(guid);


--
-- Name: fk_account_has_activity_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_activity
    ADD CONSTRAINT fk_account_has_activity_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- Name: fk_account_has_activity_activity1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_activity
    ADD CONSTRAINT fk_account_has_activity_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- Name: fk_account_has_contact_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_contact
    ADD CONSTRAINT fk_account_has_contact_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- Name: fk_account_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_contact
    ADD CONSTRAINT fk_account_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_account_has_task_task1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_task
    ADD CONSTRAINT fk_account_has_task_task1 FOREIGN KEY (task_guid) REFERENCES task(guid);


--
-- Name: fk_account_has_task_viewers; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_can_view_task
    ADD CONSTRAINT fk_account_has_task_viewers FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- Name: fk_account_private_settings_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  account_private_settings
    ADD CONSTRAINT fk_account_private_settings_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- Name: fk_accountsharetargetsetting_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  accountsharetargetsetting
    ADD CONSTRAINT fk_accountsharetargetsetting_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- Name: fk_activity_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activity
    ADD CONSTRAINT fk_activity_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- Name: fk_activity_has_contact_activity1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activity_has_contact
    ADD CONSTRAINT fk_activity_has_contact_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- Name: fk_activity_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activity_has_contact
    ADD CONSTRAINT fk_activity_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_activity_task1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activity
    ADD CONSTRAINT fk_activity_task1 FOREIGN KEY (taskguid) REFERENCES task(guid);


--
-- Name: fk_activityattachments_activity1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  activityattachments
    ADD CONSTRAINT fk_activityattachments_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- Name: fk_category_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  category
    ADD CONSTRAINT fk_category_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- Name: fk_category_has_contact_category1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  category_has_contact
    ADD CONSTRAINT fk_category_has_contact_category1 FOREIGN KEY (category_guid) REFERENCES category(guid);


--
-- Name: fk_category_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  category_has_contact
    ADD CONSTRAINT fk_category_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contact_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contact
    ADD CONSTRAINT fk_contact_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- Name: fk_contactaddress_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactaddress
    ADD CONSTRAINT fk_contactaddress_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactcustomdata_contact; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactcustomdata
    ADD CONSTRAINT fk_contactcustomdata_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactcustomfieldcontent_contactcustomfieldname1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactcustomfieldcontent
    ADD CONSTRAINT fk_contactcustomfieldcontent_contactcustomfieldname1 FOREIGN KEY (contactcustomfieldname_id) REFERENCES contactcustomfieldname(guid);


--
-- Name: fk_contactdate_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactdate
    ADD CONSTRAINT fk_contactdate_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactemail_contact; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactemail
    ADD CONSTRAINT fk_contactemail_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactfullcontext_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactfulltext
    ADD CONSTRAINT fk_contactfullcontext_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactim_contact; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactim
    ADD CONSTRAINT fk_contactim_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactimage_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactimage
    ADD CONSTRAINT fk_contactimage_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactjobinfo_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactjobinfo
    ADD CONSTRAINT fk_contactjobinfo_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactname_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactname
    ADD CONSTRAINT fk_contactname_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactphone_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactphone
    ADD CONSTRAINT fk_contactphone_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactsimpleinfo_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactsimpleinfo
    ADD CONSTRAINT fk_contactsimpleinfo_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactsocial_contact; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactsocial
    ADD CONSTRAINT fk_contactsocial_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contactstatusforaccount_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactstatusforaccount
    ADD CONSTRAINT fk_contactstatusforaccount_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- Name: fk_contactstatusforaccount_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contactstatusforaccount
    ADD CONSTRAINT fk_contactstatusforaccount_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_contacturl_contact; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  contacturl
    ADD CONSTRAINT fk_contacturl_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_notice_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  notice
    ADD CONSTRAINT fk_notice_account1 FOREIGN KEY (receiverguid) REFERENCES account(guid);


--
-- Name: fk_task_account1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  task
    ADD CONSTRAINT fk_task_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- Name: fk_task_account2; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  task
    ADD CONSTRAINT fk_task_account2 FOREIGN KEY (creatorguid) REFERENCES account(guid);


--
-- Name: fk_task_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  task_has_contact
    ADD CONSTRAINT fk_task_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- Name: fk_task_has_contact_task1; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  task_has_contact
    ADD CONSTRAINT fk_task_has_contact_task1 FOREIGN KEY (task_guid) REFERENCES task(guid);


--
-- Name: picklist_content_fk; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE  picklist_content
    ADD CONSTRAINT picklist_content_fk FOREIGN KEY (customfield_guid) REFERENCES customfield(guid);


    
   
INSERT INTO company VALUES ('aabc2320-58a7-4b59-b292-bb4a07873893','DEFAULT_COMPANY');
INSERT INTO globalinfo VALUES ('c25f7c19-929b-4971-8e57-168c4cb9efc8','SHARE_RULE','BY_SETTING');
--INSERT INTO dbo.account VALUES ('c96f7c19-929b-4971-8e57-168c4cb9efc8','admin@penpower.com.tw','8y6kWzmoVzyrllmEvNeIRw==','admin',NULL,'2016-04-25 12:24:42.522','ACTIVE','ADMIN',1,NULL,'aabc2320-58a7-4b59-b292-bb4a07873893',NULL,NULL,NULL,NULL,1,1,null,1,'LOCAL',NULL,NULL,NULL);
--INSERT INTO account_private_settings(guid,contactsperpage, mapengine, westernsurnameorder, asiansurnameorder, showownerinfo, autoshare, sharecontact, sharetask, shareactivity, shareaccounts, lastnoticecountview, sortingorder,identificationresult, account_guid)VALUES ('c96f7c19-929b-4971-8e57-168c4cb9eabc', 1,'AUTO', 'FIRSTNAME_LASTNAME','LASTNAME_FIRSTNAME', 0,0,0,0,0,null,'1970-01-01 11:22:33.999','NAME','CONTACT_CONTENT','c96f7c19-929b-4971-8e57-168c4cb9efc8');
