CREATE TABLE account (
    guid character varying(36) NOT NULL,
    email varchar(255) NOT NULL,
    password varchar(128) NOT NULL,
    displayname varchar(255) NOT NULL,
    logofilepath varchar(255),
    createtime datetime(3) NOT NULL,
    status varchar(16) NOT NULL,
    role varchar(16) NOT NULL,
    exportability int(2) not null default '0',
    boss character varying(36),
    company_guid character varying(36) NOT NULL,
    categoryorderupdatetime datetime(3),
    resigndate datetime(3),
    inheritdate datetime(3),
    inheritedaccount character varying(36),
    secretary integer DEFAULT 0 NOT NULL,
    printability integer DEFAULT 0 NOT NULL,
    inheritancestatus varchar(100),
    contactcountinprivate integer DEFAULT 0 NOT NULL
);


--
-- TOC entry 184 (class 1259 OID 202317)
-- Name: account_can_view_activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_can_view_activity (
    account_guid character varying(36) NOT NULL,
    activity_guid character varying(36) NOT NULL
);


--
-- TOC entry 185 (class 1259 OID 202320)
-- Name: account_can_view_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_can_view_contact (
    account_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);

--
-- TOC entry 186 (class 1259 OID 202323)
-- Name: account_can_view_task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_can_view_task (
    account_guid character varying(36) NOT NULL,
    task_guid character varying(36) NOT NULL
);


--
-- TOC entry 187 (class 1259 OID 202326)
-- Name: account_private_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_private_settings (
    guid character varying(36) NOT NULL,
    contactsperpage int(11) default null,
    viewmodeinpublicarea varchar(16) default null,
    mapengine varchar(20) not null default 'auto',
    westernsurnameorder varchar(30) not null default 'firstname_lastname',
    asiansurnameorder varchar(30) not null default 'lastname_firstname',
    showownerinfo int(2) not null default '0',
    autoshare int(2) not null default '0',
    sharecontact int(2) not null default '0',
    sharetask int(2) not null default '0',
    shareactivity int(2) not null default '0',
    shareaccounts mediumtext,
    lastnoticecountview datetime(3),
    sortingorder varchar(45) not null default 'name',
    identificationresult varchar(45) not null default 'contact_content',
    account_guid character varying(36) NOT NULL,
    userstoredcrmtype character varying(30),
    crmexportmode character varying(30),
    usercrmaccount character varying(45),
    usercrmpassword character varying(45),
    usercrmsecrettoken character varying(250),
    consumerkey character varying(250),
    consumersecret character varying(250),
    crmlogintoken text,
    usercrmtokentype character varying(45),
    modifytime datetime(3) DEFAULT CURRENT_TIMESTAMP(3) NOT NULL,
    lastexportcount bigint DEFAULT 0,
    lastexporttime datetime(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    lastexportresult text,
    crmsynclastcompletedtimeforwct datetime(3),
    crmsynclastcompletedtimeforcrm datetime(3),
    lastdeeplydeletedcontacttime datetime(3)
);


--
-- TOC entry 232 (class 1259 OID 203035)
-- Name: account_share_to_account_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE account_share_to_account_items (
    guid character varying(36) NOT NULL,
    share_account_guid character varying(36) NOT NULL,
    beshared_account_guid character varying(36) NOT NULL,
    item_guid character varying(36) NOT NULL,
    item_type character varying(32) NOT NULL
);


--
-- TOC entry 188 (class 1259 OID 202342)
-- Name: accountsharetargetsetting; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE accountsharetargetsetting (
    guid character varying(36) NOT NULL,
    shareitem varchar(45) not null,
    sharedaccountguid character varying(36) NOT NULL,
    account_guid character varying(36) NOT NULL
);


--
-- TOC entry 189 (class 1259 OID 202348)
-- Name: activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE activity (
    guid character varying(36) NOT NULL,
    property varchar(16) default null,
    discription mediumtext,
    createtime datetime(3) NOT NULL,
    ownerguid character varying(36) NOT NULL,
    taskguid character varying(36)
);


--
-- TOC entry 190 (class 1259 OID 202354)
-- Name: activity_has_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE activity_has_contact (
    activity_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


--
-- TOC entry 191 (class 1259 OID 202357)
-- Name: activityattachments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE activityattachments (
    guid character varying(36) NOT NULL,
    filepath varchar(255),
    createtime datetime(3),
    activity_guid character varying(36) NOT NULL
);


--
-- TOC entry 192 (class 1259 OID 202363)
-- Name: category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE category (
    guid character varying(36) NOT NULL,
    name varchar(255),
    categorytype varchar(16) not null,
    displayorder int(11) default null,
    contactcount int(11) not null,
    ownerguid character varying(36) NOT NULL,
    updatetime datetime(3),
    isdeleted int(2) not null default '0',
    secretary_account_guid character varying(36),
    inheritecategoryguid character varying(36)
);


--
-- TOC entry 193 (class 1259 OID 202370)
-- Name: category_has_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE category_has_contact (
    category_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);


--
-- TOC entry 194 (class 1259 OID 202373)
-- Name: company; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE company (
    guid character varying(36) NOT NULL,
    name varchar(255)
);


--
-- TOC entry 195 (class 1259 OID 202379)
-- Name: contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contact (
    guid character varying(36) NOT NULL,
    note mediumtext,
    birthday datetime(3),
    uniformnumber varchar(255),
    nickname varchar(255),
    recoglanguagefront int(11) default null,
    recoglanguageback int(11) default null,
    createtime datetime(3) NOT NULL,
    modifytime datetime(3) NOT NULL,
    iscorrected int(2) not null default '0',
    isdeleted int(2) not null default '0',
    textsha1 character varying(40),
    ownerguid character varying(36) NOT NULL,
    creatorguid character varying(36) NOT NULL,
    modifytimefordisplay datetime(3) NOT NULL,
    accountscanviewsha1 character varying(40),
    editorguid character varying(36),
    modifytimeforcrmsync datetime(3)
);


--
-- TOC entry 196 (class 1259 OID 202387)
-- Name: contactaddress; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactaddress (
    guid character varying(36) NOT NULL,
    street varchar(255) default null,
    city varchar(64) default null,
    state varchar(64) default null,
    zip varchar(64) default null,
    countryname varchar(64) default null,
    countrycode varchar(16) default null,
    addressformat int(11) not null default '1',
    addresstype varchar(16) not null,
    recognizesource varchar(16) not null,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- TOC entry 234 (class 1259 OID 203068)
-- Name: contactcustomdata; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactcustomdata (
    guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    intvalue bigint DEFAULT 0,
    textvalue text,
    fieldtype text NOT NULL,
    fieldsettingguid character varying(36) NOT NULL,
    floatvalue numeric(15,3) DEFAULT 0.0,
    datetimevalue datetime(3)
);


--
-- TOC entry 197 (class 1259 OID 202394)
-- Name: contactcustomfieldcontent; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactcustomfieldcontent (
    guid character varying(36) NOT NULL,
    contentname varchar(255),
    contactcustomfieldname_id character varying(36) NOT NULL
);


--
-- TOC entry 198 (class 1259 OID 202400)
-- Name: contactcustomfieldname; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactcustomfieldname (
    guid character varying(36) NOT NULL,
    fieldname varchar(255)
);


--
-- TOC entry 199 (class 1259 OID 202406)
-- Name: contactdate; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactdate (
    guid character varying(36) NOT NULL,
    datevalue datetime(3),
    datetype varchar(16) not null,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- TOC entry 200 (class 1259 OID 202412)
-- Name: contactemail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactemail (
    guid character varying(36) NOT NULL,
    emailvalue varchar(255),
    emailtype varchar(16) not null,
    recognizesource varchar(16) not null,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- TOC entry 201 (class 1259 OID 202418)
-- Name: contactfulltext; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactfulltext (
    guid character varying(36) NOT NULL,
    textcontent longtext,
    contact_guid character varying(36) NOT NULL
);


--
-- TOC entry 202 (class 1259 OID 202424)
-- Name: contactim; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactim (
    guid character varying(36) NOT NULL,
    imvalue varchar(255),
    imtype varchar(255) NOT NULL,
    recognizesource varchar(255) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- TOC entry 203 (class 1259 OID 202430)
-- Name: contactimage; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactimage (
    guid character varying(36) NOT NULL,
    filepath varchar(255),
    imagetype varchar(255) NOT NULL,
    createtime datetime(3),
    updatetime datetime(3),
    sha1 character varying(40),
    contact_guid character varying(36) NOT NULL
);

--
-- TOC entry 204 (class 1259 OID 202436)
-- Name: contactjobinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactjobinfo (
    guid character varying(36) NOT NULL,
    companyname varchar(255),
    conpanypronunce varchar(255),
    jobtitle varchar(255),
    department varchar(255),
    recognizesource varchar(16) not null,
    fieldorder bigint,
    contact_guid character varying(36) NOT NULL
);

--
-- TOC entry 205 (class 1259 OID 202442)
-- Name: contactname; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactname (
    guid character varying(36) NOT NULL,
    firstname varchar(255),
    lastname varchar(255),
    middlename varchar(255),
    prefix varchar(255),
    suffix varchar(255),
    firstnamepronunce varchar(255),
    lastnamepronunce varchar(255),
    recognizesource varchar(255) NOT NULL,
    fieldorder bigint,
    contact_guid character varying(36) NOT NULL
);

--
-- TOC entry 206 (class 1259 OID 202448)
-- Name: contactphone; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactphone (
    guid character varying(36) NOT NULL,
    phonevalue varchar(255),
    phonetype varchar(255) NOT NULL,
    recognizesource varchar(255) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);

--
-- TOC entry 207 (class 1259 OID 202454)
-- Name: contactsimpleinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactsimpleinfo (
    guid character varying(36) NOT NULL,
    fullnameeastlastwestlast varchar(255),
    company varchar(255),
    department varchar(255),
    jobtitle varchar(255),
    createtime datetime(3) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fullnameeastfirstwestfirst varchar(255),
    fullnameeastfirstwestlast varchar(255),
    fullnameeastlastwestfirst varchar(255)
);


-- TOC entry 208 (class 1259 OID 202460)
-- Name: contactsocial; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactsocial (
    guid character varying(36) NOT NULL,
    socialvalue varchar(255),
    socialtype varchar(255) NOT NULL,
    recognizesource varchar(255) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);


--
-- TOC entry 209 (class 1259 OID 202466)
-- Name: contactstatusforaccount; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contactstatusforaccount (
    guid character varying(36) NOT NULL,
    categorysha1 character varying(40),
    categoryguids mediumtext,
    isdeletedfromaccount integer DEFAULT 0 NOT NULL,
    statusupdatetime datetime(3) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    account_guid character varying(36) NOT NULL,
    exporttosalesforceid character varying(45) DEFAULT NULL,
    exporttosugarcrmid character varying(45) DEFAULT NULL,
    salesforceaccount character varying(45) DEFAULT NULL,
    sugarcrmaccount character varying(45) DEFAULT NULL,
    exporttosalesforceleadid character varying(45) DEFAULT NULL,
    modifytimeforcrmsync datetime(3),
    previousmodifiedtimeforsalesforcecontact datetime(3),
    previousmodifiedtimeforsalesforcelead datetime(3)
);


--
-- TOC entry 210 (class 1259 OID 202473)
-- Name: contacturl; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE contacturl (
    guid character varying(36) NOT NULL,
    urlvalue varchar(255),
    urltype varchar(255) NOT NULL,
    recognizesource varchar(255) NOT NULL,
    contact_guid character varying(36) NOT NULL,
    fieldorder bigint
);

--
-- TOC entry 219 (class 1259 OID 202859)
-- Name: customfield; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE customfield (
    guid character varying(36) NOT NULL,
    customfieldcategory varchar(255),
    customfieldname varchar(255),
    customfieldcontactattribute varchar(255),
    sortorder integer DEFAULT 0 NOT NULL
);

--
-- TOC entry 233 (class 1259 OID 203051)
-- Name: forget_password_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE forget_password_session (
    guid character varying(36) NOT NULL,
    email varchar(255),
    token varchar(255),
    customfieldcontactattribute text,
    createdate datetime(3)
);


--
-- TOC entry 211 (class 1259 OID 202479)
-- Name: globalinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE globalinfo (
    guid character varying(36) NOT NULL,
    configkey text,
    configvalue text
);


--
-- TOC entry 212 (class 1259 OID 202485)
-- Name: log_performance; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE log_performance (
    guid character varying(36) NOT NULL,
    userguid character varying(36) NOT NULL,
    commandname varchar(255),
    begintime datetime(3),
    endtime datetime(3),
    consumetime bigint(20) default null
);


--
-- TOC entry 218 (class 1259 OID 202850)
-- Name: loginfailedlinfo; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE loginfailedlinfo (
    guid character varying(36) NOT NULL,
    ipaddress text NOT NULL,
    lastfailuretime datetime(3) NOT NULL,
    useraccount varchar(255) NOT NULL,
    failurecount bigint DEFAULT '0' NOT NULL,
    failuretype varchar(255) NOT NULL
);


--
-- TOC entry 213 (class 1259 OID 202491)
-- Name: notice; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE notice (
    guid character varying(36) NOT NULL,
    notifytype varchar(255),
    notifytime datetime(3) NOT NULL,
    isviewed integer DEFAULT 0 NOT NULL,
    receiverguid character varying(36) NOT NULL,
    notifycontent varchar(255),
    notifycategory varchar(255) NOT NULL,
    senderguid character varying(36)
);


--
-- TOC entry 235 (class 1259 OID 203130)
-- Name: picklist_content; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE picklist_content (
    guid character varying(36) NOT NULL,
    content varchar(255),
    customfield_guid character varying(36),
    sortorder integer DEFAULT 0 NOT NULL
);

--
-- TOC entry 231 (class 1259 OID 203025)
-- Name: registry; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE registry (
    guid character varying(36) NOT NULL,
    email character varying(255),
    companyname character varying(255),
    updatetime datetime(3),
    attributekey character varying(255),
    attributevalue varchar(255),
    attributevalueex varchar(255)
);

--
-- TOC entry 214 (class 1259 OID 202498)
-- Name: session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE session (
    guid character varying(36) NOT NULL,
    logintoken character varying(36) NOT NULL,
    itemkey text NOT NULL,
    itemvalue text NOT NULL
);

--
-- TOC entry 215 (class 1259 OID 202504)
-- Name: tagsfortaskandactivity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE tagsfortaskandactivity (
    guid character varying(36) NOT NULL,
    tagtype text,
    tagname text
);

--
-- TOC entry 216 (class 1259 OID 202510)
-- Name: task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE task (
    guid character varying(36) NOT NULL,
    title varchar(255),
    description varchar(255),
    createtime datetime(3),
    ownerguid character varying(36) NOT NULL,
    creatorguid character varying(36) NOT NULL
);


--
-- TOC entry 217 (class 1259 OID 202516)
-- Name: task_has_contact; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE task_has_contact (
    task_guid character varying(36) NOT NULL,
    contact_guid character varying(36) NOT NULL
);




--
-- TOC entry 2420 (class 2606 OID 203170)
-- Name: customfield customfieldname_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE customfield
    ADD CONSTRAINT customfieldname_unique_constraint UNIQUE (customfieldname);


--
-- TOC entry 2302 (class 2606 OID 203117)
-- Name: account displayname_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE account
    ADD CONSTRAINT displayname_unique_constraint UNIQUE (displayname);


--
-- TOC entry 2472 (class 2606 OID 203058)
-- Name: forget_password_session forget_password_session_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE forget_password_session
    ADD CONSTRAINT forget_password_session_primary PRIMARY KEY (guid);


--
-- TOC entry 2306 (class 2606 OID 202520)
-- Name: account idx_16950_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE account
    ADD CONSTRAINT idx_16950_primary PRIMARY KEY (guid);


--
-- TOC entry 2325 (class 2606 OID 202522)
-- Name: accountsharetargetsetting idx_16957_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE accountsharetargetsetting
    ADD CONSTRAINT idx_16957_primary PRIMARY KEY (guid);


--
-- TOC entry 2311 (class 2606 OID 202524)
-- Name: account_can_view_activity idx_16963_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE account_can_view_activity
    ADD CONSTRAINT idx_16963_primary PRIMARY KEY (account_guid, activity_guid);


--
-- TOC entry 2315 (class 2606 OID 202526)
-- Name: account_can_view_contact idx_16966_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE account_can_view_contact
    ADD CONSTRAINT idx_16966_primary PRIMARY KEY (account_guid, contact_guid);


--
-- TOC entry 2319 (class 2606 OID 202528)
-- Name: account_can_view_task idx_16969_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE account_can_view_task
    ADD CONSTRAINT idx_16969_primary PRIMARY KEY (account_guid, task_guid);


--
-- TOC entry 2322 (class 2606 OID 202530)
-- Name: account_private_settings idx_16972_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE account_private_settings
    ADD CONSTRAINT idx_16972_primary PRIMARY KEY (guid);


--
-- TOC entry 2329 (class 2606 OID 202532)
-- Name: activity idx_16988_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE activity
    ADD CONSTRAINT idx_16988_primary PRIMARY KEY (guid);


--
-- TOC entry 2336 (class 2606 OID 202534)
-- Name: activityattachments idx_16994_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE activityattachments
    ADD CONSTRAINT idx_16994_primary PRIMARY KEY (guid);


--
-- TOC entry 2333 (class 2606 OID 202536)
-- Name: activity_has_contact idx_17000_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE activity_has_contact
    ADD CONSTRAINT idx_17000_primary PRIMARY KEY (activity_guid, contact_guid);


--
-- TOC entry 2339 (class 2606 OID 202538)
-- Name: category idx_17003_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE category
    ADD CONSTRAINT idx_17003_primary PRIMARY KEY (guid);


--
-- TOC entry 2343 (class 2606 OID 202540)
-- Name: category_has_contact idx_17010_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE category_has_contact
    ADD CONSTRAINT idx_17010_primary PRIMARY KEY (category_guid, contact_guid);


--
-- TOC entry 2345 (class 2606 OID 202542)
-- Name: company idx_17013_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE company
    ADD CONSTRAINT idx_17013_primary PRIMARY KEY (guid);


--
-- TOC entry 2348 (class 2606 OID 202544)
-- Name: contact idx_17019_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE contact
    ADD CONSTRAINT idx_17019_primary PRIMARY KEY (guid);


--
-- TOC entry 2351 (class 2606 OID 202546)
-- Name: contactaddress idx_17027_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE contactaddress
    ADD CONSTRAINT idx_17027_primary PRIMARY KEY (guid);


--
-- TOC entry 2354 (class 2606 OID 202548)
-- Name: contactcustomfieldcontent idx_17034_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE contactcustomfieldcontent
    ADD CONSTRAINT idx_17034_primary PRIMARY KEY (guid);


--
-- TOC entry 2356 (class 2606 OID 202550)
-- Name: contactcustomfieldname idx_17040_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactcustomfieldname
    ADD CONSTRAINT idx_17040_primary PRIMARY KEY (guid);


--
-- TOC entry 2359 (class 2606 OID 202552)
-- Name: contactdate idx_17046_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactdate
    ADD CONSTRAINT idx_17046_primary PRIMARY KEY (guid);


--
-- TOC entry 2362 (class 2606 OID 202554)
-- Name: contactemail idx_17052_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactemail
    ADD CONSTRAINT idx_17052_primary PRIMARY KEY (guid);


--
-- TOC entry 2366 (class 2606 OID 202556)
-- Name: contactfulltext idx_17058_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactfulltext
    ADD CONSTRAINT idx_17058_primary PRIMARY KEY (guid);


--
-- TOC entry 2370 (class 2606 OID 202558)
-- Name: contactim idx_17064_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactim
    ADD CONSTRAINT idx_17064_primary PRIMARY KEY (guid);


--
-- TOC entry 2373 (class 2606 OID 202560)
-- Name: contactimage idx_17070_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactimage
    ADD CONSTRAINT idx_17070_primary PRIMARY KEY (guid);


--
-- TOC entry 2376 (class 2606 OID 202562)
-- Name: contactjobinfo idx_17076_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactjobinfo
    ADD CONSTRAINT idx_17076_primary PRIMARY KEY (guid);


--
-- TOC entry 2379 (class 2606 OID 202564)
-- Name: contactname idx_17082_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactname
    ADD CONSTRAINT idx_17082_primary PRIMARY KEY (guid);


--
-- TOC entry 2382 (class 2606 OID 202566)
-- Name: contactphone idx_17088_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactphone
    ADD CONSTRAINT idx_17088_primary PRIMARY KEY (guid);


--
-- TOC entry 2386 (class 2606 OID 202568)
-- Name: contactsimpleinfo idx_17094_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactsimpleinfo
    ADD CONSTRAINT idx_17094_primary PRIMARY KEY (guid);


--
-- TOC entry 2389 (class 2606 OID 202570)
-- Name: contactsocial idx_17100_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactsocial
    ADD CONSTRAINT idx_17100_primary PRIMARY KEY (guid);


--
-- TOC entry 2393 (class 2606 OID 202572)
-- Name: contactstatusforaccount idx_17106_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactstatusforaccount
    ADD CONSTRAINT idx_17106_primary PRIMARY KEY (guid);


--
-- TOC entry 2397 (class 2606 OID 202574)
-- Name: contacturl idx_17113_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contacturl
    ADD CONSTRAINT idx_17113_primary PRIMARY KEY (guid);


--
-- TOC entry 2399 (class 2606 OID 202576)
-- Name: globalinfo idx_17119_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  globalinfo
    ADD CONSTRAINT idx_17119_primary PRIMARY KEY (guid);


--
-- TOC entry 2401 (class 2606 OID 202578)
-- Name: log_performance idx_17125_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  log_performance
    ADD CONSTRAINT idx_17125_primary PRIMARY KEY (guid);


--
-- TOC entry 2404 (class 2606 OID 202580)
-- Name: notice idx_17131_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  notice
    ADD CONSTRAINT idx_17131_primary PRIMARY KEY (guid);


--
-- TOC entry 2406 (class 2606 OID 202582)
-- Name: session idx_17145_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  session
    ADD CONSTRAINT idx_17145_primary PRIMARY KEY (guid);


--
-- TOC entry 2408 (class 2606 OID 202584)
-- Name: tagsfortaskandactivity idx_17151_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  tagsfortaskandactivity
    ADD CONSTRAINT idx_17151_primary PRIMARY KEY (guid);


--
-- TOC entry 2412 (class 2606 OID 202586)
-- Name: task idx_17157_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  task
    ADD CONSTRAINT idx_17157_primary PRIMARY KEY (guid);


--
-- TOC entry 2416 (class 2606 OID 202588)
-- Name: task_has_contact idx_17163_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  task_has_contact
    ADD CONSTRAINT idx_17163_primary PRIMARY KEY (task_guid, contact_guid);


--
-- TOC entry 2422 (class 2606 OID 202866)
-- Name: customfield idx_26238_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  customfield
    ADD CONSTRAINT idx_26238_primary PRIMARY KEY (guid);


--
-- TOC entry 2418 (class 2606 OID 202858)
-- Name: loginfailedlinfo idx_26250_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  loginfailedlinfo
    ADD CONSTRAINT idx_26250_primary PRIMARY KEY (guid);


--
-- TOC entry 2470 (class 2606 OID 203039)
-- Name: account_share_to_account_items idx_account_share_to_account_items_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_share_to_account_items
    ADD CONSTRAINT idx_account_share_to_account_items_primary PRIMARY KEY (guid);


--
-- TOC entry 2474 (class 2606 OID 203076)
-- Name: contactcustomdata idx_contactcustomdata_primary; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactcustomdata
    ADD CONSTRAINT idx_contactcustomdata_primary PRIMARY KEY (guid);


--
-- TOC entry 2476 (class 2606 OID 203137)
-- Name: picklist_content picklist_content_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  picklist_content
    ADD CONSTRAINT picklist_content_pk PRIMARY KEY (guid);


--
-- TOC entry 2478 (class 2606 OID 203236)
-- Name: picklist_content picklist_content_unique_constraint; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  picklist_content
    ADD CONSTRAINT picklist_content_unique_constraint UNIQUE (content, customfield_guid);


--
-- TOC entry 2466 (class 2606 OID 203034)
-- Name: registry registry_attributevalue_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  registry
    ADD CONSTRAINT registry_attributevalue_key UNIQUE (attributevalue);


--
-- TOC entry 2468 (class 2606 OID 203032)
-- Name: registry registry_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  registry
    ADD CONSTRAINT registry_pkey PRIMARY KEY (guid);


--
-- TOC entry 2303 (class 1259 OID 202589)
-- Name: idx_16950_fk_account_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16950_fk_account_account1_idx ON account (boss);


--
-- TOC entry 2304 (class 1259 OID 202590)
-- Name: idx_16950_fk_account_company_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16950_fk_account_company_idx ON account (company_guid);


--
-- TOC entry 2307 (class 1259 OID 202591)
-- Name: idx_16950_unique_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_16950_unique_index ON account (email, company_guid);


--
-- TOC entry 2323 (class 1259 OID 202592)
-- Name: idx_16957_fk_accountsharetargetsetting_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16957_fk_accountsharetargetsetting_account1_idx ON accountsharetargetsetting (account_guid);


--
-- TOC entry 2308 (class 1259 OID 202593)
-- Name: idx_16963_fk_account_has_activity_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16963_fk_account_has_activity_account1_idx ON account_can_view_activity (account_guid);


--
-- TOC entry 2309 (class 1259 OID 202594)
-- Name: idx_16963_fk_account_has_activity_activity1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16963_fk_account_has_activity_activity1_idx ON account_can_view_activity (activity_guid);


--
-- TOC entry 2312 (class 1259 OID 202595)
-- Name: idx_16966_fk_account_has_contact_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16966_fk_account_has_contact_account1_idx ON account_can_view_contact (account_guid);


--
-- TOC entry 2313 (class 1259 OID 202596)
-- Name: idx_16966_fk_account_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16966_fk_account_has_contact_contact1_idx ON account_can_view_contact (contact_guid);


--
-- TOC entry 2316 (class 1259 OID 202597)
-- Name: idx_16969_fk_account_has_task_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16969_fk_account_has_task_account1_idx ON account_can_view_task (account_guid);


--
-- TOC entry 2317 (class 1259 OID 202598)
-- Name: idx_16969_fk_account_has_task_task1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16969_fk_account_has_task_task1_idx ON account_can_view_task (task_guid);


--
-- TOC entry 2320 (class 1259 OID 202599)
-- Name: idx_16972_fk_account_private_settings_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16972_fk_account_private_settings_account1_idx ON account_private_settings (account_guid);


--
-- TOC entry 2326 (class 1259 OID 202600)
-- Name: idx_16988_fk_activity_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16988_fk_activity_account1_idx ON activity (ownerguid);


--
-- TOC entry 2327 (class 1259 OID 202601)
-- Name: idx_16988_fk_activity_task1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16988_fk_activity_task1_idx ON activity (taskguid);


--
-- TOC entry 2334 (class 1259 OID 202602)
-- Name: idx_16994_fk_activityattachments_activity1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_16994_fk_activityattachments_activity1_idx ON activityattachments (activity_guid);


--
-- TOC entry 2330 (class 1259 OID 202603)
-- Name: idx_17000_fk_activity_has_contact_activity1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17000_fk_activity_has_contact_activity1_idx ON activity_has_contact (activity_guid);


--
-- TOC entry 2331 (class 1259 OID 202604)
-- Name: idx_17000_fk_activity_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17000_fk_activity_has_contact_contact1_idx ON activity_has_contact (contact_guid);


--
-- TOC entry 2337 (class 1259 OID 202605)
-- Name: idx_17003_fk_category_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17003_fk_category_account1_idx ON category  (ownerguid);


--
-- TOC entry 2340 (class 1259 OID 202607)
-- Name: idx_17010_fk_category_has_contact_category1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17010_fk_category_has_contact_category1_idx ON category_has_contact  (category_guid);


--
-- TOC entry 2341 (class 1259 OID 202608)
-- Name: idx_17010_fk_category_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17010_fk_category_has_contact_contact1_idx ON category_has_contact  (contact_guid);


--
-- TOC entry 2346 (class 1259 OID 202609)
-- Name: idx_17019_fk_contact_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17019_fk_contact_account1_idx ON contact  (ownerguid);


--
-- TOC entry 2349 (class 1259 OID 202610)
-- Name: idx_17027_fk_contactaddress_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17027_fk_contactaddress_contact1_idx ON contactaddress  (contact_guid);


--
-- TOC entry 2352 (class 1259 OID 202611)
-- Name: idx_17034_fk_contactcustomfieldcontent_contactcustomfieldname1_; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17034_fk_contactcustomfieldcontent_contactcustomfieldname1_ ON contactcustomfieldcontent  (contactcustomfieldname_id);


--
-- TOC entry 2357 (class 1259 OID 202612)
-- Name: idx_17046_fk_contactdate_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17046_fk_contactdate_contact1_idx ON contactdate  (contact_guid);


--
-- TOC entry 2360 (class 1259 OID 202613)
-- Name: idx_17052_fk_contactemail_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17052_fk_contactemail_contact_idx ON contactemail  (contact_guid);


--
-- TOC entry 2363 (class 1259 OID 202614)
-- Name: idx_17058_contact_guid_unique; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17058_contact_guid_unique ON contactfulltext  (contact_guid);


--
-- TOC entry 2364 (class 1259 OID 202615)
-- Name: idx_17058_fk_contactfullcontext_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17058_fk_contactfullcontext_contact1_idx ON contactfulltext  (contact_guid);


--
-- TOC entry 2368 (class 1259 OID 202616)
-- Name: idx_17064_fk_contactim_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17064_fk_contactim_contact_idx ON contactim  (contact_guid);


--
-- TOC entry 2371 (class 1259 OID 202617)
-- Name: idx_17070_fk_contactimage_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17070_fk_contactimage_contact1_idx ON contactimage  (contact_guid);


--
-- TOC entry 2374 (class 1259 OID 202618)
-- Name: idx_17076_fk_contactjobinfo_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17076_fk_contactjobinfo_contact1_idx ON contactjobinfo  (contact_guid);


--
-- TOC entry 2377 (class 1259 OID 202619)
-- Name: idx_17082_fk_contactname_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17082_fk_contactname_contact1_idx ON contactname  (contact_guid);


--
-- TOC entry 2380 (class 1259 OID 202620)
-- Name: idx_17088_fk_contactphone_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17088_fk_contactphone_contact1_idx ON contactphone  (contact_guid);


--
-- TOC entry 2383 (class 1259 OID 202621)
-- Name: idx_17094_contact_guid_unique; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17094_contact_guid_unique ON contactsimpleinfo  (contact_guid);


--
-- TOC entry 2384 (class 1259 OID 202622)
-- Name: idx_17094_fk_contactsimpleinfo_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17094_fk_contactsimpleinfo_contact1_idx ON contactsimpleinfo  (contact_guid);


--
-- TOC entry 2387 (class 1259 OID 202623)
-- Name: idx_17100_fk_contactsocial_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17100_fk_contactsocial_contact_idx ON contactsocial  (contact_guid);


--
-- TOC entry 2390 (class 1259 OID 202624)
-- Name: idx_17106_fk_contactstatusforaccount_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17106_fk_contactstatusforaccount_account1_idx ON contactstatusforaccount  (account_guid);


--
-- TOC entry 2391 (class 1259 OID 202625)
-- Name: idx_17106_fk_contactstatusforaccount_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17106_fk_contactstatusforaccount_contact1_idx ON contactstatusforaccount  (contact_guid);


--
-- TOC entry 2394 (class 1259 OID 202626)
-- Name: idx_17106_unique_contact_account_pair; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX idx_17106_unique_contact_account_pair ON contactstatusforaccount  (contact_guid, account_guid);


--
-- TOC entry 2395 (class 1259 OID 202627)
-- Name: idx_17113_fk_contacturl_contact_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17113_fk_contacturl_contact_idx ON contacturl  (contact_guid);


--
-- TOC entry 2402 (class 1259 OID 202628)
-- Name: idx_17131_fk_notice_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17131_fk_notice_account1_idx ON notice  (receiverguid);


--
-- TOC entry 2409 (class 1259 OID 202629)
-- Name: idx_17157_fk_task_account1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17157_fk_task_account1_idx ON task  (ownerguid);


--
-- TOC entry 2410 (class 1259 OID 202630)
-- Name: idx_17157_fk_task_account2_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17157_fk_task_account2_idx ON task  (creatorguid);


--
-- TOC entry 2413 (class 1259 OID 202631)
-- Name: idx_17163_fk_task_has_contact_contact1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17163_fk_task_has_contact_contact1_idx ON task_has_contact  (contact_guid);


--
-- TOC entry 2414 (class 1259 OID 202632)
-- Name: idx_17163_fk_task_has_contact_task1_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX idx_17163_fk_task_has_contact_task1_idx ON task_has_contact  (task_guid);

--
-- TOC entry 2479 (class 2606 OID 202633)
-- Name: account fk_account_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account
    ADD CONSTRAINT fk_account_account1 FOREIGN KEY (boss) REFERENCES account(guid);


--
-- TOC entry 2480 (class 2606 OID 202638)
-- Name: account fk_account_company; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account
    ADD CONSTRAINT fk_account_company FOREIGN KEY (company_guid) REFERENCES company(guid);


--
-- TOC entry 2481 (class 2606 OID 202643)
-- Name: account_can_view_activity fk_account_has_activity_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_can_view_activity
    ADD CONSTRAINT fk_account_has_activity_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2482 (class 2606 OID 202648)
-- Name: account_can_view_activity fk_account_has_activity_activity1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_can_view_activity
    ADD CONSTRAINT fk_account_has_activity_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- TOC entry 2483 (class 2606 OID 202653)
-- Name: account_can_view_contact fk_account_has_contact_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_can_view_contact
    ADD CONSTRAINT fk_account_has_contact_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2484 (class 2606 OID 202658)
-- Name: account_can_view_contact fk_account_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_can_view_contact
    ADD CONSTRAINT fk_account_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2485 (class 2606 OID 202663)
-- Name: account_can_view_task fk_account_has_task_task1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_can_view_task
    ADD CONSTRAINT fk_account_has_task_task1 FOREIGN KEY (task_guid) REFERENCES task(guid);


--
-- TOC entry 2486 (class 2606 OID 202668)
-- Name: account_can_view_task fk_account_has_task_viewers; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_can_view_task
    ADD CONSTRAINT fk_account_has_task_viewers FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2487 (class 2606 OID 202673)
-- Name: account_private_settings fk_account_private_settings_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  account_private_settings
    ADD CONSTRAINT fk_account_private_settings_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2488 (class 2606 OID 202678)
-- Name: accountsharetargetsetting fk_accountsharetargetsetting_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  accountsharetargetsetting
    ADD CONSTRAINT fk_accountsharetargetsetting_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2489 (class 2606 OID 202683)
-- Name: activity fk_activity_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  activity
    ADD CONSTRAINT fk_activity_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2491 (class 2606 OID 202688)
-- Name: activity_has_contact fk_activity_has_contact_activity1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  activity_has_contact
    ADD CONSTRAINT fk_activity_has_contact_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- TOC entry 2492 (class 2606 OID 202693)
-- Name: activity_has_contact fk_activity_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  activity_has_contact
    ADD CONSTRAINT fk_activity_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2490 (class 2606 OID 202698)
-- Name: activity fk_activity_task1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  activity
    ADD CONSTRAINT fk_activity_task1 FOREIGN KEY (taskguid) REFERENCES task(guid);


--
-- TOC entry 2493 (class 2606 OID 202703)
-- Name: activityattachments fk_activityattachments_activity1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  activityattachments
    ADD CONSTRAINT fk_activityattachments_activity1 FOREIGN KEY (activity_guid) REFERENCES activity(guid);


--
-- TOC entry 2494 (class 2606 OID 202708)
-- Name: category fk_category_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  category
    ADD CONSTRAINT fk_category_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2495 (class 2606 OID 202713)
-- Name: category_has_contact fk_category_has_contact_category1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  category_has_contact
    ADD CONSTRAINT fk_category_has_contact_category1 FOREIGN KEY (category_guid) REFERENCES category(guid);


--
-- TOC entry 2496 (class 2606 OID 202718)
-- Name: category_has_contact fk_category_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  category_has_contact
    ADD CONSTRAINT fk_category_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2497 (class 2606 OID 202723)
-- Name: contact fk_contact_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contact
    ADD CONSTRAINT fk_contact_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2498 (class 2606 OID 202728)
-- Name: contactaddress fk_contactaddress_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactaddress
    ADD CONSTRAINT fk_contactaddress_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2523 (class 2606 OID 203077)
-- Name: contactcustomdata fk_contactcustomdata_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactcustomdata
    ADD CONSTRAINT fk_contactcustomdata_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2499 (class 2606 OID 202733)
-- Name: contactcustomfieldcontent fk_contactcustomfieldcontent_contactcustomfieldname1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactcustomfieldcontent
    ADD CONSTRAINT fk_contactcustomfieldcontent_contactcustomfieldname1 FOREIGN KEY (contactcustomfieldname_id) REFERENCES contactcustomfieldname(guid);


--
-- TOC entry 2500 (class 2606 OID 202738)
-- Name: contactdate fk_contactdate_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactdate
    ADD CONSTRAINT fk_contactdate_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2501 (class 2606 OID 202743)
-- Name: contactemail fk_contactemail_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactemail
    ADD CONSTRAINT fk_contactemail_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2502 (class 2606 OID 202748)
-- Name: contactfulltext fk_contactfullcontext_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactfulltext
    ADD CONSTRAINT fk_contactfullcontext_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2503 (class 2606 OID 202753)
-- Name: contactim fk_contactim_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactim
    ADD CONSTRAINT fk_contactim_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2504 (class 2606 OID 202758)
-- Name: contactimage fk_contactimage_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactimage
    ADD CONSTRAINT fk_contactimage_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2505 (class 2606 OID 202763)
-- Name: contactjobinfo fk_contactjobinfo_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactjobinfo
    ADD CONSTRAINT fk_contactjobinfo_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2506 (class 2606 OID 202768)
-- Name: contactname fk_contactname_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactname
    ADD CONSTRAINT fk_contactname_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2507 (class 2606 OID 202773)
-- Name: contactphone fk_contactphone_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactphone
    ADD CONSTRAINT fk_contactphone_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2508 (class 2606 OID 202778)
-- Name: contactsimpleinfo fk_contactsimpleinfo_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactsimpleinfo
    ADD CONSTRAINT fk_contactsimpleinfo_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2509 (class 2606 OID 202783)
-- Name: contactsocial fk_contactsocial_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactsocial
    ADD CONSTRAINT fk_contactsocial_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2510 (class 2606 OID 202788)
-- Name: contactstatusforaccount fk_contactstatusforaccount_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactstatusforaccount
    ADD CONSTRAINT fk_contactstatusforaccount_account1 FOREIGN KEY (account_guid) REFERENCES account(guid);


--
-- TOC entry 2511 (class 2606 OID 202793)
-- Name: contactstatusforaccount fk_contactstatusforaccount_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contactstatusforaccount
    ADD CONSTRAINT fk_contactstatusforaccount_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2512 (class 2606 OID 202798)
-- Name: contacturl fk_contacturl_contact; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  contacturl
    ADD CONSTRAINT fk_contacturl_contact FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2513 (class 2606 OID 202803)
-- Name: notice fk_notice_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  notice
    ADD CONSTRAINT fk_notice_account1 FOREIGN KEY (receiverguid) REFERENCES account(guid);


--
-- TOC entry 2514 (class 2606 OID 202808)
-- Name: task fk_task_account1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  task
    ADD CONSTRAINT fk_task_account1 FOREIGN KEY (ownerguid) REFERENCES account(guid);


--
-- TOC entry 2515 (class 2606 OID 202813)
-- Name: task fk_task_account2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  task
    ADD CONSTRAINT fk_task_account2 FOREIGN KEY (creatorguid) REFERENCES account(guid);


--
-- TOC entry 2516 (class 2606 OID 202818)
-- Name: task_has_contact fk_task_has_contact_contact1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  task_has_contact
    ADD CONSTRAINT fk_task_has_contact_contact1 FOREIGN KEY (contact_guid) REFERENCES contact(guid);


--
-- TOC entry 2517 (class 2606 OID 202823)
-- Name: task_has_contact fk_task_has_contact_task1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  task_has_contact
    ADD CONSTRAINT fk_task_has_contact_task1 FOREIGN KEY (task_guid) REFERENCES task(guid);


--
-- TOC entry 2524 (class 2606 OID 203138)
-- Name: picklist_content picklist_content_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE  picklist_content
    ADD CONSTRAINT picklist_content_fk FOREIGN KEY (customfield_guid) REFERENCES customfield(guid);
    
    
    
INSERT INTO company VALUES ('aabc2320-58a7-4b59-b292-bb4a07873893','DEFAULT_COMPANY');
INSERT INTO globalinfo VALUES ('c25f7c19-929b-4971-8e57-168c4cb9efc8','SHARE_RULE','BY_SETTING');
--INSERT INTO account VALUES ('c96f7c19-929b-4971-8e57-168c4cb9efc8','admin@penpower.com.tw','8y6kWzmoVzyrllmEvNeIRw==','admin',NULL,'2016-04-25 12:24:42.522','ACTIVE','ADMIN',1,NULL,'aabc2320-58a7-4b59-b292-bb4a07873893',NULL,NULL,NULL,NULL);
--INSERT INTO account_private_settings(guid,contactsperpage, mapengine, westernsurnameorder, asiansurnameorder, showownerinfo, autoshare, sharecontact, sharetask, shareactivity, shareaccounts, lastnoticecountview, sortingorder,identificationresult, account_guid)VALUES ('c96f7c19-929b-4971-8e57-168c4cb9eabc', 1,'AUTO', 'FIRSTNAME_LASTNAME','LASTNAME_FIRSTNAME', 0,0,0,0,0,null,'1970-01-01 11:22:33.999','NAME','CONTACT_CONTENT','c96f7c19-929b-4971-8e57-168c4cb9efc8')

