/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.servlet.swagger;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    private static final String API_TITLE = "World Card Team API";
    private static final String API_DESCRIPTION = "";
    private static final String API_VERSION = "1.0";
    private static final String STATUS_CODE_500_MESSAGE = "Unknow exception , check error message or contact your Administrator.";
    private static final String STATUS_CODE_404_MESSAGE = "Api not found or params incorrect.";
    private static final String STATUS_CODE_401_MESSAGE = "Unauthorized or authentication failed.";
    private static final String STATUS_CODE_469_MESSAGE = "Access with unbinding device or not-allowed IP address";
    private static final String AUTH_TOKEN_DESCRIPTION = "Authentication Token";

    @Bean
    public UiConfiguration uiConfig() {
        return UiConfiguration.DEFAULT;
    }

    @Bean
    public Docket globalApi() {
        List responseMessages = this.createGlobalResponseMessages();
        ArrayList<Parameter> operationParamters = new ArrayList<Parameter>();
        Parameter parameter = new ParameterBuilder().name("X-Auth-Token").description(AUTH_TOKEN_DESCRIPTION).modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(true).build();
        operationParamters.add(parameter);
        Docket swaggerSpringMvcPlugin = new Docket(DocumentationType.SWAGGER_2).groupName("apis").globalResponseMessage(RequestMethod.GET, responseMessages).globalResponseMessage(RequestMethod.POST, responseMessages).globalOperationParameters(operationParamters).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/api/.*")).build().apiInfo(this.metadata());
        return swaggerSpringMvcPlugin;
    }

    private List<ResponseMessage> createGlobalResponseMessages() {
        ArrayList<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
        ResponseMessageBuilder builder = new ResponseMessageBuilder();
        ResponseMessage global500 = builder.code(500).message(STATUS_CODE_500_MESSAGE).build();
        ResponseMessage global469 = builder.code(469).message(STATUS_CODE_469_MESSAGE).build();
        responseMessages.add(global500);
        responseMessages.add(global469);
        return responseMessages;
    }

    @Bean
    public Docket authApi() {
        List responseMessages = this.createGlobalResponseMessages();
        Docket swaggerSpringMvcPlugin = new Docket(DocumentationType.SWAGGER_2).groupName("authentication").globalResponseMessage(RequestMethod.GET, responseMessages).globalResponseMessage(RequestMethod.POST, responseMessages).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/auth/.*")).build().apiInfo(this.metadata());
        return swaggerSpringMvcPlugin;
    }

    @Bean
    public Docket SystemApi() {
        List responseMessages = this.createGlobalResponseMessages();
        Docket swaggerSpringMvcPlugin = new Docket(DocumentationType.SWAGGER_2).groupName("System").globalResponseMessage(RequestMethod.GET, responseMessages).globalResponseMessage(RequestMethod.POST, responseMessages).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/system/.*")).build().apiInfo(this.metadata());
        return swaggerSpringMvcPlugin;
    }

    @Bean
    public Docket CustomerApi() {
        List responseMessages = this.createGlobalResponseMessages();
        ArrayList<Parameter> operationParameters = new ArrayList<Parameter>();
        Parameter parameter = new ParameterBuilder().name("X-Auth-Token").description(AUTH_TOKEN_DESCRIPTION).modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(true).build();
        operationParameters.add(parameter);
        Docket swaggerSpringMvcPlugin = new Docket(DocumentationType.SWAGGER_2).groupName("Customer").globalResponseMessage(RequestMethod.GET, responseMessages).globalResponseMessage(RequestMethod.POST, responseMessages).select().apis(RequestHandlerSelectors.any()).paths(PathSelectors.regex((String)"/customer/.*|/auth/login_with_ad|/auth/login2|/auth/logout|/system/IsAlive")).build().apiInfo(this.metadata());
        return swaggerSpringMvcPlugin;
    }

    private ApiInfo metadata() {
        return new ApiInfoBuilder().title(API_TITLE).description(API_DESCRIPTION).version(API_VERSION).build();
    }
}

