/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.servlet.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.penpower.worldcard.team.config.ApplicationConfig;
import java.io.IOException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDesrializer
extends StdScalarDeserializer<DateTime> {
    private static final Logger LOG = LoggerFactory.getLogger(DateTimeDesrializer.class);
    private static final long serialVersionUID = 1L;

    public DateTimeDesrializer() {
        super(DateTime.class);
    }

    public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            String dateTimeAsString = jsonParser.getText().trim();
            DateTime time = ApplicationConfig.DATE_TIME_FORMATTER.parseDateTime(dateTimeAsString);
            return time;
        }
        return null;
    }
}

