/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.servlet;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.auth.ReadOnlyStatusManager;
import com.penpower.worldcard.team.enums.ReadOnlyType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import com.penpower.worldcard.team.web.servlet.SystemStatusInterceptor;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

public class SystemStatusInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SystemStatusInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LOG.debug("Check system READ_ONLY_STATUS : {} ", (Object)ReadOnlyStatusManager.READ_ONLY_STATUS.get());
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        ServerType serverType = GlobalUtils.getServerType();
        LOG.debug("SystemStatusInterceptor  serverType= {} ", (Object)serverType);
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[serverType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                LOG.debug(String.format("serverType:%s, skip the storage check", serverType));
                super.preHandle(request, response, handler);
            }
        }
        LOG.debug("*** check request method : {}  , request URL : {} ", (Object)httpRequest.getMethod(), (Object)httpRequest.getRequestURI());
        if (ReadOnlyStatusManager.READ_ONLY_STATUS.get()) {
            httpResponse.setContentType("application/json;charset=UTF-8");
            httpResponse.setStatus(200);
            ReadOnlyType readOnlyType = (ReadOnlyType)ReadOnlyStatusManager.READ_ONLY_TYPE.get();
            boolean backupReadOnlyType = ReadOnlyType.BACKUP.equals((Object)readOnlyType);
            boolean restoreReadOnlyType = ReadOnlyType.RESTORE.equals((Object)readOnlyType);
            LOG.debug("backupReadOnlyType : {} ", (Object)backupReadOnlyType);
            LOG.debug("restoreReadOnlyType : {} ", (Object)restoreReadOnlyType);
            if (backupReadOnlyType || restoreReadOnlyType) {
                String path = new UrlPathHelper().getPathWithinApplication(httpRequest);
                LOG.debug("path : {} ", (Object)path);
                if (backupReadOnlyType) {
                    boolean needToCheckReadOnlyApiPath = ReadOnlyStatusManager.NEED_TO_CHECK_READONLY_API_PATHS.contains(path);
                    LOG.debug("needToCheckReadOnlyApiPath : {} ", (Object)needToCheckReadOnlyApiPath);
                    if (needToCheckReadOnlyApiPath) {
                        String message = "System is running backup mode now....";
                        int errorCode = 499;
                        String errorMessage = "";
                        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
                        Gson gson = new Gson();
                        String unAuthorizedMessage = gson.toJson((Object)result);
                        try (ServletOutputStream ServletOutputStream2 = response.getOutputStream();){
                            ServletOutputStream2.println(unAuthorizedMessage);
                        }
                        return false;
                    }
                } else if (restoreReadOnlyType) {
                    if (ReadOnlyStatusManager.RESTORE_API_PATHS.contains(path)) {
                        return super.preHandle(request, response, handler);
                    }
                    LOG.debug("restore mode on , reject all request api.....");
                    String message = "System is running restore mode now....";
                    int errorCode = 498;
                    String errorMessage = "";
                    ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
                    Gson gson = new Gson();
                    String unAuthorizedMessage = gson.toJson((Object)result);
                    try (ServletOutputStream ServletOutputStream3 = response.getOutputStream();){
                        ServletOutputStream3.println(unAuthorizedMessage);
                    }
                    return false;
                }
            }
        }
        return super.preHandle(request, response, handler);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        super.postHandle(request, response, handler, modelAndView);
    }
}

