/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.vo;

import com.penpower.worldcard.team.enums.ServerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private int Major = 0;
    private int Minor = 0;
    private int Number = 0;
    private int Release = 0;
    private ServerType serverType;
    private String ApiName;
    private String Describe;

    public VersionInfo(String version, String apiName, ServerType svrType, String describe) {
        String[] parts = version.split("\\.");
        this.ApiName = apiName;
        this.Describe = describe;
        if (parts.length < 4) {
            throw new RuntimeException("fail version");
        }
        this.Major = Integer.valueOf(parts[0]);
        this.Minor = Integer.valueOf(parts[1]);
        this.Release = Integer.valueOf(parts[2]);
        this.Number = Integer.valueOf(parts[3]);
        this.serverType = svrType;
    }

    public int getRelease() {
        return this.Release;
    }

    public int getMajor() {
        return this.Major;
    }

    public int getMinor() {
        return this.Minor;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setRelease(int rRelease) {
        this.Release = rRelease;
    }

    public void setMajor(int major) {
        this.Major = major;
    }

    public void setMinor(int minor) {
        this.Minor = minor;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public String getVersion() {
        return "V" + this.Major + "." + this.Minor + "." + this.Release + "." + this.Number;
    }

    public String getApiName() {
        return this.ApiName;
    }

    public void setApiName(String apiName) {
        this.ApiName = apiName;
    }

    public String getDescribe() {
        return this.Describe;
    }

    public void setDescribe(String describe) {
        this.Describe = describe;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public void setServerType(ServerType rserverType) {
        this.serverType = rserverType;
    }
}

