/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.vo;

import com.penpower.worldcard.team.Utils.TimeUtil;
import com.penpower.worldcard.team.enums.SubscriberCreateType;
import com.penpower.worldcard.team.enums.SubscriptionType;
import com.penpower.worldcard.team.web.api.vo.SubscriptionPeriod;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;

public class SubscriptionInfoVo {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionInfoVo.class);
    private String companyName;
    private String phone;
    private String email;
    private String countryID;
    private String serviceId;
    private String contactName;
    private long serviceDays;
    private SubscriberCreateType subscriberCreateType;
    private String wctVersion;
    private String webVersion;
    private String oldServiceId;
    private String macaddress;
    private int accountNum;
    private LocalDate validateDate;
    Boolean hasAdditionalSubscription;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime currentDateTime;
    private List<SubscriptionPeriod> subscriptionInfos;
    private List<SubscriptionPeriod> lastExpiredSubscriptionInfos;
    @ApiModelProperty(dataType="java.lang.String", required=true, example="1970-01-01 11:22:33.999")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss.SSS")
    private DateTime expiredDateTime;

    public int getAccountNum() {
        return this.accountNum;
    }

    public void setAccountNum(int accountNum) {
        this.accountNum = accountNum;
    }

    public LocalDate getValidateDate() {
        return this.validateDate;
    }

    public void setValidateDate(LocalDate validateDate) {
        this.validateDate = validateDate;
    }

    public String toString() {
        String strRtn = "SubscriptionInfoVo  companyName=" + this.companyName + ", phone=" + this.phone + ", email=" + this.email + ", countryID=" + this.countryID + ", serviceId =" + this.serviceId + ", currentDateTime =" + this.currentDateTime + ", expiredDateTime =" + this.expiredDateTime + ", subscriptionInfos size =" + this.subscriptionInfos.size() + ", lastExpiredSubscriptionInfos size =" + this.lastExpiredSubscriptionInfos.size() + "] \r\n ";
        if (this.subscriptionInfos != null) {
            for (SubscriptionPeriod sp : this.subscriptionInfos) {
                strRtn = strRtn + sp.toString() + "\r\n";
            }
        }
        if (this.lastExpiredSubscriptionInfos != null) {
            for (SubscriptionPeriod sp : this.lastExpiredSubscriptionInfos) {
                strRtn = strRtn + sp.toString() + "\r\n";
            }
        }
        return strRtn;
    }

    public String getMacaddress() {
        return this.macaddress;
    }

    public void setMacaddress(String rmacaddress) {
        this.macaddress = rmacaddress;
    }

    public void resetToUnlimit() {
        this.validateDate = null;
        this.lastExpiredSubscriptionInfos.clear();
        this.subscriptionInfos.clear();
        SubscriptionPeriod subscriptionPeriod = new SubscriptionPeriod();
        subscriptionPeriod.setAccountNumber(10);
        subscriptionPeriod.setSubscriptionType(SubscriptionType.BUYOUT);
        this.subscriptionInfos.add(subscriptionPeriod);
    }

    public List<SubscriptionPeriod> getLastExpiredSubscriptionInfos() {
        return this.lastExpiredSubscriptionInfos;
    }

    public void setLastExpiredSubscriptionInfos(List<SubscriptionPeriod> lastExpiredSubscriptionInfos) {
        this.lastExpiredSubscriptionInfos = lastExpiredSubscriptionInfos;
    }

    public List<SubscriptionPeriod> getSubscriptionInfos() {
        return this.subscriptionInfos;
    }

    public void setSubscriptionInfos(List<SubscriptionPeriod> rsubscriptionInfos) {
        this.subscriptionInfos = rsubscriptionInfos;
    }

    public DateTime checkValidateDatetime() {
        if (this.currentDateTime == null) {
            return null;
        }
        return this.currentDateTime.plusDays(30);
    }

    public SubscriptionPeriod checkLastPeriod() {
        for (SubscriptionPeriod subscriptionInfo : this.subscriptionInfos) {
            if (subscriptionInfo.getSubscriptionType() == SubscriptionType.BUYOUT) {
                return subscriptionInfo;
            }
            LOG.debug("checkCurrentPeriod   getTimeRangeEnd ={}  now={}", (Object)subscriptionInfo.getTimeRangeEnd(), (Object)DateTime.now());
            if (!subscriptionInfo.getTimeRangeEnd().isAfterNow()) continue;
            return subscriptionInfo;
        }
        return null;
    }

    public DateTime checkLastValidateTime() {
        DateTime currdt = null;
        for (SubscriptionPeriod subscriptionInfo : this.subscriptionInfos) {
            if (subscriptionInfo.getSubscriptionType() == SubscriptionType.BUYOUT) {
                return null;
            }
            LOG.debug("checkCurrentPeriod   getTimeRangeEnd ={}  now={}", (Object)subscriptionInfo.getTimeRangeEnd(), (Object)DateTime.now());
            if (!subscriptionInfo.getTimeRangeEnd().isAfterNow()) continue;
            if (currdt == null) {
                currdt = subscriptionInfo.getTimeRangeEnd();
                continue;
            }
            currdt = TimeUtil.GetAfter((DateTime)currdt, (DateTime)subscriptionInfo.getTimeRangeEnd());
        }
        return currdt;
    }

    public SubscriptionPeriod checkCurrentPeriod() {
        for (SubscriptionPeriod subscriptionInfo : this.subscriptionInfos) {
            if (subscriptionInfo.getSubscriptionType() == SubscriptionType.BUYOUT) {
                return subscriptionInfo;
            }
            LOG.debug("checkCurrentPeriod  getTimeRangeStart={} getTimeRangeEnd ={}  now={}", new Object[]{subscriptionInfo.getTimeRangeStart(), subscriptionInfo.getTimeRangeEnd(), DateTime.now()});
            if (!subscriptionInfo.getTimeRangeStart().isBeforeNow() || !subscriptionInfo.getTimeRangeEnd().isAfterNow()) continue;
            return subscriptionInfo;
        }
        return null;
    }

    public boolean isNeedCheckValidate() {
        LOG.debug("isNeedCheckValidate  checkValidateDatetime={} now={}", (Object)this.checkValidateDatetime(), (Object)DateTime.now());
        if (this.checkValidateDatetime() == null || this.checkValidateDatetime().isBeforeNow()) {
            LOG.debug("isNeedCheckValidate = true");
            return true;
        }
        return false;
    }

    public int checkCurrentAccountCountLimit() {
        LOG.debug("checkCurrentAccountCountLimit ");
        if (this.isNeedCheckValidate()) {
            return 0;
        }
        SubscriptionPeriod subscriptionPeriod = this.checkCurrentPeriod();
        if (subscriptionPeriod != null) {
            LOG.debug("checkCurrentAccountCountLimit = subscriptionPeriod ={}", (Object)subscriptionPeriod);
            int nRtn = subscriptionPeriod.getAccountNumber();
            LOG.debug("checkCurrentAccountCountLimit nRtn={}", (Object)nRtn);
            return nRtn;
        }
        LOG.debug("checkCurrentAccountCountLimit = 0");
        return 0;
    }

    public int checkLastTrialAccountCountLimit() {
        LOG.debug("checkCurrentAccountCountLimit ");
        if (this.isNeedCheckValidate()) {
            return 0;
        }
        SubscriptionPeriod subscriptionPeriod = this.checkLastPeriod();
        if (subscriptionPeriod != null) {
            LOG.debug("checkCurrentAccountCountLimit = subscriptionPeriod ={}", (Object)subscriptionPeriod);
            int nRtn = subscriptionPeriod.getAccountNumber();
            LOG.debug("checkCurrentAccountCountLimit nRtn={}", (Object)nRtn);
            return nRtn;
        }
        LOG.debug("checkCurrentAccountCountLimit = 0");
        return 0;
    }

    public SubscriptionPeriod GetLastPeriod() {
        SubscriptionPeriod cursubscriptionPeriod = null;
        if (this.subscriptionInfos != null) {
            DateTime currdt = null;
            for (SubscriptionPeriod period : this.subscriptionInfos) {
                if (period.getSubscriptionType() == SubscriptionType.BUYOUT) {
                    return period;
                }
                if (currdt == null) {
                    currdt = period.getTimeRangeEnd();
                    cursubscriptionPeriod = period;
                    continue;
                }
                if (!period.getTimeRangeEnd().isAfter((ReadableInstant)currdt)) continue;
                currdt = period.getTimeRangeEnd();
                cursubscriptionPeriod = period;
            }
        } else {
            return null;
        }
        return cursubscriptionPeriod;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String rcompanyName) {
        this.companyName = rcompanyName;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String rtelphone) {
        this.phone = rtelphone;
    }

    public String getCoutryID() {
        return this.countryID;
    }

    public void setCoutryID(String rcoutryID) {
        this.countryID = rcoutryID;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String remail) {
        this.email = remail;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public DateTime getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public void setExpiredDateTime(DateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public void setCurrentDateTime(DateTime currentDateTime) {
        this.currentDateTime = currentDateTime;
        LOG.debug("Setcurrentdate={} ", (Object)currentDateTime);
    }

    public DateTime getCurrentDateTime() {
        return this.currentDateTime;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getWebVersion() {
        return this.webVersion;
    }

    public void setWebVersion(String webVersion) {
        this.webVersion = webVersion;
    }

    public String getWctVersione() {
        return this.wctVersion;
    }

    public void setWctVersione(String wctVersion) {
        this.wctVersion = wctVersion;
    }

    public String getOldServiceId() {
        return this.oldServiceId;
    }

    public void setOldServiceId(String oldServiceId) {
        this.oldServiceId = oldServiceId;
    }

    public long geServiceDays() {
        return this.serviceDays;
    }

    public void setServiceDays(long serviceDays) {
        this.serviceDays = serviceDays;
    }

    public SubscriberCreateType getSubscriberCreateType() {
        return this.subscriberCreateType;
    }

    public void setSubscriberCreateType(SubscriberCreateType subscriberCreateType) {
        this.subscriberCreateType = subscriberCreateType;
    }

    public boolean isHasAdditionalSubscription() {
        if (this.hasAdditionalSubscription == null) {
            return false;
        }
        return this.hasAdditionalSubscription;
    }
}

