/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.login;

import com.penpower.worldcard.team.Utils.ApplicationContextProvider;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.LicenseNeedToReactiveException;
import com.penpower.worldcard.team.exception.SubscriptionLockedException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;
import com.penpower.worldcard.team.web.api.login.ReactiveLicenseRuleHandler;
import com.penpower.worldcard.team.web.api.vo.LicenseVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ReactiveLicenseRuleHandler
extends LoginRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveLicenseRuleHandler.class);
    private SubscriptionService subscriptionService;
    private AccountService accountService;

    public ReactiveLicenseRuleHandler(LoginRuleHandler loginRuleHandler) {
        super(loginRuleHandler);
        ApplicationContext springApplicationContext = ApplicationContextProvider.getApplicationContext();
        this.accountService = (AccountService)springApplicationContext.getBean("accountService");
        this.subscriptionService = (SubscriptionService)springApplicationContext.getBean("subscriptionService");
    }

    public void doCheck(LoginRuntimeInfo loginRuntimeInfo) {
        LicenseVo licenseVo = loginRuntimeInfo.getLicenseVo();
        LOG.debug(" doCheck ReactiveLicenseRuleHandler   loginRuntimeInfo = {} ", (Object)loginRuntimeInfo);
        boolean IsAdminAccount = false;
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.accountService.getAccountInfo(null, loginRuntimeInfo.getLoginEmail());
        }
        catch (ItemNotFoundException e) {
            LOG.debug(" doCheck account not exist return");
        }
        if (accountInfo != null && accountInfo.getRole() == UserRole.ADMIN) {
            IsAdminAccount = true;
        }
        LOG.debug(" doCheck licenseVo.getLicenseMode == {} ", (Object)licenseVo.getLicenseMode());
        block1 : switch (1.$SwitchMap$com$penpower$worldcard$team$enums$LicenseMode[licenseVo.getLicenseMode().ordinal()]) {
            default: {
                LOG.debug(" doCheck licenseVo.getServerRegisterStatus == {} ", (Object)licenseVo.getServerRegisterStatus());
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerRegisterStatus[licenseVo.getServerRegisterStatus().ordinal()]) {
                    default: {
                        throw new LicenseNeedToReactiveException("License need to reactive.");
                    }
                    case 2: {
                        if (!IsAdminAccount) {
                            throw new SubscriptionLockedException("License expired in Register mode");
                        }
                        this.process(loginRuntimeInfo);
                        break block1;
                    }
                    case 3: {
                        throw new LicenseNeedToReactiveException("server never be actived.");
                    }
                    case 4: 
                    case 5: 
                }
                this.process(loginRuntimeInfo);
                break;
            }
            case 2: {
                LOG.debug(" doCheck licenseVo.getSubscriptionStatus == {} ", (Object)licenseVo.getSubscriptionStatus());
                switch (1.$SwitchMap$com$penpower$worldcard$team$enums$SubscriptionStatus[licenseVo.getSubscriptionStatus().ordinal()]) {
                    default: {
                        if (!IsAdminAccount) {
                            throw new SubscriptionLockedException("License lock in subscription mode");
                        }
                        this.process(loginRuntimeInfo);
                        break block1;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                }
                this.process(loginRuntimeInfo);
            }
        }
    }
}

