/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.login;

import com.penpower.worldcard.team.Utils.ApplicationContextProvider;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.VerifySource;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.web.api.login.LoginRuleHandler;
import com.penpower.worldcard.team.web.api.login.LoginRuntimeInfo;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AccountSecurityRuleHandler
extends LoginRuleHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AccountSecurityRuleHandler.class);
    private AccountSecurityService accountSecurityService;
    private AccountService accountService;

    public AccountSecurityRuleHandler(LoginRuleHandler loginRuleHandler) {
        super(loginRuleHandler);
        ApplicationContext springApplicationContext = ApplicationContextProvider.getApplicationContext();
        this.accountSecurityService = (AccountSecurityService)springApplicationContext.getBean("accountSecurityService");
        this.accountService = (AccountService)springApplicationContext.getBean("accountService");
    }

    public void doCheck(LoginRuntimeInfo loginRuntimeInfo) throws RuntimeException {
        LOG.debug("===================AccountSecurityRuleHandler started===================");
        String deviceId = loginRuntimeInfo.getDeviceId();
        String deviceName = loginRuntimeInfo.getDeviceName();
        Platform platform = loginRuntimeInfo.getPlatform();
        String remoteIpaddress = loginRuntimeInfo.getRemoteIpaddress();
        DateTime serverTime = loginRuntimeInfo.getServerTime();
        AccountInfo account = this.accountService.getAccountInfo(null, loginRuntimeInfo.getLoginEmail());
        this.accountSecurityService.verifyPlatformAndDevice(deviceId, deviceName, platform);
        this.accountSecurityService.createNewLoginRecord(account.getGuid(), deviceId, deviceName, platform, serverTime);
        this.accountSecurityService.verifyAccountSecurity(VerifySource.LOGIN, account.getGuid(), remoteIpaddress, deviceId, deviceName, platform, serverTime);
        LOG.debug("===================AccountSecurityRuleHandler finished(Login success)===================");
        this.accountSecurityService.updateLoginTimeForBackupRestoreRecord(account.getGuid(), deviceId, serverTime);
        this.process(loginRuntimeInfo);
    }
}

