/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.error;

import com.penpower.worldcard.team.exception.ActiveDirectoryAccountExpiredException;
import com.penpower.worldcard.team.exception.ActiveDirectoryConnectionException;
import com.penpower.worldcard.team.exception.ActiveDirectoryInvalidCredentialsException;
import com.penpower.worldcard.team.exception.ActiveDirectoryPasswordExpiredException;
import com.penpower.worldcard.team.exception.ActiveDirectoryUserMustRestPasswordException;
import com.penpower.worldcard.team.exception.ActiveDirectoryUserNotFoundException;
import com.penpower.worldcard.team.exception.LdapBusyException;
import com.penpower.worldcard.team.exception.LdapInvalidCredentialsException;
import com.penpower.worldcard.team.exception.LdapRuntimeException;
import com.penpower.worldcard.team.exception.LdapUnavaiableException;
import com.penpower.worldcard.team.web.api.vo.response.ErrorResponseInfoResult;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@Order(value=-2147483648)
public class LdapExceptionControllerAdvice {
    @ExceptionHandler(value={ActiveDirectoryConnectionException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> activeDirectoryConnectionException(Exception e, HttpServletResponse response) {
        String message = "Fail to connect to AD server.";
        int errorCode = 471;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ActiveDirectoryInvalidCredentialsException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> activeDirectoryInvalidCredentialsException(Exception e, HttpServletResponse response) {
        String message = "Indicates an Active Directory (AD) AcceptSecurityContext error, <BR>which is returned when the username is valid<BR>but the combination of password and user credential is invalid. ";
        int errorCode = 472;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ActiveDirectoryUserNotFoundException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> activeDirectoryUserNotFoundException(Exception e, HttpServletResponse response) {
        String message = "Indicates an Active Directory (AD) AcceptSecurityContext data error<BR> that is returned when the username is invalid.";
        int errorCode = 473;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ActiveDirectoryPasswordExpiredException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> activeDirectoryPasswordExpiredException(Exception e, HttpServletResponse response) {
        String message = "Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The specified account password has expired.<BR>Returns only when presented with valid username and password credential.";
        int errorCode = 474;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ActiveDirectoryAccountExpiredException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> activeDirectoryAccountExpiredException(Exception e, HttpServletResponse response) {
        String message = "Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The user's account has expired.<BR>Returns only when presented with valid username and password credential.";
        int errorCode = 475;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={ActiveDirectoryUserMustRestPasswordException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> activeDirectoryUserMustRestPasswordException(Exception e, HttpServletResponse response) {
        String message = "Indicates an Active Directory (AD) AcceptSecurityContext data error.<BR>The user's password must be changed before logging on the first time.<BR>Returns only when presented with valid user-name and password credential.";
        int errorCode = 476;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LdapInvalidCredentialsException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ldapInvalidCredentialsException(Exception e, HttpServletResponse response) {
        String message = "Indicates that during a bind operation one of the following occurred:<BR>The client passed either an incorrect DN or password,<BR>or the password is incorrect because it has expired,<BR>intruder detection has locked the account, or another similar reason.";
        int errorCode = 477;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LdapBusyException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ldapBusyException(Exception e, HttpServletResponse response) {
        String message = "Indicates that the LDAP server is too busy to process the client request at this time<BR>but if the client waits and resubmits the request,<BR>the server may be able to process it then.";
        int errorCode = 478;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LdapUnavaiableException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ldapUnavaiableException(Exception e, HttpServletResponse response) {
        String message = "Indicates that the LDAP server cannot process the client's bind request,<BR>usually because it is shutting down.";
        int errorCode = 479;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }

    @ExceptionHandler(value={LdapRuntimeException.class})
    @ResponseBody
    public ErrorResponseInfoResult<?, ?> ldapRuntimeException(Exception e, HttpServletResponse response) {
        String message = "Other ldap runtime exception occurs.";
        int errorCode = 470;
        String errorMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
        ErrorResponseInfoResult result = new ErrorResponseInfoResult(message, errorCode, errorMessage, null);
        return result;
    }
}

