/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.aop;

import com.penpower.worldcard.team.exception.ServiceBusyException;
import com.penpower.worldcard.team.web.api.aop.RequestLimit;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class RequestLimitAspect {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLimitAspect.class);
    private static final ConcurrentHashMap<String, AtomicInteger> REQUEST_LIMIT_CACHE = new ConcurrentHashMap();

    @Around(value="execution(@com.penpower.worldcard.team.web.api.aop.RequestLimit * *(..)) && @annotation(requestLimit)")
    public Object logDuration(ProceedingJoinPoint joinPoint, RequestLimit requestLimit) throws Throwable {
        LOG.debug("The RequestLimit annotation fount at api declare............ [{}]", (Object)Thread.currentThread().getName());
        int requestCountLimit = requestLimit.limitCount();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        LOG.debug("check request URI : {} ", (Object)request.getRequestURI());
        String requestUri = request.getRequestURI();
        AtomicInteger requestCount = (AtomicInteger)REQUEST_LIMIT_CACHE.get(requestUri);
        if (requestCount == null) {
            requestCount = new AtomicInteger(1);
            REQUEST_LIMIT_CACHE.put(requestUri, requestCount);
        } else {
            int currentRequestCount = requestCount.get();
            if (currentRequestCount >= requestCountLimit || currentRequestCount + 1 > requestCountLimit) {
                String exceptionMessage = String.format("Request limit exceeded.(uri : %s)", requestUri);
                throw new ServiceBusyException(exceptionMessage);
            }
            requestCount.incrementAndGet();
            REQUEST_LIMIT_CACHE.put(requestUri, requestCount);
        }
        Object result = null;
        try {
            result = joinPoint.proceed();
        }
        finally {
            requestCount.decrementAndGet();
            REQUEST_LIMIT_CACHE.put(requestUri, requestCount);
        }
        return result;
    }
}

