/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api.aop;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.entity.LogPerformance;
import com.penpower.worldcard.team.service.RequestLogService;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ControllerLogAspect {
    private static final Logger LOG = LoggerFactory.getLogger(ControllerLogAspect.class);
    @Autowired
    private RequestLogService requestLogService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Pointcut(value="execution(* com.penpower.worldcard.team.web.api.*.*(..))")
    public void methodPointcut() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void requestMapping() {
    }

    @Around(value="methodPointcut() && requestMapping()")
    public Object aroundAdvice(ProceedingJoinPoint pjp) throws Throwable {
        boolean logEnable = this.applicationProperties.getBooleanProperty("LOG_ENABLE");
        LOG.debug("logEnable : {}", (Object)logEnable);
        if (!logEnable) {
            LOG.debug("Log setting is false , skip add new log .....");
            Object retVal = pjp.proceed();
            return retVal;
        }
        LOG.debug("Log setting is true , add new log .....");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        long startTime = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        long endTime = System.currentTimeMillis();
        LogPerformance logPerformance = new LogPerformance();
        try {
            AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
            String userGuid = currentLoginUser.getGuid();
            logPerformance.setUserGuid(userGuid);
        }
        catch (Exception ex) {
            logPerformance.setUserGuid("NONE");
        }
        logPerformance.setGuid(UUIDGenerator.getRandomUUID());
        logPerformance.setBeginTime(new DateTime(startTime));
        logPerformance.setEndTime(new DateTime(endTime));
        logPerformance.setCommandName(methodName);
        logPerformance.setConsumeTime(Long.valueOf(endTime - startTime));
        this.requestLogService.addNewLog(logPerformance);
        return retVal;
    }
}

