/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.contactsystem.ContactServerBasicToken;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.NoticeDao;
import com.penpower.worldcard.team.dao.PostgreSqlSystemInfoDao;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactServerAuthService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.Office365OperationService;
import com.penpower.worldcard.team.service.SalesForceTokenService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.TokenService;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import okhttp3.OkHttpClient;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@CrossOrigin
@RequestMapping(value={"/api/test"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"test"}, description="simple test api for http GET and POST request.")
public class TestController {
    private static final Logger LOG = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private JavaMailSender javaMailSender;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private SalesForceTokenService salesForceTokenService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private ScheduleManager scheduleManager;
    @Autowired
    AccountService accountService;
    @Autowired
    private Environment env;
    @Autowired
    private NoticeDao noticeDao;
    @Autowired
    private PostgreSqlSystemInfoDao postgreSqlSystemInfoDao;
    @Autowired
    private ContactSimpleInfoDao contactSimpleInfoDao;
    @Autowired
    private ContactService contactService;
    @Autowired
    private PathManager cardPathManager;
    @Value(value="${LOG_HOME}")
    private String logHome;
    @Value(value="${Servertype}")
    private String serverType;
    @Value(value="${ENV_VAL:NULL}")
    private String valuel1;
    @Autowired
    private Office365OperationService office365OperationService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactServerAuthService contactServerAuthService;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager databaseScheduleManager;

    @RequestMapping(value={"/sendmail"}, method={RequestMethod.GET})
    public void sendmail(@RequestParam(value="Result") String Result2) {
        LOG.debug("sENDmAIL START Result ={}", (Object)Result2);
        this.accountService.setSyncTSMCResult(Result2);
    }

    @RequestMapping(value={"/getstatus"}, method={RequestMethod.GET})
    public MessageResponseResult getstatus(@RequestParam boolean deepd) {
        String message = "Get status before: " + this.contactService.getDeeplyDeleteContactJobStatus();
        this.contactService.setDeeplyDeleteContactJobStatus(deepd);
        message = message + "\r\nGet status after: " + this.contactService.getDeeplyDeleteContactJobStatus();
        MessageResponseResult respone = new MessageResponseResult("getstatus", message);
        return respone;
    }

    @RequestMapping(value={"/testldap"}, method={RequestMethod.GET})
    public MessageResponseResult testldap(@RequestParam String ldapUsername, @RequestParam String ldapPassword, @RequestParam String ldapAccountToLookup, @RequestParam String ldapSearchBase, @RequestParam String ldapAdServer) {
        LOG.info("ldapUsername={}", (Object)ldapUsername);
        LOG.info("ldapPassword={}", (Object)ldapPassword);
        LOG.info("ldapAccountToLookup={}", (Object)ldapAccountToLookup);
        LOG.info("ldapSearchBase={}", (Object)ldapSearchBase);
        LOG.info("ldapAdServer={}", (Object)ldapAdServer);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        if (ldapUsername != null) {
            env.put("java.naming.security.principal", ldapUsername);
        }
        if (ldapPassword != null) {
            env.put("java.naming.security.credentials", ldapPassword);
        }
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapAdServer);
        env.put("java.naming.ldap.attributes.binary", "objectSID");
        String resultspone = "";
        try {
            LOG.info("testldap initial");
            InitialLdapContext ctx = new InitialLdapContext();
            LOG.info("testldap search");
            NamingEnumeration results = this.findAccountByAccountName((DirContext)ctx, ldapSearchBase, ldapAccountToLookup);
            LOG.info("SearchResult={}", (Object)results);
            if (results != null) {
                while (results.hasMore()) {
                    SearchResult result = (SearchResult)results.next();
                    String primaryGroupSID = this.getPrimaryGroupSID(result);
                    LOG.info("primaryGroupSID={}", (Object)primaryGroupSID);
                    String primaryGroupName = this.findGroupBySID((DirContext)ctx, ldapSearchBase, primaryGroupSID);
                    LOG.info("primaryGroupName={}", (Object)primaryGroupName);
                    resultspone = resultspone + primaryGroupSID + "\r\n" + primaryGroupName + "\r\n";
                }
            }
        }
        catch (Exception e) {
            LOG.info("exception ={}", (Object)e.getMessage());
        }
        MessageResponseResult respone = new MessageResponseResult("testldap", resultspone);
        return respone;
    }

    public NamingEnumeration<SearchResult> findAccountByAccountName(DirContext ctx, String ldapSearchBase, String accountName) throws NamingException {
        String searchFilter = "(&(objectClass=user)";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search("", searchFilter, searchControls);
        return results;
    }

    public String findGroupBySID(DirContext ctx, String ldapSearchBase, String sid) throws NamingException {
        String searchFilter = "(&(objectClass=group)(objectSid=" + sid + "))";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingEnumeration<SearchResult> results = ctx.search(ldapSearchBase, searchFilter, searchControls);
        if (results.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)results.nextElement();
            if (results.hasMoreElements()) {
                LOG.info("Matched multiple groups for the group with SID: " + sid);
                return null;
            }
            return (String)searchResult.getAttributes().get("sAMAccountName").get();
        }
        return null;
    }

    public String getPrimaryGroupSID(SearchResult srLdapUser) throws NamingException {
        byte[] objectSID = (byte[])srLdapUser.getAttributes().get("objectSid").get();
        String strPrimaryGroupID = (String)srLdapUser.getAttributes().get("primaryGroupID").get();
        String strObjectSid = TestController.decodeSID((byte[])objectSID);
        return strObjectSid.substring(0, strObjectSid.lastIndexOf(45) + 1) + strPrimaryGroupID;
    }

    public static String decodeSID(byte[] sid) {
        StringBuilder strSid = new StringBuilder("S-");
        byte revision = sid[0];
        strSid.append(Integer.toString(revision));
        int countSubAuths = sid[1] & 0xFF;
        long authority = 0L;
        for (int i = 2; i <= 7; ++i) {
            authority |= (long)sid[i] << 8 * (5 - (i - 2));
        }
        strSid.append("-");
        strSid.append(Long.toHexString(authority));
        int offset = 8;
        int size = 4;
        for (int j = 0; j < countSubAuths; ++j) {
            long subAuthority = 0L;
            for (int k = 0; k < size; ++k) {
                subAuthority |= (long)(sid[offset + k] & 0xFF) << 8 * k;
            }
            strSid.append("-");
            strSid.append(subAuthority);
            offset += size;
        }
        return strSid.toString();
    }

    private ContactServerSettingsWithTokenDto refreshTokenProcees(String accountGuid, ContactServerSettingsWithTokenDto contactServerSetting, OkHttpClient client) {
        SupportContactServer supportContactServer = contactServerSetting.getSupportContactServer();
        if (SupportContactServer.OFFICE365.equals((Object)supportContactServer)) {
            DateTime lastUpdateTokenTime = contactServerSetting.getLastUpdateTokenTime() == null ? GlobalUtils.getEarliestTime() : contactServerSetting.getLastUpdateTokenTime();
            DateTime now = DateTime.now();
            LOG.debug("lastUpdateTokenTime={}, now={}", (Object)lastUpdateTokenTime, (Object)now);
            if (now.isAfter((ReadableInstant)lastUpdateTokenTime.plusMinutes(20))) {
                ContactServerBasicToken basicToken = this.contactServerAuthService.refreshToken(supportContactServer, contactServerSetting.getBasicToken().getRefresh_token(), contactServerSetting.getSettingPlatform(), client);
                LOG.debug("refreshToken success basicToken={}", (Object)basicToken);
                this.accountPrivateSettingService.updateOffice365AuthInfo(accountGuid, new ContactServerSettingsWithTokenDto(contactServerSetting.getAccount(), basicToken, now, contactServerSetting.getSettingPlatform()));
                contactServerSetting.setBasicToken(basicToken);
                contactServerSetting.setLastUpdateTokenTime(now);
            }
        }
        return contactServerSetting;
    }
}

