/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.RegistryDto;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Registry;
import com.penpower.worldcard.team.enums.Country;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.exception.MethodNotAllowedException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SubscriptionNotSupportException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.web.api.vo.SubscriptionInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LongResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/register"})
public class RegisterController {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterController.class);
    @Autowired
    private RegistryService registryService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private SubscriptionService subscriptionService;

    @ApiOperation(value="Register", notes="Register server whit auth")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/isReachMaxCount"}, method={RequestMethod.POST})
    public BooleanResponseResult GetisReachMaxCount() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.BUYOUT) {
            throw new MethodNotAllowedException("getAllRegistry can't call at SUBSCRIPTION mode");
        }
        BooleanResponseResult response = new BooleanResponseResult("get isReachMaxCount success.", Boolean.valueOf(this.isReachMaxCount()));
        return response;
    }

    private boolean isReachMaxCount() {
        return false;
    }

    @ApiOperation(value="Register", notes="Register server whit auth")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=445, message="This Machine is illegal for registeration"), @ApiResponse(code=405, message="license code is invalid <BR>")})
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public MessageResponseResult create(@RequestParam String email, @RequestParam String licenseCode) {
        LOG.debug("LIbrary path  : {} ", (Object)System.getProperty("java.library.path"));
        if (StringUtil.IsStringNullorEmpty((String)licenseCode) || StringUtil.IsStringNullorEmpty((String)email)) {
            throw new RequestArgumentNotValidException("one of  licenseCode, email is empty");
        }
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        if (currentLoginAccount != null) {
            LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
            if (lm == LicenseMode.SUBSCRIPTION) {
                SubscriptionInfoVo subscriptionInfoVo = this.subscriptionService.getSubscriptionInfo(currentLoginAccount.getCompanyGuid());
                this.registryService.RegisterwithoutTrial(email, licenseCode, subscriptionInfoVo.getCompanyName(), subscriptionInfoVo.getPhone(), true, subscriptionInfoVo.getCoutryID());
                Company company = this.companyService.findOne(currentLoginAccount.getCompanyGuid());
                company.setName(subscriptionInfoVo.getCompanyName());
                company.setTelphone(subscriptionInfoVo.getPhone());
                this.companyService.UpdateCompany(company);
            } else {
                Company company = this.companyService.findOne(currentLoginAccount.getCompanyGuid());
                this.registryService.RegisterwithoutTrial(email, licenseCode, company.getName(), company.getTelphone(), true, "");
            }
            this.subscriptionService.setLicenseMode(currentLoginAccount.getCompanyGuid(), LicenseMode.BUYOUT);
            this.registryService.CheckLicenseValidate(currentLoginAccount.getCompanyGuid());
        }
        MessageResponseResult response = new MessageResponseResult("Create registry success.", "");
        return response;
    }

    @RequestMapping(value={"/convertToSubscription"}, method={RequestMethod.GET})
    @ApiOperation(value="Convert license mode", notes="Convert license mode to subscription mode")
    @ApiResponses(value={@ApiResponse(code=405, message="license code is invalid <BR>"), @ApiResponse(code=404, message="Can't connect to register server. <BR>")})
    public MessageResponseResult convertToSubscription() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.BUYOUT) {
            throw new MethodNotAllowedException("convertToRegister can't call at SUBSCRIPTION mode");
        }
        RegistryDto LastTrialregistryDto = this.registryService.getRegistryTrial();
        if (LastTrialregistryDto == null) {
            throw new MethodNotAllowedException("convertToRegister can't call non register mode");
        }
        long leftday = LastTrialregistryDto.getExpiredLeftDays();
        Registry registry = this.registryService.getSystemRegInfo(currentLoginAccount.getCompanyGuid());
        String ContactName = "";
        AccountInfo accountInfo = this.accountService.getAccountInfo(null, registry.getEmail());
        if (accountInfo != null) {
            ContactName = accountInfo.getName();
        }
        Company company = this.companyService.findOne(accountInfo.getCompanyGuid());
        if (!this.registryService.IsAnyRegisterSupportSubscription() && !this.subscriptionService.IsCurrentLocateSupportSubscription()) {
            LOG.debug("IsSupportSubscription false");
            throw new SubscriptionNotSupportException("Canot support Subscription func in this locate");
        }
        this.subscriptionService.ConvertToSubscription(registry.getEmail(), company.getName(), company.getTelphone(), Country.other, ContactName, leftday, company.getGuid());
        this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.SUBSCRIPTION);
        MessageResponseResult response = new MessageResponseResult("convert to subsription mode success.", "");
        return response;
    }

    @RequestMapping(value={"/getAllRegistry"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Registries", notes="Get All Registry information")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=405, message="license code is invalid <BR>")})
    public ListResponseResult<RegistryDto> getAllRegistry() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.BUYOUT) {
            throw new MethodNotAllowedException("getAllRegistry can't call at SUBSCRIPTION mode");
        }
        List registrys = this.registryService.getRegistryInfo(false);
        ListResponseResult response = new ListResponseResult("Get all accounts information succeeded.", registrys);
        return response;
    }

    @RequestMapping(value={"/getAccountLimit"}, method={RequestMethod.GET})
    @ApiOperation(value="Get Registries limit", notes="Get the maxium registry count")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR> Maybe admin account need or only access when first time create registry"), @ApiResponse(code=405, message="license code is invalid <BR>")})
    public LongResponseResult getAccountLimit() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.BUYOUT) {
            throw new MethodNotAllowedException("getAllRegistry can't call at SUBSCRIPTION mode");
        }
        LOG.debug("getAccountLimit 1");
        Long accountLImit = new Long(this.registryService.getLicenseCount(true));
        LOG.debug("getAccountLimit 2 count={}", (Object)accountLImit);
        String strCount = String.valueOf(accountLImit);
        LOG.debug("getAccountLimit 3 count={}", (Object)strCount);
        LongResponseResult response = new LongResponseResult("Get all accounts information succeeded.", accountLImit);
        LOG.debug("getAccountLimit 4 ");
        return response;
    }

    @ApiOperation(value="refresh Register", notes="triager wct server to get Register info from Reg server")
    @RequestMapping(value={"/RefreshRegisterInfo"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=405, message="license code is invalid <BR>")})
    public BooleanResponseResult RefreshRegisterInfo() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        LicenseMode lm = this.subscriptionService.getLicenseMode(currentLoginAccount.getCompanyGuid());
        if (lm != LicenseMode.BUYOUT) {
            throw new MethodNotAllowedException("getAllRegistry can't call at BUYOUT mode");
        }
        this.registryService.DownloadRegistryInfo(currentLoginAccount.getCompanyGuid(), false);
        BooleanResponseResult response = new BooleanResponseResult("RefreshRegisterInfo", Boolean.valueOf(true));
        return response;
    }
}

