/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.mchange.v1.lang.BooleanUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountPrivateSettingDto;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.ContactRangeType;
import com.penpower.worldcard.team.enums.ContactsimpleinfoSortField;
import com.penpower.worldcard.team.enums.NameOrder;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SearchEngineInitializationNotFinshedException;
import com.penpower.worldcard.team.exception.SearchEngineNotRunningException;
import com.penpower.worldcard.team.exception.SearchEngineSpaceInsufficientException;
import com.penpower.worldcard.team.scheduler.job.RebuildElasticsearchIndexJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactSearchService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.SearchService;
import com.penpower.worldcard.team.web.api.aop.RequestLimit;
import com.penpower.worldcard.team.web.api.vo.PageInfoVo;
import com.penpower.worldcard.team.web.api.vo.SearchPageSetting;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/search/normal"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"normal search"}, description="normal search")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class NormalSearchController {
    private static final Logger LOG = LoggerFactory.getLogger(NormalSearchController.class);
    @Autowired
    SearchService dbNormalSearchService;
    @Autowired
    AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private ContactSearchService contactSearchService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private ElasticSearchService elasticSearchService;

    private String getLowerCaseKeyWord(String keyWord) {
        return StringUtils.isEmpty((CharSequence)keyWord) ? "" : keyWord.toLowerCase();
    }

    @ApiOperation(value="", notes="<BR><BR>StatusCode:495<BR>\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u6642\uff0c\u6703\u5c0e\u81f4\u4ee5\u4e0b\u5169\u7a2e\u72c0\u6cc1\uff1a<BR>1. \u641c\u5c0b\u5f15\u64ce\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6703\u4e1ferrorCode:495 exception\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7121\u6cd5\u521d\u59cb\u5316<BR>2. \u641c\u5c0b\u5f15\u64ce\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u53ef\u4ee5\u641c\u5c0b\u5230\u8cc7\u6599\uff0c\u4f46[errorData]\u6703\u56de\u50b3495(type=int)\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7684index\u7121\u6cd5\u66f4\u65b0(\u641c\u5c0b\u5230\u820a\u8cc7\u6599)<BR><BR>StatusCode:491<BR>\u7b2c\u4e00\u6b21\u4f7f\u7528searchEngine\u6642\uff0c\u6703\u9032\u884c\u521d\u59cb\u5316\u7684\u52d5\u4f5c\uff0c\u82e5\u6b64\u6642\u9032\u884c\u641c\u5c0b\uff0c\u6703\u4e1ferrorCode:491 exception<BR>\u4e26\u5728[errorData]\u986f\u793a\u521d\u59cb\u5316\u5b8c\u6210\u9032\u5ea6\u7684\u767e\u5206\u6bd4\u3002(type=double)")
    @ApiResponses(value={@ApiResponse(code=494, message="Unspecified exception for searchEngine"), @ApiResponse(code=495, message="Search result are not up-to-date because of insufficient disk space"), @ApiResponse(code=491, message="Search engine initialization is not finished."), @ApiResponse(code=493, message="Search engine indexing data is missing"), @ApiResponse(code=492, message="Search engine is not running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=425, message="Request limit exceeded , server busy."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/search_private_contact_by_keyword_sorted"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @RequestLimit(limitCount=4)
    public PageResponseResult<ContactSimpleInfoDto> searcPrivateContactByKeywordSorted(@RequestParam(required=true) String keyWord, @RequestParam(required=true) int page, @RequestParam(required=true) int pageSize, @RequestParam(required=true) ContactsimpleinfoSortField contactsimpleinfoSortField, @RequestParam(required=true) Sort.Direction sortDirection) {
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE");
        boolean indexCompleteForWCT = BooleanUtils.parseBoolean((String)globalInfo.getConfigValue());
        if (!indexCompleteForWCT) {
            if (!this.elasticSearchService.searchEngineExist()) {
                throw new SearchEngineNotRunningException("Search engine is not running");
            }
            if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
                throw new SearchEngineSpaceInsufficientException("Search engine initialization can't finished due to insufficient disk-space.");
            }
            double percent = this.contactService.getSearchEngineIndexInitializationPercentage();
            throw new SearchEngineInitializationNotFinshedException(Double.valueOf(percent));
        }
        if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
            throw new SearchEngineSpaceInsufficientException("Search engine disk-space insufficient");
        }
        if (StringUtils.isBlank((CharSequence)keyWord)) {
            PageResponseResult response = new PageResponseResult(String.format("Search private contact by keyword sorted succeeded.", new Object[0]), null, 0L, 0);
            return response;
        }
        this.checkPageAndPageSize(page, pageSize);
        AccountInfo loginUser = SecurityUtils.getCurrentLoginUser();
        SearchPageSetting searchPageSetting = new SearchPageSetting(Integer.valueOf(page), Integer.valueOf(pageSize), contactsimpleinfoSortField, sortDirection, ContactRangeType.PRIVATE);
        PageInfoVo contactSearchResult = this.contactSearchService.searchContactForNormal(keyWord, searchPageSetting, loginUser);
        PageResponseResult response = new PageResponseResult(String.format("Search private contact by keyword sorted succeeded.", new Object[0]), (List)contactSearchResult.getPageContent(), contactSearchResult.getTotalCount(), contactSearchResult.getTotalPage());
        return response;
    }

    @ApiOperation(value="", notes="StatusCode:495<BR><BR>\u5728\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u6642\uff0c\u6703\u5c0e\u81f4\u4ee5\u4e0b\u5169\u7a2e\u72c0\u6cc1\uff1a<BR>1. \u641c\u5c0b\u5f15\u64ce\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6703\u4e1ferrorCode:495 exception\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7121\u6cd5\u521d\u59cb\u5316<BR>2. \u641c\u5c0b\u5f15\u64ce\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u53ef\u4ee5\u641c\u5c0b\u5230\u8cc7\u6599\uff0c\u4f46[errorData]\u6703\u56de\u50b3495(type=int)\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7684index\u7121\u6cd5\u66f4\u65b0(\u641c\u5c0b\u5230\u820a\u8cc7\u6599)<BR><BR>StatusCode:491<BR>\u7b2c\u4e00\u6b21\u4f7f\u7528searchEngine\u6642\uff0c\u6703\u9032\u884c\u521d\u59cb\u5316\u7684\u52d5\u4f5c\uff0c\u82e5\u6b64\u6642\u9032\u884c\u641c\u5c0b\uff0c\u6703\u4e1ferrorCode:491 exception<BR>\u4e26\u5728errorDate\u986f\u793a\u521d\u59cb\u5316\u5b8c\u6210\u9032\u5ea6\u7684\u767e\u5206\u6bd4\u3002(type=double)")
    @ApiResponses(value={@ApiResponse(code=494, message="Unspecified exception for searchEngine"), @ApiResponse(code=495, message="Search result are not up-to-date because of insufficient disk space"), @ApiResponse(code=491, message="Search engine initialization is not finished."), @ApiResponse(code=493, message="Search engine indexing data is missing"), @ApiResponse(code=492, message="Search engine is not running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=425, message="Request limit exceeded , server busy."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/search_public_contact_by_keyword_sorted"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @RequestLimit(limitCount=4)
    public PageResponseResult<ContactSimpleInfoDto> searchPublicContactByKeywordSorted(@RequestParam(required=true) String keyWord, @RequestParam(required=true) int page, @RequestParam(required=true) int pageSize, @RequestParam(required=true) ContactsimpleinfoSortField contactsimpleinfoSortField, @RequestParam(required=true) Sort.Direction sortDirection) {
        long startTime = System.currentTimeMillis();
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE");
        boolean indexCompleteForWCT = BooleanUtils.parseBoolean((String)globalInfo.getConfigValue());
        if (!indexCompleteForWCT) {
            if (!this.elasticSearchService.searchEngineExist()) {
                throw new SearchEngineNotRunningException("Search engine is not running");
            }
            if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
                throw new SearchEngineSpaceInsufficientException("Search engine initialization can't finished due to insufficient disk-space.");
            }
            double percent = this.contactService.getSearchEngineIndexInitializationPercentage();
            throw new SearchEngineInitializationNotFinshedException(Double.valueOf(percent));
        }
        if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
            throw new SearchEngineSpaceInsufficientException("Search engine disk-space insufficient");
        }
        if (StringUtils.isBlank((CharSequence)keyWord)) {
            PageResponseResult response = new PageResponseResult(String.format("Search public contact by keyword sorted succeeded.", new Object[0]), null, 0L, 0);
            return response;
        }
        this.checkPageAndPageSize(page, pageSize);
        AccountInfo loginUser = SecurityUtils.getCurrentLoginUser();
        SearchPageSetting searchPageSetting = new SearchPageSetting(Integer.valueOf(page), Integer.valueOf(pageSize), contactsimpleinfoSortField, sortDirection, ContactRangeType.PUBLIC);
        PageInfoVo contactSearchResult = this.contactSearchService.searchContactForNormal(keyWord, searchPageSetting, loginUser);
        this.contactPublicService.markDownloadStatusOfContactsByAccount((List)contactSearchResult.getPageContent(), loginUser.getGuid());
        PageResponseResult response = new PageResponseResult(String.format("Search public contact by keyword sorted succeeded.", new Object[0]), (List)contactSearchResult.getPageContent(), contactSearchResult.getTotalCount(), contactSearchResult.getTotalPage());
        long endTime = System.currentTimeMillis();
        LOG.debug("TotalSpendTime:{}", (Object)(endTime - startTime));
        return response;
    }

    private void checkPageAndPageSize(int page, int pageSize) {
        if (page < 0 || pageSize <= 0) {
            throw new RequestArgumentNotValidException("the page value cannot be less than 0 or pageSize cannot be less than equal to 0 value.");
        }
    }

    private String getSQLSortTableName(ContactsimpleinfoSortField contactsimpleinfoSortField) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        AccountPrivateSettingDto accountPrivateSettingDto = this.accountPrivateSettingService.getAllUserSettings(currentLoginUser.getGuid());
        NameOrder asianNameOrder = accountPrivateSettingDto.getAsianSurnameOrder();
        NameOrder westernNameOrder = accountPrivateSettingDto.getWesternSurnameOrder();
        if (contactsimpleinfoSortField.getTableName().equals("fullname")) {
            if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)asianNameOrder) && NameOrder.FIRSTNAME_LASTNAME.equals((Object)westernNameOrder)) {
                return "a.fullnameeastfirstwestfirst";
            }
            if (NameOrder.FIRSTNAME_LASTNAME.equals((Object)asianNameOrder) && NameOrder.LASTNAME_FIRSTNAME.equals((Object)westernNameOrder)) {
                return "a.fullnameeastfirstwestlast";
            }
            if (NameOrder.LASTNAME_FIRSTNAME.equals((Object)asianNameOrder) && NameOrder.FIRSTNAME_LASTNAME.equals((Object)westernNameOrder)) {
                return "a.fullnameeastlastwestfirst";
            }
            return "a.fullnameeastlastwestlast";
        }
        String sortTableName = "a." + contactsimpleinfoSortField.getTableName();
        return sortTableName;
    }

    @ApiOperation(value="", notes="\u53d6\u5f9710\u7b46\u516c\u6709\u5340\u540d\u7247\u95dc\u9375\u5b57autocomplete\u7684\u6e05\u55ae(\u76ee\u524d\u53ea\u5217fullname\u548ccompany)<BR><BR>StatusCode:495<BR>\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u6642\uff0c\u6703\u5c0e\u81f4\u4ee5\u4e0b\u5169\u7a2e\u72c0\u6cc1\uff1a<BR>1. \u641c\u5c0b\u5f15\u64ce\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6703\u4e1ferrorCode:495 exception\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7121\u6cd5\u521d\u59cb\u5316<BR>2. \u641c\u5c0b\u5f15\u64ce\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u53ef\u4ee5\u641c\u5c0b\u5230\u8cc7\u6599\uff0c\u4f46[errorData]\u6703\u56de\u50b3495(type=int)\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7684index\u7121\u6cd5\u66f4\u65b0(\u641c\u5c0b\u5230\u820a\u8cc7\u6599)<BR><BR>StatusCode:491<BR>\u7b2c\u4e00\u6b21\u4f7f\u7528searchEngine\u6642\uff0c\u6703\u9032\u884c\u521d\u59cb\u5316\u7684\u52d5\u4f5c\uff0c\u82e5\u6b64\u6642\u9032\u884c\u641c\u5c0b\uff0c\u6703\u4e1ferrorCode:491 exception<BR>\u4e26\u5728[errorData]\u986f\u793a\u521d\u59cb\u5316\u5b8c\u6210\u9032\u5ea6\u7684\u767e\u5206\u6bd4\u3002(type=double)")
    @ApiResponses(value={@ApiResponse(code=494, message="Unspecified exception for searchEngine"), @ApiResponse(code=495, message="Search result are not up-to-date because of insufficient disk space"), @ApiResponse(code=491, message="Search engine initialization is not finished."), @ApiResponse(code=493, message="Search engine indexing data is missing"), @ApiResponse(code=492, message="Search engine is not running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=425, message="Request limit exceeded , server busy."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_public_contact_autocomplete_list"}, method={RequestMethod.POST})
    public ListResponseResult<String> getPublicContactAutocompleteList(@RequestParam(required=true) String keyword) {
        long begin = System.currentTimeMillis();
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE");
        boolean indexCompleteForWCT = BooleanUtils.parseBoolean((String)globalInfo.getConfigValue());
        if (!indexCompleteForWCT) {
            if (!this.elasticSearchService.searchEngineExist()) {
                throw new SearchEngineNotRunningException("Search engine is not running");
            }
            if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
                throw new SearchEngineSpaceInsufficientException("Search engine initialization can't finished due to insufficient disk-space.");
            }
            double percent = this.contactService.getSearchEngineIndexInitializationPercentage();
            throw new SearchEngineInitializationNotFinshedException(Double.valueOf(percent));
        }
        if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
            throw new SearchEngineSpaceInsufficientException("Search engine disk-space insufficient");
        }
        AccountInfo user = SecurityUtils.getCurrentLoginUser();
        List autocompleteResult = this.contactSearchService.getContactAutocompleteList(user, keyword, ContactRangeType.PUBLIC);
        ListResponseResult response = new ListResponseResult("Get public contact autocomplete list succeeded", autocompleteResult);
        LOG.debug("Spend time:{}", (Object)(System.currentTimeMillis() - begin));
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f9710\u7b46\u79c1\u6709\u5340\u540d\u7247\u95dc\u9375\u5b57autocomplete\u7684\u6e05\u55ae(\u76ee\u524d\u53ea\u5217fullname\u548ccompany)<BR><BR>StatusCode:495<BR>\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u6642\uff0c\u6703\u5c0e\u81f4\u4ee5\u4e0b\u5169\u7a2e\u72c0\u6cc1\uff1a<BR>1. \u641c\u5c0b\u5f15\u64ce\u5c1a\u672a\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u6703\u4e1ferrorCode:495 exception\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7121\u6cd5\u521d\u59cb\u5316<BR>2. \u641c\u5c0b\u5f15\u64ce\u521d\u59cb\u5316\u5df2\u5b8c\u6210\uff0c\u53ef\u4ee5\u641c\u5c0b\u5230\u8cc7\u6599\uff0c\u4f46[errorData]\u6703\u56de\u50b3495(type=int)\uff0c\u8aaa\u660e\u56e0\u78c1\u789f\u7a7a\u9593\u4e0d\u8db3\u5c0e\u81f4searchEngine\u7684index\u7121\u6cd5\u66f4\u65b0(\u641c\u5c0b\u5230\u820a\u8cc7\u6599)<BR><BR>StatusCode:491<BR>\u7b2c\u4e00\u6b21\u4f7f\u7528searchEngine\u6642\uff0c\u6703\u9032\u884c\u521d\u59cb\u5316\u7684\u52d5\u4f5c\uff0c\u82e5\u6b64\u6642\u9032\u884c\u641c\u5c0b\uff0c\u6703\u4e1ferrorCode:491 exception<BR>\u4e26\u5728[errorData]\u986f\u793a\u521d\u59cb\u5316\u5b8c\u6210\u9032\u5ea6\u7684\u767e\u5206\u6bd4\u3002(type=double)")
    @ApiResponses(value={@ApiResponse(code=494, message="Unspecified exception for searchEngine"), @ApiResponse(code=495, message="Search result are not up-to-date because of insufficient disk space"), @ApiResponse(code=491, message="Search engine initialization is not finished."), @ApiResponse(code=493, message="Search engine indexing data is missing"), @ApiResponse(code=492, message="Search engine is not running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=425, message="Request limit exceeded , server busy."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_private_contact_autocomplete_list"}, method={RequestMethod.POST})
    public ListResponseResult<String> getPrivateContactAutocompleteList(@RequestParam(required=true) String keyword) {
        long begin = System.currentTimeMillis();
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("ELASTIC_SEARCH_INDEXING_COMPLETE");
        boolean indexCompleteForWCT = BooleanUtils.parseBoolean((String)globalInfo.getConfigValue());
        if (!indexCompleteForWCT) {
            if (!this.elasticSearchService.searchEngineExist()) {
                throw new SearchEngineNotRunningException("Search engine is not running");
            }
            if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
                throw new SearchEngineSpaceInsufficientException("Search engine initialization can't finished due to insufficient disk-space.");
            }
            double percent = this.contactService.getSearchEngineIndexInitializationPercentage();
            throw new SearchEngineInitializationNotFinshedException(Double.valueOf(percent));
        }
        if (RebuildElasticsearchIndexJob.CURRENT_DISK_SPACE_INSUFFICIENT.get()) {
            throw new SearchEngineSpaceInsufficientException("Search engine disk-space insufficient");
        }
        AccountInfo user = SecurityUtils.getCurrentLoginUser();
        List autocompleteResult = this.contactSearchService.getContactAutocompleteList(user, keyword, ContactRangeType.PRIVATE);
        ListResponseResult response = new ListResponseResult("Get private contact autocomplete list succeeded", autocompleteResult);
        LOG.debug("Spend time:{}", (Object)(System.currentTimeMillis() - begin));
        return response;
    }
}

