/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.WorldcardAddressJNI;
import com.penpower.worldcard.team.dto.MycardIdentification;
import com.penpower.worldcard.team.dto.MycardInfo;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.LangCode;
import com.penpower.worldcard.team.enums.VCardTarget;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.service.AccountMycardService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.web.api.MycardController;
import com.penpower.worldcard.team.web.api.vo.ContactAddressVo;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MycardResponseResult;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/mycard_unauth"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"mycard-unauth"})
public class MycardUnauthController {
    private static final Logger LOG = LoggerFactory.getLogger(MycardController.class);
    @Autowired
    private ContactService contactService;
    @Autowired
    private PathManager exportPathManager;
    @Autowired
    private AccountMycardService accountMycardService;
    @Autowired
    private AccountService accountService;

    @RequestMapping(value={"/get_mycard"}, method={RequestMethod.GET})
    public MycardResponseResult getMycard(@RequestParam String mycardId) {
        MycardIdentification mycardIdentification = this.accountMycardService.getMycardIdentification(mycardId);
        MycardInfo mycardInfo = this.accountMycardService.getMycardByIdentification(mycardIdentification, true);
        MycardResponseResult response = new MycardResponseResult("Get mycard succeeded.", mycardInfo);
        return response;
    }

    @RequestMapping(value={"/get_mycard_image_base64"}, method={RequestMethod.GET})
    public MessageResponseResult getMycard(@RequestParam String mycardId, @RequestParam ContactImageType imageType) {
        String imageBase64 = this.accountMycardService.getMycardImageBase64ByTypeAndIdentification(this.accountMycardService.getMycardIdentification(mycardId), imageType, true);
        if (imageBase64 == null) {
            throw new ItemNotFoundException(String.format("ImageType[%s] not found", imageType));
        }
        return new MessageResponseResult("Get contact image success.", imageBase64);
    }

    @RequestMapping(value={"export_to_vcard"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public void exportToVCard(@RequestParam String mycardId, @RequestParam(value="vcardTarget", required=false) VCardTarget vcardTarget, HttpServletResponse response) {
        vcardTarget = VCardTarget.GOOGLE_CONTACT;
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path currDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        String fileName = "VCard" + timefmater.print((ReadableInstant)currTime) + ".vcf";
        Path vCardFile = Paths.get(currDatePath.toString(), fileName);
        try {
            this.accountMycardService.exportOneVCard(this.accountMycardService.getMycardIdentification(mycardId), vCardFile.toString(), vcardTarget, true);
            File file = new File(vCardFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("text/vcard");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_to_outlookcsv"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public void exporToOutlookCSV(@RequestParam String mycardId, @RequestParam LangCode langCode, @RequestParam(required=false) boolean old, HttpServletResponse response) {
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path currDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path csvFile = Paths.get(currDatePath.toString(), "Outlook" + timefmater.print((ReadableInstant)currTime) + ".csv");
        try {
            this.accountMycardService.exportCSVForOutlook(this.accountMycardService.getMycardIdentification(mycardId), csvFile.toString(), langCode, true, old);
            File file = new File(csvFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_to_googlecsv"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void exportToGoogleCSV(@RequestParam String mycardId, HttpServletResponse response) {
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path currDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path csvFile = Paths.get(currDatePath.toString(), "gmail_" + timefmater.print((ReadableInstant)currTime) + ".csv");
        try {
            this.accountMycardService.exportToGmail(this.accountMycardService.getMycardIdentification(mycardId), csvFile.toString(), true);
            File file = new File(csvFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"trans_to_googleaddress"}, method={RequestMethod.POST})
    public MessageResponseResult TransToGoogleAddress(@RequestBody ContactAddressVo contactAddressVo) {
        String address = new WorldcardAddressJNI().GetGoogleAddress(contactAddressVo.getStreet(), contactAddressVo.getCity(), contactAddressVo.getState(), contactAddressVo.getZip(), contactAddressVo.getCountryName());
        return new MessageResponseResult("trans to google address success", address);
    }
}

