/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.MycardIdentification;
import com.penpower.worldcard.team.dto.MycardInfo;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.LangCode;
import com.penpower.worldcard.team.enums.VCardTarget;
import com.penpower.worldcard.team.exception.ForbiddenException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.service.AccountMycardService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.web.api.vo.MycardUpdateVo;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MycardResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MycardSettingResponseResult;
import io.swagger.annotations.Api;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/mycard"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"mycard"})
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class MycardController {
    private static final Logger LOG = LoggerFactory.getLogger(MycardController.class);
    @Autowired
    private AccountMycardService accountMycardService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private PathManager exportPathManager;

    @RequestMapping(value={"/upsert_mycard"}, method={RequestMethod.POST})
    public MessageResponseResult upsertMycard(@RequestBody @Valid MycardUpdateVo mycardUpdateVo, @RequestParam(value="mycardId") String mycardId) {
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        this.accountMycardService.upsertMycard(this.getMycardIdentification(currentLoginUserEmail, mycardId), mycardUpdateVo);
        return new MessageResponseResult("Update contact success.", "nothing return");
    }

    @RequestMapping(value={"/update_mycard_enable_option"}, method={RequestMethod.POST})
    public BooleanResponseResult updateMycardEnableOption(@RequestParam boolean enableMycard, @RequestParam(value="mycardId") String mycardId) {
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        this.accountMycardService.updateMycardEnableOption(this.getMycardIdentification(currentLoginUserEmail, mycardId), enableMycard);
        return new BooleanResponseResult("update sucess", Boolean.valueOf(enableMycard));
    }

    @RequestMapping(value={"/get_mycard_setting"}, method={RequestMethod.POST})
    public MycardSettingResponseResult getMycardSetting() throws Exception {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        List mycardSettings = this.accountMycardService.getMycardSettings(accountInfo.getEmail(), accountInfo.getCompanyGuid());
        MycardSettingResponseResult response = new MycardSettingResponseResult(String.format("Get mycard url guid[%s] succeeded.", accountInfo.getGuid()), mycardSettings);
        return response;
    }

    @RequestMapping(value={"/get_mycard"}, method={RequestMethod.GET})
    public MycardResponseResult getMycard(@RequestParam(value="mycardId") String mycardId) throws UnsupportedEncodingException {
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        MycardInfo mycardInfo = this.accountMycardService.getMycardByIdentification(this.getMycardIdentification(currentLoginUserEmail, mycardId), false);
        MycardResponseResult response = new MycardResponseResult("Get mycard succeeded.", mycardInfo);
        return response;
    }

    @RequestMapping(value={"/get_mycard_image_base64"}, method={RequestMethod.GET})
    public MessageResponseResult getMycard(@RequestParam ContactImageType imageType, @RequestParam(value="mycardId") String mycardId) throws IOException {
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        String imageBase64 = this.accountMycardService.getMycardImageBase64ByTypeAndIdentification(this.getMycardIdentification(currentLoginUserEmail, mycardId), imageType, false);
        if (imageBase64 == null) {
            throw new ItemNotFoundException(String.format("ImageType[%s] not found", imageType));
        }
        return new MessageResponseResult("Get contact image success.", imageBase64);
    }

    @RequestMapping(value={"export_to_vcard"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void exportToVCard(@RequestParam VCardTarget vcardTarget, @RequestParam(value="mycardId") String mycardId, HttpServletResponse response) {
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path currDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path vCardFile = Paths.get(currDatePath.toString(), "VCard" + timefmater.print((ReadableInstant)currTime) + ".vcf");
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        try {
            this.accountMycardService.exportOneVCard(this.getMycardIdentification(currentLoginUserEmail, mycardId), vCardFile.toString(), vcardTarget, false);
            File file = new File(vCardFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_to_outlookcsv"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void exporToOutlookCSV(@RequestParam LangCode langCode, @RequestParam(value="mycardId") String mycardId, HttpServletResponse response) {
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path currDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path csvFile = Paths.get(currDatePath.toString(), "Outlook" + timefmater.print((ReadableInstant)currTime) + ".csv");
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        try {
            this.accountMycardService.exportCSVForOutlook(this.getMycardIdentification(currentLoginUserEmail, mycardId), csvFile.toString(), langCode, false, false);
            File file = new File(csvFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_to_googlecsv"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public void exportToGoogleCSV(@RequestParam(value="mycardId") String mycardId, HttpServletResponse response) {
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path currDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path csvFile = Paths.get(currDatePath.toString(), "gmail_" + timefmater.print((ReadableInstant)currTime) + ".csv");
        String currentLoginUserEmail = SecurityUtils.getCurrentLoginUser().getEmail();
        try {
            this.accountMycardService.exportToGmail(this.getMycardIdentification(currentLoginUserEmail, mycardId), csvFile.toString(), false);
            File file = new File(csvFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    private MycardIdentification getMycardIdentification(String currentLoginEmail, String mycardId) {
        MycardIdentification mycardIdentification = this.accountMycardService.getMycardIdentification(mycardId);
        if (!currentLoginEmail.equals(mycardIdentification.getEmail())) {
            throw new ForbiddenException("You don't have permission to access this ecard");
        }
        return mycardIdentification;
    }
}

