/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CategoryInfoMultiLayer;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.enums.CategoryType;
import com.penpower.worldcard.team.exception.CategoryAlreadyExistsException;
import com.penpower.worldcard.team.exception.MaxCountExceededCategoryLayerException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.CategoryService;
import com.penpower.worldcard.team.service.MultiLayerCategoryService;
import com.penpower.worldcard.team.web.api.vo.CategoryCreationMultiLayerVo;
import com.penpower.worldcard.team.web.api.vo.CategoryCreationWithLayersVo;
import com.penpower.worldcard.team.web.api.vo.CategoryToggleUsualVo;
import com.penpower.worldcard.team.web.api.vo.ContactGetByCategoryAndOwnerVo;
import com.penpower.worldcard.team.web.api.vo.ContactNumberOfCategoriesRequest;
import com.penpower.worldcard.team.web.api.vo.ContactSetCategoriesVo;
import com.penpower.worldcard.team.web.api.vo.GuidWithData;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/multi_layer_category"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
public class MultiLayerCategoryController {
    private static final Logger LOG = LoggerFactory.getLogger(MultiLayerCategoryController.class);
    @Autowired
    private MultiLayerCategoryService multiLayerCategoryService;
    @Autowired
    private CategoryService categoryService;

    @ApiOperation(notes="\u65b0\u5efa\u4e00\u500b\u985e\u5225", value="")
    @ApiResponses(value={@ApiResponse(code=428, message="Max count limit of category layer is reached."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=460, message="Category already exists.<BR>")})
    @RequestMapping(value={"/create"})
    public MessageResponseResult createCategory(@RequestBody @Valid CategoryCreationMultiLayerVo vo) {
        String accountGuid = vo.getOwnerAccountGuid();
        String parentCategoryGuid = vo.getParentCategoryGuid();
        if (!StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            int layerIndex = this.multiLayerCategoryService.getLayerIndex(parentCategoryGuid);
            if (layerIndex + 1 >= 3) {
                throw new MaxCountExceededCategoryLayerException("Category layer count limitation is reached.");
            }
            String typeAllCategoryGuid = this.multiLayerCategoryService.getTypeAllCategoryGuidByAccount(accountGuid);
            if (parentCategoryGuid.equals(typeAllCategoryGuid)) {
                parentCategoryGuid = null;
            }
        }
        CategoryInfoMultiLayer category = this.multiLayerCategoryService.createCategory(vo.getName(), accountGuid, parentCategoryGuid);
        return new MessageResponseResult("Create category success", category.getGuid());
    }

    @ApiOperation(notes="\u65b0\u5efa\u4e00\u500b\u5305\u542b\u968e\u5c64\u7684\u985e\u5225,\u6bcf\u500b\u968e\u5c64\u7684\u985e\u5225\u540d\u7a31,\u4ee5 / \u4f86\u9694\u958b, \u4f8b\u5982: Asia/Taiwan/Reseller .<BR>\u6703\u56de\u50b3\u6700\u5f8c\u4e00\u5c64\u7684\u985e\u5225guid.", value="")
    @ApiResponses(value={@ApiResponse(code=428, message="Max count limit of category layer is reached."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=460, message="Category already exists.<BR>")})
    @RequestMapping(value={"/create_with_layers"})
    public MessageResponseResult createCategoryWithLayers(@RequestBody @Valid CategoryCreationWithLayersVo vo) {
        String[] categoryNames;
        int categoryLayerCount;
        String accountGuid = vo.getOwnerAccountGuid();
        String categoryPath = vo.getCategoryPath();
        if (categoryPath.startsWith("/")) {
            categoryPath = categoryPath.substring(1);
        }
        if ((categoryLayerCount = (categoryNames = categoryPath.split("/")).length) > 3) {
            throw new MaxCountExceededCategoryLayerException("The category layer count is over limitation.");
        }
        String parentCategoryGuid = null;
        for (String categoryName : categoryNames) {
            try {
                CategoryInfoMultiLayer category = this.multiLayerCategoryService.createCategory(categoryName, accountGuid, parentCategoryGuid);
                parentCategoryGuid = category.getGuid();
            }
            catch (CategoryAlreadyExistsException e) {
                CategoryInfoMultiLayer category = this.multiLayerCategoryService.findCategoryWithName(categoryName, accountGuid, parentCategoryGuid);
                if (category == null) continue;
                parentCategoryGuid = category.getGuid();
            }
        }
        return new MessageResponseResult("Create category success", parentCategoryGuid);
    }

    @ApiOperation(notes="\u4ee5\u540d\u7a31\u4f86\u53d6\u5f97\u985e\u5225.<BR> \u63d0\u9192: \u5fc5\u9808\u6307\u5b9a\u8981\u53d6\u7684\u662f\u4f4d\u65bc\u54ea\u4e00\u500bparent\u985e\u5225\u5e95\u4e0b", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/get_by_name"})
    public BasicResponseResult<CategoryInfoMultiLayer, Object> getCategoryByName(@RequestParam String categoryName, @RequestParam String categoryOwnerGuid, @RequestParam String parentCategoryGuid) {
        CategoryInfoMultiLayer category;
        String typeAllCategoryGuid;
        String innerParentCategoryGuid = null;
        if (!StringUtil.IsStringNullorEmpty((String)parentCategoryGuid) && !parentCategoryGuid.equals(typeAllCategoryGuid = this.multiLayerCategoryService.getTypeAllCategoryGuidByAccount(categoryOwnerGuid))) {
            innerParentCategoryGuid = parentCategoryGuid;
        }
        if ((category = this.multiLayerCategoryService.findCategoryWithName(categoryName, categoryOwnerGuid, innerParentCategoryGuid)) == null) {
            return new BasicResponseResult("No such category", null);
        }
        return new BasicResponseResult("Get category success.", (Object)category);
    }

    @ApiOperation(notes="\u522a\u9664\u6307\u5b9a\u985e\u5225", value="")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=480, message="There are child categories or contacts in the category.")})
    @RequestMapping(value={"/delete"})
    public MessageResponseResult deleteCategory(@RequestParam String categoryGuid) {
        this.multiLayerCategoryService.deleteCategory(categoryGuid);
        return new MessageResponseResult("Issue delete category job success", "nothing return");
    }

    @ApiOperation(notes="\u4fee\u6539\u6307\u5b9a\u985e\u5225\u7684\u540d\u7a31", value="")
    @ApiResponses(value={@ApiResponse(code=460, message="Category already exists.<BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/update"})
    public MessageResponseResult updateCategory(@RequestParam String categoryGuid, @RequestParam String categoryName) {
        if (categoryName.length() > 40) {
            throw new RequestArgumentNotValidException("Category name is too long.");
        }
        this.multiLayerCategoryService.updateCategory(categoryGuid, categoryName);
        return new MessageResponseResult("Update category success.", "nothing return");
    }

    @ApiOperation(notes="\u53d6\u5f97\u6307\u5b9a\u5e33\u865f,\u6307\u5b9a\u985e\u5225\u5e95\u4e0b\u4e00\u5c64\u7684\u985e\u5225\u5217\u8868,\u5982\u679c\u4e0d\u6307\u5b9a\u985e\u5225,\u6703\u53d6\u5f97\u8a72\u5e33\u865f\u7684\u7b2c\u4e00\u5c64\u985e\u5225<BR><BR>needMarkHasChild : \u662f\u5426\u9700\u8981\u6a19\u793a\u985e\u5225\u5e95\u4e0b\u6709\u6c92\u6709\u5b50\u985e\u5225.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_one_layer_list"})
    public ListResponseResult<CategoryInfoMultiLayer> getCategoriesOneLayer(@RequestParam String accountGuid, @RequestParam(required=false) String parentCategoryGuid, @RequestParam boolean needMarkHasChild) {
        String typeAllCategoryGuid;
        if (!StringUtil.IsStringNullorEmpty((String)parentCategoryGuid)) {
            this.categoryService.verifyCategoryGuidsOfAccount(Arrays.asList(parentCategoryGuid), accountGuid);
        }
        if ((typeAllCategoryGuid = this.multiLayerCategoryService.getTypeAllCategoryGuidByAccount(accountGuid)).equals(parentCategoryGuid)) {
            parentCategoryGuid = null;
        }
        List categoryInfos = this.multiLayerCategoryService.getCategoriesByParent(accountGuid, parentCategoryGuid);
        if (needMarkHasChild) {
            for (CategoryInfoMultiLayer cate : categoryInfos) {
                Long count;
                if (!CategoryType.NORMAL.equals((Object)cate.getCategoryType()) || (count = this.multiLayerCategoryService.countChildCategoris(cate.getGuid())) <= 0L) continue;
                cate.setHasChildren(Boolean.valueOf(true));
            }
        }
        this.setParentGuidForClients(categoryInfos, accountGuid);
        ListResponseResult result = new ListResponseResult("Get categories by parent category success.", categoryInfos);
        return result;
    }

    @ApiOperation(notes="\u53d6\u5f97\u6307\u5b9a\u5e33\u865f\u6240\u64c1\u6709\u7684\u5168\u90e8\u985e\u5225<BR><BR> \u63d0\u9192 : \u56e0\u70ba\u56de\u50b3\u4e86\u5e33\u865f\u5e95\u4e0b\u7684\u6240\u6709\u985e\u5225,\u6240\u4ee5response model\u88e1\u7684hasChildren\u4e0d\u6703\u7d66\u503c,\u4e00\u5f8b\u70bafalse.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/get_all_by_account"})
    public ListResponseResult<CategoryInfoMultiLayer> getCategoriesByAccount(@RequestParam String accountGuid) {
        List categoryInfos = this.multiLayerCategoryService.getCategoriesByAccount(accountGuid);
        this.setParentGuidForClients(categoryInfos, accountGuid);
        ListResponseResult result = new ListResponseResult("Get categories of account success.", categoryInfos);
        return result;
    }

    private void setParentGuidForClients(List<CategoryInfoMultiLayer> categoryInfos, String categoryOwnerGuid) {
        String typeAllCategoryGuid = this.multiLayerCategoryService.getTypeAllCategoryGuidByAccount(categoryOwnerGuid);
        for (CategoryInfoMultiLayer category : categoryInfos) {
            if (CategoryType.ALL.equals((Object)category.getCategoryType()) || !StringUtil.IsStringNullorEmpty((String)category.getParentCategoryGuid())) continue;
            category.setParentCategoryGuid(typeAllCategoryGuid);
        }
    }

    @ApiOperation(notes="\u53d6\u56de\u6307\u5b9a\u5e33\u865f\u5e95\u4e0b,\u53ef\u505a\u70ba\u985e\u5225\u79fb\u52d5\u76ee\u7684\u5730\u7684\u985e\u5225\u5217\u8868<BR><BR>accountGuid : \u8981\u53d6\u54ea\u4e00\u500b\u5e33\u865f\u5e95\u4e0b\u7684\u5217\u8868<BR>movedCategoryGuid : \u88ab\u79fb\u52d5\u7684\u985e\u5225GUID", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_list_for_move"})
    public ListResponseResult<CategoryInfoMultiLayer> getCategoriesForMove(@RequestParam String accountGuid, @RequestParam String movedCategoryGuid) {
        CategoryInfoMultiLayer categoryInfo = this.multiLayerCategoryService.getCategory(movedCategoryGuid);
        if (!this.isPureNormalCategory(categoryInfo)) {
            throw new RequestArgumentNotValidException("This category can not move.");
        }
        List categoryInfos = this.multiLayerCategoryService.getCategoriesByAccount(accountGuid);
        List normalCategoryInfos = categoryInfos.stream().filter(c -> this.isPureNormalCategory(c) && !movedCategoryGuid.equals(c.getGuid()) || CategoryType.ALL.equals((Object)c.getCategoryType())).collect(Collectors.toList());
        List childCategories = this.getAllChildCategories(normalCategoryInfos, movedCategoryGuid);
        normalCategoryInfos.removeAll(childCategories);
        this.setParentGuidForClients(normalCategoryInfos, accountGuid);
        ListResponseResult result = new ListResponseResult("Get categories for moving success.", normalCategoryInfos);
        return result;
    }

    private boolean isPureNormalCategory(CategoryInfoMultiLayer categoryInfo) {
        return CategoryType.NORMAL.equals((Object)categoryInfo.getCategoryType()) && StringUtil.IsStringNullorEmpty((String)categoryInfo.getSecretaryAccountGuid());
    }

    private List<CategoryInfoMultiLayer> getAllChildCategories(List<CategoryInfoMultiLayer> originalCategoryInfos, String guid) {
        List<CategoryInfoMultiLayer> children = originalCategoryInfos.stream().filter(c -> guid.equals(c.getParentCategoryGuid())).collect(Collectors.toList());
        for (int i = 0; i < children.size(); ++i) {
            List categories = this.getAllChildCategories(originalCategoryInfos, children.get(i).getGuid());
            children.addAll(categories);
        }
        return children;
    }

    @ApiOperation(notes="\u6309\u4f7f\u7528\u8005\u8a2d\u5b9a\u7684\u986f\u793a\u9806\u5e8f,\u53d6\u56de\u767b\u5165\u5e33\u865f\u5e95\u4e0b,\u88ab\u6a19\u70ba\u91d8\u9078\u7684\u985e\u5225\u5217\u8868<BR><BR> \u63d0\u9192 : response model\u88e1\u7684hasChildren\u4e0d\u6703\u7d66\u503c,\u4e00\u5f8b\u70bafalse.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/get_toggled_list"})
    public ListResponseResult<CategoryInfoMultiLayer> getCategoriesToggled() {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        List categoryInfos = this.multiLayerCategoryService.getCategoriesToggled(loginAccount.getGuid());
        ListResponseResult result = new ListResponseResult("Get toggled categories success.", categoryInfos);
        return result;
    }

    @ApiOperation(notes="\u5c07\u985e\u5225\u79fb\u52d5\u5230\u67d0\u4e00\u500b\u6307\u5b9a\u7684\u7236\u985e\u5225\u5e95\u4e0b<BR><BR>movedCategoryGuid : \u88ab\u79fb\u52d5\u7684\u985e\u5225GUID<BR>targetParentCategoryGuid : \u505a\u70ba\u76ee\u7684\u5730\u7684\u7236\u985e\u5225GUID<BR>categoryOwnerGuid : \u985e\u5225\u64c1\u6709\u8005\u7684GUID", value="")
    @ApiResponses(value={@ApiResponse(code=460, message="Category already exists.<BR>"), @ApiResponse(code=428, message="Max count limit of category layer is reached."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=460, message="Category already exists.<BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/move"})
    public MessageResponseResult moveCategory(@RequestParam String movedCategoryGuid, @RequestParam String targetParentCategoryGuid, @RequestParam String categoryOwnerGuid) {
        LOG.debug("movedCategoryGuid : {} , targetParentCategoryGuid :{} , categoryOwnerGuid : {} ");
        if (movedCategoryGuid.equals(targetParentCategoryGuid)) {
            throw new RequestArgumentNotValidException("Cant't move category to itself");
        }
        String typeAllCategoryGuid = this.multiLayerCategoryService.getTypeAllCategoryGuidByAccount(categoryOwnerGuid);
        LOG.debug("typeAllCategoryGuid : {} ", (Object)typeAllCategoryGuid);
        if (StringUtil.IsStringNullorEmpty((String)targetParentCategoryGuid) || targetParentCategoryGuid.equals(typeAllCategoryGuid)) {
            this.multiLayerCategoryService.moveCategoryToRoot(movedCategoryGuid);
        } else {
            int childLayerCount;
            int parentCategoryLayerIndex = this.multiLayerCategoryService.getLayerIndex(targetParentCategoryGuid);
            if (parentCategoryLayerIndex + (childLayerCount = this.multiLayerCategoryService.getChildLayerCount(movedCategoryGuid)) + 1 >= 3) {
                throw new MaxCountExceededCategoryLayerException("This move will exceed category layer limitation.");
            }
            this.multiLayerCategoryService.moveCategory(movedCategoryGuid, targetParentCategoryGuid);
        }
        return new MessageResponseResult("Move category success.", "nothing return");
    }

    @ApiOperation(notes="\u5c07\u591a\u500b\u985e\u5225\u6307\u5b9a\u6216\u53d6\u6d88\u70ba\u767b\u5165\u5e33\u865f\u7684\u91d8\u9078\u985e\u5225<BR><BR> \u63d0\u9192 : request\u88e1\u7684\"list\"\u70ba\u8981\u88ab\u8a2d\u5b9a\u7684\u985e\u5225guid\u6e05\u55ae", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/toggle_categories"})
    public MessageResponseResult toggleCategories(@RequestBody CategoryToggleUsualVo vo) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        this.multiLayerCategoryService.toggleCategories(loginAccount.getGuid(), vo.getList(), vo.isSetAsToggled());
        return new MessageResponseResult("Toggle categories success.", "nothing return");
    }

    @ApiOperation(notes="\u8a2d\u5b9a\u91d8\u9078\u985e\u5225\u7684\u9806\u5e8f<BR><BR> \u63d0\u9192 : request\u88e1\u7684\"list\"\u70ba\u8981\u88ab\u8a2d\u5b9a\u7684\u985e\u5225guid\u6e05\u55ae, \u6309\u9700\u8981\u7684\u9806\u5e8f\u6392\u5217.", value="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/set_order_for_toggled_categories"})
    public MessageResponseResult setToggledCategoriesOrder(@RequestBody @Valid ListRequestVo<String> orderInfo) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        this.multiLayerCategoryService.setOrderOfToggledCategories(loginAccount.getGuid(), orderInfo.getList());
        return new MessageResponseResult("Set toggled categories order success.", "nothing return");
    }

    @ApiOperation(notes="(\u5df2\u642c,\u8acb\u6539\u7528 /api/contact/private/add_or_set_categories)<BR><BR>\u8a2d\u5b9a\u540d\u7247\u7684\u985e\u5225.<BR>Response Model\u88e1,\u5305\u542b\u56de\u50b3\u7684\u8a0a\u606f,\u4ee5\u53ca\u4e00\u500b\u8a2d\u5b9a\u5931\u6557\u7684\u540d\u7247\u5217\u8868. \u5217\u8868\u88e1\u6bcf\u4e00\u500b\u9805\u76ee,\u662f\u8a72\u5931\u6557\u540d\u7247\u7684guid,\u53ca\u5176\u932f\u8aa4\u63cf\u8ff0. <BR>\u63cf\u8ff0\u5206\u5169\u7a2e,\u6d41\u7a0b\u4e0a\u53ef\u77e5\u539f\u56e0\u7684\u70ba\u932f\u8aa4\u78bc,\u610f\u5916\u539f\u56e0\u7684\u5247\u70ba\u932f\u8aa4\u5b57\u4e32. \u53ef\u77e5\u539f\u56e0\u7684\u932f\u8aa4\u78bc\u6709\u4ee5\u4e0b\u5e7e\u500b:<BR>422 : Request required parameters not valid. <BR>425 : Max count limit of contact in private is reached.", value="")
    @RequestMapping(value={"/add_or_set_categories_multi_layer"}, method={RequestMethod.POST})
    public ListResponseResult<GuidWithData<String>> setPrivateCategories(@RequestBody @Valid ContactSetCategoriesVo vo) {
        return new ListResponseResult("", null);
    }

    @ApiOperation(notes="(\u5df2\u642c,\u8acb\u6539\u7528 /api/contact/public/get_contact_number_shared_by_categories)<BR><BR>\u50b3\u5165\u516c\u6709\u5340\u88e1\u7684\u985e\u5225guid\u5217\u8868,\u53d6\u56de\u9019\u4e9b\u985e\u5225\u88e1\u7684\u540d\u7247\u6578\u91cf.", value="")
    @RequestMapping(value={"/get_contact_number_shared_by_categories"})
    public ListResponseResult<GuidWithData<Long>> getContactNumberOfSharedCategories(@RequestBody ContactNumberOfCategoriesRequest vo) {
        return new ListResponseResult("Get contact number of categories success.", null);
    }

    @ApiOperation(notes="(\u5df2\u642c,\u8acb\u6539\u7528 /api/contact/public/get_contacts_shared_by_category)<BR><BR>\u53d6\u5f97\u516c\u6709\u5340\u88e1,\u67d0\u4e00\u500b\u985e\u5225\u88e1\u7684\u540d\u7247\u5217\u8868.", value="")
    @RequestMapping(value={"/get_contacts_shared_by_category"})
    public PageResponseResult<ContactSimpleInfoDto> getSharedContactsByCategory(@RequestBody @Valid ContactGetByCategoryAndOwnerVo vo) {
        PageResponseResult result = new PageResponseResult("Get shared contacts of category success.", null, 100L, 10);
        return result;
    }

    @ApiOperation(notes="(\u5df2\u642c,\u8acb\u6539\u7528 /api/contact/public/get_contact_number_shared_by_account_uncategory)<BR><BR>\u53d6\u5f97\u516c\u6709\u5340\u88e1,\u67d0\u5e33\u865f\u6240\u64c1\u6709\u4e26\u4e14\u6709\u5206\u4eab\u7d66\u6211,\u4f46\u537b\u4e0d\u5728\u4ed6\u7684\u79c1\u6709\u5340\u88e1\u7684\u540d\u7247\u6578\u91cf.", value="")
    @RequestMapping(value={"/get_contact_number_shared_by_account_uncategory"})
    public BasicResponseResult<Long, Object> getContactNumberSharedByAccountButNotInHisPrivate(@RequestParam String accountGuid) {
        Long contactNum = 0L;
        return new BasicResponseResult("Get shared contact number by all success.", (Object)contactNum);
    }

    @ApiOperation(notes="(\u5df2\u642c,\u8acb\u6539\u7528 /api/contact/public/get_contacts_shared_by_account_uncategory)<BR><BR>\u53d6\u5f97\u516c\u6709\u5340\u88e1,\u67d0\u5e33\u865f\u6240\u64c1\u6709\u4e26\u4e14\u6709\u5206\u4eab\u7d66\u6211,\u4f46\u537b\u4e0d\u5728\u4ed6\u7684\u79c1\u6709\u5340\u88e1\u7684\u540d\u7247\u5217\u8868.", value="")
    @RequestMapping(value={"/get_contacts_shared_by_account_uncategory"})
    public PageResponseResult<ContactSimpleInfoDto> getContactsSharedByAccountButNotInHisPrivate(@RequestParam String accountGuid) {
        PageResponseResult result = new PageResponseResult("Get shared contacts of account success.", null, 1000L, 10);
        return result;
    }
}

