/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.enums.ActiveDirectoryTreeSearchOption;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.ldap.ActiveDirectoryAccountInfo;
import com.penpower.worldcard.team.ldap.ActiveDirectoryUtils;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.LdapService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryAccountTreeInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectorySyncInfo;
import com.penpower.worldcard.team.web.api.vo.response.ActiveDirectoryAccountTreeResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ActiveDirectorySyncInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/ldap"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"Ldap_Operations"}, description="LDAP & AD \u76f8\u95dc\u7684\u8cc7\u6599\u64cd\u4f5capi")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class LdapController {
    private static final Logger LOG = LoggerFactory.getLogger(LdapController.class);
    @Autowired
    CompanyService companyService;
    @Autowired
    AccountService accountService;
    @Autowired
    LdapService ldapService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    CompanyGlobalInfoService companyGlobalInfoService;

    @ApiOperation(value="getAllAdAccounts", notes="\u53d6\u5f97\u6240\u6709AD\u7684Account\u6e05\u55ae. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @ApiResponses(value={@ApiResponse(code=470, message="Other ldap runtime exception occurs."), @ApiResponse(code=477, message="Indicates that during a bind operation one of the following occurred:<BR>The client passed either an incorrect DN or password,<BR>or the password is incorrect because it has expired,<BR>intruder detection has locked the account, or another similar reason."), @ApiResponse(code=478, message="Indicates that the LDAP server is too busy to process the client request at this time<BR>but if the client waits and resubmits the request,<BR>the server may be able to process it then."), @ApiResponse(code=479, message="Indicates that the LDAP server cannot process the client's bind request,<BR>usually because it is shutting down."), @ApiResponse(code=472, message="Indicates an Active Directory (AD) AcceptSecurityContext error, <BR>which is returned when the username is valid<BR>but the combination of password and user credential is invalid. "), @ApiResponse(code=473, message="Indicates an Active Directory (AD) AcceptSecurityContext data error<BR> that is returned when the username is invalid."), @ApiResponse(code=474, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The specified account password has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=475, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The user's account has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=476, message="Indicates an Active Directory (AD) AcceptSecurityContext data error.<BR>The user's password must be changed before logging on the first time.<BR>Returns only when presented with valid user-name and password credential."), @ApiResponse(code=471, message="Fail to connect to AD server."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_ad_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<ActiveDirectoryAccountInfo> getActiveDirectoryAccounts(@RequestBody @Valid ActiveDirectoryInfo activeDirectoryInfo) {
        LOG.debug("activeDirectoryInfo : {}", (Object)activeDirectoryInfo);
        ActiveDirectoryUtils activeDirectoryUtils = null;
        try {
            activeDirectoryUtils = new ActiveDirectoryUtils(activeDirectoryInfo);
        }
        catch (Exception ex) {
            LOG.error("Invalid ad import params.", (Throwable)ex);
            throw new RequestArgumentNotValidException("Invalid ad import params.", (Throwable)ex);
        }
        String accountNameLocalPart = this.getLocalPartName(activeDirectoryInfo.getLoginAccount());
        LOG.debug("accountNameLocalPart : {} ", (Object)accountNameLocalPart);
        activeDirectoryUtils.authenticate(accountNameLocalPart, activeDirectoryInfo.getLoginPassword());
        activeDirectoryUtils.setCtxBaseDn(activeDirectoryInfo.getAdServerBaseDn());
        List allActiveDirectoryAccounts = activeDirectoryUtils.getAllUserAccountNames();
        LOG.debug("allActiveDirectoryAccounts : {}", (Object)allActiveDirectoryAccounts);
        ListResponseResult result = new ListResponseResult("Retrive all acive directory account names succeeded.", allActiveDirectoryAccounts);
        return result;
    }

    private String getLocalPartName(String loginAccount) {
        String[] localPartSplit = loginAccount.split("@");
        return localPartSplit[0];
    }

    @ApiOperation(value="getADSyncOption", notes="\u53d6\u5f97ad\u540c\u6b65\u6642\u7684\u53c3\u6578,\u4e0d\u5305\u542b\u5bc6\u78bc")
    @ApiResponses(value={@ApiResponse(code=470, message="Other ldap runtime exception occurs."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_AD_sync_option"}, method={RequestMethod.GET})
    public ActiveDirectorySyncInfoResponseResult getADSyncOption() {
        ActiveDirectorySyncInfo activeDirectorySyncInfo = new ActiveDirectorySyncInfo();
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        activeDirectorySyncInfo.setAdServer(this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_SERVER", "", currentLoginUser.getCompanyGuid()));
        activeDirectorySyncInfo.setLoginAccount(this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_ACCOUNTNAME", "", currentLoginUser.getCompanyGuid()));
        activeDirectorySyncInfo.setLoginPassword("");
        activeDirectorySyncInfo.setAdServerBaseDn(this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_BASEDN", "", currentLoginUser.getCompanyGuid()));
        boolean syncWithAD = Boolean.parseBoolean(this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_WITH_AD", "", currentLoginUser.getCompanyGuid()));
        activeDirectorySyncInfo.setEnableSync(syncWithAD);
        ActiveDirectorySyncInfoResponseResult respone = new ActiveDirectorySyncInfoResponseResult("get ad sync option success", activeDirectorySyncInfo);
        return respone;
    }

    @ApiOperation(value="setADSyncOption", notes="\u8a2d\u5b9aad\u540c\u6b65\u6642\u7684\u53c3\u6578,\u5e33\u5bc6\u9a57\u8a3c\u5931\u6557\u6703\u8a2d\u5b9a\u7121\u6548")
    @ApiResponses(value={@ApiResponse(code=470, message="Other ldap runtime exception occurs."), @ApiResponse(code=477, message="Indicates that during a bind operation one of the following occurred:<BR>The client passed either an incorrect DN or password,<BR>or the password is incorrect because it has expired,<BR>intruder detection has locked the account, or another similar reason."), @ApiResponse(code=478, message="Indicates that the LDAP server is too busy to process the client request at this time<BR>but if the client waits and resubmits the request,<BR>the server may be able to process it then."), @ApiResponse(code=479, message="Indicates that the LDAP server cannot process the client's bind request,<BR>usually because it is shutting down."), @ApiResponse(code=472, message="Indicates an Active Directory (AD) AcceptSecurityContext error, <BR>which is returned when the username is valid<BR>but the combination of password and user credential is invalid. "), @ApiResponse(code=473, message="Indicates an Active Directory (AD) AcceptSecurityContext data error<BR> that is returned when the username is invalid."), @ApiResponse(code=474, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The specified account password has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=475, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The user's account has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=476, message="Indicates an Active Directory (AD) AcceptSecurityContext data error.<BR>The user's password must be changed before logging on the first time.<BR>Returns only when presented with valid user-name and password credential."), @ApiResponse(code=471, message="Fail to connect to AD server."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/set_AD_sync_option"}, method={RequestMethod.POST})
    public MessageResponseResult setADSyncOption(@RequestParam boolean enableSync, @RequestBody ActiveDirectoryInfo activeDirectoryInfo) {
        LOG.debug("activeDirectoryInfo : {}", (Object)activeDirectoryInfo);
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (enableSync) {
            ActiveDirectoryUtils activeDirectoryUtils = null;
            try {
                activeDirectoryUtils = new ActiveDirectoryUtils(activeDirectoryInfo);
            }
            catch (Exception ex) {
                LOG.error("Invalid ad import params.={}", (Object)ex.getMessage());
                throw new RequestArgumentNotValidException("Invalid ad import params.", (Throwable)ex);
            }
            String accountNameLocalPart = this.getLocalPartName(activeDirectoryInfo.getLoginAccount());
            LOG.debug("accountNameLocalPart : {} ", (Object)accountNameLocalPart);
            activeDirectoryUtils.authenticate(accountNameLocalPart, activeDirectoryInfo.getLoginPassword());
            this.companyGlobalInfoService.createNewProperties("SYNC_AD_SERVER", activeDirectoryInfo.getAdServer(), currentLoginUser.getCompanyGuid());
            this.companyGlobalInfoService.createNewProperties("SYNC_AD_ACCOUNTNAME", activeDirectoryInfo.getLoginAccount(), currentLoginUser.getCompanyGuid());
            this.companyGlobalInfoService.createNewProperties("SYNC_AD_PASSWORD", activeDirectoryInfo.getLoginPassword(), currentLoginUser.getCompanyGuid());
            this.companyGlobalInfoService.createNewProperties("SYNC_AD_BASEDN", activeDirectoryInfo.getAdServerBaseDn(), currentLoginUser.getCompanyGuid());
            this.companyGlobalInfoService.createNewProperties("SYNC_WITH_AD", Boolean.TRUE.toString(), currentLoginUser.getCompanyGuid());
        } else {
            this.companyGlobalInfoService.createNewProperties("SYNC_WITH_AD", Boolean.FALSE.toString(), currentLoginUser.getCompanyGuid());
        }
        MessageResponseResult respone = new MessageResponseResult("sync success", "");
        return respone;
    }

    @ApiOperation(value="getAllAdAccounts", notes="\u53d6\u5f97\u6240\u6709AD\u7684Account\u6e05\u55ae. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @RequestMapping(value={"/sync_with_ADServer"}, method={RequestMethod.POST})
    public MessageResponseResult syncWithADServer() {
        this.ldapService.syncWithADServer();
        MessageResponseResult respone = new MessageResponseResult("sync success", "");
        return respone;
    }

    @ApiOperation(value="getAdAccountTree", notes="\u53d6\u5f97AD Account and Tree. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @ApiResponses(value={@ApiResponse(code=470, message="Other ldap runtime exception occurs."), @ApiResponse(code=477, message="Indicates that during a bind operation one of the following occurred:<BR>The client passed either an incorrect DN or password,<BR>or the password is incorrect because it has expired,<BR>intruder detection has locked the account, or another similar reason."), @ApiResponse(code=478, message="Indicates that the LDAP server is too busy to process the client request at this time<BR>but if the client waits and resubmits the request,<BR>the server may be able to process it then."), @ApiResponse(code=479, message="Indicates that the LDAP server cannot process the client's bind request,<BR>usually because it is shutting down."), @ApiResponse(code=472, message="Indicates an Active Directory (AD) AcceptSecurityContext error, <BR>which is returned when the username is valid<BR>but the combination of password and user credential is invalid. "), @ApiResponse(code=473, message="Indicates an Active Directory (AD) AcceptSecurityContext data error<BR> that is returned when the username is invalid."), @ApiResponse(code=474, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The specified account password has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=475, message="Indicates an Active Directory (AD) AcceptSecurityContext data error that is a logon failure.<BR>The user's account has expired.<BR>Returns only when presented with valid username and password credential."), @ApiResponse(code=476, message="Indicates an Active Directory (AD) AcceptSecurityContext data error.<BR>The user's password must be changed before logging on the first time.<BR>Returns only when presented with valid user-name and password credential."), @ApiResponse(code=471, message="Fail to connect to AD server."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/get_ad_accountTree"}, method={RequestMethod.POST})
    public ActiveDirectoryAccountTreeResponseResult getAdAccountTree(@RequestParam(name="options", required=false) List<ActiveDirectoryTreeSearchOption> options, @RequestBody @Valid ActiveDirectoryInfo activeDirectoryInfo) {
        if (CollectionUtils.isEmpty(options)) {
            options = Arrays.asList(ActiveDirectoryTreeSearchOption.values());
        }
        ActiveDirectoryAccountTreeInfo result = this.ldapService.getAdAccountTree(activeDirectoryInfo, options);
        ActiveDirectoryAccountTreeResponseResult respone = new ActiveDirectoryAccountTreeResponseResult("", result);
        return respone;
    }
}

