/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountInfoLess;
import com.penpower.worldcard.team.dto.ContactSimpleInfoCustomerDto;
import com.penpower.worldcard.team.dto.CustomFieldDto;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.SystemIoException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.web.api.vo.ContactGetFromModifiedTimeByAccountVo;
import com.penpower.worldcard.team.web.api.vo.ContactGetFromModifiedTimeVo;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVo;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/customer"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
@Api(tags={"customer"})
public class CustomerApiController {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerApiController.class);
    @Autowired
    private ContactService contactService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private PathManager cardPathManager;
    private final int maxCountInList = 3000;

    @ApiOperation(value="", notes="\u53d6\u5f97\u6240\u6709\u7684Account\u6e05\u55ae.")
    @RequestMapping(value={"/account/get_all"})
    public ListResponseResult<AccountInfoLess> getAccounts(@RequestHeader(value="X-Auth-Token", required=false) String token) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List accountInfos = this.accountService.getAccountInfos(currentLoginUser.getCompanyGuid());
        List accountsInfoLess = accountInfos.stream().map(a -> new AccountInfoLess(a.getGuid(), a.getEmail(), a.getName(), a.getStatus(), a.getAccountType(), a.getAccountSubscriptionStatus(), a.getLockedIssue())).collect(Collectors.toList());
        ListResponseResult response = new ListResponseResult("Get all account less information succeeded.", accountsInfoLess);
        return response;
    }

    @ApiOperation(value="", notes="\u5f9e\u6574\u500b\u8cc7\u6599\u5eab\u88e1\u9762,\u5728\u6307\u5b9a\u6642\u9593\u9ede\u4e4b\u5f8c,\u53d6\u5f97\u6709\u4fee\u6539\u904e\u7684\u540d\u7247\u7c21\u8981\u8cc7\u8a0a\u6e05\u55ae.<BR><BR> modifiedTimeFrom : \u6307\u5b9a\u6642\u9593(\u5b57\u4e32\u683c\u5f0f\u70ba yyyy-MM-dd HH:mm:ss.SSS),\u4e0d\u6307\u5b9a\u5247\u5f9e\u6700\u65e9\u7684\u4e00\u7b46\u958b\u59cb\u56de\u50b3<BR> contactNumberGet : \u6307\u5b9a\u8981\u6293\u53d6\u5e7e\u7b46<BR> isDeletedSkip : \u662f\u5426\u8981\u5ffd\u7565\u5df2\u7d93\u88ab\u522a\u9664\u7684\u540d\u7247<BR><BR> \u63d0\u9192 : \u7c21\u8981\u8cc7\u8a0a\u88e1\u5305\u542b\u540d\u7247\u6587\u5b57\u5167\u5bb9\u7684sha1\u503c,\u4ee5\u53ca\u540d\u7247\u5f71\u50cf\u7684sha1\u503c,\u53ef\u4ee5\u7528\u4f86\u5224\u65b7\u662f\u5426\u548cLOCAL\u7aef\u7684\u8cc7\u6599\u4e00\u81f4,\u82e5\u4e00\u81f4\u5247\u4e0d\u9700\u8981\u91cd\u8907\u4e0b\u8f09.")
    @RequestMapping(value={"/contact/get_list_from_time"})
    public ListResponseResult<ContactSimpleInfoCustomerDto> getContactInfosFromModifiedTime(@RequestHeader(value="X-Auth-Token", required=false) String token, @RequestBody ContactGetFromModifiedTimeVo vo) {
        Integer contactNumberGet = vo.getContactNumberGet();
        if (contactNumberGet == null || contactNumberGet <= 0 || contactNumberGet > 3000) {
            throw new RequestArgumentNotValidException(String.format("contactNumberGet parameter is not found or invalid, max value: %d", 3000));
        }
        DateTime timeFrom = vo.getModifiedTimeFrom() == null ? GlobalUtils.getEarliestTime() : vo.getModifiedTimeFrom();
        boolean isDeletedSkip = vo.getIsDeletedSkip() == null ? false : vo.getIsDeletedSkip();
        List infos = this.contactService.getContactSimpleInfosForCustomerFromModifiedTime(timeFrom, isDeletedSkip, contactNumberGet.intValue());
        ListResponseResult result = new ListResponseResult("Get contacts from specified time success.", infos);
        return result;
    }

    @ApiOperation(value="", notes="\u5f9e\u6307\u5b9aAccount\u7684\u79c1\u6709\u5340\u88e1\u9762,\u5728\u6307\u5b9a\u6642\u9593\u9ede\u4e4b\u5f8c,\u53d6\u5f97\u6709\u4fee\u6539\u904e\u7684\u540d\u7247\u7c21\u8981\u8cc7\u8a0a\u6e05\u55ae.<BR><BR> accountGuid : \u6307\u5b9aAccount Guid<BR> modifiedTimeFrom : \u6307\u5b9a\u6642\u9593(\u5b57\u4e32\u683c\u5f0f\u70ba yyyy-MM-dd HH:mm:ss.SSS),\u4e0d\u6307\u5b9a\u5247\u5f9e\u6700\u65e9\u7684\u4e00\u7b46\u958b\u59cb\u56de\u50b3<BR> contactNumberGet : \u6307\u5b9a\u8981\u6293\u53d6\u5e7e\u7b46<BR> isDeletedSkip : \u662f\u5426\u8981\u5ffd\u7565\u5df2\u7d93\u88ab\u522a\u9664\u7684\u540d\u7247<BR><BR> \u63d0\u9192 : \u7c21\u8981\u8cc7\u8a0a\u88e1\u5305\u542b\u540d\u7247\u6587\u5b57\u5167\u5bb9\u7684sha1\u503c,\u4ee5\u53ca\u540d\u7247\u5f71\u50cf\u7684sha1\u503c,\u53ef\u4ee5\u7528\u4f86\u5224\u65b7\u662f\u5426\u548cLOCAL\u7aef\u7684\u8cc7\u6599\u4e00\u81f4,\u82e5\u4e00\u81f4\u5247\u4e0d\u9700\u8981\u91cd\u8907\u4e0b\u8f09.")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/contact/get_list_from_time_by_account"})
    public ListResponseResult<ContactSimpleInfoCustomerDto> getContactInfosFromModifiedTimeByAccountPrivate(@RequestHeader(value="X-Auth-Token", required=false) String token, @RequestBody ContactGetFromModifiedTimeByAccountVo vo) {
        String accountGuid = vo.getAccountGuid();
        this.accountService.verifyAccount(accountGuid, null);
        Integer contactNumberGet = vo.getContactNumberGet();
        if (contactNumberGet == null || contactNumberGet <= 0 || contactNumberGet > 3000) {
            throw new RequestArgumentNotValidException(String.format("contactNumberGet parameter is not found or invalid, max value: %d", 3000));
        }
        DateTime timeFrom = vo.getModifiedTimeFrom() == null ? GlobalUtils.getEarliestTime() : vo.getModifiedTimeFrom();
        boolean isDeletedSkip = vo.getIsDeletedSkip() == null ? false : vo.getIsDeletedSkip();
        List infos = this.contactService.getContactSimpleInfosForCustomerFromModifiedTimeByAccount(timeFrom, isDeletedSkip, contactNumberGet.intValue(), accountGuid);
        ListResponseResult result = new ListResponseResult("Get contacts from specified time success.", infos);
        return result;
    }

    @ApiOperation(value="", notes="\u5f9e\u6307\u5b9aAccount\u6240\u64c1\u6709\u7684\u540d\u7247\u88e1\u9762,\u5728\u6307\u5b9a\u6642\u9593\u9ede\u4e4b\u5f8c,\u53d6\u5f97\u6709\u4fee\u6539\u904e\u7684\u540d\u7247\u7c21\u8981\u8cc7\u8a0a\u6e05\u55ae.<BR><BR> accountGuid : \u6307\u5b9aAccount Guid<BR> modifiedTimeFrom : \u6307\u5b9a\u6642\u9593(\u5b57\u4e32\u683c\u5f0f\u70ba yyyy-MM-dd HH:mm:ss.SSS),\u4e0d\u6307\u5b9a\u5247\u5f9e\u6700\u65e9\u7684\u4e00\u7b46\u958b\u59cb\u56de\u50b3<BR> contactNumberGet : \u6307\u5b9a\u8981\u6293\u53d6\u5e7e\u7b46<BR> isDeletedSkip : \u662f\u5426\u8981\u5ffd\u7565\u5df2\u7d93\u88ab\u522a\u9664\u7684\u540d\u7247<BR><BR> \u63d0\u9192 : \u7c21\u8981\u8cc7\u8a0a\u88e1\u5305\u542b\u540d\u7247\u6587\u5b57\u5167\u5bb9\u7684sha1\u503c,\u4ee5\u53ca\u540d\u7247\u5f71\u50cf\u7684sha1\u503c,\u53ef\u4ee5\u7528\u4f86\u5224\u65b7\u662f\u5426\u548cLOCAL\u7aef\u7684\u8cc7\u6599\u4e00\u81f4,\u82e5\u4e00\u81f4\u5247\u4e0d\u9700\u8981\u91cd\u8907\u4e0b\u8f09.")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/contact/get_list_from_time_by_owner"})
    public ListResponseResult<ContactSimpleInfoCustomerDto> getContactInfosFromModifiedTimeByOwner(@RequestHeader(value="X-Auth-Token", required=false) String token, @RequestBody ContactGetFromModifiedTimeByAccountVo vo) {
        String accountGuid = vo.getAccountGuid();
        this.accountService.verifyAccount(accountGuid, null);
        Integer contactNumberGet = vo.getContactNumberGet();
        if (contactNumberGet == null || contactNumberGet <= 0 || contactNumberGet > 3000) {
            throw new RequestArgumentNotValidException(String.format("contactNumberGet parameter is not found or invalid, max value: %d", 3000));
        }
        DateTime timeFrom = vo.getModifiedTimeFrom() == null ? GlobalUtils.getEarliestTime() : vo.getModifiedTimeFrom();
        boolean isDeletedSkip = vo.getIsDeletedSkip() == null ? false : vo.getIsDeletedSkip();
        List infos = this.contactService.getContactSimpleInfosForCustomerFromModifiedTimeByOwner(timeFrom, isDeletedSkip, contactNumberGet.intValue(), accountGuid);
        ListResponseResult result = new ListResponseResult("Get contacts from specified time success.", infos);
        return result;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u540d\u7247\u7684\u8a73\u7d30\u8cc7\u8a0a\u4ee5\u53ca\u6587\u5b57\u5167\u5bb9.<BR><BR>contactGuid : \u6307\u5b9a\u540d\u7247\u7684 Guid")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/contact/get_content"})
    public BasicResponseResult<ContactInfoVo, Object> getContactCotent(@RequestHeader(value="X-Auth-Token", required=false) String token, @RequestParam(required=true) String contactGuid) {
        ContactInfoVo contactInfoVo = this.contactPrivateService.getContactInfoVoByGuid(contactGuid);
        if (contactInfoVo == null) {
            throw new ItemNotFoundException("contact not found.");
        }
        contactInfoVo.getCustomDataList().forEach(info -> {
            try {
                CustomFieldDto customFieldDto = this.customFieldService.getCustomField(info.getCustomfieldSettingGuid());
                info.setFieldCaption(customFieldDto.getCustomFieldName());
                if (CustomFieldContactAttribute.PICKLIST.equals((Object)customFieldDto.getCustomFieldContactAttribute())) {
                    String picklistItemID = info.getTextValue();
                    List picklistSettings = customFieldDto.getPicklistContents();
                    picklistSettings.stream().filter(p -> p.getGuid().equals(picklistItemID)).findFirst().ifPresent(p -> info.setTextValue(p.getContent()));
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        });
        return new BasicResponseResult("Get contact by guid success.", (Object)contactInfoVo);
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u540d\u7247\u5f71\u50cf\u7684base64\u5b57\u4e32.<BR><BR>contactGuid : \u6307\u5b9a\u540d\u7247\u7684 Guid<BR>imageType : \u6307\u5b9a\u8981\u54ea\u4e00\u5f35\u540d\u7247\u5f71\u50cf")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    @RequestMapping(value={"/contact/get_image_base64"}, method={RequestMethod.GET})
    public MessageResponseResult getContactImageBase64(@RequestHeader(value="X-Auth-Token", required=false) String token, @RequestParam String contactGuid, @RequestParam ContactImageType imageType) {
        this.contactPrivateService.verifyContactGuids(Arrays.asList(contactGuid));
        byte[] arrayByte = new byte[]{};
        try {
            arrayByte = this.contactPrivateService.getImageContent(contactGuid, imageType);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file: ", (Throwable)e);
        }
        String imageBase64 = Base64.encodeBase64String((byte[])arrayByte);
        return new MessageResponseResult("Get contact image success.", imageBase64);
    }
}

