/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceAccountSearchResult;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.exception.CRMLoginException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.SalesForceTokenService;
import com.penpower.worldcard.team.service.SalesforceService;
import com.penpower.worldcard.team.web.api.vo.SalesforceSearchVo;
import com.penpower.worldcard.team.web.api.vo.response.SalesForceSearchRecordResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/crm"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"crm"}, description="crm api")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class CrmController {
    private static final Logger LOG = LoggerFactory.getLogger(CrmController.class);
    @Autowired
    private SalesforceService salesforceService;
    @Autowired
    private SalesForceTokenService salesForceTokenService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private CRMAuthenticationManager salesforceAuthenticationManager;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;

    @ApiOperation(value="", notes="\u641c\u5c0bsalesforce\u88e1\u7684accounts")
    @ApiResponses(value={@ApiResponse(code=409, message="The crm operation has failed."), @ApiResponse(code=400, message="CRM system login failed."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/search_salesforce_accounts"}, method={RequestMethod.POST})
    public SalesForceSearchRecordResponseResult searchSalesforceAccounts(@RequestBody SalesforceSearchVo vo) {
        AccountInfo currentLoginAccount;
        String userCRMloginTokenString;
        BasicToken basicToken;
        String keyword = vo.getKeyword();
        if (StringUtils.isEmpty((CharSequence)keyword)) {
            keyword = "";
        }
        if ((basicToken = this.salesforceAuthenticationManager.getAccessToken(userCRMloginTokenString = this.accountPrivateSettingService.getUserCRMLoginToken((currentLoginAccount = SecurityUtils.getCurrentLoginUser()).getGuid()), SalesForceOAuthTokenType.USER_AGENT)) instanceof NullCRMToken) {
            throw new CRMLoginException("Crm token expired.");
        }
        SalesforceAccountSearchResult salesforceAccountResult = null;
        OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(currentLoginAccount.getCompanyGuid());
        try {
            salesforceAccountResult = this.salesforceService.searchSalesforceAccounts(basicToken, keyword, client);
        }
        catch (Exception ex) {
            try {
                basicToken = this.salesForceTokenService.retrieveToken(currentLoginAccount.getGuid(), client);
                if (basicToken instanceof NullCRMToken) {
                    throw new CRMLoginException("Crm token expired.");
                }
                salesforceAccountResult = this.salesforceService.searchSalesforceAccounts(basicToken, keyword, client);
            }
            catch (Exception ex2) {
                throw new CRMLoginException("Crm token expired", (Throwable)ex2);
            }
        }
        return new SalesForceSearchRecordResponseResult("Search salesforce accounts succeeded.", salesforceAccountResult);
    }

    @ApiOperation(value="", notes="\u53d6\u5f97salesforce\u4e2d\u6700\u8fd1\u67e5\u770b\u7684accounts")
    @ApiResponses(value={@ApiResponse(code=409, message="The crm operation has failed."), @ApiResponse(code=400, message="CRM system login failed."), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_salesforce_recentview_accounts"}, method={RequestMethod.POST})
    public SalesForceSearchRecordResponseResult getSalesforceRecentviewAccounts() {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        String userCRMloginTokenString = this.accountPrivateSettingService.getUserCRMLoginToken(currentLoginAccount.getGuid());
        BasicToken basicToken = this.salesforceAuthenticationManager.getAccessToken(userCRMloginTokenString, SalesForceOAuthTokenType.USER_AGENT);
        if (basicToken instanceof NullCRMToken) {
            throw new CRMLoginException("Crm token expired.");
        }
        SalesforceAccountSearchResult salesforceAccountResult = null;
        OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(currentLoginAccount.getCompanyGuid());
        try {
            salesforceAccountResult = this.salesforceService.getSalesforceRecentviewAccounts(basicToken, client);
        }
        catch (Exception ex) {
            try {
                basicToken = this.salesForceTokenService.retrieveToken(currentLoginAccount.getGuid(), client);
                if (basicToken instanceof NullCRMToken) {
                    throw new CRMLoginException("Crm token expired.");
                }
                salesforceAccountResult = this.salesforceService.getSalesforceRecentviewAccounts(basicToken, client);
                this.accountPrivateSettingService.updateCRMLoginToken(currentLoginAccount.getGuid(), basicToken);
            }
            catch (Exception ex2) {
                throw new CRMLoginException("Crm token expired", (Throwable)ex2);
            }
        }
        return new SalesForceSearchRecordResponseResult("Get salesforce recentview accounts succeeded.", salesforceAccountResult);
    }
}

