/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.Utils.WorldcardAddressJNI;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.dto.CustomFieldDto;
import com.penpower.worldcard.team.enums.CRMExportMode;
import com.penpower.worldcard.team.enums.CrmTargetType;
import com.penpower.worldcard.team.enums.CustomFieldContactAttribute;
import com.penpower.worldcard.team.enums.LangCode;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.enums.VCardTarget;
import com.penpower.worldcard.team.exception.IncorrectAccountSettings;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.DeleteUndownloadedContactsOfAccountJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ContactPublicService;
import com.penpower.worldcard.team.service.ContactService;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.web.api.vo.ContactAddressVo;
import com.penpower.worldcard.team.web.api.vo.ContactInfoVo;
import com.penpower.worldcard.team.web.api.vo.ContactListRequestVo;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.PageInfo;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contact"}, produces={"application/json;charset=UTF-8"}, method={RequestMethod.POST})
@Api(tags={"contact"})
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE)")
public class ContactController {
    private static final Logger LOG = LoggerFactory.getLogger(ContactController.class);
    @Autowired
    private ContactService contactService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private ContactPublicService contactPublicService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private PathManager exportPathManager;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private CustomFieldService customFieldService;

    @RequestMapping(value={"/get_contact_content"})
    public BasicResponseResult<ContactInfoVo, Object> getContactCotent(@RequestParam(required=true) String contactGuid) {
        ContactInfoVo contactInfoVo = this.contactPrivateService.getContactInfoVoByGuid(contactGuid);
        contactInfoVo.getCustomDataList().forEach(info -> {
            try {
                CustomFieldDto customFieldDto = this.customFieldService.getCustomField(info.getCustomfieldSettingGuid());
                info.setFieldCaption(customFieldDto.getCustomFieldName());
                if (CustomFieldContactAttribute.PICKLIST.equals((Object)customFieldDto.getCustomFieldContactAttribute())) {
                    String picklistItemID = info.getTextValue();
                    List picklistSettings = customFieldDto.getPicklistContents();
                    picklistSettings.stream().filter(p -> p.getGuid().equals(picklistItemID)).findFirst().ifPresent(p -> info.setTextValue(p.getContent()));
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        });
        return new BasicResponseResult("Get contact by guid success.", (Object)contactInfoVo);
    }

    @RequestMapping(value={"/get_by_guid_list"})
    public PageResponseResult<ContactSimpleInfoDto> getContactsByGuids(@RequestBody @Valid ContactListRequestVo vo) {
        List contactGuids = vo.getList();
        PageInfo pageInfo = vo.getPageInfo();
        PageResult contactPage = this.contactPrivateService.getSimpleContactDtoPageByGuids(contactGuids, pageInfo);
        AccountInfo myAccount = SecurityUtils.getCurrentLoginUser();
        this.contactPublicService.markDownloadStatusOfContactsByAccount(contactPage.getData(), myAccount.getGuid());
        PageResponseResult result = new PageResponseResult("Get contacts by guids success.", contactPage.getData(), contactPage.getTotalCount(), contactPage.getTotalPage());
        return result;
    }

    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=460, message="Account settings incorrect.<BR>")})
    @RequestMapping(value={"/export_contacts_to_salesforce"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u532f\u51fa\u540d\u7247\u5230Salesforce. <BR><BR>NOTE: salesforceTarget\u53c3\u6578,\u53ea\u80fd\u50b3 SALESFORCE_CONTACT \u6216 SALESFORCE_LEAD")
    public MessageResponseResult exportContactsToSalesforce(@RequestBody ListRequestVo<String> contactGuidVo, @RequestParam CrmTargetType salesforceTarget, @RequestParam(required=false) String salesforceAccountId) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = loginAccount.getGuid();
        if (!CrmTargetType.SALESFORCE_CONTACT.equals((Object)salesforceTarget) && !CrmTargetType.SALESFORCE_LEAD.equals((Object)salesforceTarget)) {
            throw new RequestArgumentNotValidException("Export target type should be SALESFORCE_CONTACT or SALESFORCE_LEAD");
        }
        try {
            AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
            SupportCRM supportCRM = this.systemSettingService.getSystemCRM(currentLoginUser);
            if (!SupportCRM.SALESFORCE.equals((Object)supportCRM)) {
                throw new IncorrectAccountSettings("System CRM export setting is not Salesforce");
            }
        }
        catch (ItemNotFoundException e) {
            throw new IncorrectAccountSettings("System CRM export setting is not set");
        }
        try {
            CRMExportMode exportMode = this.accountPrivateSettingService.getCrmExportMode(accountGuid);
            if (CRMExportMode.AUTO_SYNC_CONTACT.equals((Object)exportMode)) {
                throw new IncorrectAccountSettings("Account CRM export setting is auto sync");
            }
        }
        catch (ItemNotFoundException e) {
            throw new IncorrectAccountSettings("CRM settings for login account are not set");
        }
        boolean isSendNotice = true;
        this.contactService.exportContactsToCRM(accountGuid, contactGuidVo.getList(), isSendNotice, salesforceTarget, salesforceAccountId, loginAccount.getCompanyGuid());
        return new MessageResponseResult("Send out job for exporting contacts to salesforce success.", null);
    }

    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=460, message="Account settings incorrect.<BR>")})
    @RequestMapping(value={"/export_contacts_to_contact_server"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u532f\u51fa\u540d\u7247\u5230\u516c\u53f8\u901a\u8a0a\u9304. ")
    public MessageResponseResult exportContactsToContactServer(@RequestBody ListRequestVo<String> contactGuidVo) {
        AccountInfo currentloginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = currentloginAccount.getGuid();
        try {
            if (!this.accountPrivateSettingService.isManualExportToSystemContactServer(accountGuid)) {
                throw new IncorrectAccountSettings("Account contact server export setting is not manual.");
            }
        }
        catch (ItemNotFoundException e) {
            throw new IncorrectAccountSettings("Contact server settings for login account are not set");
        }
        boolean isSendNotice = true;
        this.contactService.exportContactsToContactServer(accountGuid, contactGuidVo.getList(), isSendNotice, currentloginAccount.getCompanyGuid());
        return new MessageResponseResult("Send out job for exporting contacts to contact server success.", null);
    }

    public MessageResponseResult exportContactsToCRM(@RequestBody ListRequestVo<String> contactGuidVo) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = loginAccount.getGuid();
        try {
            if (!this.accountPrivateSettingService.isManualExportToCRM(accountGuid)) {
                throw new IncorrectAccountSettings("Account CRM export setting is not manual.");
            }
        }
        catch (ItemNotFoundException e) {
            throw new IncorrectAccountSettings("There is no CRM settings.");
        }
        boolean isSendNotice = true;
        return new MessageResponseResult("Send out job for exporting contacts to sugar crm success.", null);
    }

    @RequestMapping(value={"export_contacts_to_googlecsv"}, method={RequestMethod.POST})
    public void ExportGoogleCSV(@RequestBody ListRequestVo<String> contactGuids, HttpServletResponse response) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = loginAccount.getGuid();
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path CurrDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path csvFile = Paths.get(CurrDatePath.toString(), "gmail_" + timefmater.print((ReadableInstant)currTime) + ".csv");
        LOG.debug("exportContactsToFile 2 {}", (Object)csvFile.toString());
        this.contactService.exportContactsToGmail(accountGuid, contactGuids.getList(), csvFile.toString());
        try {
            File file = new File(csvFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_contacts_to_Outlookcsv"}, method={RequestMethod.POST})
    public void ExportOutlookCSV(@RequestBody ListRequestVo<String> contactGuids, @RequestParam LangCode langCode, HttpServletResponse response) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = loginAccount.getGuid();
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path CurrDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path csvFile = Paths.get(CurrDatePath.toString(), "Outlook" + timefmater.print((ReadableInstant)currTime) + ".csv");
        LOG.debug("exportContactsToFile 2 {}", (Object)csvFile.toString());
        this.contactService.exportCSVForOutlook(accountGuid, contactGuids.getList(), csvFile.toString(), langCode);
        try {
            File file = new File(csvFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_one_contact_to_vcard"}, method={RequestMethod.POST})
    public void ExportOneVCard(@RequestParam String contactGuid, @RequestParam VCardTarget vcardTarget, HttpServletResponse response) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = loginAccount.getGuid();
        DateTime currTime = new DateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path CurrDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        Path VCardFile = Paths.get(CurrDatePath.toString(), "VCard" + timefmater.print((ReadableInstant)currTime) + ".vcf");
        LOG.debug("exportContactsToFile 2 {}", (Object)VCardFile.toString());
        this.contactService.exportOneVCard(accountGuid, contactGuid, CurrDatePath.toString(), "VCard" + timefmater.print((ReadableInstant)currTime) + ".vcf", vcardTarget);
        try {
            File file = new File(VCardFile.toString());
            FileInputStream is = new FileInputStream(file);
            long fileSize = file.length();
            response.setContentType("application/octet-stream");
            response.setContentLengthLong(fileSize);
            IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException ex) {
            LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
            throw new RuntimeException("IOError writing file to output stream");
        }
    }

    @RequestMapping(value={"export_contacts_to_vcard_zip"}, method={RequestMethod.POST})
    public void ExportVCardZip(@RequestBody ListRequestVo<String> contactGuids, @RequestParam VCardTarget vcardTarget, HttpServletResponse response) {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        String accountGuid = loginAccount.getGuid();
        DateTime currTime = new DateTime();
        LocalDateTime loTime = new LocalDateTime();
        DateTimeFormatter datefmt = DateTimeFormat.forPattern((String)"yyyy_MM_dd");
        Path CurrDatePath = this.exportPathManager.CreateFullyPath(datefmt.print((ReadableInstant)currTime));
        DateTimeFormatter timefmater = DateTimeFormat.forPattern((String)"hh_mm_ss_SSS");
        DateTimeFormatter symbolFmater = DateTimeFormat.forPattern((String)"yyyyMMdd_hhmmss_");
        String symbolName = symbolFmater.print((ReadablePartial)loTime);
        LOG.debug("exportContactsToFile symbolName  {}", (Object)symbolName);
        String fileName = this.contactService.exportVCardZip(accountGuid, contactGuids.getList(), CurrDatePath.toString(), symbolName, "VCard" + timefmater.print((ReadableInstant)currTime), vcardTarget);
        if (fileName != null && fileName.length() != 0) {
            try {
                File file = new File(fileName);
                FileInputStream is = new FileInputStream(file);
                long fileSize = file.length();
                response.setContentType("application/octet-stream");
                response.setContentLengthLong(fileSize);
                IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException ex) {
                LOG.debug("Error writing file to output stream. Filename was {}", (Throwable)ex);
                throw new RuntimeException("IOError writing file to output stream");
            }
        } else {
            throw new RuntimeException("export file fail");
        }
    }

    @RequestMapping(value={"trans_to_googleaddress"}, method={RequestMethod.POST})
    public MessageResponseResult TransToGoogleAddress(@RequestBody ContactAddressVo contactAddressVo) {
        String address = new WorldcardAddressJNI().GetGoogleAddress(contactAddressVo.getStreet(), contactAddressVo.getCity(), contactAddressVo.getState(), contactAddressVo.getZip(), contactAddressVo.getCountryName());
        return new MessageResponseResult("trans to google address success", address);
    }

    @RequestMapping(value={"/clean_undownloaded_contacts"}, method={RequestMethod.POST})
    public MessageResponseResult cleanUndownloadedContacts() {
        AccountInfo loginAccount = SecurityUtils.getCurrentLoginUser();
        JobIdentify jobIdentify = new JobIdentify("CLEAN_UNDOWNLOADED_CONTACTS" + UUIDGenerator.getRandomUUID(), DeleteUndownloadedContactsOfAccountJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("ACCOUNT_GUID", loginAccount.getGuid());
        this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
        return new MessageResponseResult("Clean job issued.", null);
    }
}

