/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.penpower.worldcard.team.Utils.DiskInfos;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.BackupScheduleInfo;
import com.penpower.worldcard.team.dto.BackupStoragInfos;
import com.penpower.worldcard.team.dto.BackupStoragInfosLess;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.BackupFailedType;
import com.penpower.worldcard.team.enums.BackupRunningStaus;
import com.penpower.worldcard.team.enums.ContactImageTransferStatus;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ScheduleType;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.StorageSpaceStatus;
import com.penpower.worldcard.team.exception.BackupJobAlreadyRunningException;
import com.penpower.worldcard.team.exception.BackupRuntimException;
import com.penpower.worldcard.team.exception.BackupScheduleJobAlreadySetException;
import com.penpower.worldcard.team.exception.BackupStorageSpaceNotEnoughException;
import com.penpower.worldcard.team.exception.ImageDataMigrationJobRunningException;
import com.penpower.worldcard.team.exception.InvalidBackupPathException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.exception.UnsupportFileSystemTypeException;
import com.penpower.worldcard.team.notice.content.BackupFailedContent;
import com.penpower.worldcard.team.restore.DatabaseConnectionInfo;
import com.penpower.worldcard.team.restore.PostgreSqlJdbcUtils;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.BackupJob;
import com.penpower.worldcard.team.service.BackupInfoService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.web.api.BackupController;
import com.penpower.worldcard.team.web.api.vo.response.BackupScheduleInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.DateTimeResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.LastBackupErrorMessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.StorageSpaceStatusResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.validation.Valid;
import org.joda.time.DateTime;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/backup"}, produces={"application/json;charset=UTF-8"})
@Api(tags={""}, description="\u5099\u4efd\u76f8\u95dc\u7684API\u64cd\u4f5c")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class BackupController {
    private static final Logger LOG = LoggerFactory.getLogger(BackupController.class);
    @Autowired
    private Environment env;
    @Autowired
    private BackupInfoService backupService;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager databaseScheduleManager;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private RegistryService registryService;

    @ApiOperation(value="", notes="\u53d6\u5f97\u5099\u4efd\u7684\u8cc7\u6599\u593e\u6e05\u55ae(USB)")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_backup_storage_infos"}, method={RequestMethod.GET})
    public ListResponseResult<BackupStoragInfos> getBackupStorageInfos() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        List backupStoragInfos = this.backupService.getBackupStorageInfos();
        if (backupStoragInfos == null || backupStoragInfos.size() <= 0) {
            throw new ItemNotFoundException("No external storage information found.");
        }
        ListResponseResult response = new ListResponseResult("Get all backup storage informations succeeded.", backupStoragInfos);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u9810\u8a08\u5099\u4efd\u8def\u5f91\u7684\u5b58\u5132\u7a7a\u9593\u72c0\u614b<BR>(\u8cc7\u6599\u5eab\u5927\u5c0f / \u53ef\u7528\u7a7a\u9593)\u4e4b\u503c < 1\t\t: NOT_ENOUGH<BR>(\u8cc7\u6599\u5eab\u5927\u5c0f / \u53ef\u7528\u7a7a\u9593)\u4e4b\u503c\u4ecb\u65bc1-2\u4e4b\u9593\t: WARNING<BR>(\u8cc7\u6599\u5eab\u5927\u5c0f / \u53ef\u7528\u7a7a\u9593)\u4e4b\u503c\u5927\u65bc2\t\t: NORMAL<BR>")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/check_backup_storage_space"}, method={RequestMethod.POST})
    public StorageSpaceStatusResult<StorageSpaceStatus> checkBackupStorage(@RequestBody @Valid BackupStoragInfosLess backupStoragInfosLess) {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        String backupStoragePath = backupStoragInfosLess.getStoragePath();
        Path backupStorage = Paths.get(backupStoragePath, new String[0]);
        LOG.debug("backupStoragePath : {} ", (Object)backupStoragePath);
        if (!Files.exists(backupStorage, new LinkOption[0])) {
            throw new ItemNotFoundException("Backup storage path not found.");
        }
        DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)backupStorage);
        long usableSpaceBytes = diskInfos.getUsableSpaceBytes();
        long currentDatabaseSizeBytes = this.getBackupDatabaseSize();
        LOG.debug("usableSpaceBytes : {} ", (Object)usableSpaceBytes);
        LOG.debug("currentDatabaseSizeBytes : {} ", (Object)currentDatabaseSizeBytes);
        if (currentDatabaseSizeBytes <= 0L) {
            StorageSpaceStatusResult response = new StorageSpaceStatusResult("Get all backup storage space status succeeded.", StorageSpaceStatus.NORMAL);
            return response;
        }
        if (usableSpaceBytes <= 0L) {
            StorageSpaceStatusResult response = new StorageSpaceStatusResult("Get all backup storage space status succeeded.", StorageSpaceStatus.NOT_ENOUGH);
            return response;
        }
        double multipleValue = (double)usableSpaceBytes / (double)currentDatabaseSizeBytes;
        boolean lessThan_1 = multipleValue < 0.0;
        boolean largerThan_1_lessThan_2 = multipleValue >= 1.0 && multipleValue <= 2.0;
        boolean larger_2 = multipleValue > 2.0;
        LOG.debug("multipleValue : {} ", (Object)multipleValue);
        LOG.debug("lessThan_1 : {} ", (Object)lessThan_1);
        LOG.debug("largerThan_1_lessThan_2 : {} ", (Object)largerThan_1_lessThan_2);
        LOG.debug("larger_2 : {} ", (Object)larger_2);
        if (lessThan_1) {
            StorageSpaceStatusResult response = new StorageSpaceStatusResult("Get all backup storage space status succeeded.", StorageSpaceStatus.NOT_ENOUGH);
            return response;
        }
        if (largerThan_1_lessThan_2) {
            StorageSpaceStatusResult response = new StorageSpaceStatusResult("Get all backup storage space status succeeded.", StorageSpaceStatus.WARNING);
            return response;
        }
        StorageSpaceStatusResult response = new StorageSpaceStatusResult("Get all backup storage space status succeeded.", StorageSpaceStatus.NORMAL);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u7684\u5099\u4efd\u7684\u72c0\u614b")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_backup_job_status"}, method={RequestMethod.GET})
    public MessageResponseResult getBackupJobStatus() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        boolean databaseBackupJobRunning = this.databaseScheduleManager.jobRunning(BackupJob.class);
        boolean inMemoryBackupJobRunning = this.scheduleManager.jobRunning(BackupJob.class);
        LOG.debug("databaseBackupJobRunning : {}", (Object)databaseBackupJobRunning);
        LOG.debug("inMemoryBackupJobRunning : {}", (Object)inMemoryBackupJobRunning);
        BackupRunningStaus status = (BackupRunningStaus)BackupJob.BACKUP_RUNNING_STATUS.get();
        if (!this.jobRunning(databaseBackupJobRunning, inMemoryBackupJobRunning) && !BackupRunningStaus.FIRED.equals((Object)status)) {
            throw new ItemNotFoundException("There is no backup job running....");
        }
        return new MessageResponseResult("Get current backup job running status succeeded.", status.toString());
    }

    private boolean jobRunning(boolean databaseBackupJobRunning, boolean inMemoryBackupJobRunning) {
        return databaseBackupJobRunning || inMemoryBackupJobRunning;
    }

    @ApiOperation(value="", notes="\u53d6\u7684\u76ee\u524d\u5099\u4efd\u7684\u8655\u7406\u767e\u5206\u6bd4\u6578\u5b57(\u5982\u679c\u6709\u5728\u57f7\u884c\u4e2d)")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_backup_job_progress"}, method={RequestMethod.GET})
    public MessageResponseResult getBackupJobProgress() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        boolean databaseBackupJobRunning = this.databaseScheduleManager.jobRunning(BackupJob.class);
        LOG.debug("databaseBackupJobRunning : {} ", (Object)databaseBackupJobRunning);
        boolean inMemoryBackupJobRunning = this.scheduleManager.jobRunning(BackupJob.class);
        LOG.debug("inMemoryBackupJobRunning : {} ", (Object)inMemoryBackupJobRunning);
        if (!this.jobRunning(databaseBackupJobRunning, inMemoryBackupJobRunning) && !BackupRunningStaus.FIRED.equals(BackupJob.BACKUP_RUNNING_STATUS.get())) {
            throw new ItemNotFoundException("There is no backup job running....");
        }
        Path backupSqlFile = (Path)BackupJob.BACKUP_FILE_PATH.get();
        LOG.debug("backupSqlFile:{}", (Object)backupSqlFile);
        if (backupSqlFile == null || !Files.exists(backupSqlFile, new LinkOption[0])) {
            throw new ItemNotFoundException("There is no backup job running....");
        }
        long backupSize = 0L;
        if (Files.exists(backupSqlFile, new LinkOption[0])) {
            try {
                backupSize = Files.size(backupSqlFile);
            }
            catch (IOException e) {
                throw new ItemNotFoundException("Fail to get current backup file size.....");
            }
        }
        if (!databaseBackupJobRunning && !inMemoryBackupJobRunning) {
            backupSize = 0L;
        }
        return new MessageResponseResult("Get current backup job running progress value succeeded.", String.valueOf(backupSize));
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u6700\u5f8c\u4e00\u6b21\u5099\u4efd\u7684\u6642\u9593")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_last_backup_time"}, method={RequestMethod.GET})
    public DateTimeResponseResult getLastBackupTime() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        DateTime lastBackupTime = this.backupService.getLastBackUpTime();
        if (lastBackupTime == null) {
            throw new ItemNotFoundException("No last backup time found.");
        }
        return new DateTimeResponseResult("Get last backup time succeeded.", lastBackupTime);
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u4e0a\u6b21\u5099\u4efd\u5931\u6557\u7684Error Message")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_last_backup_error_message"}, method={RequestMethod.GET})
    public LastBackupErrorMessageResponseResult getLastBackupErrorMessage() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        BackupFailedContent lastBackupFailedContent = this.backupService.getLastBackupErrorMessage();
        if (lastBackupFailedContent == null) {
            throw new ItemNotFoundException("There is no last backup failed error message...");
        }
        return new LastBackupErrorMessageResponseResult("Get last backup failed error message succeeded.", lastBackupFailedContent);
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u5b9a\u671f\u5099\u4efd\u7684\u8a2d\u5b9a\u8cc7\u6599")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_backup_schedule_information"}, method={RequestMethod.GET})
    public BackupScheduleInfoResponseResult getBackupScheduleInformation() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        BackupScheduleInfo backupScheduleInfo = this.backupService.readScheduleTmpInfo();
        BackupScheduleInfoResponseResult result = new BackupScheduleInfoResponseResult("Get backup job schedule settings succeeded.", backupScheduleInfo);
        return result;
    }

    @ApiOperation(value="", notes="\u79fb\u9664\u76ee\u524d\u6240\u6709\u5b9a\u671f\u5099\u4efd\u7684\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=465, message="Unspecified exception for backup job."), @ApiResponse(code=466, message="Backup job is already running"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/remove_backup_schedule"}, method={RequestMethod.POST})
    public MessageResponseResult remove_backup_schedule() {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        boolean databaseBackupJobRunning = this.databaseScheduleManager.jobRunning(BackupJob.class);
        boolean inMemoryBackupJobRunning = this.scheduleManager.jobRunning(BackupJob.class);
        LOG.debug("databaseBackupJobRunning : {} ", (Object)databaseBackupJobRunning);
        LOG.debug("inMemoryBackupJobRunning : {} ", (Object)inMemoryBackupJobRunning);
        if (this.jobRunning(databaseBackupJobRunning, inMemoryBackupJobRunning)) {
            throw new BackupJobAlreadyRunningException("Backup job is already running....");
        }
        JobIdentify backupScheduleJobIdentify = new JobIdentify("BACKUP_JOB_GROUP", BackupJob.class);
        boolean removed = this.databaseScheduleManager.deleteSchedule(backupScheduleJobIdentify);
        if (!removed) {
            throw new BackupRuntimException("Fail to remove all backup schedule settings.....");
        }
        this.backupService.deleteScheduleTmpInfo();
        MessageResponseResult result = new MessageResponseResult("Remove all backup job schedule settings succeeded.", null);
        return result;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u5b9a\u671f\u5099\u4efd")
    @ApiResponses(value={@ApiResponse(code=459, message="The image data migration job already running"), @ApiResponse(code=464, message="There is not enough space available on the backup path."), @ApiResponse(code=481, message="Backup path only support ext4 or ntfs file system."), @ApiResponse(code=468, message="The backup storage path is invalid or not exists."), @ApiResponse(code=465, message="Unspecified exception for backup job."), @ApiResponse(code=466, message="Backup job is already running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_backup_schedule"}, method={RequestMethod.POST})
    public MessageResponseResult setBackupSchedule(@RequestBody @Valid BackupScheduleInfo backupScheduleInfo) {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("CONTACT_IMAGE_TRANSFER_STATUS");
        ContactImageTransferStatus status = ContactImageTransferStatus.valueOf((String)globalInfo.getConfigValue());
        if (ContactImageTransferStatus.IN_PROGRESS.equals((Object)status)) {
            throw new ImageDataMigrationJobRunningException("The image data migration job already running.....");
        }
        String storagePath = backupScheduleInfo.getStoragePath();
        Path backpPath = Paths.get(storagePath, new String[0]);
        boolean backupPathExists = Files.isDirectory(backpPath, new LinkOption[0]);
        LOG.debug("backupPathExists : {}", (Object)backupPathExists);
        if (!backupPathExists) {
            throw new InvalidBackupPathException("The backup destination path does not exists.");
        }
        DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)backpPath);
        long usableSpaceBytes = diskInfos.getUsableSpaceBytes();
        long currentDatabaseSizeBytes = this.getBackupDatabaseSize();
        LOG.debug("usableSpaceBytes : {} ", (Object)usableSpaceBytes);
        LOG.debug("currentDatabaseSizeBytes : {} ", (Object)currentDatabaseSizeBytes);
        if (currentDatabaseSizeBytes > usableSpaceBytes) {
            throw new BackupStorageSpaceNotEnoughException("There is not enough space available on the backup path.");
        }
        boolean supportFileSystem = FileSystemUtil.verifySupportFileSystem((Path)backpPath);
        if (!supportFileSystem) {
            throw new UnsupportFileSystemTypeException("Backup path file system will be EXT4 or NTFS.");
        }
        boolean databaseBackupJobRunning = this.databaseScheduleManager.jobRunning(BackupJob.class);
        boolean inMemoryBackupJobRunning = this.scheduleManager.jobRunning(BackupJob.class);
        LOG.debug("databaseBackupJobRunning : {} ", (Object)databaseBackupJobRunning);
        LOG.debug("inMemoryBackupJobRunning : {} ", (Object)inMemoryBackupJobRunning);
        if (databaseBackupJobRunning | inMemoryBackupJobRunning) {
            throw new BackupJobAlreadyRunningException("Backup job is already running....");
        }
        JobIdentify backupJobIdentify = new JobIdentify("BACKUP_JOB_GROUP", BackupJob.class);
        boolean oldSchedulSettingsRemove = this.databaseScheduleManager.deleteSchedule(backupJobIdentify);
        if (!oldSchedulSettingsRemove) {
            throw new BackupRuntimException("Can't remove old settings of backup scheudle.");
        }
        LOG.debug("backupScheduleInfo : {}", (Object)backupScheduleInfo);
        ScheduleType scheduleType = backupScheduleInfo.getScheduleType();
        DateTime now = DateTime.now().plusSeconds(5);
        LOG.debug("backup schedule start time : {} ", (Object)now);
        JobDataMap dataMap = new JobDataMap();
        BackupStoragInfosLess backupStoragInfosLess = new BackupStoragInfosLess();
        backupStoragInfosLess.setStorageName(backupScheduleInfo.getStorageName());
        backupStoragInfosLess.setStoragePath(backupScheduleInfo.getStoragePath());
        dataMap.put("backupStoragInfosLess", (Object)backupStoragInfosLess);
        String cronExpression = null;
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ScheduleType[scheduleType.ordinal()]) {
            case 1: {
                String dailyCronExpressionTemplate = "0 %s %s * * ?";
                cronExpression = String.format(dailyCronExpressionTemplate, backupScheduleInfo.getMinute(), backupScheduleInfo.getHour());
                this.databaseScheduleManager.startSchedule(backupJobIdentify, cronExpression, now.toDate(), dataMap);
                break;
            }
            case 2: {
                String weeklyCronExpressionTemplate = "0 %s %s ? * %s";
                cronExpression = String.format(weeklyCronExpressionTemplate, backupScheduleInfo.getMinute(), backupScheduleInfo.getHour(), backupScheduleInfo.getDayOfWeek());
                this.databaseScheduleManager.startSchedule(backupJobIdentify, cronExpression, now.toDate(), dataMap);
                break;
            }
            case 3: {
                String monthLyCronExpressionTemplate = "0 %s %s %s * ?";
                cronExpression = String.format(monthLyCronExpressionTemplate, backupScheduleInfo.getMinute(), backupScheduleInfo.getHour(), backupScheduleInfo.getDayOfMonth());
                this.databaseScheduleManager.startSchedule(backupJobIdentify, cronExpression, now.toDate(), dataMap);
                break;
            }
            default: {
                throw new BackupRuntimException("Schedule type was not correctly. , type : " + scheduleType);
            }
        }
        this.backupService.writeScheduleTmpInfo(backupScheduleInfo);
        LOG.debug("Write the backupScheduleInfo into db.....");
        MessageResponseResult result = new MessageResponseResult("Set backup job schedule settings succeeded.", null);
        return result;
    }

    @ApiOperation(value="", notes="\u7acb\u5373\u555f\u52d5\u5099\u4efd")
    @ApiResponses(value={@ApiResponse(code=459, message="The image data migration job already running"), @ApiResponse(code=464, message="There is not enough space available on the backup path."), @ApiResponse(code=481, message="Backup path only support ext4 or ntfs file system."), @ApiResponse(code=468, message="The backup storage path is invalid or not exists."), @ApiResponse(code=467, message="The backup job schedule is already set up."), @ApiResponse(code=465, message="Unspecified exception for backup job."), @ApiResponse(code=466, message="Backup job is already running"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/start_backup"}, method={RequestMethod.POST})
    public MessageResponseResult startBackup(@RequestBody @Valid BackupStoragInfosLess backupStoragInfosLess) {
        if (!HardwareIdUtil.linuxSystem()) {
            throw new PermissionDeniedException("Linux system support only.");
        }
        boolean databaseBackupJobRunning = this.databaseScheduleManager.jobRunning(BackupJob.class);
        boolean inMemoryBackupJobRunning = this.scheduleManager.jobRunning(BackupJob.class);
        LOG.debug("databaseBackupJobRunning : {} ", (Object)databaseBackupJobRunning);
        LOG.debug("inMemoryBackupJobRunning : {} ", (Object)inMemoryBackupJobRunning);
        if (this.jobRunning(databaseBackupJobRunning, inMemoryBackupJobRunning)) {
            throw new BackupJobAlreadyRunningException("Backup job is already running....");
        }
        JobKey jobKey = new JobKey(BackupJob.class.getName(), "BACKUP_JOB_GROUP");
        JobDetail scheduleBackupJobDetail = this.databaseScheduleManager.getJobDetail(jobKey);
        LOG.debug("Check job is already set up or not ,scheduleBackupJobDetail : {} ", (Object)scheduleBackupJobDetail);
        if (scheduleBackupJobDetail != null) {
            throw new BackupScheduleJobAlreadySetException("The backup schedule job has ben set.");
        }
        Globalinfo globalInfo = this.globalInfoService.getPropertiesByKey("CONTACT_IMAGE_TRANSFER_STATUS");
        ContactImageTransferStatus status = ContactImageTransferStatus.valueOf((String)globalInfo.getConfigValue());
        if (ContactImageTransferStatus.IN_PROGRESS.equals((Object)status)) {
            throw new ImageDataMigrationJobRunningException("The image data migration job already running.....");
        }
        String storagePath = backupStoragInfosLess.getStoragePath();
        Path backpPath = Paths.get(storagePath, new String[0]);
        boolean backupPathExists = Files.isDirectory(backpPath, new LinkOption[0]);
        LOG.debug("backupPathExists : {}", (Object)backupPathExists);
        if (!backupPathExists) {
            throw new InvalidBackupPathException("The backup destination path does not exists.");
        }
        boolean supportFileSystem = FileSystemUtil.verifySupportFileSystem((Path)backpPath);
        if (!supportFileSystem) {
            throw new UnsupportFileSystemTypeException("Backup path file system will be EXT4 or NTFS.");
        }
        DiskInfos diskInfos = FileSystemUtil.getDiskInfos((Path)backpPath);
        long usableSpaceBytes = diskInfos.getUsableSpaceBytes();
        long currentDatabaseSizeBytes = this.getBackupDatabaseSize();
        LOG.debug("usableSpaceBytes : {} ", (Object)usableSpaceBytes);
        LOG.debug("currentDatabaseSizeBytes : {} ", (Object)currentDatabaseSizeBytes);
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        if (currentDatabaseSizeBytes > usableSpaceBytes) {
            String backupFailedContent = GlobalUtils.getJsonString((Object)new BackupFailedContent(BackupFailedType.BACKUP_STORAGE_SPACE_NOT_ENOUGH, null));
            this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.BACKUP_FAILED, backupFailedContent, null, currentLoginAccount.getCompanyGuid());
            throw new BackupStorageSpaceNotEnoughException("There is not enough space available on the backup path.");
        }
        JobIdentify jobIdentify = new JobIdentify("BACKUP_JOB_GROUP", BackupJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("backupStoragInfosLess", (Object)backupStoragInfosLess);
        DateTime launchTime = new DateTime().plusSeconds(1);
        this.scheduleManager.startScheduleOnce(jobIdentify, launchTime.toDate(), dataMap);
        BackupJob.BACKUP_RUNNING_STATUS.set(BackupRunningStaus.FIRED);
        MessageResponseResult response = new MessageResponseResult("Backup job start scceeded.(in background)", null);
        return response;
    }

    private long getBackupDatabaseSize() {
        String databaseName;
        String password;
        String username;
        String serverPort;
        String serverIpAddress;
        ServerType serverType = this.registryService.GetServerType();
        String rootUrlFormat = "%s%s:%s/";
        if (ServerType.SYNOLOGY_NAS.equals((Object)serverType)) {
            serverIpAddress = this.env.getProperty("dataSource.synology_nas.ip");
            serverPort = this.env.getProperty("dataSource.synology_nas.port");
            username = this.env.getProperty("dataSource.synology_nas.username");
            password = this.env.getProperty("dataSource.synology_nas.password");
            databaseName = this.env.getProperty("dataSource.synology_nas.databaseName");
        } else if (ServerType.QNAP_NAS.equals((Object)serverType)) {
            serverIpAddress = this.env.getProperty("dataSource.qnap_nas.ip");
            serverPort = this.env.getProperty("dataSource.qnap_nas.port");
            username = this.env.getProperty("dataSource.qnap_nas.username");
            password = this.env.getProperty("dataSource.qnap_nas.password");
            databaseName = this.env.getProperty("dataSource.qnap_nas.databaseName");
        } else {
            serverIpAddress = this.env.getProperty("dataSource.nas.ip");
            serverPort = this.env.getProperty("dataSource.nas.port");
            username = this.env.getProperty("dataSource.nas.username");
            password = this.env.getProperty("dataSource.nas.password");
            databaseName = this.env.getProperty("dataSource.nas.databaseName");
        }
        DatabaseConnectionInfo databaseConnectionInfo = new DatabaseConnectionInfo(rootUrlFormat, serverIpAddress, serverPort, username, password);
        PostgreSqlJdbcUtils jdbcDatabaseUtils = new PostgreSqlJdbcUtils(databaseConnectionInfo);
        long restoreDatabaseSizeBytes = jdbcDatabaseUtils.queryDatabaseSize(databaseName);
        return restoreDatabaseSizeBytes;
    }
}

