/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.NetworkUtil;
import com.penpower.worldcard.team.Utils.SSLUtil;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CustomFieldDto;
import com.penpower.worldcard.team.dto.IpAllowedInfoDto;
import com.penpower.worldcard.team.dto.MailSettingInfo;
import com.penpower.worldcard.team.dto.SSLInfo;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.enums.CustomFieldCategory;
import com.penpower.worldcard.team.enums.LoginFailureOption;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.ShareRule;
import com.penpower.worldcard.team.enums.SupportCRM;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.enums.SystemProperty;
import com.penpower.worldcard.team.exception.CustomFieldMaxCountException;
import com.penpower.worldcard.team.exception.DuplicateCustomFieldValueException;
import com.penpower.worldcard.team.exception.DuplicateItemValueException;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.ValueOutofRangeException;
import com.penpower.worldcard.team.mail.MailInfo;
import com.penpower.worldcard.team.mail.PurchaseLicensedMailInfoBuilder;
import com.penpower.worldcard.team.notice.content.GlobalShareRuleChangeContent;
import com.penpower.worldcard.team.notice.content.SystemContactServerSettingsChangedContent;
import com.penpower.worldcard.team.notice.content.SystemContactServerSettingsRemovedContent;
import com.penpower.worldcard.team.notice.content.SystemCrmSettingsChangedContent;
import com.penpower.worldcard.team.notice.content.SystemCrmSettingsRemovedContent;
import com.penpower.worldcard.team.notice.content.SystemDomainChangedContent;
import com.penpower.worldcard.team.notice.event.WebSocketNoticePublisher;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.ContactServerAuthService;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.service.ElasticSearchService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.IpConstraintService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.web.api.vo.CompanyDomainVo;
import com.penpower.worldcard.team.web.api.vo.CustomFieldCreationVo;
import com.penpower.worldcard.team.web.api.vo.IpAllowedInfoCreationVo;
import com.penpower.worldcard.team.web.api.vo.IpAllowedInfoUpdateVo;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.PurchaseLiceneseInfo;
import com.penpower.worldcard.team.web.api.vo.SSLDetailInfo;
import com.penpower.worldcard.team.web.api.vo.SystemCRMDetail;
import com.penpower.worldcard.team.web.api.vo.SystemContactServerDetail;
import com.penpower.worldcard.team.web.api.vo.response.BasicResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.BooleanResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.CompanyDomainResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.CustomFieldNameResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MailSettingInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SSLDetailInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ShareRuleResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SupportCRMResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SupportCRMWithUrlResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.SystemContactServerResponseResult;
import com.penpower.worldcard.team.websokcet.WebSocketNotifyEvent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.mail.MailSendException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/account/admin/setting"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"admin_user_settings"}, description="Admin user settings")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class AdminUserSettingController {
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserSettingController.class);
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private AccountService accountService;
    @Autowired
    @Qualifier(value="webSocketNoticePublisher")
    private WebSocketNoticePublisher webSocketNoticePublisher;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private IpConstraintService ipConstraintService;
    @Autowired
    private ElasticSearchService elasticSearchService;
    @Autowired
    private ContactServerAuthService contactServerAuthService;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private CRMAuthenticationManager salesforceAuthenticationManager;
    public static final String FORCE_CHANGE_PASSWORD = "FORCE_CHANGE_PASSWORD";
    public static final String AUTO_LOCK_UNACTIVE = "AUTO_LOCK_UNACTIVE";
    public static final String CHANGE_PASSWORD_PERIOD = "CHANGE_PASSWORD_PERIOD";
    public static final String AUTO_LOCK_UNACTIVE_DAYS = "AUTO_LOCK_UNACTIVE_DAYS";
    public static final String LOGIN_FAILURE_COUNT_LIMIT = "LOGIN_FAILURE_COUNT_LIMIT";
    public static final String LOGIN_FAILURE_BLOCK_PERIOD = "LOGIN_FAILURE_BLOCK_PERIOD";
    public static final String LOGIN_FAILURE_OPTION = "LOGIN_FAILURE_OPTION";

    @ApiOperation(value="", notes="\u53d6\u5f97\u6307\u5b9a\u7684\u81ea\u8a02\u6b04\u4f4d\u5167\u5bb9")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_custom_field"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public CustomFieldNameResponseResult getCustomField(@RequestParam(required=true) String customFieldGuid) {
        CustomFieldDto customFieldDto = this.customFieldService.getCustomField(customFieldGuid);
        CustomFieldNameResponseResult response = new CustomFieldNameResponseResult("Get custom field by id succeeded.", customFieldDto);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u7684\u6240\u6709\u7684\u81ea\u8a02\u6b04\u4f4d\u5167\u5bb9(\u9700\u6307\u5b9acategory CONTACT,TASK,ACTIVITY)")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_all_custom_fields_by_category"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<CustomFieldDto> getAllCustomFieldsByCategory(@RequestParam(required=true) CustomFieldCategory customFieldCategory) {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        List customFieldContentDtos = this.customFieldService.getAllCustomFields(customFieldCategory, currentLoginAccount.getCompanyGuid());
        ListResponseResult response = new ListResponseResult("Get all custom fields succeeded.", customFieldContentDtos);
        return response;
    }

    @ApiOperation(value="", notes="\u5efa\u7acb\u65b0\u7684\u81ea\u8a02\u6b04\u4f4d<BR>customFieldContents \u548c customFieldContactAttribute\u5728category\u70bacontact\u7684\u6642\u5019\u624d\u6709\u6548<BR>\u5982\u679c\u70batask\u6216\u8457\u662factivity\u7684\u6642\u5019\u8acb\u50b3\u5165null<BR>")
    @ApiResponses(value={@ApiResponse(code=430, message="Picklist content cannot have the same value."), @ApiResponse(code=433, message="customfield name has the duplicate content value."), @ApiResponse(code=402, message="Total custom field count cannot be larger than16"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>")})
    @RequestMapping(value={"/create_custom_field"}, method={RequestMethod.POST})
    public MessageResponseResult create_custom_fieldName(@RequestBody @Valid CustomFieldCreationVo customFieldCreationVo) {
        LOG.debug("customFieldCreationVo : {} ", (Object)customFieldCreationVo);
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        CustomFieldCategory category = customFieldCreationVo.getCustomFieldCategory();
        String companyGuid = currentLoginAccount.getCompanyGuid();
        long totalCustomFieldCounts = this.customFieldService.getAllCustomFieldCountByCategory(category, companyGuid);
        LOG.debug("totalCustomFieldCounts : {} ", (Object)totalCustomFieldCounts);
        if (totalCustomFieldCounts >= 16L) {
            throw new CustomFieldMaxCountException("Max custom field count exceeded. size : " + totalCustomFieldCounts);
        }
        CustomFieldDto customFieldDto = this.customFieldService.getCustomFieldByCustomFieldNameAndCompany(customFieldCreationVo.getCustomFieldName(), companyGuid);
        if (customFieldDto != null) {
            throw new DuplicateCustomFieldValueException("fail to create new custom field , customfield name has the duplicate content value.");
        }
        String guid = null;
        try {
            guid = this.customFieldService.createNewCustomField(customFieldCreationVo, currentLoginAccount.getCompanyGuid());
        }
        catch (PersistenceException ex) {
            if (ExceptionUtils.getRootCauseMessage((Throwable)ex).indexOf("customfieldname_unique_constraint") > 0) {
                throw new DuplicateCustomFieldValueException("fail to create new custom field , customfield name has the duplicate content value.");
            }
            LOG.error("fail to create new custom field , picklist content has the duplicate content value.", (Throwable)ex);
            throw new DuplicateItemValueException("fail to create new custom field , picklist content has the duplicate content value.");
        }
        this.elasticSearchService.createCustomFieldMappingSetting(customFieldCreationVo, guid);
        MessageResponseResult response = new MessageResponseResult("Create new custom field succeeded.", guid);
        return response;
    }

    @ApiOperation(value="", notes="\u66f4\u65b0\u81ea\u8a02\u6b04\u4f4d\u7684\u5167\u5bb9")
    @ApiResponses(value={@ApiResponse(code=430, message="Picklist content cannot have the same value."), @ApiResponse(code=433, message="customfield name has the duplicate content value."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/update_custom_field"}, method={RequestMethod.POST})
    public MessageResponseResult update_custom_field(@RequestBody @Valid CustomFieldDto customFieldDto) {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        String companyGuid = currentLoginAccount.getCompanyGuid();
        CustomFieldDto sameNameCustomField = this.customFieldService.getCustomFieldByCustomFieldNameAndCompany(customFieldDto.getCustomFieldName(), companyGuid);
        LOG.info("sameNameCustomField={}, customFieldDto={}", (Object)sameNameCustomField, (Object)customFieldDto);
        if (sameNameCustomField != null && !sameNameCustomField.getGuid().equals(customFieldDto.getGuid())) {
            throw new DuplicateCustomFieldValueException("fail to create new custom field , customfield name has the duplicate content value.");
        }
        try {
            this.customFieldService.updateCustomField(customFieldDto);
        }
        catch (PersistenceException | DataIntegrityViolationException ex) {
            if (ExceptionUtils.getRootCauseMessage((Throwable)ex).indexOf("customfieldname_unique_constraint") > 0) {
                throw new DuplicateCustomFieldValueException("fail to create new custom field , customfield name has the duplicate content value.");
            }
            LOG.error("fail to update custom field , picklist content has the duplicate content value.", ex);
            throw new DuplicateItemValueException("fail to update custom field , picklist content has the duplicate content value.");
        }
        MessageResponseResult response = new MessageResponseResult("Update custom field succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u66f4\u65b0\u6574\u500b\u81ea\u8a02\u6b04\u4f4d\u6e05\u55ae\u7684\u6392\u5e8f\u9806\u5e8f, \u4f9d\u7167\u50b3\u5165\u7684list\u88e1\u9762item\u7684\u9806\u5e8f\u5132\u5b58\u5230\u8cc7\u6599\u5eab\u88e1\u9762\u4f86\u505a\u6392\u5e8f\u7684\u4f9d\u64da<br><br><b>\u6ce8\u610f\uff1a \u6b64api\u53ea\u6703\u66f4\u65b0\u50b3\u5165\u7684\u6e05\u55ae\u7167\u9806\u5e8f\u505aorder\u7684\u5132\u5b58\uff0c\u5982\u679c\u6709\u5c11\u50b3\u7684\u8cc7\u6599\u4e0d\u6703\u505a\u66f4\u65b0</b>")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/update_custom_fields_order"}, method={RequestMethod.POST})
    public MessageResponseResult update_custom_fields_order(@RequestBody @Valid ListRequestVo<String> customFieldGuids) {
        this.customFieldService.updateCustomFieldsOrder(customFieldGuids);
        MessageResponseResult response = new MessageResponseResult("Update custom field succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u522a\u9664\u4e00\u500b\u6307\u5b9a\u7684\u81ea\u8a02\u6b04\u4f4d")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/delete_custom_field"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult delete_custom_fieldContent(@RequestParam(required=true) String customFieldGuid) {
        this.customFieldService.deleteCustomField(customFieldGuid);
        MessageResponseResult response = new MessageResponseResult("Delete custom field succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/update_share_rule"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult update_share_rule(@RequestParam(required=true) ShareRule shareRule) {
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SHARE_RULE", currentLoginAccount.getCompanyGuid());
        if (globalinfocompany == null) {
            throw new ItemNotFoundException("No share rule setting found.");
        }
        this.companyGlobalInfoService.updatePropertyValue(globalinfocompany.getGuid(), shareRule.toString());
        String globalShareRuleChangeContent = GlobalUtils.getJsonString((Object)new GlobalShareRuleChangeContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), shareRule.toString()));
        this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.GLOBAL_SHARE_RULE_CHANGE, globalShareRuleChangeContent, null, currentLoginAccount.getCompanyGuid());
        MessageResponseResult response = new MessageResponseResult("Update share rule setting succeeded.", null);
        return response;
    }

    @RequestMapping(value={"/update_is_auto_lock_unactive"}, method={RequestMethod.POST})
    public MessageResponseResult updateIsAutoLockUnactive(@RequestParam boolean AutoLockUnactive) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.companyGlobalInfoService.createNewProperties(AUTO_LOCK_UNACTIVE, Boolean.toString(AutoLockUnactive), currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("get sucess", "success");
    }

    @RequestMapping(value={"/update_is_reject_locked_account_login"}, method={RequestMethod.POST})
    public MessageResponseResult updateIsRejectLockedAccountLogin(@RequestParam boolean rejectLockedAccountLogin) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.companyGlobalInfoService.createNewProperties("REJECT_LOCKED_ACCOUNT_LOGIN", Boolean.toString(rejectLockedAccountLogin), currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("get sucess", "success");
    }

    @RequestMapping(value={"/update_is_force_change_password"}, method={RequestMethod.POST})
    public MessageResponseResult UpdateIsForceChangePassword(@RequestParam boolean forceChangePassword) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.companyGlobalInfoService.createNewProperties(FORCE_CHANGE_PASSWORD, Boolean.toString(forceChangePassword), currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("get sucess", "success");
    }

    @RequestMapping(value={"/update_change_password_period"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=462, message="Update value is out of range")})
    public MessageResponseResult updateChangePasswordPeriod(@RequestParam String strChangePasswordPeriod) {
        int changePasswordPeriod = 0;
        try {
            changePasswordPeriod = Integer.valueOf(strChangePasswordPeriod);
        }
        catch (NumberFormatException ex) {
            throw new ValueOutofRangeException("input param is not number");
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (changePasswordPeriod > 365 || changePasswordPeriod < 30) {
            throw new ValueOutofRangeException("change password period is out of range");
        }
        this.companyGlobalInfoService.createNewProperties(CHANGE_PASSWORD_PERIOD, (long)changePasswordPeriod, currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("update sucess", "success");
    }

    @RequestMapping(value={"/update_autoLock_unactive_days"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=462, message="Update value is out of range")})
    public MessageResponseResult updateAutoLockUnactiveDays(@RequestParam String strAutoLockUnactiveDays) {
        int autoLockUnactiveDays = 0;
        try {
            autoLockUnactiveDays = Integer.valueOf(strAutoLockUnactiveDays);
        }
        catch (NumberFormatException ex) {
            throw new ValueOutofRangeException("input param is not number");
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (autoLockUnactiveDays > 100 || autoLockUnactiveDays < 3) {
            throw new ValueOutofRangeException("days of autolock unactive account is out of range");
        }
        this.companyGlobalInfoService.createNewProperties(AUTO_LOCK_UNACTIVE_DAYS, (long)autoLockUnactiveDays, currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("update sucess", "success");
    }

    @RequestMapping(value={"/update_login_failure_count_limit"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=462, message="Update value is out of range")})
    public MessageResponseResult updateLoginFailureCountLimit(@RequestParam String strLoginFailureCountLimit) {
        int loginFailureCountLimit = 0;
        try {
            loginFailureCountLimit = Integer.valueOf(strLoginFailureCountLimit);
        }
        catch (NumberFormatException ex) {
            throw new ValueOutofRangeException("input param is not number");
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (loginFailureCountLimit > 10 || loginFailureCountLimit < 3) {
            throw new ValueOutofRangeException("limit of login failures count is out of range");
        }
        this.companyGlobalInfoService.createNewProperties(LOGIN_FAILURE_COUNT_LIMIT, (long)loginFailureCountLimit, currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("update sucess", "success");
    }

    @RequestMapping(value={"/update_login_failure_block_Period"}, method={RequestMethod.POST})
    @ApiResponses(value={@ApiResponse(code=462, message="Update value is out of range")})
    public MessageResponseResult updateLoginFailureBlockPeriod(@RequestParam String strLoginFailureBlockPeriod) {
        int loginFailureBlockPeriod = 0;
        try {
            loginFailureBlockPeriod = Integer.valueOf(strLoginFailureBlockPeriod);
        }
        catch (NumberFormatException ex) {
            throw new ValueOutofRangeException("input param is not number");
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        if (loginFailureBlockPeriod > 60 || loginFailureBlockPeriod < 5) {
            throw new ValueOutofRangeException("period of login failure block is out of range");
        }
        this.companyGlobalInfoService.createNewProperties(LOGIN_FAILURE_BLOCK_PERIOD, (long)loginFailureBlockPeriod, currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("update sucess", "success");
    }

    @RequestMapping(value={"/update_login_failure_option"}, method={RequestMethod.POST})
    public MessageResponseResult updateLoginFailureOption(@RequestParam LoginFailureOption loginFailureOption) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.companyGlobalInfoService.createNewProperties(LOGIN_FAILURE_OPTION, loginFailureOption.toString(), currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("update sucess", "success");
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u7ba1\u7406\u8005\u7684\u5171\u4eab\u898f\u5247\u8a2d\u5b9a<BR> ALL - \u5168\u90e8\u5171\u4eab <BR> BY_SETTING - \u4f9d\u64da\u6b0a\u9650\u8207\u5206\u4eab\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_share_rule"}, method={RequestMethod.POST})
    public ShareRuleResponseResult get_share_rule() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        ShareRule shareRule = this.systemSettingService.getShareRule(currentLoginUser);
        ShareRuleResponseResult response = new ShareRuleResponseResult("Get share rule setting succeeded.", shareRule);
        return response;
    }

    @RequestMapping(value={"/set_SMTPSetting"}, method={RequestMethod.POST})
    public MessageResponseResult SetSMTPSetting(@RequestBody MailSettingInfo mailSettingInfo) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Gson gson = new Gson();
        LOG.debug("mailSettingInfo = {} BEFORE", (Object)mailSettingInfo);
        String json = gson.toJson((Object)mailSettingInfo);
        LOG.debug("mailSettingInfojson = {} after", (Object)json);
        this.companyGlobalInfoService.createNewProperties("SMTP_MAIL_SETTING", json, currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("set sucess", "success");
    }

    @RequestMapping(value={"/get_SMTPSetting"}, method={RequestMethod.GET})
    public MailSettingInfoResponseResult GetSMTPSetting() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany globalinfocompany = this.companyGlobalInfoService.getPropertiesByKey("SMTP_MAIL_SETTING", currentLoginUser.getCompanyGuid());
        String MailSetJson = "";
        MailSettingInfo MailSetting = new MailSettingInfo();
        if (globalinfocompany != null) {
            MailSetJson = globalinfocompany.getConfigValue();
        }
        try {
            if (!StringUtil.IsStringNullorEmpty((String)MailSetJson)) {
                LOG.debug("MailSetJson = {} BEFORE", (Object)MailSetJson);
                Gson gson = new Gson();
                MailSetting = (MailSettingInfo)gson.fromJson(MailSetJson, MailSettingInfo.class);
                MailSetting.setPassWord("");
                LOG.debug("MailSetting = {} AFTER", (Object)MailSetting);
            }
        }
        catch (Exception ee) {
            LOG.error("get mail load setting =" + ee.getMessage());
        }
        return new MailSettingInfoResponseResult("Get sucess", MailSetting);
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u76ee\u524d\u7cfb\u7d71\u8981\u4f7f\u7528\u7684CRM\u7cfb\u7d71\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_CRM_system"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult setCRMsystem(@RequestParam(required=true) SupportCRM supportCRM, @RequestParam(required=false) String customDomain) {
        if (StringUtils.isNotEmpty((CharSequence)customDomain) && SupportCRM.SALESFORCE.equals((Object)supportCRM)) {
            OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(SecurityUtils.getCurrentLoginUser().getCompanyGuid());
            this.salesforceAuthenticationManager.testDomain(customDomain, client);
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany newSystemCRMInfo = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CRM", currentLoginUser.getCompanyGuid());
        Globalinfocompany newCRMUrlInfo = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CRM_URL", currentLoginUser.getCompanyGuid());
        if (newSystemCRMInfo == null) {
            newSystemCRMInfo = this.companyGlobalInfoService.createNewProperties("SYSTEM_CRM", supportCRM.toString(), currentLoginUser.getCompanyGuid());
        } else {
            this.companyGlobalInfoService.updatePropertyValue(newSystemCRMInfo.getGuid(), supportCRM.toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)customDomain)) {
            if (newCRMUrlInfo == null) {
                newCRMUrlInfo = this.companyGlobalInfoService.createNewProperties("SYSTEM_CRM_URL", customDomain, currentLoginUser.getCompanyGuid());
            } else {
                this.companyGlobalInfoService.updatePropertyValue(newCRMUrlInfo.getGuid(), customDomain);
            }
        }
        try {
            AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
            String newSystemCRMSettingContent = GlobalUtils.getJsonString((Object)new SystemCrmSettingsChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), newSystemCRMInfo.getConfigValue()));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_CRM_SETTINGS_CHANGED, newSystemCRMSettingContent, null, currentLoginAccount.getCompanyGuid());
            List accountInfos = this.accountService.getAccountInfos(currentLoginUser.getCompanyGuid());
            List allAccountGuids = accountInfos.stream().map(accountInfo -> accountInfo.getGuid()).collect(Collectors.toList());
            this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.SYSTEM_CRM_SETTINGS_CHANGED, allAccountGuids);
        }
        catch (Exception ex) {
            LOG.warn("Fail to publish CRM settings changed notice event...", (Throwable)ex);
        }
        MessageResponseResult response = new MessageResponseResult("Set system CRM setting succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u8a2d\u5b9a\u76ee\u524d\u7cfb\u7d71\u8981\u4f7f\u7528\u7684\u516c\u53f8\u901a\u8a0a\u9304\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_contact_server"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult setContactServer(@RequestParam(required=true) SupportContactServer supportContactServer, @RequestParam(required=false) String serverUrl) throws IOException {
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer) && StringUtils.isEmpty((CharSequence)serverUrl)) {
            throw new RequestArgumentNotValidException("ServerUrl must be provided");
        }
        if (SupportContactServer.NONE.equals((Object)supportContactServer)) {
            throw new RequestArgumentNotValidException("SupportContactServer can't be NONE");
        }
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            this.contactServerAuthService.checkExchangeServiceUrl(serverUrl);
        }
        if (SupportContactServer.QCONTACTZ.equals((Object)supportContactServer)) {
            OkHttpClient client = this.companyGlobalInfoService.getOKHttpClientWithProxy(SecurityUtils.getCurrentLoginUser().getCompanyGuid());
            String version = this.contactServerAuthService.getQContactzAppVersion(client);
            LOG.info("currentVersion={}, supportedVersion={}", (Object)version, (Object)"1.5.351");
            if (GlobalUtils.compareVersions((String)version, (String)"1.5.351") < 0) {
                throw new HttpConnectionException(String.format("Current version: %s, please upgrade to at least %s", version, "1.5.351"));
            }
        }
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany newSystemContactServer = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CONTACT_SERVER", currentLoginAccount.getCompanyGuid());
        Globalinfocompany newSystemContactServerUrl = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CONTACT_SERVER_URL", currentLoginAccount.getCompanyGuid());
        if (newSystemContactServer == null) {
            newSystemContactServer = this.companyGlobalInfoService.createNewProperties("SYSTEM_CONTACT_SERVER", supportContactServer.toString(), currentLoginAccount.getCompanyGuid());
        } else {
            this.companyGlobalInfoService.updatePropertyValue(newSystemContactServer.getGuid(), supportContactServer.toString());
        }
        if (SupportContactServer.EXCHANGE.equals((Object)supportContactServer)) {
            if (newSystemContactServerUrl == null) {
                newSystemContactServerUrl = this.companyGlobalInfoService.createNewProperties("SYSTEM_CONTACT_SERVER_URL", serverUrl, currentLoginAccount.getCompanyGuid());
            } else {
                this.companyGlobalInfoService.updatePropertyValue(newSystemContactServerUrl.getGuid(), serverUrl);
            }
        }
        try {
            String newSystemContactServerSettingContent = GlobalUtils.getJsonString((Object)new SystemContactServerSettingsChangedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), newSystemContactServer.getConfigValue()));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_CONTACT_SERVER_SETTINGS_CHANGED, newSystemContactServerSettingContent, null, currentLoginAccount.getCompanyGuid());
            List accountInfos = this.accountService.getAccountInfos(currentLoginAccount.getCompanyGuid());
            List allAccountGuids = accountInfos.stream().map(accountInfo -> accountInfo.getGuid()).collect(Collectors.toList());
            this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.SYSTEM_CONTACT_SERVER_SETTINGS_CHANGED, allAccountGuids);
        }
        catch (Exception ex) {
            LOG.warn("Fail to publish Contact server settings changed notice event...", (Throwable)ex);
        }
        MessageResponseResult response = new MessageResponseResult("Set system contact server setting succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u76ee\u524d\u7cfb\u7d71\u4f7f\u7528\u7684CRM\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_CRM_system"}, method={RequestMethod.POST})
    public SupportCRMWithUrlResponseResult getCRMSystem() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        SupportCRM systemCRMSetting = this.systemSettingService.getSystemCRM(currentLoginUser);
        Globalinfocompany crmUrl = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CRM_URL", currentLoginUser.getCompanyGuid());
        boolean isCustomized = crmUrl != null;
        String url = crmUrl == null ? "login.salesforce.com" : crmUrl.getConfigValue();
        SupportCRMWithUrlResponseResult response = new SupportCRMWithUrlResponseResult("Get system CRM setting succeeded.", new SystemCRMDetail(systemCRMSetting, url, Boolean.valueOf(isCustomized)));
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u76ee\u524d\u7cfb\u7d71\u4f7f\u7528\u7684\u516c\u53f8\u901a\u8a0a\u9304\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_contact_server_system"}, method={RequestMethod.POST})
    public SystemContactServerResponseResult getContactServerSystem() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        SupportContactServer supportContactServer = this.systemSettingService.getSystemContactServer(currentLoginUser);
        Globalinfocompany contactServerUrl = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CONTACT_SERVER_URL", currentLoginUser.getCompanyGuid());
        String url = contactServerUrl == null ? "" : contactServerUrl.getConfigValue();
        SystemContactServerResponseResult response = new SystemContactServerResponseResult("Get system contact server setting succeeded.", new SystemContactServerDetail(supportContactServer, url));
        return response;
    }

    @ApiOperation(value="", notes="\u79fb\u5f9e\u76ee\u524d\u7cfb\u7d71\u7d81\u5b9a\u7684CRM\u8a2d\u5b9a\t")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/remove_CRM_system"}, method={RequestMethod.POST})
    public SupportCRMResponseResult removeCRMSystem() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        SupportCRM oldSystemCRMSetting = this.systemSettingService.getSystemCRM(currentLoginUser);
        this.systemSettingService.removeSystemCRM(currentLoginUser);
        try {
            AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
            String newSystemCRMSettingContent = GlobalUtils.getJsonString((Object)new SystemCrmSettingsRemovedContent(currentLoginAccount.getName(), currentLoginAccount.getGuid(), oldSystemCRMSetting.toString()));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_CRM_SETTINGS_REMOVED, newSystemCRMSettingContent, null, currentLoginAccount.getCompanyGuid());
        }
        catch (Exception ex) {
            LOG.warn("Fail to publish CRM settings removed notice event...", (Throwable)ex);
        }
        SupportCRMResponseResult response = new SupportCRMResponseResult("Remove system CRM setting succeeded.", null);
        return response;
    }

    @ApiOperation(value="", notes="\u79fb\u5f9e\u76ee\u524d\u7cfb\u7d71\u7d81\u5b9a\u7684\u516c\u53f8\u901a\u8a0a\u9304")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/remove_contact_server"}, method={RequestMethod.POST})
    public SupportCRMResponseResult removeContactServer() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        SupportContactServer oldContactServerSetting = this.systemSettingService.getSystemContactServer(currentLoginUser);
        this.systemSettingService.removeSystemContactServer(currentLoginUser);
        try {
            String removedContactServerSettingContent = GlobalUtils.getJsonString((Object)new SystemContactServerSettingsRemovedContent(currentLoginUser.getName(), currentLoginUser.getGuid(), oldContactServerSetting.toString()));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_CONTACT_SERVER_SETTINGS_REMOVED, removedContactServerSettingContent, null, currentLoginUser.getCompanyGuid());
        }
        catch (Exception ex) {
            LOG.warn("Fail to publish contact server settings removed notice event...", (Throwable)ex);
        }
        SupportCRMResponseResult response = new SupportCRMResponseResult("Remove system contact server setting succeeded.", null);
        return response;
    }

    private void ReStartTomcatService() {
    }

    @RequestMapping(value={"/upload_SSL"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4e0a\u50b3SSL\u6191\u8b49", notes="\u4e0a\u50b3SSL\u6191\u8b49\u5230SERVER \u4e26\u53d6\u5f97\u4e00\u500bGUID")
    @ApiResponses(value={@ApiResponse(code=403, message="Upload file failed.<BR>")})
    public MessageResponseResult UploadSSL(@RequestPart MultipartFile sslfile) {
        String uploadFileID = SSLUtil.UploadSSL((MultipartFile)sslfile);
        MessageResponseResult response = new MessageResponseResult("Upload file success", uploadFileID);
        return response;
    }

    private void SetServerNeedToRestart() {
        Globalinfo serverNeedToRestart = this.globalInfoService.getPropertiesByKey("SERVER_NEED_TO_RESTART");
        if (serverNeedToRestart == null) {
            this.globalInfoService.createNewProperties("SERVER_NEED_TO_RESTART", "true");
        } else {
            serverNeedToRestart.setConfigValue("true");
            this.globalInfoService.updatePropertyValue(serverNeedToRestart.getGuid(), "true");
        }
    }

    @RequestMapping(value={"/get_uploaded_SSL_detail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53d6\u5f97\u4e0a\u50b3\u7684SSL\u6191\u8b49\u8a73\u7d30\u8cc7\u8a0a", notes="\u4e0a\u50b3SSL\u6191\u8b49\u5230SERVER SSL\u6191\u8b49\u8a73\u7d30\u8cc7\u8a0a")
    @ApiResponses(value={@ApiResponse(code=404, message="\u627e\u4e0d\u5230\u4e0a\u50b3\u7684SSL File"), @ApiResponse(code=405, message="\u7121\u6cd5\u89e3\u6790\u76ee\u524d\u7684SSL File")})
    public SSLDetailInfoResponseResult GetUploadedSSLDetail(@RequestBody SSLInfo sslInfo) {
        SSLDetailInfo sslDetailInfo = SSLUtil.GetUploadedSSLDetail((SSLInfo)sslInfo);
        sslDetailInfo.setIsNeedToRestartWCT(false);
        SSLDetailInfoResponseResult resopone = new SSLDetailInfoResponseResult("Get SSLINFO  SUCCESS", sslDetailInfo);
        return resopone;
    }

    @RequestMapping(value={"/get_current_SSL_detail"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53d6\u5f97\u4e0a\u50b3\u7684SSL\u6191\u8b49\u8a73\u7d30\u8cc7\u8a0a", notes="\u4e0a\u50b3SSL\u6191\u8b49\u5230SERVER SSL\u6191\u8b49\u8a73\u7d30\u8cc7\u8a0a")
    @ApiResponses(value={@ApiResponse(code=404, message="\u7121\u6cd5\u53d6\u5f97tomcat \u8a2d\u5b9a\u7684SSL File \u4f4d\u7f6e"), @ApiResponse(code=405, message="\u7121\u6cd5\u89e3\u6790\u76ee\u524d\u7684SSL File")})
    public SSLDetailInfoResponseResult GetUploadedSSLDetail() {
        SSLDetailInfo sslDetailInfo = SSLUtil.GetCurrentSSLFileDetail();
        SSLDetailInfoResponseResult resopone = new SSLDetailInfoResponseResult("Get SSLINFO  SUCCESS", sslDetailInfo);
        return resopone;
    }

    @RequestMapping(value={"/replace_SSL"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7f6e\u63dbSSL\u6191\u8b49", notes="\u4f7f\u7528\u4e0a\u50b3\u7684SSL\u6191\u8b49GUID \u53ca\u5bc6\u78bc\u7f6e\u63dbSSL\u6191\u8b49\u4e26\u91cd\u555f Service")
    @ApiResponses(value={@ApiResponse(code=404, message="\u627e\u4e0d\u5230\u4e0a\u50b3\u7684SSL File"), @ApiResponse(code=406, message="\u4e0a\u50b3\u7684SSL \u6a94\u6848\u4e0d\u5408\u6cd5"), @ApiResponse(code=405, message="\u7121\u6cd5\u66f4\u65b0Tomcat\u7684\u8a2d\u5b9a"), @ApiResponse(code=423, message="\u7121\u6cd5\u91cd\u555f\u4f3a\u670d\u5668")})
    public MessageResponseResult ReplaceSSL(@RequestBody SSLInfo sslInfo) {
        LOG.debug("ReplaceSSL password={}", (Object)sslInfo.getPassWord());
        SSLUtil.ReplaceSSL((SSLInfo)sslInfo);
        this.SetServerNeedToRestart();
        this.ReStartTomcatService();
        MessageResponseResult response = new MessageResponseResult("Replace SSL File success", "");
        return response;
    }

    @RequestMapping(value={"/reset_default_SSL"}, method={RequestMethod.POST})
    @ApiOperation(value="\u7f6e\u63dbSSL\u6191\u8b49", notes="\u4f7f\u7528\u4e0a\u50b3\u7684SSL\u6191\u8b49GUID \u53ca\u5bc6\u78bc\u7f6e\u63dbSSL\u6191\u8b49\u4e26\u91cd\u555f Service")
    @ApiResponses(value={@ApiResponse(code=405, message="\u7121\u6cd5\u66f4\u65b0Tomcat\u7684\u8a2d\u5b9a"), @ApiResponse(code=423, message="\u7121\u6cd5\u91cd\u555f\u4f3a\u670d\u5668")})
    public MessageResponseResult ResetDefaultSSL() {
        SSLUtil.ResetDefaultSSL();
        this.SetServerNeedToRestart();
        this.ReStartTomcatService();
        MessageResponseResult response = new MessageResponseResult("ResetDefaultSSL success", "");
        return response;
    }

    @RequestMapping(value={"/purchase_license"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u5bc4\u9001\u52a0\u8cfc\u6388\u6b0a\u7684\u4fe1\u4ef6")
    @ApiResponses(value={@ApiResponse(code=435, message="Fail to send mail."), @ApiResponse(code=436, message="Fail to connection to SMPT server."), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult purchaseLicense(@RequestBody @Valid PurchaseLiceneseInfo purchaseLiceneseInfo) {
        try {
            PurchaseLicensedMailInfoBuilder mailInfoBuilder = new PurchaseLicensedMailInfoBuilder(purchaseLiceneseInfo.getSenderName(), purchaseLiceneseInfo.getSenderMail(), purchaseLiceneseInfo.getSenderPhone(), purchaseLiceneseInfo.getSenderRequirement(), purchaseLiceneseInfo.getLanguageCode());
            MailInfo purchaseLicenseMailInfo = mailInfoBuilder.createMailInfo();
            LOG.debug("Check mail info : \n {}", (Object)purchaseLicenseMailInfo);
            GlobalUtils.sendMail((String)purchaseLiceneseInfo.getReceiverMail(), (String)purchaseLicenseMailInfo.getMailSubject(), (String)purchaseLicenseMailInfo.getStringMailBody(), (String)"text/html;charset=utf-8", (String)"");
        }
        catch (Exception ex) {
            LOG.error("Fail to send mail ={} ", (Throwable)ex);
            throw new MailSendException(ex.getMessage(), (Throwable)ex);
        }
        MessageResponseResult result = new MessageResponseResult(String.format("The purchase licnese requirement mail has been send to %s.", purchaseLiceneseInfo.getReceiverMail()), "");
        return result;
    }

    @RequestMapping(value={"/SetProperty"}, method={RequestMethod.POST})
    @ApiOperation(value="Set Property", notes="Set system property")
    public BooleanResponseResult SetProperty(@RequestParam SystemProperty systemProperty, @RequestParam String valueString) {
        String responString = "";
        BooleanResponseResult response = null;
        if (systemProperty == SystemProperty.MAX_CONTACT_COUNT_IN_PRIVATE) {
            try {
                int nValue = Integer.parseUnsignedInt(valueString);
                LOG.debug("SetProperty VALUE={}", (Object)nValue);
                if (nValue <= 100000 && nValue >= 5000) {
                    LOG.debug("SetProperty IN");
                    Globalinfo maxContactCount = this.globalInfoService.getPropertiesByKey("MAX_CONTACT_COUNT_IN_PRIVATE");
                    LOG.debug("SetProperty IN maxContactCount={}", (Object)maxContactCount);
                    if (maxContactCount != null) {
                        maxContactCount.setConfigValue(Integer.toString(nValue));
                        LOG.debug("SetProperty IN VALUE ={}", (Object)Integer.toString(nValue));
                        this.globalInfoService.updatePropertyValue(maxContactCount.getGuid(), valueString);
                        LOG.debug("SetProperty IN VALUE ={}", (Object)valueString);
                        response = new BooleanResponseResult("set property success", Boolean.valueOf(true));
                    }
                }
            }
            catch (Exception e) {
                response = new BooleanResponseResult("set property false error= " + e.toString(), Boolean.valueOf(false));
            }
        }
        if (response == null) {
            response = new BooleanResponseResult("set property false no such key", Boolean.valueOf(false));
        }
        return response;
    }

    @RequestMapping(value={"/create_ip_allowed_info"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u5efa\u7acbIP\u5141\u8a31\u8cc7\u8a0a\uff0cipConstraintType<BR>BY_RANGE - \u8a2d\u5b9aIP\u5340\u6bb5<BR>BY_SPECIFIC - \u8a2d\u5b9a\u55ae\u4e00IP\u4f4d\u5740(ipEnd\u4e0d\u53ef\u6709\u503c)")
    @ApiResponses(value={@ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=460, message="Item already exists.<BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult createIpAllowedInfo(@RequestBody @Valid IpAllowedInfoCreationVo creationVo) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.ipConstraintService.verifyIpAllowedInfoVo(creationVo, currentLoginUser.getCompanyGuid());
        String guid = this.ipConstraintService.createIpAllowedInfo(creationVo, currentLoginUser.getCompanyGuid());
        MessageResponseResult response = new MessageResponseResult(String.format("IpAllowed information [guid=%s]has been created", guid), "");
        return response;
    }

    @RequestMapping(value={"/get_ip_allowed_infos"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u53d6\u5f97\u6240\u6709\u7684IP\u5141\u8a31\u8cc7\u8a0a")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public ListResponseResult<IpAllowedInfoDto> getIpAllowedInfos() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List ipAllowedInfosDto = this.ipConstraintService.getIpAllowedInfos(currentLoginUser.getCompanyGuid());
        ListResponseResult response = new ListResponseResult("Get all ipAllowed informations succeeded.", ipAllowedInfosDto);
        return response;
    }

    @RequestMapping(value={"/get_ip_allowed_info"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="", notes="\u53d6\u5f97\u6307\u5b9a\u7684IP\u5141\u8a31\u8cc7\u8a0a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public BasicResponseResult<IpAllowedInfoDto, Object> getIpAllowedInfo(@RequestParam(required=true) String guid) {
        this.ipConstraintService.verifyIpAllowedInfoExist(guid);
        IpAllowedInfoDto ipAllowedInfoDto = this.ipConstraintService.getIpAllowedInfo(guid);
        BasicResponseResult response = new BasicResponseResult(String.format("Get ipAllowed information by guid[%s] succeeded.", guid), (Object)ipAllowedInfoDto);
        return response;
    }

    @RequestMapping(value={"/update_ip_allowed_info"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u66f4\u65b0IP\u5141\u8a31\u8cc7\u8a0a\uff0cipConstraintType<BR>BY_RANGE - \u8a2d\u5b9aIP\u5340\u6bb5<BR>BY_SPECIFIC - \u8a2d\u5b9a\u55ae\u4e00IP\u4f4d\u5740(ipEnd\u4e0d\u53ef\u6709\u503c)")
    @ApiResponses(value={@ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=460, message="Item already exists.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult updateIpAllowedInfo(@RequestBody @Valid IpAllowedInfoUpdateVo updateVo) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.ipConstraintService.verifyIpAllowedInfoExist(updateVo.getGuid());
        this.ipConstraintService.verifyIpAllowedInfoVo((IpAllowedInfoCreationVo)updateVo, currentLoginUser.getCompanyGuid());
        this.ipConstraintService.updateIpAllowedInfo(updateVo);
        MessageResponseResult response = new MessageResponseResult(String.format("IpAllowed information [guid=%s]has been updated", updateVo.getGuid()), "");
        return response;
    }

    @RequestMapping(value={"/delete_ip_allowed_info"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="", notes="\u522a\u9664\u4e00\u500bIP\u5141\u8a31\u8cc7\u8a0a")
    @ApiResponses(value={@ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult deleteIpAllowedInfo(@RequestParam(required=true) String guid) {
        this.ipConstraintService.verifyIpAllowedInfoExist(guid);
        this.ipConstraintService.deleteIpAllowedInfo(guid);
        MessageResponseResult response = new MessageResponseResult(String.format("IpAllowed information [guid=%s]has been deleted", guid), "");
        return response;
    }

    @RequestMapping(value={"/get_ip_need_to_constraint"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u53d6\u5f97IP\u662f\u5426\u9700\u8981\u53d7\u5230\u9650\u5236\u7684\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public BooleanResponseResult getIpNeedToConstraint() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        boolean ipNeedToConstraint = this.ipConstraintService.getIpNeedToConstraint(currentLoginUser.getCompanyGuid());
        BooleanResponseResult response = new BooleanResponseResult("Get ip need to constraint setting succeed", Boolean.valueOf(ipNeedToConstraint));
        return response;
    }

    @RequestMapping(value={"/update_ip_need_to_constraint"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="", notes="\u958b\u555f\u6216\u95dc\u9589IP\u662f\u5426\u9700\u8981\u53d7\u5230\u9650\u5236\u7684\u8a2d\u5b9a")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult updateIpNeedToConstraint(@RequestParam(required=true) boolean ipNeedToConstraint) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany ipConstraintType = this.companyGlobalInfoService.getPropertiesByKey("IP_NEED_TO_CONSTRAINT", currentLoginUser.getCompanyGuid());
        if (ipConstraintType == null) {
            ipConstraintType = this.companyGlobalInfoService.createNewProperties("IP_NEED_TO_CONSTRAINT", "false", currentLoginUser.getCompanyGuid());
        }
        this.companyGlobalInfoService.updatePropertyValue(ipConstraintType.getGuid(), String.valueOf(ipNeedToConstraint));
        MessageResponseResult response = new MessageResponseResult("Update ip need to constraint setting succeed", "");
        return response;
    }

    @RequestMapping(value={"/is_ip_fit_rule"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ApiOperation(value="", notes="\u6aa2\u67e5request ip\u662f\u5426\u8207server\u70ba\u540c\u4e00\u5340\u7db2\u6216\u5728\u5916\u90e8IP\u4f8b\u5916\u6e05\u55ae\u5167")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public BooleanResponseResult isRequestIpInServerLan(HttpServletRequest request) {
        String remoteIp = NetworkUtil.getClientIp((HttpServletRequest)request);
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        LOG.debug("remoteIp:{}", (Object)remoteIp);
        boolean isRequestIpInServerLan = this.ipConstraintService.isIpValid(remoteIp, currentLoginUser.getCompanyGuid());
        BooleanResponseResult response = new BooleanResponseResult("Get is request ip fit rule", Boolean.valueOf(isRequestIpInServerLan));
        return response;
    }

    @RequestMapping(value={"/set_company_domain"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u8a2d\u5b9acompany\u7db2\u57df")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult setCompanyDomain(@RequestBody @Valid CompanyDomainVo companyDomainVo) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany companyDomainInfo = this.companyGlobalInfoService.getPropertiesByKey("COMPANY_DOMAIN_INFO", currentLoginUser.getCompanyGuid());
        String companyDomainValue = GlobalUtils.getJsonStringWithDateTimeSerializer((Object)companyDomainVo);
        if (companyDomainInfo == null) {
            this.companyGlobalInfoService.createNewProperties("COMPANY_DOMAIN_INFO", companyDomainValue, currentLoginUser.getCompanyGuid());
        } else {
            this.companyGlobalInfoService.updatePropertyValue(companyDomainInfo.getGuid(), companyDomainValue);
        }
        String systemDomainChangedContent = GlobalUtils.getJsonString((Object)new SystemDomainChangedContent(currentLoginUser.getName(), currentLoginUser.getGuid()));
        this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_DOMAIN_CHANGED, systemDomainChangedContent, null, currentLoginUser.getCompanyGuid());
        return new MessageResponseResult("Set company domain success", "");
    }

    @RequestMapping(value={"/remove_company_domain"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u79fb\u9664company\u7db2\u57df")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public MessageResponseResult removeCompanyDomain() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany companyDomainInfo = this.companyGlobalInfoService.getPropertiesByKey("COMPANY_DOMAIN_INFO", currentLoginUser.getCompanyGuid());
        if (companyDomainInfo != null) {
            this.companyGlobalInfoService.deleteProperty(companyDomainInfo.getGuid());
            String systemDomainChangedContent = GlobalUtils.getJsonString((Object)new SystemDomainChangedContent(currentLoginUser.getName(), currentLoginUser.getGuid()));
            this.noticeService.addNewNoticeToAllUsers(NotifyCategory.SYSTEM, NotifyType.SYSTEM_DOMAIN_REMOVED, systemDomainChangedContent, null, currentLoginUser.getCompanyGuid());
        }
        return new MessageResponseResult("Remove company domain success", "");
    }

    @RequestMapping(value={"/get_company_domain"}, method={RequestMethod.POST})
    @ApiOperation(value="", notes="\u53d6\u5f97company\u7db2\u57df")
    @ApiResponses(value={@ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>")})
    public CompanyDomainResponseResult GetCompanyDomain() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany companyDomainInfo = this.companyGlobalInfoService.getPropertiesByKey("COMPANY_DOMAIN_INFO", currentLoginUser.getCompanyGuid());
        if (companyDomainInfo == null) {
            throw new ItemNotFoundException("Company domain not found");
        }
        String companyDomainJsonValue = companyDomainInfo.getConfigValue();
        CompanyDomainVo companyDomain = (CompanyDomainVo)GlobalUtils.getObjectFromJsonWithDateTimeSerializer((String)companyDomainJsonValue, CompanyDomainVo.class);
        CompanyDomainResponseResult response = new CompanyDomainResponseResult("Get company domain success", companyDomain);
        return response;
    }

    @ApiOperation(value="get server id", notes="Get wct server id")
    @ApiResponses(value={@ApiResponse(code=404, message="Can't connect to register server. <BR>")})
    @RequestMapping(value={"/get_server_id"}, method={RequestMethod.GET})
    public MessageResponseResult getServerId() {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        Globalinfocompany serverIdProperty = this.companyGlobalInfoService.getPropertiesByKey("SERVER_ID", accountInfo.getCompanyGuid());
        return new MessageResponseResult("Get server Id success", serverIdProperty.getConfigValue());
    }
}

