/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.web.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.AccountSecurityInfo;
import com.penpower.worldcard.team.dto.DeviceInfoLess;
import com.penpower.worldcard.team.dto.ResignedAcountInfo;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.InheritMode;
import com.penpower.worldcard.team.enums.PlatformForDevice;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.AccountAlreadyExistsException;
import com.penpower.worldcard.team.exception.AccountResignedAndExistsException;
import com.penpower.worldcard.team.exception.AssignInheritorFailedException;
import com.penpower.worldcard.team.exception.DeleteAccountException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.LicenseCountMaxExceededException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.exception.ScheduleStartException;
import com.penpower.worldcard.team.exception.SystemIoException;
import com.penpower.worldcard.team.exception.UploadFileException;
import com.penpower.worldcard.team.exception.UserNameConflictException;
import com.penpower.worldcard.team.files.PathManager;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.AssignAccountInheritorJob;
import com.penpower.worldcard.team.service.AccountSecurityService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.MultiLayerCategoryService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SessionService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.web.api.vo.AccountCreationVo;
import com.penpower.worldcard.team.web.api.vo.AccountUpdateVo;
import com.penpower.worldcard.team.web.api.vo.ListRequestVo;
import com.penpower.worldcard.team.web.api.vo.SubRespone;
import com.penpower.worldcard.team.web.api.vo.response.AccountInfoResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.ListResponseResult;
import com.penpower.worldcard.team.web.api.vo.response.MessageResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import javax.validation.Valid;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.validator.internal.constraintvalidators.hv.EmailValidator;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin
@RequestMapping(value={"/api/admin/account"}, produces={"application/json;charset=UTF-8"})
@Api(tags={"admin_account"}, description="Admin account operation")
@PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
public class AdminAccountController {
    private static final Logger LOG = LoggerFactory.getLogger(AdminAccountController.class);
    private static final String DISPATCH_SERVER_CHECK_ACCOUNT_EXIST_URL = "account_exist";
    @Autowired
    private AccountService accountService;
    @Autowired
    private PathManager temporaryPathManager;
    @Autowired
    private PathManager accountPathManager;
    @Autowired
    private SessionService sessionService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private AccountSecurityService accountSecurityService;
    @Autowired
    private MultiLayerCategoryService multiLayerCategoryService;

    @ApiOperation(value="getBoss", notes="Get account boss.")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_boss"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public AccountInfoResponseResult getBoss(@RequestParam(required=true) String guid) {
        this.accountService.verifyAccount(guid, null);
        AccountInfo accountInfo = this.accountService.getBoss(guid);
        AccountInfoResponseResult response = new AccountInfoResponseResult(String.format("Get boss account information by guid[%s] succeeded.", guid), accountInfo);
        return response;
    }

    @ApiOperation(value="getSubordinates.", notes="Get account all subordinates.")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_subordinates"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<AccountInfo> getSubordinates(@RequestParam(required=true) String guid) {
        this.accountService.verifyAccount(guid, null);
        List subordinates = this.accountService.getSubordinates(guid);
        ListResponseResult response = new ListResponseResult("Get account all subordinates succeeded.", subordinates);
        return response;
    }

    @ApiOperation(value="uploadLogoImage", notes="\u4e0a\u50b3Account logo\u5716\u7247, \u6a94\u6848\u4e0a\u50b3\u5f8c\u6703\u5f97\u5230\u4e00\u500b\u66ab\u6642\u7684guid, <BR>\u6b64guid\u7528\u65bccreate\u548cupdate account")
    @ApiResponses(value={@ApiResponse(code=403, message="Upload file failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/upload_logo"}, method={RequestMethod.POST})
    public MessageResponseResult uploadLogo(@RequestPart(value="logoFile", required=true) MultipartFile logoFile) {
        LOG.debug("Logo fileName {}", (Object)logoFile.getName());
        LOG.debug("Logo size {}", (Object)logoFile.getSize());
        LOG.debug("Logo content-type {}", (Object)logoFile.getContentType());
        String currentToken = SecurityUtils.getCurrentLoginUserToken().getToken();
        String temporaryFileGuid = UUIDGenerator.getRandomUUID();
        String fileName = logoFile.getOriginalFilename();
        Path temporaryLogo = this.temporaryPathManager.createNewOne(currentToken, fileName, true);
        LOG.debug("check new temporaryLogo : {} ", (Object)temporaryLogo);
        try {
            Files.createDirectories(temporaryLogo.getParent(), new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(temporaryLogo, StandardOpenOption.CREATE);
                 InputStream is = logoFile.getInputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
        }
        catch (IOException e) {
            LOG.error("Fail to save temporary file.....", (Throwable)e);
            throw new UploadFileException("Upload file failed, reason : " + e.getMessage());
        }
        String relativePath = this.temporaryPathManager.getRelativePath(temporaryLogo);
        this.sessionService.createSession(currentToken, temporaryFileGuid, relativePath);
        MessageResponseResult response = new MessageResponseResult("Logo file upload succeeded. got temproary file guid.", temporaryFileGuid);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_logo"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getAccountLogo(@RequestParam(required=true) String accountGuid) {
        ResponseEntity responseEnty;
        this.accountService.verifyAccount(accountGuid, null);
        String accountLogoRelativePath = this.accountService.getAccountLogoRelativePath(accountGuid);
        Path accountLogo = this.accountPathManager.getFullyPath(accountLogoRelativePath);
        try (InputStream is = Files.newInputStream(accountLogo, new OpenOption[0]);){
            long fileSize = Files.size(accountLogo);
            String contentType = GlobalUtils.getFileContent((Path)accountLogo);
            MediaType mediaType = MediaType.parseMediaType((String)contentType);
            byte[] imageBytes = IOUtils.toByteArray((InputStream)is);
            responseEnty = ResponseEntity.ok().contentLength(fileSize).contentType(mediaType).body((Object)imageBytes);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file....", (Throwable)e);
        }
        return responseEnty;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_logo_base64"}, method={RequestMethod.GET})
    public MessageResponseResult getAccountLogoBase64(@RequestParam(required=true) String accountGuid) {
        this.accountService.verifyAccount(accountGuid, null);
        String accountLogoRelativePath = this.accountService.getAccountLogoRelativePath(accountGuid);
        Path accountLogo = this.accountPathManager.getFullyPath(accountLogoRelativePath);
        String imageBase64String = "";
        try (InputStream is = Files.newInputStream(accountLogo, new OpenOption[0]);){
            byte[] imageBytes = IOUtils.toByteArray((InputStream)is);
            imageBase64String = Base64.encodeBase64String((byte[])imageBytes);
        }
        catch (IOException e) {
            throw new SystemIoException("Fail to load image file....", (Throwable)e);
        }
        MessageResponseResult response = new MessageResponseResult("Get base64 string of account logo image succeeded.", imageBase64String);
        return response;
    }

    @ApiOperation(value="getAccount", notes="\u4f7f\u7528\u7279\u5b9a\u7684Account guid\u641c\u5c0bAccount. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public AccountInfoResponseResult getAccount(@RequestParam(required=true) String guid) {
        this.accountService.verifyAccount(guid, null);
        AccountInfo accountInfo = this.accountService.getAccountInfo(guid, null);
        AccountInfoResponseResult response = new AccountInfoResponseResult(String.format("Search account by guid[%s] succeeded.", guid), accountInfo);
        return response;
    }

    @ApiOperation(value="", notes="\u4f7f\u7528\u6307\u5b9aaccoung guid\u53d6\u5f97\u8a72\u5e33\u865f\u6240\u6709AccountSecurityInfo\uff0c\u6bcf\u500b\u5e33\u865f\u90fd\u6709\u4e94\u500b\u5e73\u53f0(IOS,ANDROID,WINDOWS,MAC,WEB)\u7684Security info")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=422, message="Request required parameters not valid. <BR>"), @ApiResponse(code=401, message="Authentication failed.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_account_security_infos"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<AccountSecurityInfo> getAccountSecurityInfos(@RequestParam(required=true) String guid) {
        this.accountService.verifyAccount(guid, null);
        List accountSecurityInfos = this.accountSecurityService.getAccountSecurityInfos(guid);
        ListResponseResult response = new ListResponseResult(String.format("Search accountSecurityInfo list by guid[%s] succeeded.", guid), accountSecurityInfos);
        return response;
    }

    @ApiOperation(value="getAllAccounts", notes="\u53d6\u5f97\u6240\u6709\u7684Account\u6e05\u55ae. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @ApiResponses(value={@ApiResponse(code=401, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<AccountInfo> getAccounts() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List accountInfos = this.accountService.getAccountInfos(currentLoginUser.getCompanyGuid());
        ListResponseResult response = new ListResponseResult("Get all accounts succeeded.", accountInfos);
        return response;
    }

    @ApiOperation(value="getAllAccountsByType", notes="\u53d6\u5f97\u6240\u6709\u6307\u5b9a\u7684AccountTYpe\u7684Account\u6e05\u55ae. <BR><BR>USER ROLE\u5fc5\u9700\u70baADMIN")
    @ApiResponses(value={@ApiResponse(code=401, message="You don't have permission to access this request.<BR>")})
    @PostMapping(value={"/get_accounts_by_type"}, consumes={"application/x-www-form-urlencoded"})
    public ListResponseResult<AccountInfo> getAccountsByType(@RequestParam(required=true) AccountType accountType) {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List accountInfos = this.accountService.getAccountInfosByType(currentLoginUser.getCompanyGuid(), accountType);
        ListResponseResult response = new ListResponseResult("Get all accounts by type succeeded.", accountInfos);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_active_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<AccountInfo> getActiveAccounts() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List activeAccounts = this.accountService.getAccountsByStatus(currentLoginUser.getCompanyGuid(), new UserStatus[]{UserStatus.ACTIVE});
        ListResponseResult response = new ListResponseResult("Get all active accounts succeeded.", activeAccounts);
        return response;
    }

    @ApiOperation(value="setAccountStatusToResigned", notes="Set account status to RESIGNED.")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=406, message="Account status is RESIGNED or INACTIVE cannot change to RESIGNED.<BR>")})
    @RequestMapping(value={"/set_account_status_to_resigned"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult setAccountStatusToResigned(@RequestParam(required=true) String accountGuid) {
        this.accountService.verifyAccount(accountGuid, null);
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.accountService.setAccountStatusToResigned(accountGuid, currentLoginUser.getCompanyGuid());
        MessageResponseResult response = new MessageResponseResult("Set accounts status to RESIGNED succeeded.", null);
        return response;
    }

    private boolean incorrectActiveAccountsSize(List<String> activeAccounts) {
        return activeAccounts == null || activeAccounts.size() >= 1;
    }

    @ApiOperation(value="setAccountsStatusToResigned", notes="Set account list status to RESIGNED .<BR>  account guid list will be put in the response data , if the acouunt stats failed to change to RESIGNED. (e.g RESIGNED or INACTIVE)")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/set_accounts_status_to_resigned"}, method={RequestMethod.POST})
    public ListResponseResult<String> setAccountsStatusToResigned(@RequestBody(required=true) ListRequestVo<String> accountGuids) {
        List accountsGuidToResigned = accountGuids.getList();
        ArrayList<String> updateFailedAccountsGuid = new ArrayList<String>();
        for (String accountGuidToResigned : accountsGuidToResigned) {
            try {
                AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
                this.accountService.setAccountStatusToResigned(accountGuidToResigned, currentLoginUser.getCompanyGuid());
            }
            catch (Exception ex) {
                updateFailedAccountsGuid.add(accountGuidToResigned);
            }
        }
        ListResponseResult response = new ListResponseResult("Set all accounts status to RESIGNED succeeded.", updateFailedAccountsGuid);
        return response;
    }

    @ApiOperation(value="getResignedAccounts", notes="\u53d6\u5f97\u6240\u6709\u5df2\u96e2\u8077\u7684\u5e33\u865f,account\u72c0\u614b\u70baRESIGNED.")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_resigned_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<ResignedAcountInfo> getResignedAccounts() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List nonInheritAccounts = this.accountService.getResignedAccounts(false, currentLoginUser.getCompanyGuid());
        List inheritAccounts = this.accountService.getResignedAccounts(true, currentLoginUser.getCompanyGuid());
        ArrayList resignedAccounts = new ArrayList();
        resignedAccounts.addAll(inheritAccounts);
        resignedAccounts.addAll(nonInheritAccounts);
        ListResponseResult response = new ListResponseResult("Get all accounts succeeded.(Status = RESIGNED)", resignedAccounts);
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_non_inherited_and_resigned_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<ResignedAcountInfo> getNonInheritedAndResignedAccounts() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List accountInfos = this.accountService.getResignedAccounts(false, currentLoginUser.getCompanyGuid());
        ListResponseResult response = new ListResponseResult("Get all accounts which status are RESIGNED.(no account inherited.)", accountInfos);
        return response;
    }

    @ApiOperation(value="", notes="\u53d6\u5f97\u6240\u6709UserStatus\u70baRESIGNED,\u4e26\u4e14\u7e7c\u627f\u72c0\u614b\u70baRESIGNED, RESIGNING \u7684\u5e33\u865f")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_inherited_and_resigned_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<ResignedAcountInfo> getInheritedAndResignedAccounts() {
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        List accountInfos = this.accountService.getResignedAccounts(true, currentLoginUser.getCompanyGuid());
        ListResponseResult response = new ListResponseResult("Get all accounts which status are RESIGNED.(have account inherited.)", accountInfos);
        return response;
    }

    @ApiOperation(value="createNewAccount", notes="\u5efa\u7acb\u65b0\u7684Account. <BR> Response\u7684json\u88e1\u9762\u7684data\u6703\u5305\u542b\u65b0\u5efa\u7acb\u7684account guid. <BR><BR> \u9810\u8a2d\u7684\u5e33\u865f\u5bc6\u78bc\u70ba <B></B> <BR> \u65b0\u5efa\u7684account\u72c0\u614b\u70ba<B>INACTIVE</B><BR> \u65b0\u5efa\u7684account\u5fc5\u9700\u8abf\u7528/change_password \u7684api \u9032\u884c\u5bc6\u78bc\u8b8a\u66f4\u5f8c\u8f49\u70ba ACTIVE \u624d\u53ef\u4f7f\u7528account\u76f8\u95dc\u7684API<BR> logoTmpGuid\u8acb\u4f7f\u7528/api/account/upload_logo \u7684api \u4f86\u53d6\u5f97.<BR><BR>accountSecurityInfos\u53ef\u4ee5\u70ba\u7a7a(\u7b2c\u4e00\u7b46\u5e33\u865f\u5efa\u7acb\u7684\u60c5\u6cc1)\uff0c\u6703\u4f7f\u7528\u9810\u8a2d\u503c\u8a2d\u5b9a<BR>accountSecurityInfos List\u7684\u9577\u5ea6\u5fc5\u9808\u70ba5.<BR>\u4e14platform\u5fc5\u9808\u5206\u5225\u70baIOS, ANDROID, WINDOWS, MAC, WEB(\u4e0d\u5f97\u7f3a\u5c11\u6216\u91cd\u8907).<BR>")
    @ApiResponses(value={@ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=441, message="Account already exists and status is RESIGNED."), @ApiResponse(code=415, message="user name already in use."), @ApiResponse(code=426, message="License count is 0 or max count of account exceeded."), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=460, message="Account already exists.<BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/create_account"}, method={RequestMethod.POST})
    public MessageResponseResult createAccount(@RequestBody @Valid AccountCreationVo accountCreationVo) {
        LOG.debug("accountCreationVo : {} ", (Object)accountCreationVo);
        EmailValidator validator = new EmailValidator();
        AccountType accountType = accountCreationVo.getAccountType();
        if (AccountType.LOCAL.equals((Object)accountType)) {
            boolean emailValid = validator.isValid((CharSequence)accountCreationVo.getEmail(), null);
            if (!emailValid) {
                throw new RequestArgumentNotValidException("Account mail is not a well-formed email address");
            }
        } else {
            boolean adAccountMailValid = validator.isValid((CharSequence)accountCreationVo.getAdAccountMail(), null);
            if (!adAccountMailValid) {
                throw new RequestArgumentNotValidException("Active directory account mail is not a well-formed email address");
            }
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        int count = this.systemSettingService.getLicenseCount(currentLoginUser.getCompanyGuid(), true);
        LOG.debug("create_account getLicenseCount: {} ", (Object)count);
        if (count <= 0) {
            LOG.debug("LicenseCountMaxExceededException{} ", (Object)count);
            throw new LicenseCountMaxExceededException("License count is 0 or max count of account exceeded.");
        }
        long currentAccountCount = this.accountService.getAccountCount(currentLoginUser.getCompanyGuid());
        if (currentAccountCount >= (long)count) {
            throw new LicenseCountMaxExceededException(String.format("Max account count limit exceeded. (limit=%d , current=%d) ", count, currentAccountCount));
        }
        AccountInfo account = null;
        try {
            account = this.accountService.getAccountInfo(null, accountCreationVo.getEmail());
            LOG.debug("account : {} ", (Object)account);
            if (account != null) {
                if (UserStatus.RESIGNED.equals((Object)account.getStatus())) {
                    throw new AccountResignedAndExistsException("Can't create a new account , Account[%s] already exists and status is RESIGNED.");
                }
                String errorFormatString = String.format("Can't create a new account , Account[%s] already exists.", accountCreationVo.getEmail());
                LOG.error(errorFormatString);
                throw new AccountAlreadyExistsException(errorFormatString);
            }
        }
        catch (ItemNotFoundException ex) {
            LOG.debug("No account found , can be created.");
        }
        LOG.debug("accountType : {}", (Object)accountCreationVo.getAccountType());
        if (this.CheckAccountInOtherWCTServer(accountCreationVo.getEmail())) {
            String errorFormatString = String.format("Can't create a new account , Account[%s] already exists in other WCT server.", accountCreationVo.getEmail());
            LOG.error(errorFormatString);
            throw new AccountAlreadyExistsException(errorFormatString);
        }
        if (AccountType.AD.equals((Object)accountCreationVo.getAccountType())) {
            boolean requiredParamsCorrect = StringUtils.isNotBlank((CharSequence)accountCreationVo.getAdServer()) && StringUtils.isNotBlank((CharSequence)accountCreationVo.getAdServerBaseDn()) && StringUtils.isNotBlank((CharSequence)accountCreationVo.getActivedirectoryguid());
            LOG.debug("requiredParamsCorrect : {} ", (Object)requiredParamsCorrect);
            if (!requiredParamsCorrect) {
                throw new RequestArgumentNotValidException("Both ad Server and Server BaseD params cannot contain empty value.");
            }
        }
        String guid = null;
        try {
            try {
                this.accountService.getAccountInfoByDisplayName(accountCreationVo.getName(), currentLoginUser.getCompanyGuid());
                throw new UserNameConflictException("Fail to update account , user name already in use.");
            }
            catch (ItemNotFoundException ex) {
                guid = this.accountService.createAccount(accountCreationVo, currentLoginUser.getCompanyGuid(), true);
                this.removeTmpLogoSessionQuiet(accountCreationVo.getLogoTmpGuid());
            }
        }
        catch (PersistenceException ex) {
            LOG.error("PersistenceException : {}", (Throwable)ex);
            throw new UserNameConflictException("Fail to update account , user name already in use.");
        }
        MessageResponseResult response = new MessageResponseResult(String.format("Account[%s] has been created.", accountCreationVo.getEmail()), guid);
        return response;
    }

    private boolean CheckAccountInOtherWCTServer(String accountEmail) {
        LOG.debug("CheckAccountInOtherWCTServer accountEmail={}", (Object)accountEmail);
        ServerType serverType = this.registryService.GetServerType();
        if (serverType == ServerType.Google_Linux_Server_Cloud || serverType == ServerType.ASUSTOR_NAS_AUTOMATION) {
            GsonBuilder gsonb;
            Gson gsonRespone;
            SubRespone subRespone;
            String checkAccountJson = "{ \"email\": \"" + accountEmail + "\" }";
            String checkAccountExist = "";
            if (serverType == ServerType.Google_Linux_Server_Cloud) {
                checkAccountExist = this.subscriptionService.RequestToDispatchServerPassByPRS(DISPATCH_SERVER_CHECK_ACCOUNT_EXIST_URL, checkAccountJson);
            } else if (serverType == ServerType.ASUSTOR_NAS_AUTOMATION) {
                checkAccountExist = this.subscriptionService.RequestToDispatchServerFromFreeTrialPassByPRS(DISPATCH_SERVER_CHECK_ACCOUNT_EXIST_URL, checkAccountJson);
            }
            if (!StringUtil.IsStringNullorEmpty((String)checkAccountExist) && (subRespone = (SubRespone)(gsonRespone = (gsonb = new GsonBuilder()).create()).fromJson(checkAccountExist, SubRespone.class)) != null) {
                switch (subRespone.getStatus()) {
                    case 200: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void removeTmpLogoSessionQuiet(String value) {
        try {
            Optional<String> tmpLogoGuid = Optional.ofNullable(value);
            if (tmpLogoGuid.isPresent()) {
                this.sessionService.removeSessionByKey(tmpLogoGuid.get());
            }
        }
        catch (Exception ex) {
            LOG.warn("remove session failed....", (Throwable)ex);
        }
    }

    @ApiOperation(value="updateAccount", notes="\u66f4\u65b0account\u8cc7\u6599 . <BR> logo\u53ef\u70ba\u6a94\u6848\u76f8\u5c0d\u8def\u5f91(\u672a\u8b8a\u66f4)\u6216\u8457\u65b0\u7684tmpImageGuid(\u4e0a\u50b3\u65b0\u7684logo\u5f97\u5230tmpImageGuid)<BR><BR>accountSecurityInfos List\u7684\u9577\u5ea6\u5fc5\u9808\u70ba5.<BR>\u4e14platform\u5fc5\u9808\u5206\u5225\u70baIOS, ANDROID, WINDOWS, MAC, WEB(\u4e0d\u5f97\u7f3a\u5c11\u6216\u91cd\u8907).<BR>\u7576bindingDeviceEnable\u70bafalse\u6642\uff0cbindingdevicesAndIpConstraint\u5fc5\u9808\u70ba\u7a7a.")
    @ApiResponses(value={@ApiResponse(code=422, message="Request parameters value is invalid. <BR>"), @ApiResponse(code=426, message="Fail to update account."), @ApiResponse(code=415, message="user name already in use."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>"), @ApiResponse(code=403, message="Request parameters value is invalid. <BR>")})
    @RequestMapping(value={"/update_account"}, method={RequestMethod.POST})
    public MessageResponseResult updateAccount(@RequestBody @Valid AccountUpdateVo accountUpdateVo) {
        LOG.debug("accountUpdateVo : {} ", (Object)accountUpdateVo);
        AccountInfo currentLoginAccount = SecurityUtils.getCurrentLoginUser();
        this.accountService.verifyAccount(accountUpdateVo.getGuid(), null);
        try {
            try {
                AccountInfo accountInfo = this.accountService.getAccountInfoByDisplayName(accountUpdateVo.getName(), currentLoginAccount.getCompanyGuid());
                if (!accountInfo.getGuid().equals(accountUpdateVo.getGuid())) {
                    throw new UserNameConflictException("Fail to update account , user name already in use.");
                }
                this.accountService.updateAccount(accountUpdateVo, currentLoginAccount);
                this.accountService.publishAccountSecurityChangedEvent(accountUpdateVo);
            }
            catch (ItemNotFoundException ex) {
                this.accountService.updateAccount(accountUpdateVo, currentLoginAccount);
                this.accountService.publishAccountSecurityChangedEvent(accountUpdateVo);
            }
        }
        catch (PersistenceException | DataIntegrityViolationException ex) {
            throw new UserNameConflictException("Fail to update account , user name already in use.");
        }
        this.removeTmpLogoSessionQuiet(accountUpdateVo.getLogo());
        this.multiLayerCategoryService.renameAllSecretaryCategoriesCreatedByAccount(accountUpdateVo.getGuid());
        MessageResponseResult response = new MessageResponseResult(String.format("Account[guid=%s] has been updated.", accountUpdateVo.getGuid()), "");
        return response;
    }

    @ApiOperation(value="deleteAccountByGuid", notes="\u805e\u9664\u7279\u5b9aAccount \u4f7f\u7528\u5176guid.<BR> Account\u7684\u72c0\u614b\u70baACTIVE\u7684\u7121\u6cd5\u88ab\u522a\u9664.")
    @ApiResponses(value={@ApiResponse(code=460, message="The resource item can't be removed.<BR>"), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/delete_account"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult deleteAccount(@RequestParam(required=true) String guid) {
        this.accountService.verifyAccount(guid, null);
        try {
            this.accountService.deleteAccount(guid);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException ex) {
            throw new DeleteAccountException("Fail to delete account ,  a foreign key constraint fails.");
        }
        MessageResponseResult response = new MessageResponseResult(String.format("Account[guid=%s] has been removed.", guid), "");
        return response;
    }

    @ApiOperation(value="deleteAccountByList", notes="\u805e\u9664\u6574\u500baccount guid\u6e05\u55ae. <BR> \u672a\u80fd\u88ab\u79fb\u9664\u7684account\u6e05\u55ae\u6703\u5728response data\u88e1\u9762.<BR> Account\u7684\u72c0\u614b\u70baACTIVE\u7684\u7121\u6cd5\u88ab\u522a\u9664.")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/delete_accounts"}, method={RequestMethod.POST})
    public ListResponseResult<AccountInfo> deleteAccounts(@RequestBody(required=true) ListRequestVo<String> guids) {
        ListResponseResult response;
        List toDeleteGuids = guids.getList();
        ArrayList<String> undeleteAccountGuids = new ArrayList<String>();
        for (String guid : toDeleteGuids) {
            try {
                this.accountService.deleteAccount(guid);
            }
            catch (Exception ex) {
                LOG.debug("delete_accounts exception={}", (Object)ex.getMessage());
                undeleteAccountGuids.add(guid);
            }
        }
        List<Object> undeletedAccounts = new ArrayList();
        if (undeleteAccountGuids.size() > 0) {
            undeletedAccounts = undeleteAccountGuids.stream().map(accountGuid -> this.accountService.getAccountInfo(accountGuid, null)).collect(Collectors.toList());
        }
        if (this.containsUnremovedAccount(undeletedAccounts)) {
            response = new ListResponseResult("the part of account list has been removed , but some account status is ACTIVE will not to be removed.", undeletedAccounts);
            return response;
        }
        response = new ListResponseResult("Account list has been removed.", undeletedAccounts);
        return response;
    }

    private boolean containsUnremovedAccount(List<AccountInfo> undeletedAccount) {
        return undeletedAccount != null && undeletedAccount.size() > 0;
    }

    @ApiOperation(value="getUserRoles", notes="Return all UserRole defined.")
    @ApiResponses(value={@ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/get_user_roles"}, method={RequestMethod.POST})
    public ListResponseResult<UserRole> getUserRoles() {
        List<UserRole> userRoles = Arrays.asList(UserRole.values());
        ListResponseResult response = new ListResponseResult("Got all UserRole defined.", userRoles);
        return response;
    }

    @ApiOperation(value="", notes="\u4f7f\u7528\u6307\u5b9a\u7684Account guid\u548cPlatform\uff0c\u641c\u5c0bAccount\u6700\u8fd1\u5728\u8a72\u5e73\u53f0\u7684\u767b\u5165\u7d00\u9304(\u4e0a\u9650\u5341\u7b46)")
    @RequestMapping(value={"/get_recent_login_devices_by_platform"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    public ListResponseResult<DeviceInfoLess> getRecentLoginDevicesByPlatfrom(@RequestParam String guid, @RequestParam PlatformForDevice platform) {
        this.accountService.verifyAccount(guid, null);
        List loginDevices = this.accountSecurityService.getRecentLoginDevicesByPlatfrom(guid, platform);
        ListResponseResult response = new ListResponseResult("Get recent login devices record succeeded", loginDevices);
        return response;
    }

    @ApiOperation(value="changeSubscriptionstatus", notes="change Subscriptionstatus")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/update_subscription_status"}, method={RequestMethod.POST})
    @PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
    public MessageResponseResult updateSubscriptionStatus(@RequestBody @Valid ListRequestVo<String> accountGuids, @RequestParam AccountSubscriptionStatus accountSubscriptionStatus) {
        List accountsGuids = accountGuids.getList();
        for (String accountsGuid : accountsGuids) {
            this.accountService.verifyAccount(accountsGuid, null);
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.accountService.updateSubscriptionStatus(accountsGuids, accountSubscriptionStatus, currentLoginUser.getCompanyGuid(), AccountLockCase.CHANGE_BY_ADMIN, true);
        MessageResponseResult response = new MessageResponseResult("Subscription_status has be change.", "");
        return response;
    }

    @ApiOperation(value="unlockaccount", notes="unlockaccount replace for change subscriptionstatus")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/unlock_account"}, method={RequestMethod.POST})
    @PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (hasAuthority('ADMIN'))")
    public MessageResponseResult UnLockAccount(@RequestBody @Valid ListRequestVo<String> accountGuids) {
        List accountsGuids = accountGuids.getList();
        for (String accountsGuid : accountsGuids) {
            this.accountService.verifyAccount(accountsGuid, null);
        }
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        this.accountService.unLockAccount(accountsGuids, currentLoginUser.getCompanyGuid());
        MessageResponseResult response = new MessageResponseResult("Subscription_status has be change.", "");
        return response;
    }

    @ApiOperation(value="", notes="")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="Request required parameters not valid. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/reset_password"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="(principal.status==T(com.penpower.worldcard.team.enums.UserStatus).ACTIVE) and (principal.accountType==T(com.penpower.worldcard.team.enums.AccountType).LOCAL) and (hasAuthority('ADMIN'))")
    public MessageResponseResult resetPassword(@RequestParam String guid) {
        String passwordRestByAdminGuid = guid;
        this.accountService.verifyAccount(passwordRestByAdminGuid, null);
        this.accountService.resetPassword(passwordRestByAdminGuid);
        MessageResponseResult response = new MessageResponseResult("Password has been reset.", "");
        return response;
    }

    @ApiOperation(value="", notes="\u6307\u5b9a\u7e7c\u627f\u4eba.")
    @ApiResponses(value={@ApiResponse(code=442, message="Assign account inheritor failed."), @ApiResponse(code=438, message="Schedule already exists with this identification."), @ApiResponse(code=439, message="Fail to start schedule."), @ApiResponse(code=404, message="Resource item not found in system. <BR>"), @ApiResponse(code=403, message="You don't have permission to access this request.<BR>")})
    @RequestMapping(value={"/assign_inheritor_account"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public MessageResponseResult assignInheritorAccount(@RequestParam String userGuid, @RequestParam String inheritorAccountGuid, @RequestParam InheritMode inheritMode) {
        boolean assignAccountInheritorJobRunning = this.scheduleManager.jobRunning(AssignAccountInheritorJob.class);
        if (assignAccountInheritorJobRunning) {
            throw new ScheduleStartException("There are one of the AssignAccountInheritorJob job running....");
        }
        this.accountService.verifyAccount(userGuid, null);
        this.accountService.verifyAccount(inheritorAccountGuid, null);
        AccountInfo sourceAccount = this.accountService.getAccountInfo(userGuid, null);
        AccountInfo inheritorAccount = this.accountService.getAccountInfo(inheritorAccountGuid, null);
        boolean inheritorStatusValid = this.accountService.verifyInheritorStatus(userGuid);
        if (!(UserStatus.RESIGNED.equals((Object)sourceAccount.getStatus()) && SecurityUtils.validUser((UserStatus)inheritorAccount.getStatus()) && inheritorStatusValid)) {
            throw new AssignInheritorFailedException("Fail to assign account inheritor , account status not RESIGNED or inherator status not ACTINVE or INACTIVE , or inherite job not completed.");
        }
        LOG.debug("assignInheritor , sourceAccount status : {} ", (Object)sourceAccount.getStatus());
        LOG.debug("assignInheritor , inheritorAccount status : {} ", (Object)inheritorAccount.getStatus());
        JobIdentify jobIdentify = new JobIdentify("ASSIGN_INHERITOR_GROUP", AssignAccountInheritorJob.class);
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("accountGuid", userGuid);
        dataMap.put("inheritorAccountGuid", inheritorAccountGuid);
        dataMap.put("JOB_DATA_INHERIT_MODE", (Object)inheritMode);
        AccountInfo currentLoginUser = SecurityUtils.getCurrentLoginUser();
        dataMap.put("adminAccountName", currentLoginUser.getName());
        dataMap.put("adminAccountGuid", currentLoginUser.getGuid());
        this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
        MessageResponseResult response = new MessageResponseResult("assign inheritor succeeded.", "");
        return response;
    }
}

