/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.auth.TokenInfo;
import com.penpower.worldcard.team.dao.TokenDao;
import com.penpower.worldcard.team.entity.Token;
import com.penpower.worldcard.team.enums.Platform;
import com.penpower.worldcard.team.enums.PlatformCategory;
import com.penpower.worldcard.team.enums.TokenStatus;
import com.penpower.worldcard.team.exception.TokenNotFoundException;
import com.penpower.worldcard.team.service.TokenService;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tokenService")
public class TokenServiceImpl
implements TokenService {
    private static final Logger LOG = LoggerFactory.getLogger(TokenServiceImpl.class);
    @Autowired
    private TokenDao tokenDao;

    public List<String> getUserTokensByPlatformCategory(String userGuid, PlatformCategory platformCategory) {
        List tokens = this.tokenDao.findUserTokensByPlatformCategory(userGuid, platformCategory);
        return tokens;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public TokenInfo createNewTokenWithPlatformAndIpAndDeviceId(String userGuid, Platform platform, String remoteIpaddress, String deviceId, String hostname) {
        Token token = new Token(UUIDGenerator.getRandomUUID(), userGuid, platform, remoteIpaddress, deviceId, hostname);
        this.tokenDao.save((Object)token);
        return new TokenInfo(token);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public TokenInfo createNewToken(String userGuid, String ip) {
        LOG.debug("create new token by user: {} ", (Object)userGuid);
        Token token = new Token(UUIDGenerator.getRandomUUID(), userGuid, ip);
        this.tokenDao.save((Object)token);
        return new TokenInfo(token);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public TokenInfo createNewTokenForPlatform(String userGuid, String ip, Platform platform) {
        LOG.debug("create new token by user: {} ", (Object)userGuid);
        Token token = new Token(UUIDGenerator.getRandomUUID(), userGuid, ip);
        token.setPlatform(platform);
        this.tokenDao.save((Object)token);
        return new TokenInfo(token);
    }

    public TokenInfo getTokenInfo(String token) throws TokenNotFoundException {
        LOG.debug("try to get token, token :{}", (Object)token);
        Token tokenEntity = this.tokenDao.findByToken(token);
        LOG.debug("tokenEntity: {}", (Object)tokenEntity);
        if (tokenEntity == null) {
            throw new TokenNotFoundException(String.format("Token<%s> was not found.", token));
        }
        return new TokenInfo(tokenEntity);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void replaceToken(TokenInfo tokenInfo) {
        Token tokenEntity = this.tokenDao.findByToken(tokenInfo.getToken());
        if (tokenEntity != null) {
            tokenEntity = new Token(tokenInfo);
            this.tokenDao.save((Object)tokenEntity);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void putToken(TokenInfo tokenInfo) {
        Token tokenEntity = this.tokenDao.findByToken(tokenInfo.getToken());
        if (tokenEntity == null) {
            tokenEntity = new Token(tokenInfo);
            this.tokenDao.save((Object)tokenEntity);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void removeToken(String token) {
        Token tokenEntity = this.tokenDao.findByToken(token);
        if (tokenEntity != null) {
            this.tokenDao.delete((Object)tokenEntity);
        }
    }

    public String getUserGuid(String token) {
        String userGuid = this.tokenDao.findUserGuidByToken(token);
        return userGuid;
    }

    public boolean expired(String token) {
        Token tokenEntity = this.tokenDao.findByToken(token);
        if (tokenEntity != null) {
            DateTime expiredTime = new DateTime((Object)tokenEntity.getExpiredtime());
            return expiredTime.isBeforeNow();
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setToExpired(String token) throws TokenNotFoundException {
        LOG.debug("set to expired..... token : {} ", (Object)token);
        Token tokenEntity = this.tokenDao.findByToken(token);
        if (tokenEntity != null) {
            DateTime createTime = tokenEntity.getCreatedtime();
            tokenEntity.setExpiredtime(createTime);
            this.tokenDao.save((Object)tokenEntity);
        }
    }

    public TokenStatus getTokenStatus(String token) throws TokenNotFoundException {
        Token tokenEntity = this.tokenDao.findByToken(token);
        if (tokenEntity != null) {
            DateTime expiredTime = new DateTime((Object)tokenEntity.getExpiredtime());
            DateTime invalidTime = new DateTime((Object)tokenEntity.getInvalidtime());
            LOG.debug(">>>> tokenEntity : {}", (Object)tokenEntity);
            LOG.debug(">>>> expiredTime : {}", (Object)expiredTime);
            LOG.debug(">>>> invalidTime : {}", (Object)invalidTime);
            if (invalidTime.isBeforeNow()) {
                return TokenStatus.INVALID;
            }
            if (expiredTime.isBeforeNow()) {
                return TokenStatus.EXPIRED;
            }
            return TokenStatus.VALID;
        }
        throw new TokenNotFoundException(String.format("Token<%s> was not found.", token));
    }

    public void setUserTokensExipred(String userGuid, String currentToken) {
        List tokens = this.tokenDao.findAllTokenByUserGuid(userGuid);
        tokens.stream().filter(token -> !token.equals(currentToken)).forEach(token -> this.setToExpired(token));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setToInvalid(String token) throws TokenNotFoundException {
        Token tokenEntity = this.tokenDao.findByToken(token);
        this.tokenDao.delete((Object)tokenEntity);
    }

    public void deleteInvalidateToken() {
        DateTime currTime = DateTime.now();
        this.tokenDao.deleteInvalidateToken(currTime);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setUserTokensInvalid(String userGuid, String currentToken) {
        LOG.debug("***** userGuid : {}", (Object)userGuid);
        LOG.debug("***** currentToken : {}", (Object)currentToken);
        List tokens = this.tokenDao.findAllTokenByUserGuid(userGuid);
        tokens.stream().forEach(token -> this.setToInvalid(token));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setTokensInvalid(String userGuid) {
        LOG.debug("***** userGuid : {}", (Object)userGuid);
        List tokens = this.tokenDao.findAllTokenByUserGuid(userGuid);
        LOG.debug("tokens : {}", (Object)tokens);
        tokens.stream().forEach(token -> this.setToInvalid(token));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setAllTokenIvalidate() {
        this.tokenDao.deleteAllInBatch();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void cleanTokens() {
        this.tokenDao.deleteAllInBatch();
    }

    public void printAllTokenLog() {
    }

    public List<TokenInfo> getAllTokenInfoByUserGuid(String userGuid) {
        List userAllTokens = this.tokenDao.findAllTokenByUserGuid(userGuid);
        return userAllTokens.stream().map(token -> this.getTokenInfo(token)).collect(Collectors.toList());
    }

    public List<String> GetAllTokenGuids() {
        List<String> tokens = this.tokenDao.findAll().stream().map(token -> token.getToken()).collect(Collectors.toList());
        return tokens;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public TokenInfo refreshTokenWithIpAndDeviceId(String token, String userGuid, String hostName) {
        LOG.debug("refresh tokoen : {} , userGuid:{}", (Object)token, (Object)userGuid);
        Token oldtokenEntity = this.tokenDao.findByToken(token);
        if (oldtokenEntity != null) {
            Token newTokenEntity = new Token(token, userGuid, oldtokenEntity.getPlatform(), oldtokenEntity.getIp(), oldtokenEntity.getDeviceid(), hostName);
            this.tokenDao.save((Object)newTokenEntity);
            return new TokenInfo(newTokenEntity);
        }
        return null;
    }
}

