/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.ListObjectPaginator;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.CategoryDao;
import com.penpower.worldcard.team.dao.CompanyDao;
import com.penpower.worldcard.team.dao.ContactSimpleInfoDao;
import com.penpower.worldcard.team.dao.ContactfulltextDao;
import com.penpower.worldcard.team.dao.NormalSearchDao;
import com.penpower.worldcard.team.dto.ContactSimpleInfoDto;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Category;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Contactsimpleinfo;
import com.penpower.worldcard.team.enums.NameDisplayOrderSettingType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.service.TestService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TestServiceImpl
implements TestService {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceImpl.class);
    @Autowired
    AccountDao accountDao;
    @Autowired
    CompanyDao companyDao;
    @Autowired
    CategoryDao categoryDao;
    @Autowired
    private ContactfulltextDao contactfulltextDao;
    @Autowired
    private NormalSearchDao normalSearchDao;
    @Autowired
    private ContactSimpleInfoDao ContactSimpleInfoDao;

    public List<Category> getCategoryList(List<String> categoryGuids) {
        LOG.debug("categoryGuids: {}", categoryGuids);
        List categories = this.categoryDao.findByGuidList(categoryGuids);
        LOG.debug("categories: {}", (Object)categories);
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void test() {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"a.createtime"});
        PageRequest pageRequest = new PageRequest(0, 5, sort);
        LOG.debug("pageRequest getOffset : {} ", (Object)pageRequest.getOffset());
        LOG.debug("pageRequest getPageNumber : {} ", (Object)pageRequest.getPageNumber());
        LOG.debug("pageRequest getPageSize : {} ", (Object)pageRequest.getPageSize());
        String orderBy = "order by a.createtime desc";
        long startTime = System.currentTimeMillis();
        List sortedResult = this.normalSearchDao.findUserPublicContactGuidsByKeyword("a", "e4ac2f98-1ef5-4f41-809e-1fdff8660fc7", orderBy);
        LOG.debug("sortedResult : {} ", (Object)sortedResult);
        long endTime = System.currentTimeMillis();
        List pageResult = ListObjectPaginator.getPageResult((List)sortedResult, (PageRequest)pageRequest);
        LOG.debug("Total cost time ms : {} ", (Object)(endTime - startTime));
        LOG.debug("sortedResult : {} ", (Object)sortedResult.size());
        LOG.debug("pageResult : {} ", (Object)pageResult.size());
        long startTime2 = System.currentTimeMillis();
        List result = pageResult.stream().filter(Objects::nonNull).map(guid -> {
            Contactsimpleinfo contactSimpleInfo = (Contactsimpleinfo)this.ContactSimpleInfoDao.findOne((Serializable)((Object)guid));
            return new ContactSimpleInfoDto(contactSimpleInfo, NameDisplayOrderSettingType.EAST_FL_WEST_FL, contactSimpleInfo.getContact());
        }).collect(Collectors.toList());
        long endTime2 = System.currentTimeMillis();
        LOG.debug("result size : {} ", (Object)result.size());
        LOG.debug("Total cost time ms : {} ", (Object)(endTime2 - startTime2));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addCompanyAndAccount() {
        Company company = new Company();
        company.setGuid(UUIDGenerator.getRandomUUID());
        company.setName("PENPOWER");
        this.companyDao.save((Object)company);
        Account boss = new Account();
        boss.setGuid(UUIDGenerator.getRandomUUID());
        boss.setCreateTime(new DateTime());
        boss.setDisplayName("carpe");
        boss.setEmail("carpe@pen.com");
        boss.setPassword("bbbbbb");
        boss.setRole(UserRole.NORMAL_USER);
        boss.setStatus(UserStatus.ACTIVE);
        boss.setCompanyGuid(company.getGuid());
        this.accountDao.save((Object)boss);
        Account account = new Account();
        account.setGuid(UUID.randomUUID().toString());
        account.setCreateTime(new DateTime());
        account.setDisplayName("ralph");
        account.setEmail("ralph@pen.com");
        account.setPassword("aaaaaa");
        account.setRole(UserRole.NORMAL_USER);
        account.setStatus(UserStatus.ACTIVE);
        account.setCompanyGuid(company.getGuid());
        account.setBoss(boss);
        this.accountDao.save((Object)account);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void printCompanyAndBoss() {
    }
}

