/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.CustomFieldService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.IpConstraintService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.SystemService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SystemServiceImpl
implements SystemService {
    private static final Logger LOG = LoggerFactory.getLogger(SystemService.class);
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private IpConstraintService ipConstraintService;
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Value(value="${SimplifyUI}")
    private String SimplifyUI;

    private void ConvertAllGlobalInfo(Company company, String newCompanyGuid) {
        this.ConvertGlobalInfoToCompanyGlobalInfo("SERVER_ID", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SHARE_RULE", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SYSTEM_CRM", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("IP_NEED_TO_CONSTRAINT", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_LICENSE_MODE", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_DATABASE_SIGN", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_SERVICEID", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_TEMPLATE_SIGNID", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_LASTCHECK_TIME", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_CHECK_RESOULT", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_CHECK_CONNECT_STATUS", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("SUBSCRIBE_INFO", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("HAVE_SET_SALSEFORCE", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("HAVE_SCAN_BY_SECRETARY", newCompanyGuid);
        this.ConvertGlobalInfoToCompanyGlobalInfo("HAVE_SET_BOSS", newCompanyGuid);
        LOG.info("ConvertAllGlobalInfo set company before");
        Globalinfo globalinfoCompanyName = this.globalInfoService.getPropertiesByKey("COMPANY_NAME");
        if (globalinfoCompanyName != null) {
            company.setName(globalinfoCompanyName.getConfigValue());
        } else {
            company.setName("");
        }
        Globalinfo globalinfoCompanytel = this.globalInfoService.getPropertiesByKey("COMPANY_TEL");
        if (globalinfoCompanyName != null) {
            company.setTelphone(globalinfoCompanytel.getConfigValue());
        } else {
            company.setTelphone("");
        }
        this.companyService.UpdateCompany(company);
    }

    private void ConvertGlobalInfoToCompanyGlobalInfo(String propertiesCompanyConfigureKey, String newCompanyGuid) {
        LOG.info("ConvertGlobalInfoToCompanyGlobalInfo key={},companyid={}", (Object)propertiesCompanyConfigureKey, (Object)newCompanyGuid);
        Globalinfo globalinfo = this.globalInfoService.getPropertiesByKey(propertiesCompanyConfigureKey);
        if (globalinfo != null) {
            LOG.info("ConvertGlobalInfoToCompanyGlobalInfo globalinfo.getConfigValue()={}", (Object)globalinfo.getConfigValue());
            this.companyGlobalInfoService.createNewProperties(propertiesCompanyConfigureKey, globalinfo.getConfigValue(), newCompanyGuid);
            this.globalInfoService.deleteProperty(globalinfo.getGuid());
            LOG.info("ConvertGlobalInfoToCompanyGlobalInfo end");
        }
    }

    public void ConvertDBtoMultiCompany() {
        String dataSchemaMultiCompany = this.globalInfoService.getPropertiesStringByKey("DATABASE_SCHEMA_MULITI_COMPANY");
        LOG.info("ConvertDBtoMultiCompany dataSchemaMultiCompany ={}", (Object)dataSchemaMultiCompany);
        if (dataSchemaMultiCompany.compareToIgnoreCase("true") == 0) {
            LOG.info("ConvertDBtoMultiCompany ConvertED ");
            return;
        }
        List companys = this.companyService.FindAllCompany();
        LOG.info("ConvertDBtoMultiCompany companys={}", (Object)companys);
        for (Company company : companys) {
            if (company.getGuid().compareToIgnoreCase("aabc2320-58a7-4b59-b292-bb4a07873893") != 0) continue;
            List accounts = null;
            LOG.info("ConvertDBtoMultiCompany company={}", (Object)company);
            try {
                accounts = this.accountService.GetAccountByCompany(company.getGuid());
            }
            catch (ItemNotFoundException e) {
                LOG.info("ConvertDBtoMultiCompany ItemNotFoundException={}", (Object)e.getMessage());
                this.companyService.DeleteCompany(company);
                LOG.info("ConvertDBtoMultiCompany delete companySuccess 1");
                break;
            }
            if (accounts.size() == 0) {
                LOG.info("ConvertDBtoMultiCompany accountsize =0");
                this.companyService.DeleteCompany(company);
                LOG.info("ConvertDBtoMultiCompany delete companySuccess 2");
                break;
            }
            try {
                LOG.info("ConvertDBtoMultiCompany start convert");
                String newCompanyGuid = UUIDGenerator.getRandomUUID();
                this.ConvertAllGlobalInfo(company, newCompanyGuid);
                LOG.info("ConvertDBtoMultiCompany 1");
                for (AccountInfo account : accounts) {
                    this.accountService.UpdateAccountCompanyGuid(account.getGuid(), newCompanyGuid);
                }
                LOG.info("ConvertDBtoMultiCompany 2");
                this.companyService.ChangeGuid(company.getGuid(), newCompanyGuid);
                this.noticeService.UpdateAllNoticewithCompany(newCompanyGuid);
                this.customFieldService.UpdateAllCustomFieldwithCompany(newCompanyGuid);
                this.ipConstraintService.UpdateipConstraintWithCompany(newCompanyGuid);
                this.contactPrivateService.UpdateAllContactWithCompanyGuid(newCompanyGuid);
            }
            catch (Exception e) {
                LOG.error("ConvertDBtoMultiCompany fail ex={}", (Object)e.getMessage());
            }
            break;
        }
        this.globalInfoService.createNewProperties("DATABASE_SCHEMA_MULITI_COMPANY", "true");
        LOG.info("initial subscription option");
        List allcompanys = this.companyService.FindAllCompany();
        for (Company company : allcompanys) {
            if (this.subscriptionService.getLicenseMode(company.getGuid()) != LicenseMode.NONE || this.registryService.getRegistryInfoincludeExpried(false, false).size() <= 0) continue;
            LOG.info("initial subscription set licensemode = buyout");
            this.subscriptionService.setLicenseMode(company.getGuid(), LicenseMode.BUYOUT);
        }
        LOG.info("ConvertDBtoMultiCompany finish");
    }

    public boolean GetSimplifyUI() {
        LOG.debug("SimplifyUI={}", (Object)this.SimplifyUI);
        return this.SimplifyUI.compareToIgnoreCase("true") == 0;
    }
}

