/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.SystemMonitorDao;
import com.penpower.worldcard.team.entity.Systemmonitor;
import com.penpower.worldcard.team.enums.MonitorType;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.SystemMonitorService;
import com.penpower.worldcard.team.service.impl.SystemMonitorServiceImpl;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SystemMonitorServiceImpl
implements SystemMonitorService {
    private static final Logger LOG = LoggerFactory.getLogger(SystemMonitorServiceImpl.class);
    @Autowired
    private SystemMonitorDao systemMonitorDao;

    public void executeMonitorOnce(MonitorType monitorType) {
        Systemmonitor systemMonitor = new Systemmonitor();
        systemMonitor.setGuid(UUIDGenerator.getRandomUUID());
        systemMonitor.setMonitortype(monitorType);
        systemMonitor.setMonitortime(DateTime.now());
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$MonitorType[monitorType.ordinal()]) {
            case 1: {
                systemMonitor.setValue(this.getCpuUsagePercentage());
            }
        }
        if (systemMonitor.getValue() != 0.0) {
            LOG.debug("systemMonitor:{}", (Object)systemMonitor);
            this.systemMonitorDao.save((Object)systemMonitor);
        }
    }

    private double getCpuUsagePercentage() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            Double systemCpuLoad = (Double)mbs.getAttribute(name, "ProcessCpuLoad");
            if (systemCpuLoad == null) {
                return 0.0;
            }
            return new BigDecimal(systemCpuLoad).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        }
        catch (Exception ex) {
            LOG.error("Can't find system cpu usage", (Throwable)ex);
            throw new ItemNotFoundException("Can't find system cpu usage");
        }
    }
}

