/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithSalesforceJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CRMExportService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.io.Serializable;
import java.util.List;
import okhttp3.OkHttpClient;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SugarCRMOperation")
@Transactional
public class SugarCRMOperation
implements CRMOperationService {
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private CRMExportService crmExportService;

    public String getExportedCrmID(String accountGuid, String contactGuid) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[getExportedCrmID]: Can not find status.");
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String crmAccount = crmSettingsDto.getUserCRMAccount();
        String crmID = status.getExporttosugarcrmid();
        if (crmAccount.equals(status.getSugarcrmaccount())) {
            return crmID;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setExportCrmInfo(String accountGuid, String contactGuid, String exportedCrmRecordID, String exportedCrmAccount, DateTime crmRecordModifyTime) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find status.");
        }
        if (exportedCrmRecordID != null) {
            status.setExporttosugarcrmid(exportedCrmRecordID);
        }
        if (exportedCrmAccount != null) {
            status.setSugarcrmaccount(exportedCrmAccount);
        }
        this.contactStatusForAccountDao.save((Object)status);
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public String exportContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, boolean isForSync, BasicToken basicToken, String salesforceTargetAccountId, OkHttpClient client) {
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String retCrmID = null;
        this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), retCrmID, crmSettingsDto.getUserCRMAccount(), null);
        return retCrmID;
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public void updateContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, String crmID, boolean isForSync, BasicToken basicToken, String salesforceTargetAccountId, OkHttpClient client) {
    }

    public List<ContactCrmSyncInfoForWCT> getWctSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, boolean isAutoExport) {
        return null;
    }

    public ContactCrmSyncInfoForCRM getRecordSyncInfo(String accountGuid, String crmID, BasicToken basicToken, OkHttpClient client) {
        return null;
    }

    public void deleteRecord(String accountGuid, String crmID, String contactGuid, boolean isForSync, BasicToken basicToken, OkHttpClient client) {
    }

    public List<ContactCrmSyncInfoForCRM> getCrmSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, BasicToken basicToken, OkHttpClient client) {
        return null;
    }

    public ContactCrmSyncInfoForWCT getWctSyncInfoByCorrespondingCrmSyncInfo(String accountGuid, ContactCrmSyncInfoForCRM syncInfoCRM) {
        return null;
    }

    public ContactCreationVo getContactCreationVoByCrmID(String accountGuid, String crmID, BasicToken basicToken, OkHttpClient client) {
        return null;
    }

    public void exportContactCheck(ContactInfoForResponse contact) {
    }

    public ContactUpdateVo getContactUpdateVoByCrmID(ContactCrmSyncInfoForWCT syncInfoWCT, BasicToken basicToken, ContactInfoForRequest originContact, OkHttpClient client) {
        return null;
    }

    public void updateWCTModifyTimeForSync(String accountGuid, ContactCrmSyncInfoForCRM syncInfo, SyncContactsOfAccountsWithSalesforceJob.CrmSyncActionType crmActionType) {
    }
}

