/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.HardwareIdUtil;
import com.penpower.worldcard.team.Utils.JodaDateTime2PRSAdapter;
import com.penpower.worldcard.team.Utils.LocalDateAdapter;
import com.penpower.worldcard.team.Utils.LocalDateTimeAdapter;
import com.penpower.worldcard.team.Utils.SSLTrustManager;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.Utils.SubscribCode;
import com.penpower.worldcard.team.Utils.TrustAllHostnameVerifier;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.config.property.ApplicationProperties;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.AccountLoginRecordDao;
import com.penpower.worldcard.team.dao.LogPerformanceDao;
import com.penpower.worldcard.team.dao.SystemMonitorDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.ServerStatus;
import com.penpower.worldcard.team.dto.SubscribeDBSign;
import com.penpower.worldcard.team.dto.WctInfo;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Accountloginrecord;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Globalinfo;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountLockedIssue;
import com.penpower.worldcard.team.enums.Country;
import com.penpower.worldcard.team.enums.IssueStatus;
import com.penpower.worldcard.team.enums.LicenseMode;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.RequestMethod;
import com.penpower.worldcard.team.enums.ServerRegisterStatus;
import com.penpower.worldcard.team.enums.ServerType;
import com.penpower.worldcard.team.enums.SubscriberCreateType;
import com.penpower.worldcard.team.enums.SubscriptionStatus;
import com.penpower.worldcard.team.enums.SubscriptionType;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.DifferentTimeException;
import com.penpower.worldcard.team.exception.IncorrectRegistrationInformationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.CheckSubscriptionValidateJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.RegistryService;
import com.penpower.worldcard.team.service.SubscriptionService;
import com.penpower.worldcard.team.service.impl.DatabaseSystemSettingService;
import com.penpower.worldcard.team.service.impl.SubscriptionServiceImpl;
import com.penpower.worldcard.team.web.api.vo.BuyoutInfoVo;
import com.penpower.worldcard.team.web.api.vo.DifferentTimeDetail;
import com.penpower.worldcard.team.web.api.vo.DifferentTimeVo;
import com.penpower.worldcard.team.web.api.vo.FreeTrialServerStartupVo;
import com.penpower.worldcard.team.web.api.vo.LicenseVo;
import com.penpower.worldcard.team.web.api.vo.PassToDMBody;
import com.penpower.worldcard.team.web.api.vo.SignPRS;
import com.penpower.worldcard.team.web.api.vo.SignPRSToken;
import com.penpower.worldcard.team.web.api.vo.SubCheckRespone;
import com.penpower.worldcard.team.web.api.vo.SubCheckResult;
import com.penpower.worldcard.team.web.api.vo.SubRespone;
import com.penpower.worldcard.team.web.api.vo.SubscriptionInfoVo;
import com.penpower.worldcard.team.web.api.vo.SubscriptionPeriod;
import com.penpower.worldcard.team.web.api.vo.WCTStartupNotice;
import com.penpower.worldcard.team.web.api.vo.response.TimeDefferenceResult;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletContext;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.joda.time.DateTime;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="subscriptionService")
@Transactional
public class SubscriptionServiceImpl
implements SubscriptionService {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionServiceImpl.class);
    private static final String SUBSCRIPTION_URL = "https://subscrib.worldcardteam.com/PRS";
    private static final String SUBSCRIPTION_WEB_URL = "https://subscrib.worldcardteam.com/?token=";
    @Autowired
    private ContactPrivateService contactPrivateService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;
    @Autowired
    private GlobalInfoService globalInfoService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private DatabaseSystemSettingService databaseSystemSettingService;
    @Autowired
    private AccountLoginRecordDao accountLoginRecordDao;
    @Autowired
    private SystemMonitorDao systemMonitorDao;
    @Autowired
    private LogPerformanceDao logPerformanceDao;
    @Autowired
    private RegistryService registryService;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private NoticeService noticeService;
    private JobIdentify jobIdentify;
    @Autowired
    private ServletContext context;
    private SSLTrustManager mMyTrustManager;
    @Value(value="${Servertype}")
    private String serverType;

    public SubscriptionStatus getSubScriptionStatus(String companyGuid) {
        ServerStatus serverStatus = new ServerStatus();
        this.checkScriptionStatus(serverStatus, companyGuid);
        return serverStatus.getSubscriptionStatus();
    }

    public void setLicenseMode(String companyGuid, LicenseMode licenseMode) {
        GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_LICENSE_MODE", (String)licenseMode.toString(), (String)companyGuid);
    }

    public LicenseMode getLicenseMode(String companyGuid) {
        LOG.debug("getLicenseMode start");
        LicenseMode lm = LicenseMode.NONE;
        try {
            String licenseMode = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_LICENSE_MODE", (String)companyGuid);
            LOG.debug("getLicenseMode lm ={}", (Object)licenseMode);
            lm = LicenseMode.valueOf((String)licenseMode);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("getLicenseMode fail={}", (Object)e.getMessage());
            lm = LicenseMode.NONE;
        }
        return lm;
    }

    public long getAllCompanyAccountCount() {
        List companys = this.companyService.FindAllCompany();
        long accountCount = 0L;
        for (Company company : companys) {
            SubscriptionInfoVo subscriptionInfoVo = this.getSubscriptionInfo(company.getGuid());
            if (subscriptionInfoVo == null) continue;
            accountCount += (long)subscriptionInfoVo.getAccountNum();
        }
        return accountCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String GetSUBSCRIPTION_WEB_URL() {
        try {
            LOG.debug("GetSUBSCRIPTION_WEB_URL in");
            ClassLoader classLoader = this.getClass().getClassLoader();
            String url = classLoader.getResource("surscrpitionurl.json").getFile();
            File file = new File(url);
            url = file.getAbsolutePath();
            LOG.debug("GetSUBSCRIPTION_WEB_URL in URL={}", (Object)url);
            url = URLDecoder.decode(url, "UTF-8");
            Path surscriptionurlJsonFile = Paths.get(url, new String[0]);
            LOG.debug("GetSUBSCRIPTION_WEB_URL surscriptionurlJsonFile={}", (Object)surscriptionurlJsonFile);
            if (!Files.exists(surscriptionurlJsonFile, new LinkOption[0])) return "https://subscrib.worldcardteam.com/?token=";
            LOG.debug("GetSUBSCRIPTION_WEB_URL exist");
            try (FileReader fr = new FileReader(surscriptionurlJsonFile.toFile());){
                LOG.debug("GetSUBSCRIPTION_WEB_URL file can read");
                char[] cbuf = new char[100];
                int nLength = fr.read(cbuf);
                LOG.debug("geturl ={}", (Object)cbuf);
                String rtnUrl = new String(cbuf, 0, nLength);
                rtnUrl = rtnUrl.replace("\r", "");
                rtnUrl = rtnUrl.replace("\n", "");
                rtnUrl = rtnUrl.replace("\r\n", "");
                rtnUrl = rtnUrl.replace("\t", "");
                String string = rtnUrl + "/?token=";
                return string;
            }
            catch (IOException ex) {
                LOG.debug("GetSUBSCRIPTION_WEB_URL IOException={}", (Throwable)ex);
                return "https://subscrib.worldcardteam.com/?token=";
            }
        }
        catch (Exception e) {
            e.getMessage();
            LOG.debug("GetSUBSCRIPTION_WEB_URL exce={}", (Throwable)e);
        }
        return "https://subscrib.worldcardteam.com/?token=";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String GetSUBSCRIPTION_URL() {
        try {
            LOG.debug("GetSUBSCRIPTION_URL in");
            ClassLoader classLoader = this.getClass().getClassLoader();
            String url = classLoader.getResource("surscrpitionurl.json").getFile();
            File file = new File(url);
            url = file.getAbsolutePath();
            LOG.debug("GetSUBSCRIPTION_URL in URL={}", (Object)url);
            url = URLDecoder.decode(url, "UTF-8");
            Path surscriptionurlJsonFile = Paths.get(url, new String[0]);
            LOG.debug("GetSUBSCRIPTION_URL surscriptionurlJsonFile={}", (Object)surscriptionurlJsonFile);
            if (!Files.exists(surscriptionurlJsonFile, new LinkOption[0])) return "https://subscrib.worldcardteam.com/PRS";
            LOG.debug("GetSUBSCRIPTION_URL exist");
            try (FileReader fr = new FileReader(surscriptionurlJsonFile.toFile());){
                LOG.debug("GetSUBSCRIPTION_URL file can read");
                char[] cbuf = new char[100];
                int nLength = fr.read(cbuf);
                LOG.debug("geturl ={}", (Object)cbuf);
                String rtnUrl = new String(cbuf, 0, nLength);
                rtnUrl = rtnUrl.replace("\r", "");
                rtnUrl = rtnUrl.replace("\n", "");
                rtnUrl = rtnUrl.replace("\r\n", "");
                rtnUrl = rtnUrl.replace("\t", "");
                String string = rtnUrl + "/PRS";
                return string;
            }
            catch (IOException ex) {
                LOG.debug("GetSUBSCRIPTION_URL IOException={}", (Throwable)ex);
                return "https://subscrib.worldcardteam.com/PRS";
            }
        }
        catch (Exception e) {
            e.getMessage();
            LOG.debug("GetSUBSCRIPTION_URL exce={}", (Object)e.getMessage());
        }
        return "https://subscrib.worldcardteam.com/PRS";
    }

    private SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            this.mMyTrustManager = new SSLTrustManager();
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{this.mMyTrustManager}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        return ssfFactory;
    }

    private String RequestToPRS(String apiUrl, RequestMethod requestMethod, String bodyData, String companyGuid) {
        LOG.debug("apiUrl = {} method ={} RequestToPRS requestbody={}", new Object[]{apiUrl, requestMethod, bodyData});
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).sslSocketFactory(this.createSSLSocketFactory(), (X509TrustManager)this.mMyTrustManager).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier()).build();
        String responseString = "";
        MediaType type = MediaType.parse((String)"application/json;charset=UTF-8");
        RequestBody body = RequestBody.create((MediaType)type, (byte[])bodyData.getBytes());
        Request request = null;
        String url = this.GetSUBSCRIPTION_URL() + apiUrl;
        LOG.debug("url = {} ", (Object)url);
        SignPRSToken signPRStoken = new SignPRSToken();
        signPRStoken.setServiceId(this.GetServiceID(companyGuid));
        signPRStoken.setcurrDateTime(LocalDateTime.now(ZoneOffset.UTC));
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        signPRStoken.setMacaddress(macAddress);
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        String signToken = gson.toJson((Object)signPRStoken);
        LOG.debug("getSubscriptionURL token={}", (Object)signToken);
        String SignTokenEncode = SubscribCode.Encode((String)signToken, (ServerType)this.GetServerType());
        LOG.debug("getSubscriptionURL SignTokenEncode={}", (Object)SignTokenEncode);
        if (requestMethod == RequestMethod.POST) {
            request = new Request.Builder().url(url).addHeader("PRS-WCT-AUTH", SignTokenEncode).post(body).build();
        } else if (requestMethod == RequestMethod.GET) {
            request = new Request.Builder().url(url).addHeader("PRS-WCT-AUTH", SignTokenEncode).get().build();
        }
        if (request != null) {
            try (Response response = httpClient.newCall(request).execute();){
                ResponseBody responseBody = response.body();
                responseString = responseBody.string();
            }
            catch (IOException e) {
                LOG.error("RequestToPRS Fail toe={}", (Throwable)e);
                throw new ItemNotFoundException("Connect to subscription server fail");
            }
        }
        LOG.debug("RequestToPRS respone={}", (Object)responseString);
        return responseString;
    }

    public String GetServiceID(String companyGuid) {
        return GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_SERVICEID", (String)companyGuid);
    }

    public void SetServiceID(String serviceID, String companyGuid) {
        GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_SERVICEID", (String)serviceID, (String)companyGuid);
    }

    public void SetPropty(String propertiesCompanyConfigureKey, String value, String companyGuid) {
        GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)propertiesCompanyConfigureKey, (String)value, (String)companyGuid);
    }

    public String getPropty(String propertiesCompanyConfigureKey, String companyGuid) {
        return GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)propertiesCompanyConfigureKey, (String)companyGuid);
    }

    void checkScriptionStatus(ServerStatus serverStatus, String companyGuid) {
        String checkResult = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_RESOULT", (String)companyGuid);
        String connectStatus = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)companyGuid);
        IssueStatus issueStatus = IssueStatus.OK;
        IssueStatus connectissueStatus = IssueStatus.OK;
        if (!StringUtil.IsStringNullorEmpty((String)checkResult)) {
            issueStatus = IssueStatus.valueOf((String)checkResult);
            serverStatus.setIssueStatuss(issueStatus);
        }
        if (!StringUtil.IsStringNullorEmpty((String)connectStatus)) {
            connectissueStatus = IssueStatus.valueOf((String)connectStatus);
            serverStatus.setIssueStatuss(connectissueStatus);
        }
        if (connectissueStatus == IssueStatus.LOCKED || issueStatus == IssueStatus.LOCKED) {
            serverStatus.setSubscriptionStatus(SubscriptionStatus.LOCK);
        } else {
            LOG.debug("checkScriptionStatus serverStatus={}", (Object)serverStatus);
            SubscriptionInfoVo subscriptionInfoVo = this.getSubscriptionInfo(companyGuid);
            LOG.debug("checkScriptionStatus subscriptionInfoVo={}", (Object)subscriptionInfoVo);
            if (subscriptionInfoVo != null) {
                SubscriptionPeriod lastSubscriptionPeriod = subscriptionInfoVo.GetLastPeriod();
                LOG.debug("checkScriptionStatus lastSubscriptionPeriod={}", (Object)lastSubscriptionPeriod);
                if (lastSubscriptionPeriod != null) {
                    SubscriptionStatus subscriptionStatus = this.checPeriodkScriptionStatus(lastSubscriptionPeriod, subscriptionInfoVo.getSubscriberCreateType());
                    LOG.debug("checkScriptionStatus subscriptionStatus={}", (Object)subscriptionStatus);
                    serverStatus.setSubscriptionStatus(subscriptionStatus);
                    if (lastSubscriptionPeriod.getSubscriptionType() != SubscriptionType.BUYOUT) {
                        serverStatus.setExpiredDate(lastSubscriptionPeriod.getTimeRangeEnd());
                    }
                } else {
                    List lastExipredSubscription = subscriptionInfoVo.getLastExpiredSubscriptionInfos();
                    if (lastExipredSubscription.size() > 0) {
                        SubscriptionPeriod expiredPeriod = (SubscriptionPeriod)lastExipredSubscription.get(lastExipredSubscription.size() - 1);
                        SubscriptionStatus subscriptionStatus = this.checPeriodkScriptionStatus(expiredPeriod, subscriptionInfoVo.getSubscriberCreateType());
                        LOG.debug("checkScriptionStatus expiredsubscriptionStatus={}", (Object)subscriptionStatus);
                        serverStatus.setSubscriptionStatus(subscriptionStatus);
                        serverStatus.setExpiredDate(expiredPeriod.getTimeRangeEnd());
                    } else {
                        LOG.debug("checkScriptionStatus LOCK 1");
                        serverStatus.setSubscriptionStatus(SubscriptionStatus.LOCK);
                    }
                }
            } else {
                LOG.debug("checkScriptionStatus LOCK 2");
                serverStatus.setSubscriptionStatus(SubscriptionStatus.LOCK);
            }
        }
    }

    public SubscriptionStatus checPeriodkScriptionStatus(SubscriptionPeriod subscriptionPeriod, SubscriberCreateType subscriberCreateType) {
        LOG.debug("checPeriodkScriptionStatus subscriptionPeriod={}", (Object)subscriptionPeriod);
        if (subscriptionPeriod.getSubscriptionType() == SubscriptionType.BUYOUT) {
            return SubscriptionStatus.BUYOUT;
        }
        SubscriptionStatus serverStatus = SubscriptionStatus.LOCK;
        if (subscriptionPeriod != null) {
            if (subscriptionPeriod.getTimeRangeEnd().plusMonths(6).isBeforeNow()) {
                serverStatus = SubscriptionStatus.LOCK;
            } else {
                LOG.debug("checPeriodkScriptionStatus subscriptionPeriod 1");
                if (subscriptionPeriod.getTimeRangeEnd().isBeforeNow()) {
                    LOG.debug("checPeriodkScriptionStatus subscriptionPeriod 2");
                    serverStatus = subscriptionPeriod.getSubscriptionType() == SubscriptionType.TRIAL ? SubscriptionStatus.OUT_OF_TRIAL : SubscriptionStatus.OUT_OF_SUBSCRIPTION;
                } else {
                    LOG.debug("checPeriodkScriptionStatus subscriptionPeriod 3");
                    if (subscriptionPeriod.getTimeRangeEnd().minusDays(14).isBeforeNow()) {
                        LOG.debug("checPeriodkScriptionStatus subscriptionPeriod 4");
                        serverStatus = subscriptionPeriod.getSubscriptionType() == SubscriptionType.TRIAL ? SubscriptionStatus.TRIAL_LEFT_2_WEEK : SubscriptionStatus.SUBSCRIPTION_LEFT_2_WEEK;
                    } else {
                        LOG.debug("checPeriodkScriptionStatus subscriptionPeriod 5");
                        serverStatus = subscriptionPeriod.getSubscriptionType() == SubscriptionType.TRIAL ? SubscriptionStatus.TRIAL : SubscriptionStatus.SUBSCRIPTION;
                    }
                }
            }
        } else {
            serverStatus = SubscriptionStatus.LOCK;
        }
        return serverStatus;
    }

    public ServerStatus getServerStatus(String accountGUID) {
        LOG.debug("getServerStatus accountGUID={}", (Object)accountGUID);
        Account account = this.accountDao.findOne(accountGUID);
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.setAccountSubscriptionStatus(account.getAccountSubscriptionStatus());
        if (this.getLicenseMode(account.getCompanyGuid()) == LicenseMode.BUYOUT) {
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerRegisterStatus[this.registryService.GetRegisterStatus(account.getCompanyGuid()).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    serverStatus.setSubscriptionStatus(SubscriptionStatus.LOCK);
                    serverStatus.setIsReadOnly(true);
                    return serverStatus;
                }
                case 4: 
                case 5: {
                    serverStatus.setSubscriptionStatus(SubscriptionStatus.BUYOUT);
                    serverStatus.setIsReadOnly(false);
                    return serverStatus;
                }
            }
        }
        this.checkScriptionStatus(serverStatus, account.getCompanyGuid());
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$SubscriptionStatus[serverStatus.getSubscriptionStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                serverStatus.setIsReadOnly(false);
                break;
            }
            default: {
                serverStatus.setIsReadOnly(true);
            }
        }
        String checkResult = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_RESOULT", (String)account.getCompanyGuid());
        String connectStatus = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)account.getCompanyGuid());
        LOG.debug("getServerStatus checkResult={}   connectStatus={}", (Object)checkResult, (Object)connectStatus);
        if (!StringUtil.IsStringNullorEmpty((String)connectStatus)) {
            LOG.debug("getServerStatus 2");
            IssueStatus connectissueStatus = IssueStatus.valueOf((String)connectStatus);
            if (connectissueStatus == IssueStatus.LOCKED) {
                LOG.debug("getServerStatus 3");
                serverStatus.setIssueStatuss(IssueStatus.LOCKED);
            } else if (!StringUtil.IsStringNullorEmpty((String)checkResult)) {
                LOG.debug("getServerStatus 3");
                IssueStatus issueStatus = IssueStatus.valueOf((String)checkResult);
                serverStatus.setIssueStatuss(issueStatus);
            } else {
                LOG.debug("getServerStatus 4");
                serverStatus.setIssueStatuss(IssueStatus.OK);
            }
        } else if (!StringUtil.IsStringNullorEmpty((String)checkResult)) {
            LOG.debug("getServerStatus 5");
            IssueStatus issueStatus = IssueStatus.valueOf((String)checkResult);
            serverStatus.setIssueStatuss(issueStatus);
        } else {
            LOG.debug("getServerStatus 6");
            serverStatus.setIssueStatuss(IssueStatus.OK);
        }
        LOG.debug("getServerStatus serverStatus={}", (Object)serverStatus);
        return serverStatus;
    }

    public SubscriptionInfoVo getSubscriptionInfo(String companyGuid) {
        String SubscriptionInfo = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_INFO", (String)companyGuid);
        if (SubscriptionInfo != null) {
            return this.ConvertSubscriptioninfo(SubscriptionInfo);
        }
        return null;
    }

    private static String DecodeSubscription(String src) {
        LOG.debug("DecodeSubscription src = {}", (Object)src);
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] subinfobyte = decoder.decode(src);
        String Subinfo = new String(subinfobyte);
        LOG.debug("DecodeSubscription Subinfo = {}", (Object)Subinfo);
        return Subinfo;
    }

    private SubscriptionInfoVo ConvertSubscriptioninfo(String subscriptionJson) {
        Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
        subscriptionJson = SubscriptionServiceImpl.DecodeSubscription((String)subscriptionJson);
        SubscriptionInfoVo si = (SubscriptionInfoVo)gson.fromJson(subscriptionJson, SubscriptionInfoVo.class);
        return si;
    }

    public int getAccountLimit(String companyGuid) {
        String SubscriptionInfo = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_INFO", (String)companyGuid);
        SubscriptionInfoVo subscriptionInfoVo = this.getSubscriptionInfo(companyGuid);
        LOG.error("getAccountLimit subscriptionInfoVo={}", (Object)subscriptionInfoVo);
        if (subscriptionInfoVo != null) {
            int nRtn = subscriptionInfoVo.checkCurrentAccountCountLimit();
            LOG.error("getAccountLimit nRtn={}", (Object)nRtn);
            return nRtn;
        }
        return 0;
    }

    public String getSubscriptionURL(String accountGuid, String companyGuid) {
        block8: {
            block6: {
                String tokenRespone;
                block7: {
                    SignPRS signPRS = new SignPRS();
                    signPRS.setServiceId(this.GetServiceID(companyGuid));
                    signPRS.setWctAccountGuid(accountGuid);
                    Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
                    String signInfo = gson.toJson((Object)signPRS);
                    LOG.error("getSubscriptionURL body={}", (Object)signInfo);
                    tokenRespone = this.RequestToPRS("/api/sub/token", RequestMethod.POST, signInfo, companyGuid);
                    GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)IssueStatus.OK.toString(), (String)companyGuid);
                    LOG.error("getSubscriptionURL responne={}", (Object)tokenRespone);
                    if (StringUtil.IsStringNullorEmpty((String)tokenRespone)) break block6;
                    GsonBuilder gsonb = new GsonBuilder();
                    Gson gsonRespone = gsonb.create();
                    SubRespone subRespone = (SubRespone)gsonRespone.fromJson(tokenRespone, SubRespone.class);
                    if (subRespone == null) break block7;
                    switch (subRespone.getStatus()) {
                        case 0: 
                        case 200: {
                            String token = (String)subRespone.getData();
                            if (!StringUtil.IsStringNullorEmpty((String)token)) {
                                return this.GetSUBSCRIPTION_WEB_URL() + token;
                            }
                            LOG.error("getSubscriptionURL Fail subRespone can't resolve subRespone={}", (Object)subRespone);
                            break block8;
                        }
                        case 403: {
                            LOG.debug("getSubscriptionURL account not access ={}", (Object)subRespone.getMessage());
                            Account account = this.accountDao.findOne(subRespone.getMessage());
                            if (account != null) {
                                LOG.debug("getSubscriptionURL account  ={}", (Object)account.getDisplayName());
                                throw new PermissionDeniedException("getSubscriptionURL account not found account", account.getDisplayName());
                            }
                            LOG.debug("getSubscriptionURL account not found account  ={}", (Object)subRespone.getMessage());
                            throw new PermissionDeniedException(subRespone.getMessage());
                        }
                        default: {
                            LOG.error("getSubscriptionURL unknow error   subRespone={}", (Object)subRespone);
                            throw new PermissionDeniedException("Subscription server return unknown error ");
                        }
                    }
                }
                LOG.error("getSubscriptionURL Fail subRespone can't resolve signRespone={}", (Object)tokenRespone);
                break block8;
            }
            LOG.error("getSubscriptionURL Fail respone null");
        }
        return null;
    }

    public ServerType GetServerType() {
        LOG.debug("ServerType={}", (Object)this.serverType);
        ServerType svrType = ServerType.valueOf((String)this.serverType);
        LOG.debug("ServerTypeA={}", (Object)svrType);
        return svrType;
    }

    public boolean IsCurrentLocateSupportSubscription() {
        ServerType serverType = this.GetServerType();
        switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ServerType[serverType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        String checkRespone = "";
        try {
            checkRespone = this.RequestToPRS("/country/can_subscribe", RequestMethod.GET, "", "");
        }
        catch (ItemNotFoundException e) {
            Globalinfo globalinfo = this.globalInfoService.getPropertiesByKey("CAN_SUPPORTED_SUBSCRIPTION");
            if (globalinfo != null) {
                boolean cansupportSubscribFromLog = Boolean.parseBoolean(globalinfo.getConfigValue());
                return cansupportSubscribFromLog;
            }
            throw new ItemNotFoundException("Connect to subscription server fail");
        }
        LOG.debug("IsCurrentLocateSupportSubscription ={}", (Object)checkRespone);
        if (!StringUtil.IsStringNullorEmpty((String)checkRespone)) {
            GsonBuilder gsonb = new GsonBuilder();
            Gson gsonRespone = gsonb.create();
            SubRespone subRespone = (SubRespone)gsonRespone.fromJson(checkRespone, SubRespone.class);
            if (subRespone != null) {
                boolean cansupportSubscrib = (Boolean)subRespone.getData();
                Globalinfo globalinfo = this.globalInfoService.getPropertiesByKey("CAN_SUPPORTED_SUBSCRIPTION");
                if (globalinfo == null) {
                    this.globalInfoService.createNewProperties("CAN_SUPPORTED_SUBSCRIPTION", subRespone.getData().toString());
                } else {
                    this.globalInfoService.updatePropertyValue(globalinfo.getGuid(), subRespone.getData().toString());
                }
                LOG.info("ConvertGlobalInfoToCompanyGlobalInfo end");
                return cansupportSubscrib;
            }
            LOG.error("IsCurrentLocateSupportSubscription Fail subRespone can't resolve subRespone={}", (Object)subRespone);
        } else {
            LOG.error("IsCurrentLocateSupportSubscription Fail respone null");
        }
        return false;
    }

    public void CheckDBSign(String companyGuid) {
        String SignID = this.getPropty("SUBSCRIBE_TEMPLATE_SIGNID", companyGuid);
        if (StringUtil.IsStringNullorEmpty((String)SignID)) {
            this.SignDBSign(companyGuid);
        }
        if (StringUtil.IsStringNullorEmpty((String)(SignID = this.getPropty("SUBSCRIBE_TEMPLATE_SIGNID", companyGuid)))) {
            return;
        }
        SignPRS signPRS = new SignPRS();
        signPRS.setSignInDailyGuid(SignID);
        String dbSign = this.getPropty("SUBSCRIBE_DATABASE_SIGN", companyGuid);
        signPRS.setDbsign(dbSign);
        String serviceID = this.GetServiceID(companyGuid);
        signPRS.setServiceId(serviceID);
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        signPRS.setMacaddress(macAddress);
        String ip = HardwareIdUtil.GetCurrentNetIP();
        signPRS.setIp(ip);
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        String signInfo = gson.toJson((Object)signPRS);
        LOG.error("CheckDBSign body={}", (Object)signInfo);
        String checkRespone = this.RequestToPRS("/api/sub/check", RequestMethod.POST, signInfo, companyGuid);
        GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)IssueStatus.OK.toString(), (String)companyGuid);
        LOG.error("CheckDBSign responne={}", (Object)checkRespone);
        if (!StringUtil.IsStringNullorEmpty((String)checkRespone)) {
            GsonBuilder gsonb = new GsonBuilder();
            Gson gsonRespone = gsonb.create();
            SubCheckRespone subCheckRespone = (SubCheckRespone)gsonRespone.fromJson(checkRespone, SubCheckRespone.class);
            if (subCheckRespone != null) {
                SubCheckResult subCheckResult = (SubCheckResult)subCheckRespone.getData();
                if (subCheckResult != null) {
                    this.SetPropty("SUBSCRIBE_TEMPLATE_SIGNID", "", companyGuid);
                    DateTime currDt = new DateTime();
                    this.SetPropty("SUBSCRIBE_LASTCHECK_TIME", currDt.toString(), companyGuid);
                    this.SetPropty("SUBSCRIBE_CHECK_RESOULT", subCheckResult.getIssueStatus().toString(), companyGuid);
                    switch (1.$SwitchMap$com$penpower$worldcard$team$enums$IssueStatus[subCheckResult.getIssueStatus().ordinal()]) {
                        case 1: {
                            this.DupcateServiceID(serviceID, companyGuid);
                            this.DownloadSubscriptionInfo(companyGuid);
                            this.CheckLicenseValidate(companyGuid, false, null, true);
                            break;
                        }
                        case 2: {
                            this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.SUBSCRIPTION_DUPLICATE_SERVICE, "", null, companyGuid);
                            break;
                        }
                    }
                } else {
                    LOG.error("CheckDBSign Fail subRespone can't resolve subCheckRespone={}", (Object)subCheckRespone);
                }
            } else {
                LOG.error("CheckDBSign Fail subRespone can't resolve checkRespone={}", (Object)checkRespone);
            }
        } else {
            LOG.error("CheckDBSign Fail respone null");
        }
    }

    public void SignDBSign(String companyGuid) {
        SignPRS signPRS = new SignPRS();
        String dbSign = this.getPropty("SUBSCRIBE_DATABASE_SIGN", companyGuid);
        signPRS.setDbsign(dbSign);
        String serviceID = this.GetServiceID(companyGuid);
        signPRS.setServiceId(serviceID);
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        signPRS.setMacaddress(macAddress);
        String ip = HardwareIdUtil.GetCurrentNetIP();
        signPRS.setIp(ip);
        signPRS.setWctVersione("8.1.0.0");
        signPRS.setWebVersion("1.8.9");
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        signPRS.setSignInDate(LocalDate.now());
        String signInfo = gson.toJson((Object)signPRS);
        LOG.error("SignDBSign body={}", (Object)signInfo);
        String signRespone = this.RequestToPRS("/api/sub/sign_in", RequestMethod.POST, signInfo, companyGuid);
        GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)IssueStatus.OK.toString(), (String)companyGuid);
        LOG.error("SignDBSign responne={}", (Object)signRespone);
        if (!StringUtil.IsStringNullorEmpty((String)signRespone)) {
            Gson gsonRespone = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
            SubRespone subRespone = (SubRespone)gsonRespone.fromJson(signRespone, SubRespone.class);
            if (subRespone != null) {
                String signGUID = (String)subRespone.getData();
                if (!StringUtil.IsStringNullorEmpty((String)signGUID)) {
                    this.SetPropty("SUBSCRIBE_TEMPLATE_SIGNID", signGUID, companyGuid);
                    return;
                }
                LOG.error("SignDBSign Fail subRespone can't resolve subRespone={}", (Object)subRespone);
            } else {
                LOG.error("SignDBSign Fail subRespone can't resolve signRespone={}", (Object)signRespone);
            }
        } else {
            LOG.error("SignDBSign Fail respone null");
        }
    }

    private void BuyOutByReedm(String ReedeemCode, String companyGuid) {
        BuyoutInfoVo buyoutInfoVo = new BuyoutInfoVo();
        buyoutInfoVo.setSerialNumber(ReedeemCode);
        buyoutInfoVo.setServiceId(this.GetServiceID(companyGuid));
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        String buyoutInfo = gson.toJson((Object)buyoutInfoVo);
        LOG.error("buyoutInfo body={}", (Object)buyoutInfo);
        String buyoutRespone = this.RequestToPRS("/api/sub/add_license", RequestMethod.POST, buyoutInfo, companyGuid);
        LOG.error("buyoutRespone responne={}", (Object)buyoutRespone);
        if (!StringUtil.IsStringNullorEmpty((String)buyoutRespone)) {
            GsonBuilder gsonb = new GsonBuilder();
            Gson gsonRespone = gsonb.create();
            SubRespone subRespone = (SubRespone)gsonRespone.fromJson(buyoutRespone, SubRespone.class);
            if (subRespone != null) {
                switch (subRespone.getStatus()) {
                    case 403: {
                        LOG.error("buyoutRespone Fail  subRespone={}", (Object)subRespone);
                        throw new PermissionDeniedException("serial number is used.");
                    }
                    case 404: {
                        LOG.error("buyoutRespone Fail  subRespone={}", (Object)subRespone);
                        throw new IncorrectRegistrationInformationException("serial number is invalidate");
                    }
                }
                if (((String)subRespone.getData()).compareToIgnoreCase(ReedeemCode) == 0) {
                    return;
                }
                LOG.error("buyoutRespone Fail  subRespone={}", (Object)subRespone);
            } else {
                LOG.error("buyoutRespone Fail subRespone can't resolve initRespone={}", (Object)subRespone);
            }
        } else {
            LOG.error("buyoutRespone Fail respone null");
        }
        throw new IncorrectRegistrationInformationException("buyoutRespone data invalid.");
    }

    private void SubscribByRedeem(String ReedeemCode, String companyGuid) {
        if (this.CheckSerialBelongSubscription(ReedeemCode)) {
            SubscriptionInfoVo subscriptionInfoVo = new SubscriptionInfoVo();
            subscriptionInfoVo.setSubscriberCreateType(SubscriberCreateType.SUBSCRIPTION_BY_SERIAL);
            subscriptionInfoVo.setWctVersione("8.1.0.0");
            subscriptionInfoVo.setWebVersion("1.8.9");
            subscriptionInfoVo.setServiceId(ReedeemCode);
            subscriptionInfoVo.setOldServiceId(this.GetServiceID(companyGuid));
            String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
            subscriptionInfoVo.setMacaddress(macAddress);
            Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
            String initInfo = gson.toJson((Object)subscriptionInfoVo);
            LOG.error("InitialToPRS body={}", (Object)initInfo);
            String initRespone = this.RequestToPRS("/api/sub/service_id", RequestMethod.POST, initInfo, companyGuid);
            LOG.error("InitialToPRS responne={}", (Object)initRespone);
            if (!StringUtil.IsStringNullorEmpty((String)initRespone)) {
                GsonBuilder gsonb = new GsonBuilder();
                Gson gsonRespone = gsonb.create();
                SubRespone subRespone = (SubRespone)gsonRespone.fromJson(initRespone, SubRespone.class);
                if (subRespone != null) {
                    String ServicdID = (String)subRespone.getData();
                    if (!StringUtil.IsStringNullorEmpty((String)ServicdID)) {
                        this.SetServiceID(ServicdID, companyGuid);
                        return;
                    }
                    LOG.error("InitialToPRS Fail subRespone can't resolve subRespone={}", (Object)subRespone);
                } else {
                    LOG.error("InitialToPRS Fail subRespone can't resolve initRespone={}", (Object)initRespone);
                }
            } else {
                LOG.error("InitialToPRS Fail respone null");
            }
        } else {
            LOG.error("InitialToPRS Fail respone null");
        }
        throw new IncorrectRegistrationInformationException("subscriptionn data invalid.");
    }

    public void CommitByRedeem(String ReedeemCode, String companyGuid) {
        if (this.GetServerType() == ServerType.QNAP_NAS) {
            this.BuyOutByReedm(ReedeemCode, companyGuid);
        } else {
            this.SubscribByRedeem(ReedeemCode, companyGuid);
        }
    }

    public void CheckLicenseValidate(String companyGuid, boolean IsNeedToInvalidateToken, AccountInfo currentLoginAccount, boolean hideAccountInNotice) {
        int validateAcntCount = 0;
        SubscriptionInfoVo subscriptionInfoVo = this.getSubscriptionInfo(companyGuid);
        LOG.debug("CheckLicenseValidate subscriptionInfoVo ={}", (Object)subscriptionInfoVo);
        if (subscriptionInfoVo != null) {
            validateAcntCount = subscriptionInfoVo.checkCurrentAccountCountLimit();
            if (subscriptionInfoVo.checkCurrentPeriod() == null) {
                LOG.debug("CheckLicenseValidate UpdateAllAccountToTemplateInvalidate 1");
                this.accountService.UpdateAllAccountToTemplateInvalidate(IsNeedToInvalidateToken, companyGuid, currentLoginAccount, AccountLockCase.SUBSCRIPTION_EXPIRED, hideAccountInNotice);
                return;
            }
        }
        LOG.debug("CheckLicenseValidate validateAcntCount ={}", (Object)validateAcntCount);
        List accountInfos = this.accountService.getAccountInfos(companyGuid);
        LOG.debug("CheckLicenseValidate accountInfossize ={}", (Object)accountInfos.size());
        List accountsGuidsInSubscription = accountInfos.stream().filter(account -> AccountLockedIssue.NO_ISSUE.equals((Object)account.getLockedIssue())).filter(account -> UserStatus.ACTIVE.equals((Object)account.getStatus()) || UserStatus.INACTIVE.equals((Object)account.getStatus())).map(account -> account.getGuid()).collect(Collectors.toList());
        LOG.debug("CheckLicenseValidate accountsGuidsInSubscriptionsize ={}", (Object)accountsGuidsInSubscription.size());
        if (accountsGuidsInSubscription.size() > validateAcntCount) {
            if (validateAcntCount == 0) {
                LOG.debug("CheckLicenseValidate UpdateAllAccountToTemplateInvalidate 2");
                this.accountService.UpdateAllAccountToTemplateInvalidate(IsNeedToInvalidateToken, companyGuid, currentLoginAccount, AccountLockCase.SUBSCRIPTION_EXPIRED, hideAccountInNotice);
            } else {
                this.accountService.UpdateAllAccountToTemplateInvalidate(IsNeedToInvalidateToken, companyGuid, currentLoginAccount, AccountLockCase.SUBSCRIPTION_REDUCE, hideAccountInNotice);
            }
        }
    }

    private static LocalDateTime JodaTimeToJavaTime(DateTime dt) {
        LocalDateTime currTime = LocalDateTime.of(dt.getYear(), dt.getMonthOfYear(), dt.getDayOfMonth(), dt.getHourOfDay(), dt.getMinuteOfHour(), dt.getSecondOfMinute(), dt.getMillisOfSecond());
        return currTime;
    }

    public void MakeDataBaseSign(String companyGuid) {
        LocalDate today = LocalDate.now();
        SubscribeDBSign SDBS = new SubscribeDBSign();
        Sort sortnew = new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "logintime")});
        PageRequest newpageRequest = new PageRequest(0, 1, sortnew);
        List accountloginrecords = this.accountLoginRecordDao.FindWithCompanyGuid(companyGuid, (Pageable)newpageRequest).getContent();
        LOG.debug("MakeDataBaseSign COMPANYGUID={},accountloginrecordsize ={} ", (Object)accountloginrecords.size());
        if (accountloginrecords != null && accountloginrecords.size() > 0) {
            LOG.debug("MakeDataBaseSign COMPANYGUID={},accountloginrecord ={} ", (Object)companyGuid, (Object)((Accountloginrecord)accountloginrecords.get(0)).getLogintime());
            SDBS.setLastLoginTime(SubscriptionServiceImpl.JodaTimeToJavaTime((DateTime)((Accountloginrecord)accountloginrecords.get(0)).getLogintime()));
        }
        List acounts = this.accountService.getAccountInfos(companyGuid);
        SDBS.setActivedAccountNum((long)acounts.size());
        SDBS.setContacNum(this.contactPrivateService.getContactNumByAll(companyGuid).longValue());
        Contact contact = this.contactPrivateService.getLastModifyContact(companyGuid);
        if (contact != null) {
            LOG.debug("MakeDataBaseSign COMPANYGUID={},getModifyTime ={} ", (Object)companyGuid, (Object)contact.getModifyTime());
            SDBS.setLastUpdateCnntactTime(SubscriptionServiceImpl.JodaTimeToJavaTime((DateTime)contact.getModifyTime()));
        }
        SDBS.setToday(today);
        SDBS.setVersion("1.8.9(8.1.0.0)");
        if (this.getPropty("HAVE_SET_BOSS", companyGuid).length() > 0) {
            SDBS.setIshasboss(true);
        } else {
            SDBS.setIshasboss(false);
        }
        if (this.getPropty("HAVE_SCAN_BY_SECRETARY", companyGuid).length() > 0) {
            SDBS.setIsUseSecretary(true);
        } else {
            SDBS.setIsUseSecretary(false);
        }
        if (this.getPropty("HAVE_SET_SALSEFORCE", companyGuid).length() > 0) {
            SDBS.setIsSetSaleforce(true);
        } else {
            SDBS.setIsSetSaleforce(false);
        }
        DateTime currDatetime = new DateTime();
        DateTime startDateTime = new DateTime(currDatetime.getYear(), currDatetime.getMonthOfYear(), currDatetime.getDayOfMonth(), 0, 0, 0);
        DateTime endDateTime = new DateTime(currDatetime.getYear(), currDatetime.getMonthOfYear(), currDatetime.getDayOfMonth(), 23, 59, 59);
        SDBS.setcpu95upp(this.systemMonitorDao.CountByUsageLageThanByTimeRange(95.0, startDateTime, endDateTime).longValue());
        SDBS.setcpu90upp(this.systemMonitorDao.CountByUsageLageThanByTimeRange(90.0, startDateTime, endDateTime).longValue());
        SDBS.setcpu80upp(this.systemMonitorDao.CountByUsageLageThanByTimeRange(80.0, startDateTime, endDateTime).longValue());
        SDBS.setcpu65upp(this.systemMonitorDao.CountByUsageLageThanByTimeRange(65.0, startDateTime, endDateTime).longValue());
        SDBS.setcpu45upp(this.systemMonitorDao.CountByUsageLageThanByTimeRange(45.0, startDateTime, endDateTime).longValue());
        SDBS.setrespone10up(this.logPerformanceDao.CountConsumetimeLageThanByTimeRange(10000L, startDateTime, endDateTime).longValue());
        SDBS.setrespone5up(this.logPerformanceDao.CountConsumetimeLageThanByTimeRange(5000L, startDateTime, endDateTime).longValue());
        SDBS.setrespone3up(this.logPerformanceDao.CountConsumetimeLageThanByTimeRange(3000L, startDateTime, endDateTime).longValue());
        SDBS.setrespone1up(this.logPerformanceDao.CountConsumetimeLageThanByTimeRange(1000L, startDateTime, endDateTime).longValue());
        SDBS.setresponeAll(this.logPerformanceDao.CountConsumetimeLageThanByTimeRange(0L, startDateTime, endDateTime).longValue());
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        String dbSign = gson.toJson((Object)SDBS);
        LOG.debug("MAKEDBSIGN   dbSign={}", (Object)dbSign);
        this.SetPropty("SUBSCRIBE_DATABASE_SIGN", dbSign, companyGuid);
        this.SetPropty("SUBSCRIBE_TEMPLATE_SIGNID", "", companyGuid);
    }

    public boolean CheckSerialBelongSubscription(String SerialCode) {
        String SerialCodeEncode = SubscribCode.Encode((String)SerialCode, (ServerType)this.GetServerType());
        LOG.debug("CheckSerialBelongSubscription Encode ={}", (Object)SerialCodeEncode);
        String CheckSerialNumespone = this.RequestToPRS("/api/sub/checkXD?SerialCode=" + SerialCodeEncode, RequestMethod.POST, "", "");
        if (!StringUtil.IsStringNullorEmpty((String)CheckSerialNumespone)) {
            Gson gsonRespone = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
            SubRespone subRespone = (SubRespone)gsonRespone.fromJson(CheckSerialNumespone, SubRespone.class);
            if (subRespone != null) {
                String BelongSubscription = (String)subRespone.getData();
                if (!StringUtil.IsStringNullorEmpty((String)BelongSubscription)) {
                    if (BelongSubscription.compareToIgnoreCase("true") == 0) {
                        return true;
                    }
                } else {
                    LOG.error("CheckSerialBelongSubscription Fail subRespone can't resolve subRespone={}", (Object)BelongSubscription);
                }
            } else {
                LOG.error("CheckSerialBelongSubscription Fail subRespone can't resolve CheckSerialNumespone={}", (Object)CheckSerialNumespone);
            }
        } else {
            LOG.error("CheckSerialBelongSubscription Fail respone null");
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void DownloadSubscriptionInfo(String companyGuid) {
        String serviceID = this.GetServiceID(companyGuid);
        LOG.error("DownloadSubscriptionInfo ={}", (Object)serviceID);
        if (!StringUtil.IsStringNullorEmpty((String)serviceID)) {
            String SubInfoRespone = this.RequestToPRS("/api/sub/" + serviceID, RequestMethod.GET, "", companyGuid);
            GlobalUtils.setProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_CHECK_CONNECT_STATUS", (String)IssueStatus.OK.toString(), (String)companyGuid);
            LOG.error("DownloadSubscriptionInfo ={}", (Object)SubInfoRespone);
            if (!StringUtil.IsStringNullorEmpty((String)SubInfoRespone)) {
                GsonBuilder gsonb = new GsonBuilder();
                Gson gsonRespone = gsonb.create();
                SubRespone subRespone = (SubRespone)gsonRespone.fromJson(SubInfoRespone, SubRespone.class);
                if (subRespone != null) {
                    if (subRespone.getStatus() == 404) {
                        this.SetPropty("SUBSCRIBE_INFO", "", companyGuid);
                        LOG.error("DownloadSubscriptionInfo Fail item not found.");
                    } else {
                        String SubscriptionInfo = (String)subRespone.getData();
                        if (!StringUtil.IsStringNullorEmpty((String)SubscriptionInfo)) {
                            this.SetPropty("SUBSCRIBE_INFO", SubscriptionInfo, companyGuid);
                            this.StartCheckLastValidateTime(companyGuid);
                        } else {
                            LOG.error("DownloadSubscriptionInfo Fail subRespone can't resolve SubscriptionInfo={}", (Object)SubscriptionInfo);
                        }
                    }
                } else {
                    LOG.error("DownloadSubscriptionInfo Fail subRespone can't resolve subRespone={}", (Object)subRespone);
                }
            } else {
                LOG.error("DownloadSubscriptionInfo Fail respone null");
            }
        } else {
            LOG.error("DownloadSubscriptionInfo no serviceID");
        }
    }

    public void CheckLastValidateTime() {
    }

    public void StartCheckLastValidateTime(String companyGuid) {
        LOG.debug("StartCheckLastValidateTime Start ");
        SubscriptionInfoVo subscriptionInfoVo = this.getSubscriptionInfo(companyGuid);
        DateTime lastValidateTime = subscriptionInfoVo.checkLastValidateTime();
        if (this.jobIdentify != null) {
            this.scheduleManager.deleteSchedule(this.jobIdentify);
            this.jobIdentify = null;
        }
        if (lastValidateTime != null) {
            this.jobIdentify = new JobIdentify("CHECK_SUBSCRIPTION_VALIDATE_JOG" + UUIDGenerator.getRandomUUID(), CheckSubscriptionValidateJob.class);
            LOG.debug("StartCheckLastValidateTime job lastValidateTime ={}", (Object)lastValidateTime);
            Date lastValidateDate = lastValidateTime.toDate();
            LOG.debug("StartCheckLastValidateTime job lastValidateDate ={}", (Object)lastValidateDate);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("COMPANY_GUID", companyGuid);
            this.scheduleManager.startScheduleOnce(this.jobIdentify, lastValidateTime.toDate(), dataMap);
        }
    }

    public void DupcateServiceID(String oldServiceID, String companyGuid) {
        SubscriptionInfoVo subscriptionInfoVo = new SubscriptionInfoVo();
        subscriptionInfoVo.setOldServiceId(oldServiceID);
        subscriptionInfoVo.setSubscriberCreateType(SubscriberCreateType.ILLEGAL_DUPCATE);
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        subscriptionInfoVo.setMacaddress(macAddress);
        subscriptionInfoVo.setWctVersione("8.1.0.0");
        subscriptionInfoVo.setWebVersion("1.8.9");
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        String initInfo = gson.toJson((Object)subscriptionInfoVo);
        LOG.error("InitialToPRS body={}", (Object)initInfo);
        String initRespone = this.RequestToPRS("/api/sub/service_id", RequestMethod.POST, initInfo, companyGuid);
        LOG.error("InitialToPRS responne={}", (Object)initRespone);
        if (!StringUtil.IsStringNullorEmpty((String)initRespone)) {
            GsonBuilder gsonb = new GsonBuilder();
            Gson gsonRespone = gsonb.create();
            SubRespone subRespone = (SubRespone)gsonRespone.fromJson(initRespone, SubRespone.class);
            if (subRespone != null) {
                String ServicdID = (String)subRespone.getData();
                if (!StringUtil.IsStringNullorEmpty((String)ServicdID)) {
                    this.SetServiceID(ServicdID, companyGuid);
                    return;
                }
                LOG.error("InitialToPRS Fail subRespone can't resolve subRespone={}", (Object)subRespone);
            } else {
                LOG.error("InitialToPRS Fail subRespone can't resolve initRespone={}", (Object)initRespone);
            }
        } else {
            LOG.error("InitialToPRS Fail respone null");
        }
        throw new IncorrectRegistrationInformationException("subscriptionn data invalid.");
    }

    public void ConvertToSubscription(String eMail, String CompanyName, String Telphone, Country country, String contactName, long serviceDayLeft, String companyGuid) {
        SubscriptionInfoVo subscriptionInfoVo = new SubscriptionInfoVo();
        subscriptionInfoVo.setCompanyName(CompanyName);
        subscriptionInfoVo.setCoutryID(country.toString());
        subscriptionInfoVo.setEmail(eMail);
        subscriptionInfoVo.setPhone(Telphone);
        subscriptionInfoVo.setServiceDays(serviceDayLeft);
        subscriptionInfoVo.setContactName(contactName);
        subscriptionInfoVo.setSubscriberCreateType(SubscriberCreateType.REGISTER_TRANSER);
        subscriptionInfoVo.setWctVersione("8.1.0.0");
        subscriptionInfoVo.setWebVersion("1.8.9");
        String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
        subscriptionInfoVo.setMacaddress(macAddress);
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        String initInfo = gson.toJson((Object)subscriptionInfoVo);
        LOG.error("InitialToPRS body={}", (Object)initInfo);
        String initRespone = this.RequestToPRS("/api/sub/service_id", RequestMethod.POST, initInfo, companyGuid);
        LOG.error("InitialToPRS responne={}", (Object)initRespone);
        if (!StringUtil.IsStringNullorEmpty((String)initRespone)) {
            GsonBuilder gsonb = new GsonBuilder();
            Gson gsonRespone = gsonb.create();
            SubRespone subRespone = (SubRespone)gsonRespone.fromJson(initRespone, SubRespone.class);
            if (subRespone != null) {
                String ServicdID = (String)subRespone.getData();
                if (!StringUtil.IsStringNullorEmpty((String)ServicdID)) {
                    this.SetServiceID(ServicdID, companyGuid);
                    return;
                }
                LOG.error("InitialToPRS Fail subRespone can't resolve subRespone={}", (Object)subRespone);
            } else {
                LOG.error("InitialToPRS Fail subRespone can't resolve initRespone={}", (Object)initRespone);
            }
        } else {
            LOG.error("InitialToPRS Fail respone null");
        }
        throw new IncorrectRegistrationInformationException("subscriptionn data invalid.");
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void Initial(String eMail, String CompanyName, String Telphone, Country country, String contactName, int accountNum, LocalDate validateDate, SubscriberCreateType subscriberCreateType, String SerialCode, String companyGuid) {
        block8: {
            block6: {
                String initRespone;
                block7: {
                    SubscriptionInfoVo subscriptionInfoVo = new SubscriptionInfoVo();
                    subscriptionInfoVo.setCompanyName(CompanyName);
                    if (country != null) {
                        subscriptionInfoVo.setCoutryID(country.toString());
                    } else {
                        subscriptionInfoVo.setCoutryID(Country.Taiwan.toString());
                    }
                    subscriptionInfoVo.setEmail(eMail);
                    subscriptionInfoVo.setPhone(Telphone);
                    subscriptionInfoVo.setServiceDays(180L);
                    subscriptionInfoVo.setContactName(contactName);
                    subscriptionInfoVo.setSubscriberCreateType(subscriberCreateType);
                    subscriptionInfoVo.setWctVersione("8.1.0.0");
                    subscriptionInfoVo.setWebVersion("1.8.9");
                    subscriptionInfoVo.setAccountNum(accountNum);
                    subscriptionInfoVo.setValidateDate(validateDate);
                    subscriptionInfoVo.setServiceId(SerialCode);
                    subscriptionInfoVo.setCurrentDateTime(DateTime.now());
                    String macAddress = HardwareIdUtil.getEthernetInterfaceMac((ServerType)this.GetServerType());
                    subscriptionInfoVo.setMacaddress(macAddress);
                    Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).registerTypeAdapter(DateTime.class, (Object)new JodaDateTime2PRSAdapter()).setDateFormat(0, 0).create();
                    LOG.error("InitialToPRS subscriptionInfoVo={}", (Object)subscriptionInfoVo);
                    String initInfo = gson.toJson((Object)subscriptionInfoVo);
                    LOG.error("InitialToPRS body={}", (Object)initInfo);
                    initRespone = this.RequestToPRS("/api/sub/service_id", RequestMethod.POST, initInfo, companyGuid);
                    LOG.error("InitialToPRS responne={}", (Object)initRespone);
                    if (StringUtil.IsStringNullorEmpty((String)initRespone)) break block6;
                    GsonBuilder gsonb = new GsonBuilder();
                    Gson gsonRespone = gsonb.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
                    SubRespone subRespone = (SubRespone)gsonRespone.fromJson(initRespone, SubRespone.class);
                    if (subRespone == null) break block7;
                    switch (subRespone.getStatus()) {
                        default: {
                            String ServicdID = (String)subRespone.getData();
                            if (!StringUtil.IsStringNullorEmpty((String)ServicdID)) {
                                this.SetServiceID(ServicdID, companyGuid);
                                return;
                            }
                            LOG.error("InitialToPRS Fail subRespone can't resolve subRespone={}", (Object)subRespone);
                            break block8;
                        }
                        case 409: {
                            LOG.error("InitialToPRS timeDefferenceResult={}", (Object)subRespone.getMessage());
                            String timedefinejson = subRespone.getMessage();
                            TimeDefferenceResult timeDefferenceResult = (TimeDefferenceResult)gsonRespone.fromJson(timedefinejson, TimeDefferenceResult.class);
                            LOG.error("InitialToPRS TimeDefferenceResult={}", (Object)timeDefferenceResult);
                            Duration duration = Duration.between(timeDefferenceResult.getClientRequestTime(), timeDefferenceResult.getServerReceiveRequestTime());
                            DifferentTimeDetail detail = new DifferentTimeDetail(duration.toHours(), duration.toMinutes() % 60L, duration.getSeconds() % 60L);
                            LOG.debug("detail :{} ", (Object)detail);
                            DifferentTimeVo differentTime = new DifferentTimeVo(timeDefferenceResult.getClientRequestTime(), timeDefferenceResult.getServerReceiveRequestTime(), detail);
                            LOG.debug("differentTime : {} ", (Object)differentTime);
                            throw new DifferentTimeException(differentTime, String.format("Login failed , client and server time different value was larger than %d seconds.", 300));
                        }
                    }
                }
                LOG.error("InitialToPRS Fail subRespone can't resolve initRespone={}", (Object)initRespone);
                break block8;
            }
            LOG.error("InitialToPRS Fail respone null");
        }
        throw new IncorrectRegistrationInformationException("subscriptionn data invalid.");
    }

    public void freeTrialServerStartup() {
        Path wctServerInfoPath = Paths.get(this.context.getRealPath(""), new String[0]).getParent();
        Gson gson = new Gson();
        if (Files.exists(wctServerInfoPath, new LinkOption[0])) {
            Path wctInfoFile = wctServerInfoPath.resolve("wct_info.json");
            try (FileReader fr = new FileReader(wctInfoFile.toFile());){
                WctInfo wctInfo = (WctInfo)gson.fromJson((Reader)fr, WctInfo.class);
                FreeTrialServerStartupVo freeTrialServerStartupVo = new FreeTrialServerStartupVo();
                freeTrialServerStartupVo.setIp(wctInfo.getIp());
                freeTrialServerStartupVo.setPort(wctInfo.getPort());
                LOG.info("FreeTrial Server startup success: ip:{}, port:{}", (Object)wctInfo.getIp(), (Object)wctInfo.getPort());
                String startupVo = gson.toJson((Object)freeTrialServerStartupVo);
                LOG.error("FreeTrialServerStartup body={}", (Object)startupVo);
                String startupRespone = this.RequestToPRS("/api/sub/free_trial_server_startup", RequestMethod.POST, startupVo, "");
                LOG.error("FreeTrialServerStartup responne={}", (Object)startupRespone);
                Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
                if (maxCompanyCount == null) {
                    this.globalInfoService.createNewProperties("MAX_COMPANY_COUNT", wctInfo.getMaxCompanyCount());
                } else {
                    this.globalInfoService.updatePropertyValue(maxCompanyCount.getGuid(), wctInfo.getMaxCompanyCount());
                }
                Globalinfo maxAccountCount = this.globalInfoService.getPropertiesByKey("MAX_ACCOUNT_COUNT");
                if (maxAccountCount == null) {
                    this.globalInfoService.createNewProperties("MAX_ACCOUNT_COUNT", wctInfo.getMaxAccountCount());
                } else {
                    this.globalInfoService.updatePropertyValue(maxAccountCount.getGuid(), wctInfo.getMaxAccountCount());
                }
                Globalinfo dispatchServerURL = this.globalInfoService.getPropertiesByKey("DISPATCH_SERVER_URL");
                if (dispatchServerURL == null) {
                    this.globalInfoService.createNewProperties("DISPATCH_SERVER_URL", wctInfo.getDispatchServerIP());
                } else {
                    this.globalInfoService.updatePropertyValue(dispatchServerURL.getGuid(), wctInfo.getDispatchServerIP());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public LicenseVo GetLicense(String companyGuid) {
        List companys = this.companyService.FindAllCompany();
        Company currcompany = null;
        for (Company company : companys) {
            if (company.getGuid().compareToIgnoreCase(companyGuid) != 0) continue;
            currcompany = company;
            break;
        }
        LicenseVo lv = null;
        if (currcompany != null) {
            lv = this.databaseSystemSettingService.GetLicense(currcompany.getGuid());
        } else {
            lv = new LicenseVo();
            lv.setServerRegisterStatus(ServerRegisterStatus.NONE);
            lv.setSubscriptionStatus(SubscriptionStatus.NONE);
            lv.setLicenseMode(LicenseMode.NONE);
        }
        return lv;
    }

    public String getCompanyIDByServiceID(String ServiceID) {
        List companys = this.companyService.FindAllCompany();
        long accountCount = 0L;
        for (Company company : companys) {
            String currServiceID = GlobalUtils.getProperty((CompanyGlobalInfoService)this.companyGlobalInfoService, (String)"SUBSCRIBE_SERVICEID", (String)company.getGuid());
            if (currServiceID.compareToIgnoreCase(ServiceID) != 0 || StringUtil.IsStringNullorEmpty((String)ServiceID)) continue;
            return company.getGuid();
        }
        throw new ItemNotFoundException("No serviceID");
    }

    public void MessageToDispatchServerReady() {
        Path wctServerInfoPath = Paths.get(this.context.getRealPath(""), new String[0]).getParent();
        Gson gson = new Gson();
        if (Files.exists(wctServerInfoPath, new LinkOption[0])) {
            Path wctInfoFile = wctServerInfoPath.resolve("wct_info.json");
            try (FileReader fr = new FileReader(wctInfoFile.toFile());){
                WctInfo wctInfo = (WctInfo)gson.fromJson((Reader)fr, WctInfo.class);
                WCTStartupNotice wctStartupNotice = new WCTStartupNotice();
                wctStartupNotice.setIp(wctInfo.getIp());
                wctStartupNotice.setPort(wctInfo.getPort());
                Gson gsonStartupnotic = new GsonBuilder().setPrettyPrinting().create();
                String string = gsonStartupnotic.toJson((Object)wctStartupNotice);
            }
            catch (Exception e) {
                LOG.error("MessageToDispatchServerReady error={}", (Object)e.getMessage());
            }
        } else {
            LOG.error("MessageToDispatchServerReady wctinfo not exist");
        }
    }

    public String RequestToDispatchServerPassByPRS(String apiUrl, String bodyString) {
        PassToDMBody passToDMBody = new PassToDMBody();
        passToDMBody.setApiName(apiUrl);
        passToDMBody.setJsonBody(bodyString);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String passToDMBodyString = gson.toJson((Object)passToDMBody);
        String respone = this.RequestToPRS("/api/sub/trans_to_dm", RequestMethod.POST, passToDMBodyString, "");
        LOG.debug("RequestToDispatchServerPassByPRS respone={}", (Object)respone);
        return respone;
    }

    public String RequestToDispatchServerFromFreeTrialPassByPRS(String apiUrl, String bodyString) {
        PassToDMBody passToDMBody = new PassToDMBody();
        passToDMBody.setApiName(apiUrl);
        passToDMBody.setJsonBody(bodyString);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String passToDMBodyString = gson.toJson((Object)passToDMBody);
        String respone = this.RequestToPRS("/api/sub/trans_to_dm_from_freetrial", RequestMethod.POST, passToDMBodyString, "");
        LOG.debug("RequestToDispatchServerFromFreeTrialPassByPRS respone={}", (Object)respone);
        return respone;
    }

    public void googleCloudServerStartup() {
        Path wctServerInfoPath = Paths.get(this.context.getRealPath(""), new String[0]).getParent();
        Gson gson = new Gson();
        if (Files.exists(wctServerInfoPath, new LinkOption[0])) {
            Path wctInfoFile = wctServerInfoPath.resolve("wct_info.json");
            try (FileReader fr = new FileReader(wctInfoFile.toFile());){
                WctInfo wctInfo = (WctInfo)gson.fromJson((Reader)fr, WctInfo.class);
                FreeTrialServerStartupVo googleCloudServerStartupVo = new FreeTrialServerStartupVo();
                googleCloudServerStartupVo.setIp(wctInfo.getIp());
                googleCloudServerStartupVo.setPort(wctInfo.getPort());
                googleCloudServerStartupVo.setCustomized(wctInfo.isCustomized());
                googleCloudServerStartupVo.setMaxAccountCount(Long.valueOf(wctInfo.getMaxAccountCount()).longValue());
                googleCloudServerStartupVo.setSalesAgent(wctInfo.getSalesAgent());
                LOG.info("Google cloud linux server startup success: ip:{}, port:{}", (Object)wctInfo.getIp(), (Object)wctInfo.getPort());
                String startupVo = gson.toJson((Object)googleCloudServerStartupVo);
                LOG.error("GoogleCloudServerStartup body={}", (Object)startupVo);
                String startupRespone = this.RequestToPRS("/api/sub/cloud_server_startup", RequestMethod.POST, startupVo, "");
                LOG.error("GoogleCloudServerStartup responne={}", (Object)startupRespone);
                Globalinfo maxCompanyCount = this.globalInfoService.getPropertiesByKey("MAX_COMPANY_COUNT");
                if (maxCompanyCount == null) {
                    this.globalInfoService.createNewProperties("MAX_COMPANY_COUNT", wctInfo.getMaxCompanyCount());
                } else {
                    this.globalInfoService.updatePropertyValue(maxCompanyCount.getGuid(), wctInfo.getMaxCompanyCount());
                }
                Globalinfo maxAccountCount = this.globalInfoService.getPropertiesByKey("MAX_ACCOUNT_COUNT");
                if (maxAccountCount == null) {
                    this.globalInfoService.createNewProperties("MAX_ACCOUNT_COUNT", wctInfo.getMaxAccountCount());
                } else {
                    this.globalInfoService.updatePropertyValue(maxAccountCount.getGuid(), wctInfo.getMaxAccountCount());
                }
                Globalinfo dispatchServerURL = this.globalInfoService.getPropertiesByKey("DISPATCH_SERVER_URL");
                if (dispatchServerURL == null) {
                    this.globalInfoService.createNewProperties("DISPATCH_SERVER_URL", wctInfo.getDispatchServerIP());
                } else {
                    this.globalInfoService.updatePropertyValue(dispatchServerURL.getGuid(), wctInfo.getDispatchServerIP());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

