/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.SessionDao;
import com.penpower.worldcard.team.entity.Session;
import com.penpower.worldcard.team.service.SessionService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SessionServiceImpl
implements SessionService {
    private static final Logger LOG = LoggerFactory.getLogger(SessionServiceImpl.class);
    @Autowired
    private SessionDao sessionDao;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void createSession(String currentToken, String itemKey, String itemValue) {
        Session session = new Session();
        session.setGuid(UUIDGenerator.getRandomUUID());
        session.setLoginToken(currentToken);
        session.setItemKey(itemKey);
        session.setItemValue(itemValue);
        LOG.debug("new session : {} ", (Object)session);
        this.sessionDao.save((Object)session);
    }

    public Session getSessionByKey(String key) {
        Session session = this.sessionDao.findByItemkey(key);
        return session;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void removeSessionByKey(String key) {
        this.sessionDao.deleteByItemkey(key);
    }

    public Session getSessionByLoginTokenAndItemKey(String currentLoginToken, String itemKey) {
        Session session = this.sessionDao.findByLogintokenAndItemkey(currentLoginToken, itemKey);
        return session;
    }

    public List<Session> getSessionByLoginToken(String logintoken) {
        List sessions = this.sessionDao.findByLogintoken(logintoken);
        return sessions;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void removeSessionByLogintokenAndItemkey(String logintoken, String itemkey) {
        this.sessionDao.deleteByLogintokenAndItemkey(logintoken, itemkey);
    }
}

