/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.config.ApplicationConfig;
import com.penpower.worldcard.team.dao.GlobalinfoDao;
import com.penpower.worldcard.team.dao.SearchEngineIndexingEventDao;
import com.penpower.worldcard.team.entity.Searchengineindexingevent;
import com.penpower.worldcard.team.service.SearchEngineIndexingEventService;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SearchEngineIndexingEventServiceImpl
implements SearchEngineIndexingEventService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchEngineIndexingEventServiceImpl.class);
    @Autowired
    private SearchEngineIndexingEventDao searchEngineIndexingEventDao;
    @Autowired
    private GlobalinfoDao globalinfoDao;

    public Page<Searchengineindexingevent> getSearchEngineIndexingEventAfterSpecificTime(DateTime elasticSearchLastEventCompleteTime, PageRequest pageRequest) {
        Page indexingPagedEvent = this.searchEngineIndexingEventDao.findSearchEngineIndexingEventAfterSpecificTime(elasticSearchLastEventCompleteTime, (Pageable)pageRequest);
        return indexingPagedEvent;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteExpiredSearchEngineIndexingEvent() {
        List dateTimeValues = this.globalinfoDao.findAllElasticSearchLastEventCompleteTime("ELASTIC_SEARCH_LAST_COMPLETE_EVENT_TIME_");
        if (dateTimeValues.isEmpty()) {
            return;
        }
        DateTime min = null;
        for (String dateTimeValue : dateTimeValues) {
            DateTime dateTime = DateTime.parse((String)dateTimeValue, (DateTimeFormatter)ApplicationConfig.DATE_TIME_FORMATTER);
            if (min != null && !dateTime.isBefore((ReadableInstant)min)) continue;
            min = dateTime;
        }
        this.searchEngineIndexingEventDao.deleteByCreatedTimeLessThan(min);
    }
}

