/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceAccountSearchResult;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactInfoFully;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactQueryAllResult;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactSearchResult;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadInfoFully;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadQueryAllResult;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadSearchResult;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadtQueryAllResult;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.service.SalesforceService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SalesforceServiceImpl
implements SalesforceService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceServiceImpl.class);
    private static final String QUERY_ALL_BASE_URL = "/services/data/v39.0/queryAll";
    private static final String CONTACT_BASE_URL = "/services/data/v39.0/sobjects/Contact/";
    private static final String ACCOUNT_BASE_URL = "/services/data/v39.0/sobjects/Account/";
    private static final String LEAD_BASE_URL = "/services/data/v39.0/sobjects/Lead/";
    private static final String QUERY_BASE_URL = "/services/data/v39.0/query";
    private Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contactDeleted(BasicToken basicToken, String CRMContactId, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String contactDeletedSoql = String.format("SELECT+id+FROM+Contact+WHERE+IsDeleted+=+true+AND+id+=+'%s'", CRMContactId);
            HttpUrl queryContactUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", contactDeletedSoql).build();
            Request queryContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryContactUrl).build();
            try (Response queryDeletedContactResponse = client.newCall(queryContactRequest).execute();){
                if (!queryDeletedContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryDeletedContactResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryDeletedContactResponse);
                SalesforceContactSearchResult result = (SalesforceContactSearchResult)this.gson.fromJson(jsonString, SalesforceContactSearchResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to check contact was deleted...", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean leadDeleted(BasicToken basicToken, String CRMContactId, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String leadDeletedSoql = String.format("SELECT+id+FROM+Lead+WHERE+IsDeleted+=+true+AND+id+=+'%s'", CRMContactId);
            HttpUrl queryLeadUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", leadDeletedSoql).build();
            Request queryLeadRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryLeadUrl).build();
            try (Response queryDeletedLeadResponse = client.newCall(queryLeadRequest).execute();){
                if (!queryDeletedLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryDeletedLeadResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryDeletedLeadResponse);
                SalesforceLeadSearchResult result = (SalesforceLeadSearchResult)this.gson.fromJson(jsonString, SalesforceLeadSearchResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("fail to check leade was deledted....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SalesforceContactInfoFully> getModifiedContactRecordsAfterSpecifiedTime(BasicToken basicToken, DateTime time, boolean isFirstTimeSync, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "";
            querySOQL = isFirstTimeSync ? "SELECT Id,CreatedDate,LastModifiedDate, IsDeleted FROM Contact WHERE LastModifiedDate >= " + time.toString() + " AND isDeleted=false" : "SELECT Id,CreatedDate,LastModifiedDate, IsDeleted FROM Contact WHERE LastModifiedDate >= " + time.toString();
            HttpUrl queryContactUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryContactUrl).build();
            try (Response queryAllContactResponse = client.newCall(queryContactRequest).execute();){
                if (!queryAllContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse);
                SalesforceContactQueryAllResult result = (SalesforceContactQueryAllResult)this.gson.fromJson(jsonString, SalesforceContactQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    ArrayList<SalesforceContactInfoFully> arrayList = new ArrayList<SalesforceContactInfoFully>();
                    return arrayList;
                }
                List list = result.getRecords();
                return list;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query contact by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SalesforceContactInfoFully getContactBasicRecord(BasicToken basicToken, String contactID, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,CreatedDate,LastModifiedDate, IsDeleted FROM Contact WHERE Id  = '" + contactID + "'";
            HttpUrl queryContactUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryContactUrl).build();
            try (Response queryAllContactResponse = client.newCall(queryContactRequest).execute();){
                if (!queryAllContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllContactResponse);
                SalesforceContactQueryAllResult result = (SalesforceContactQueryAllResult)this.gson.fromJson(jsonString, SalesforceContactQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    SalesforceContactInfoFully salesforceContactInfoFully = null;
                    return salesforceContactInfoFully;
                }
                SalesforceContactInfoFully salesforceContactInfoFully = (SalesforceContactInfoFully)result.getRecords().get(0);
                return salesforceContactInfoFully;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query contact by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public SalesforceContactInfoFully getContactRecord(BasicToken basicToken, String contactID, OkHttpClient client) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SalesforceLeadInfoFully> getModifiedLeadRecordsAfterSpecifiedTime(BasicToken basicToken, DateTime time, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,LastName,FirstName,Salutation,Phone,MobilePhone,Fax,Email, Website,Description,Title,Company,Street,City,State,PostalCode, Country,CreatedDate,LastModifiedDate,LastViewedDate,LastReferencedDate,IsDeleted FROM Lead WHERE LastModifiedDate > " + time.toString();
            HttpUrl queryLeadUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryLeadRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryLeadUrl).build();
            try (Response queryAllLeadResponse = client.newCall(queryLeadRequest).execute();){
                if (!queryAllLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse);
                SalesforceLeadQueryAllResult result = (SalesforceLeadQueryAllResult)this.gson.fromJson(jsonString, SalesforceLeadQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    ArrayList<SalesforceLeadInfoFully> arrayList = new ArrayList<SalesforceLeadInfoFully>();
                    return arrayList;
                }
                List list = result.getRecords();
                return list;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query contact by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SalesforceLeadInfoFully getLeadRecord(BasicToken basicToken, String leadID, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String queryAllUrl = salesforceAuthToken.getInstance_url() + QUERY_ALL_BASE_URL;
            String querySOQL = "SELECT Id,LastName,FirstName,Salutation,Phone,MobilePhone,Fax,Email, Website,Description,Title,Company,Street,City,State,PostalCode, Country,CreatedDate,LastModifiedDate,LastViewedDate,LastReferencedDate,IsDeleted FROM Lead WHERE Id  = '" + leadID + "'";
            HttpUrl queryLeadUrl = HttpUrl.parse((String)queryAllUrl).newBuilder().addEncodedQueryParameter("q", querySOQL).build();
            Request queryLeatRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(queryLeadUrl).build();
            try (Response queryAllLeadResponse = client.newCall(queryLeatRequest).execute();){
                if (!queryAllLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse));
                }
                String jsonString = OkHttpUtils.getResponseBodyString((Response)queryAllLeadResponse);
                SalesforceLeadtQueryAllResult result = (SalesforceLeadtQueryAllResult)this.gson.fromJson(jsonString, SalesforceLeadtQueryAllResult.class);
                if (result == null || result.getTotalSize() <= 0) {
                    SalesforceLeadInfoFully salesforceLeadInfoFully = null;
                    return salesforceLeadInfoFully;
                }
                SalesforceLeadInfoFully salesforceLeadInfoFully = (SalesforceLeadInfoFully)result.getRecords().get(0);
                return salesforceLeadInfoFully;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to query lead by specific time....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteContact(BasicToken basicToken, String CRMContactId, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String deleteContactUrl = salesforceAuthToken.getInstance_url() + CONTACT_BASE_URL + CRMContactId;
            Request deleteContactRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(deleteContactUrl).delete().build();
            try (Response deleteContactResponse = client.newCall(deleteContactRequest).execute();){
                if (!deleteContactResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)deleteContactResponse));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to delete contact...", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteLead(BasicToken basicToken, String CRMLeadId, OkHttpClient client) {
        if (basicToken instanceof NullCRMToken) {
            throw new CRMOperationException("User CRM token not found.");
        }
        try {
            SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
            String deleteLeadUrl = salesforceAuthToken.getInstance_url() + LEAD_BASE_URL + CRMLeadId;
            Request deleteLeadRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(deleteLeadUrl).delete().build();
            try (Response deleteLeadResponse = client.newCall(deleteLeadRequest).execute();){
                if (!deleteLeadResponse.isSuccessful()) {
                    throw new IOException(OkHttpUtils.getResponseBodyString((Response)deleteLeadResponse));
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOG.error("Fail to delete lead...", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
    }

    private String escapeSpecialCharacter(String keyword) {
        return StringUtils.replaceEach((String)keyword, (String[])new String[]{"'", "_", "\\", "\"", "%"}, (String[])new String[]{"\\'", "\\_", "\\\\", "\\\"", "\\%25"});
    }

    public SalesforceAccountSearchResult searchSalesforceAccounts(BasicToken basicToken, String keyword, OkHttpClient client) {
        LOG.debug("Search account by keword , execute salsesforce search account RESTful api .....");
        keyword = this.escapeSpecialCharacter(keyword);
        String queryKeyword = "%25" + keyword + "%25";
        if (keyword == "") {
            queryKeyword = "";
        }
        SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
        String queryUrl = salesforceAuthToken.getInstance_url() + QUERY_BASE_URL;
        String queryAccountSoql = String.format("SELECT+id,name+FROM+Account+WHERE+name+LIKE+'%s'", queryKeyword);
        HttpUrl searchAccountUrl = HttpUrl.parse((String)queryUrl).newBuilder().addEncodedQueryParameter("q", queryAccountSoql).build();
        Request searchAccountRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(searchAccountUrl).build();
        SalesforceAccountSearchResult searchRecords = null;
        try (Response searchAccountResponse = client.newCall(searchAccountRequest).execute();){
            if (!searchAccountResponse.isSuccessful()) {
                throw new CRMOperationException(OkHttpUtils.getResponseBodyString((Response)searchAccountResponse));
            }
            String jsonBody = OkHttpUtils.getResponseBodyString((Response)searchAccountResponse);
            searchRecords = (SalesforceAccountSearchResult)this.gson.fromJson(jsonBody, SalesforceAccountSearchResult.class);
        }
        catch (Exception ex) {
            LOG.error("Fail to execute search account RESTful api ....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
        return searchRecords;
    }

    public SalesforceAccountSearchResult getSalesforceRecentviewAccounts(BasicToken basicToken, OkHttpClient client) {
        LOG.debug("Search account by keword , execute salsesforce search account RESTful api .....");
        SalesforceOAuthToken salesforceAuthToken = (SalesforceOAuthToken)basicToken;
        String queryUrl = salesforceAuthToken.getInstance_url() + QUERY_BASE_URL;
        String queryAccountSoql = "SELECT+id,name+FROM+Account+order+by+LastViewedDate+DESC+nulls+last";
        HttpUrl searchAccountUrl = HttpUrl.parse((String)queryUrl).newBuilder().addEncodedQueryParameter("q", queryAccountSoql).build();
        Request searchAccountRequest = new Request.Builder().addHeader("Authorization", "Bearer " + basicToken.getAccess_token()).url(searchAccountUrl).build();
        LOG.info("searchAccountRequest={}", (Object)searchAccountRequest);
        SalesforceAccountSearchResult searchRecords = null;
        try (Response searchAccountResponse = client.newCall(searchAccountRequest).execute();){
            if (!searchAccountResponse.isSuccessful()) {
                throw new CRMOperationException(OkHttpUtils.getResponseBodyString((Response)searchAccountResponse));
            }
            String jsonBody = OkHttpUtils.getResponseBodyString((Response)searchAccountResponse);
            searchRecords = (SalesforceAccountSearchResult)this.gson.fromJson(jsonBody, SalesforceAccountSearchResult.class);
        }
        catch (Exception ex) {
            LOG.error("Fail to execute search account RESTful api ....", (Throwable)ex);
            throw new CRMOperationException(ex.getMessage());
        }
        return searchRecords;
    }
}

