/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.salesforce.vo.lead.SalesforceLeadInfoFully;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactStatusSyncInfo;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.CrmExportFailedReason;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithSalesforceJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.SalesforceExportService;
import com.penpower.worldcard.team.service.SalesforceService;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SalesforceLeadOperation")
@Transactional
public class SalesforceLeadOperation
implements CRMOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceLeadOperation.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private SalesforceExportService salesforceExportService;
    @Autowired
    private SalesforceService salesforceBasicService;
    @Value(value="${TSMCCust}")
    private String TSMCCust;
    @Autowired
    private SalesforceService salesforceService;

    public String getExportedCrmID(String accountGuid, String contactGuid) {
        List statusList = this.contactStatusForAccountDao.findByAccountGuidAndContactGuid(accountGuid, contactGuid);
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            throw new ItemNotFoundException("[getExportedContactServerID]: Can not find status.");
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String crmAccount = crmSettingsDto.getUserCRMAccount();
        String crmID = ((Contactstatusforaccount)statusList.get(0)).getExporttosalesforceleadid();
        if (crmAccount.equals(((Contactstatusforaccount)statusList.get(0)).getSalesforceaccount())) {
            return crmID;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setExportCrmInfo(String accountGuid, String contactGuid, String exportedCrmRecordID, String exportedCrmAccount, DateTime crmRecordModifyTime) {
        Account account = this.accountDao.findOne(accountGuid);
        if (account == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find account.");
        }
        Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
        if (contact == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find contact.");
        }
        Contactstatusforaccount status = this.contactStatusForAccountDao.findFirstByAccountAndContact(account, contact);
        if (status == null) {
            throw new ItemNotFoundException("[setExportCrmInfo]: Can not find status.");
        }
        if (exportedCrmRecordID != null) {
            status.setExporttosalesforceleadid(exportedCrmRecordID);
        }
        if (exportedCrmAccount != null) {
            status.setSalesforceaccount(exportedCrmAccount);
        }
        if (crmRecordModifyTime != null) {
            status.setPreviousModifiedTimeForSalesforceLead(crmRecordModifyTime);
        }
        this.contactStatusForAccountDao.save((Object)status);
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public String exportContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, boolean isForSync, BasicToken basicToken, String salesforceTargetAccountId, OkHttpClient client) {
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String retCrmID = this.salesforceExportService.createNewLeadRecord(basicToken, contactInfo, client);
        DateTime crmModifyTime = null;
        if (isForSync) {
            ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, retCrmID, basicToken, client);
            if (record == null) {
                throw new ItemNotFoundException("Contact exported, but get corresponding CRM record failed.");
            }
            crmModifyTime = record.getModifiedTime();
        }
        this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), retCrmID, crmSettingsDto.getUserCRMAccount(), crmModifyTime);
        return retCrmID;
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public void updateContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, String crmID, boolean isForSync, BasicToken basicToken, String salesforceTargetAccountId, OkHttpClient client) {
        if (this.salesforceBasicService.leadDeleted(basicToken, crmID, client)) {
            this.exportContactToCRM(accountGuid, contactInfo, isForSync, basicToken, salesforceTargetAccountId, client);
        } else {
            this.salesforceExportService.updateLeadRecord(basicToken, crmID, contactInfo, client);
            if (isForSync) {
                ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, crmID, basicToken, client);
                if (record == null) {
                    throw new ItemNotFoundException("CRM record udpated, but get it back failed.");
                }
                this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), null, null, record.getModifiedTime());
            }
        }
    }

    private boolean IsTSMCCust() {
        LOG.debug("TSMCCUST={}", (Object)this.TSMCCust);
        return this.TSMCCust.compareToIgnoreCase("true") == 0;
    }

    public List<ContactCrmSyncInfoForWCT> getWctSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, boolean isAutoExport) {
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        boolean isFirstTimeSync = false;
        if (lastSyncCompletedTime == null || lastSyncCompletedTime.equals((Object)GlobalUtils.getEarliestTime())) {
            isFirstTimeSync = true;
        }
        List syncStatusList = new ArrayList();
        syncStatusList = this.IsTSMCCust() ? this.contactStatusForAccountDao.findContactUndeletedByAccountAndModifyTimeExcludeFailedReasonForCRMSync(accountGuid, lastTime, CrmExportFailedReason.UNKNOWN_ACCOUNT) : (isFirstTimeSync || isAutoExport ? this.contactStatusForAccountDao.findContactUndeletedByAccountAndModifyTimeForCRMSync(accountGuid, lastTime) : this.contactStatusForAccountDao.findContactByAccountAndModifyTimeForCRMSync(accountGuid, lastTime));
        ArrayList<ContactCrmSyncInfoForWCT> syncInfos = new ArrayList<ContactCrmSyncInfoForWCT>();
        for (ContactStatusSyncInfo syncStatus : syncStatusList) {
            Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
            if (status.getIsdeletedfromaccount().booleanValue() && status.getModifyTimeForCrmSync().isBefore((ReadableInstant)lastTime)) continue;
            ContactCrmSyncInfoForWCT syncInfo = this.getSyncInfoForWctFromStatus(syncStatus);
            LOG.debug("[getWctSyncInfosByAccount] syncInfo:{}", (Object)syncInfo);
            syncInfos.add(syncInfo);
        }
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    private ContactCrmSyncInfoForWCT getSyncInfoForWctFromStatus(ContactStatusSyncInfo syncStatus) {
        Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
        boolean isDeleted = status.getIsdeletedfromaccount();
        DateTime modifyTime = status.getModifyTimeForCrmSync();
        DateTime contactModifyTime = syncStatus.getModifyTime();
        boolean isUpdatedByLastCRMSync = false;
        if (modifyTime != null && contactModifyTime != null) {
            isUpdatedByLastCRMSync = modifyTime.isEqual((ReadableInstant)contactModifyTime);
        }
        if (!status.getIsdeletedfromaccount().booleanValue() && contactModifyTime != null && contactModifyTime.isAfter((ReadableInstant)modifyTime)) {
            modifyTime = contactModifyTime;
        }
        if (modifyTime == null && contactModifyTime != null) {
            modifyTime = contactModifyTime;
        } else if (modifyTime == null && contactModifyTime == null) {
            modifyTime = GlobalUtils.getEarliestTime();
        }
        ContactCrmSyncInfoForWCT syncInfo = new ContactCrmSyncInfoForWCT(syncStatus.getContactGuid(), status.getPreviousModifiedTimeForSalesforceLead(), status.getExporttosalesforceleadid(), Boolean.valueOf(isDeleted), modifyTime, status.getSalesforceaccount(), isUpdatedByLastCRMSync);
        return syncInfo;
    }

    public ContactCrmSyncInfoForCRM getRecordSyncInfo(String accountGuid, String crmID, BasicToken basicToken, OkHttpClient client) {
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        SalesforceLeadInfoFully record = this.salesforceService.getLeadRecord(basicToken, crmID, client);
        if (record == null) {
            return null;
        }
        return new ContactCrmSyncInfoForCRM(crmID, Boolean.valueOf(record.isIsDeleted()), record.getLastModifiedDate(), crmSettingsDto.getUserCRMAccount());
    }

    public void deleteRecord(String accountGuid, String crmID, String contactGuid, boolean isForSync, BasicToken basicToken, OkHttpClient client) {
    }

    public List<ContactCrmSyncInfoForCRM> getCrmSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, BasicToken basicToken, OkHttpClient client) {
        return null;
    }

    public ContactCrmSyncInfoForWCT getWctSyncInfoByCorrespondingCrmSyncInfo(String accountGuid, ContactCrmSyncInfoForCRM syncInfoCRM) {
        return null;
    }

    public ContactCreationVo getContactCreationVoByCrmID(String accountGuid, String crmID, BasicToken basicToken, OkHttpClient client) {
        return null;
    }

    public void exportContactCheck(ContactInfoForResponse contact) {
    }

    public ContactUpdateVo getContactUpdateVoByCrmID(ContactCrmSyncInfoForWCT syncInfoWCT, BasicToken basicToken, ContactInfoForRequest originContact, OkHttpClient client) {
        return null;
    }

    public void updateWCTModifyTimeForSync(String accountGuid, ContactCrmSyncInfoForCRM syncInfo, SyncContactsOfAccountsWithSalesforceJob.CrmSyncActionType crmActionType) {
    }
}

