/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.PenpowerCountryMapperUtil;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceErrorResponse;
import com.penpower.worldcard.team.crm.salesforce.vo.SalesforceAccountInfo;
import com.penpower.worldcard.team.crm.salesforce.vo.contact.SalesforceContactInfoFully;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.ContactDao;
import com.penpower.worldcard.team.dao.ContactStatusForAccountDao;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactStatusSyncInfo;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.entity.Contact;
import com.penpower.worldcard.team.entity.Contactstatusforaccount;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.CountryCode;
import com.penpower.worldcard.team.enums.CrmExportFailedReason;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import com.penpower.worldcard.team.enums.SalesforceErrorCode;
import com.penpower.worldcard.team.enums.UpdateComponent;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.scheduler.job.SyncContactsOfAccountsWithSalesforceJob;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.CRMOperationService;
import com.penpower.worldcard.team.service.SalesforceExportService;
import com.penpower.worldcard.team.service.SalesforceService;
import com.penpower.worldcard.team.service.impl.SalesforceContactOperation;
import com.penpower.worldcard.team.web.api.vo.ContactCreationVo;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForCRM;
import com.penpower.worldcard.team.web.api.vo.ContactCrmSyncInfoForWCT;
import com.penpower.worldcard.team.web.api.vo.ContactUpdateVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="SalesforceContactOperation")
@Transactional
public class SalesforceContactOperation
implements CRMOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceContactOperation.class);
    @Autowired
    private AccountDao accountDao;
    @Autowired
    private ContactDao contactDao;
    @Autowired
    private ContactStatusForAccountDao contactStatusForAccountDao;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private SalesforceExportService salesforceExportService;
    @Autowired
    private SalesforceService salesforceService;
    @Autowired
    private SalesforceService salesforceBasicService;
    @Value(value="${TSMCCust}")
    private String TSMCCust;

    public String getExportedCrmID(String accountGuid, String contactGuid) {
        List statusList = this.contactStatusForAccountDao.findByAccountGuidAndContactGuid(accountGuid, contactGuid);
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            throw new ItemNotFoundException("[getExportedCRMID]: Can not find status.");
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String crmAccount = crmSettingsDto.getUserCRMAccount();
        String crmID = ((Contactstatusforaccount)statusList.get(0)).getExporttosalesforceid();
        if (crmAccount.equals(((Contactstatusforaccount)statusList.get(0)).getSalesforceaccount())) {
            return crmID;
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setExportCrmInfo(String accountGuid, String contactGuid, String exportedCrmRecordID, String exportedCrmAccount, DateTime crmRecordModifyTime) {
        List statusList = this.contactStatusForAccountDao.findByAccountGuidAndContactGuid(accountGuid, contactGuid);
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            throw new ItemNotFoundException("[getExportedCRMID]: Can not find status.");
        }
        Contactstatusforaccount status = (Contactstatusforaccount)statusList.get(0);
        if (exportedCrmRecordID != null) {
            status.setExporttosalesforceid(exportedCrmRecordID);
        }
        if (exportedCrmAccount != null) {
            status.setSalesforceaccount(exportedCrmAccount);
        }
        if (crmRecordModifyTime != null) {
            status.setPreviousModifiedTimeForSalesforceContact(crmRecordModifyTime);
        }
        this.contactStatusForAccountDao.save((Object)status);
    }

    public void exportContactCheck(ContactInfoForResponse contactInfo) {
        Optional name = GlobalUtils.getFirstListItem((List)contactInfo.getNames());
        if (!name.isPresent() || StringUtil.IsStringNullorEmpty((String)((ContactnameInfo)name.get()).getLastName())) {
            SalesforceErrorResponse response = new SalesforceErrorResponse("There is no last name.", SalesforceErrorCode.REQUIRED_FIELD_MISSING, Arrays.asList("LastName"));
            List<SalesforceErrorResponse> responses = Arrays.asList(response);
            throw new CRMOperationException(GlobalUtils.getJsonString(responses));
        }
        List mails = contactInfo.getEmails();
        for (ContactemailInfo mail : mails) {
            if (StringUtil.IsStringNullorEmpty((String)mail.getValue()) || mail.getValue().matches("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z]+$")) continue;
            SalesforceErrorResponse response = new SalesforceErrorResponse("Email is invalid.", SalesforceErrorCode.INVALID_EMAIL_ADDRESS, Arrays.asList("Email"));
            List<SalesforceErrorResponse> responses = Arrays.asList(response);
            throw new CRMOperationException(GlobalUtils.getJsonString(responses));
        }
    }

    private void skipIfThisErrorCode(Exception e, SalesforceErrorCode errorCode) throws Exception {
        Gson gson = new Gson();
        List list = (List)gson.fromJson(e.getMessage(), new /* Unavailable Anonymous Inner Class!! */.getType());
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw e;
        }
        SalesforceErrorResponse response = (SalesforceErrorResponse)list.get(0);
        if (!errorCode.equals((Object)response.getErrorCode())) {
            throw e;
        }
    }

    public void deleteRecord(String accountGuid, String crmID, String contactGuid, boolean isForSync, BasicToken basicToken, OkHttpClient client) {
        try {
            this.salesforceService.deleteContact(basicToken, crmID, client);
        }
        catch (Exception e) {
            LOG.error("salesforceService.deleteContact fail: {}", (Object)e.getMessage());
            throw e;
        }
        if (isForSync) {
            ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, crmID, basicToken, client);
            if (record == null) {
                throw new ItemNotFoundException("CRM record deleted, but get it back failed.");
            }
            this.setExportCrmInfo(accountGuid, contactGuid, "", "", record.getModifiedTime());
        }
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public String exportContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, boolean isForSync, BasicToken basicToken, String salesforceTargetAccountId, OkHttpClient client) {
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        String retCrmID = "";
        try {
            retCrmID = this.salesforceExportService.createNewContactRecord(basicToken, (ContactInfoForRequest)contactInfo, salesforceTargetAccountId, client);
        }
        catch (Exception e) {
            LOG.error("salesforceExportService.createNewContactRecord fail: {}", (Object)e.getMessage());
            throw e;
        }
        DateTime crmModifyTime = null;
        if (isForSync) {
            ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, retCrmID, basicToken, client);
            if (record == null) {
                throw new ItemNotFoundException("Contact exported, but get corresponding CRM record failed.");
            }
            crmModifyTime = record.getModifiedTime();
        }
        this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), retCrmID, crmSettingsDto.getUserCRMAccount(), crmModifyTime);
        return retCrmID;
    }

    @Transactional(propagation=Propagation.NEVER, rollbackFor={Exception.class})
    public void updateContactToCRM(String accountGuid, ContactInfoForResponse contactInfo, String crmID, boolean isForSync, BasicToken basicToken, String salesforceTargetAccountId, OkHttpClient client) {
        if (this.salesforceBasicService.contactDeleted(basicToken, crmID, client)) {
            this.exportContactToCRM(accountGuid, contactInfo, isForSync, basicToken, salesforceTargetAccountId, client);
        } else {
            try {
                this.salesforceExportService.updateContactRecord(basicToken, crmID, (ContactInfoForRequest)contactInfo, salesforceTargetAccountId, client);
            }
            catch (Exception e) {
                LOG.error("salesforceExportService.updateContactRecord fail: {}", (Object)e.getMessage());
                throw e;
            }
            if (isForSync) {
                ContactCrmSyncInfoForCRM record = this.getRecordSyncInfo(accountGuid, crmID, basicToken, client);
                if (record == null) {
                    throw new ItemNotFoundException("CRM record udpated, but get it back failed.");
                }
                this.setExportCrmInfo(accountGuid, contactInfo.getGuid(), null, null, record.getModifiedTime());
            }
        }
    }

    public List<ContactCrmSyncInfoForCRM> getCrmSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, BasicToken basicToken, OkHttpClient client) {
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        boolean isFirstTimeSync = false;
        if (lastSyncCompletedTime == null || lastSyncCompletedTime.equals((Object)GlobalUtils.getEarliestTime())) {
            isFirstTimeSync = true;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        List records = this.salesforceService.getModifiedContactRecordsAfterSpecifiedTime(basicToken, lastTime, isFirstTimeSync, client);
        List<ContactCrmSyncInfoForCRM> syncInfos = records.stream().map(r -> new ContactCrmSyncInfoForCRM(r.getId(), Boolean.valueOf(r.isIsDeleted()), r.getLastModifiedDate(), crmSettingsDto.getUserCRMAccount())).collect(Collectors.toList());
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    private boolean IsTSMCCust() {
        LOG.debug("TSMCCUST={}", (Object)this.TSMCCust);
        return this.TSMCCust.compareToIgnoreCase("true") == 0;
    }

    public List<ContactCrmSyncInfoForWCT> getWctSyncInfosByAccount(String accountGuid, DateTime lastSyncCompletedTime, boolean isAutoExport) {
        DateTime lastTime = lastSyncCompletedTime == null ? GlobalUtils.getEarliestTime() : lastSyncCompletedTime;
        boolean isFirstTimeSync = false;
        if (lastSyncCompletedTime == null || lastSyncCompletedTime.equals((Object)GlobalUtils.getEarliestTime())) {
            isFirstTimeSync = true;
        }
        List syncStatusList = new ArrayList();
        syncStatusList = this.IsTSMCCust() ? this.contactStatusForAccountDao.findContactUndeletedByAccountAndModifyTimeExcludeFailedReasonForCRMSync(accountGuid, lastTime, CrmExportFailedReason.UNKNOWN_ACCOUNT) : (isFirstTimeSync || isAutoExport ? this.contactStatusForAccountDao.findContactUndeletedByAccountAndModifyTimeForCRMSync(accountGuid, lastTime) : this.contactStatusForAccountDao.findContactByAccountAndModifyTimeForCRMSync(accountGuid, lastTime));
        ArrayList<ContactCrmSyncInfoForWCT> syncInfos = new ArrayList<ContactCrmSyncInfoForWCT>();
        for (ContactStatusSyncInfo syncStatus : syncStatusList) {
            Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
            if (status.getIsdeletedfromaccount().booleanValue() && status.getModifyTimeForCrmSync().isBefore((ReadableInstant)lastTime)) continue;
            ContactCrmSyncInfoForWCT syncInfo = this.getSyncInfoForWctFromStatus(syncStatus);
            LOG.debug("[getWctSyncInfosByAccount] syncInfo:{}", (Object)syncInfo);
            syncInfos.add(syncInfo);
        }
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    public ContactCrmSyncInfoForCRM getRecordSyncInfo(String accountGuid, String crmID, BasicToken basicToken, OkHttpClient client) {
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        CRMSettingsDto crmSettingsDto = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
        SalesforceContactInfoFully record = this.salesforceService.getContactBasicRecord(basicToken, crmID, client);
        if (record == null) {
            return null;
        }
        return new ContactCrmSyncInfoForCRM(crmID, Boolean.valueOf(record.isIsDeleted()), record.getLastModifiedDate(), crmSettingsDto.getUserCRMAccount());
    }

    public ContactCrmSyncInfoForWCT getWctSyncInfoByCorrespondingCrmSyncInfo(String accountGuid, ContactCrmSyncInfoForCRM syncInfoCRM) {
        List statusList = this.contactStatusForAccountDao.findSyncInfoByAccountAndSalesforceAccountAndContactId(accountGuid, syncInfoCRM.getSyncCrmAccount(), syncInfoCRM.getCrmID());
        if (CollectionUtils.isEmpty((Collection)statusList)) {
            return null;
        }
        ContactCrmSyncInfoForWCT syncInfoWCT = this.getSyncInfoForWctFromStatus((ContactStatusSyncInfo)statusList.get(0));
        return syncInfoWCT;
    }

    private Contactstatusforaccount pickupStatusByTime(List<Contactstatusforaccount> statusList) {
        return statusList.get(0);
    }

    private ContactCrmSyncInfoForWCT getSyncInfoForWctFromStatus(ContactStatusSyncInfo syncStatus) {
        Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
        boolean isDeleted = status.getIsdeletedfromaccount();
        DateTime modifyTime = status.getModifyTimeForCrmSync();
        DateTime contactModifyTime = syncStatus.getModifyTime();
        boolean isUpdatedByLastCRMSync = false;
        if (modifyTime != null && contactModifyTime != null) {
            isUpdatedByLastCRMSync = modifyTime.isEqual((ReadableInstant)contactModifyTime);
        }
        if (!status.getIsdeletedfromaccount().booleanValue() && contactModifyTime != null && contactModifyTime.isAfter((ReadableInstant)modifyTime)) {
            modifyTime = contactModifyTime;
        }
        if (modifyTime == null && contactModifyTime != null) {
            modifyTime = contactModifyTime;
        } else if (modifyTime == null && contactModifyTime == null) {
            modifyTime = GlobalUtils.getEarliestTime();
        }
        ContactCrmSyncInfoForWCT syncInfo = new ContactCrmSyncInfoForWCT(syncStatus.getContactGuid(), status.getPreviousModifiedTimeForSalesforceContact(), status.getExporttosalesforceid(), Boolean.valueOf(isDeleted), modifyTime, status.getSalesforceaccount(), isUpdatedByLastCRMSync);
        return syncInfo;
    }

    public ContactUpdateVo getContactUpdateVoByCrmID(ContactCrmSyncInfoForWCT syncInfoWCT, BasicToken basicToken, ContactInfoForRequest originalContactInfo, OkHttpClient client) {
        String crmID = syncInfoWCT.getCrmID();
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        SalesforceContactInfoFully record = this.salesforceService.getContactRecord(basicToken, crmID, client);
        if (record == null) {
            return null;
        }
        ContactInfoForRequest contactInfo = this.getContactCreationVoFromSalesforceContactInfoFully(record);
        contactInfo = this.mergeContactRecordWithOriginContact(contactInfo, originalContactInfo);
        contactInfo.setRecogLanguageFront(originalContactInfo.getRecogLanguageFront());
        contactInfo.setRecogLanguageBack(originalContactInfo.getRecogLanguageBack());
        ContactUpdateVo resultVo = new ContactUpdateVo();
        BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
        resultVo.setContactGuid(syncInfoWCT.getContactGuid());
        resultVo.setUpdateComponents(new UpdateComponent[]{UpdateComponent.UC_CONTENT});
        resultVo.setdisplayModifyTime(record.getLastModifiedDate());
        return resultVo;
    }

    public ContactCreationVo getContactCreationVoByCrmID(String accountGuid, String crmID, BasicToken basicToken, OkHttpClient client) {
        if (StringUtil.IsStringNullorEmpty((String)crmID)) {
            return null;
        }
        SalesforceContactInfoFully record = this.salesforceService.getContactRecord(basicToken, crmID, client);
        if (record == null) {
            return null;
        }
        ContactInfoForRequest contactInfo = this.getContactCreationVoFromSalesforceContactInfoFully(record);
        ContactCreationVo resultVo = new ContactCreationVo();
        BeanUtils.copyProperties((Object)contactInfo, (Object)resultVo);
        resultVo.setCreatorAccountGuid(accountGuid);
        resultVo.setClientCreatedTime(record.getCreatedDate());
        return resultVo;
    }

    private ContactInfoForRequest getContactCreationVoFromSalesforceContactInfoFully(SalesforceContactInfoFully record) {
        ContactaddressInfo address;
        CountryCode countryCode;
        ContactphoneInfo phone;
        ContactInfoForRequest resultVo = new ContactInfoForRequest();
        ContactnameInfo name = new ContactnameInfo();
        name.setLastName(record.getLastName());
        name.setFirstName(record.getFirstName());
        name.setSuffix(record.getSalutation());
        name.setRecognizeSource(RecognizeSourceType.MANUAL);
        resultVo.getNames().add(name);
        SalesforceAccountInfo sfAccount = record.getAccount();
        if (sfAccount != null && !StringUtil.IsStringNullorEmpty((String)sfAccount.getName()) || !StringUtil.IsStringNullorEmpty((String)record.getDepartment()) || !StringUtil.IsStringNullorEmpty((String)record.getTitle())) {
            String companyName = "";
            if (sfAccount != null) {
                companyName = sfAccount.getName();
            }
            ContactjobinfoInfo jobInfo = new ContactjobinfoInfo(companyName, record.getDepartment(), record.getTitle(), RecognizeSourceType.MANUAL);
            resultVo.getJobinfos().add(jobInfo);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getHomePhone())) {
            phone = new ContactphoneInfo(record.getHomePhone(), ContactPhoneType.HOME_TEL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getPhone())) {
            phone = new ContactphoneInfo(record.getPhone(), ContactPhoneType.BUSINESS_TEL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getMobilePhone())) {
            phone = new ContactphoneInfo(record.getMobilePhone(), ContactPhoneType.CELL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getOtherPhone())) {
            phone = new ContactphoneInfo(record.getOtherPhone(), ContactPhoneType.OTHER_TEL, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getFax())) {
            phone = new ContactphoneInfo(record.getFax(), ContactPhoneType.BUSINESS_FAX, RecognizeSourceType.MANUAL);
            resultVo.getPhones().add(phone);
        }
        if (!(StringUtil.IsStringNullorEmpty((String)record.getMailingCountry()) && StringUtil.IsStringNullorEmpty((String)record.getMailingCity()) && StringUtil.IsStringNullorEmpty((String)record.getMailingState()) && StringUtil.IsStringNullorEmpty((String)record.getMailingStreet()) && StringUtil.IsStringNullorEmpty((String)record.getMailingPostalCode()))) {
            int addressFormat = 0;
            countryCode = null;
            try {
                countryCode = PenpowerCountryMapperUtil.getCountryCode((String)record.getMailingCountry());
            }
            catch (Exception ex) {
                LOG.error("{}", (Throwable)ex);
            }
            address = new ContactaddressInfo(record.getMailingCountry(), record.getMailingCity(), record.getMailingState(), record.getMailingStreet(), record.getMailingPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
            address.setCountryCode(countryCode == null ? null : countryCode.toString().toLowerCase());
            resultVo.getAddresses().add(address);
        }
        if (!(StringUtil.IsStringNullorEmpty((String)record.getOtherCountry()) && StringUtil.IsStringNullorEmpty((String)record.getOtherCity()) && StringUtil.IsStringNullorEmpty((String)record.getOtherState()) && StringUtil.IsStringNullorEmpty((String)record.getOtherStreet()) && StringUtil.IsStringNullorEmpty((String)record.getOtherPostalCode()))) {
            int addressFormat = 0;
            countryCode = null;
            try {
                countryCode = PenpowerCountryMapperUtil.getCountryCode((String)record.getOtherCountry());
            }
            catch (Exception ex) {
                LOG.error("{}", (Throwable)ex);
            }
            address = new ContactaddressInfo(record.getOtherCountry(), record.getOtherCity(), record.getOtherState(), record.getOtherStreet(), record.getOtherPostalCode(), Integer.valueOf(addressFormat), ContactFieldType.OTHER, RecognizeSourceType.MANUAL);
            address.setCountryCode(countryCode == null ? null : countryCode.toString().toLowerCase());
            resultVo.getAddresses().add(address);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getEmail())) {
            ContactemailInfo mail = new ContactemailInfo(record.getEmail(), ContactFieldType.BUSINESS, RecognizeSourceType.MANUAL);
            resultVo.getEmails().add(mail);
        }
        if (!StringUtil.IsStringNullorEmpty((String)record.getBirthdate())) {
            DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
            DateTime birthday = dtfOut.parseDateTime(record.getBirthdate());
            resultVo.setBirthday(birthday);
        }
        resultVo.setNote(record.getDescription());
        return resultVo;
    }

    private <T> List<T> mergeCRMListToOriginListForSameType(List<T> crm, List<T> origin) {
        T contactTypeObj;
        if (crm == null) {
            crm = new ArrayList<T>();
        }
        if (origin == null) {
            origin = new ArrayList<T>();
        }
        if (CollectionUtils.isEmpty(crm) && CollectionUtils.isEmpty(origin)) {
            return new ArrayList();
        }
        int originContactStartPosition = crm.size();
        T t = contactTypeObj = crm.size() > 0 ? crm.get(0) : origin.get(0);
        if (contactTypeObj != null) {
            if (contactTypeObj instanceof ContactaddressInfo || contactTypeObj instanceof ContactjobinfoInfo || contactTypeObj instanceof ContactnameInfo) {
                originContactStartPosition = 1;
            } else if (contactTypeObj instanceof ContactdateInfo) {
                originContactStartPosition = 0;
            } else if (contactTypeObj instanceof ContacturlInfo) {
                originContactStartPosition = ContactUrlType.BUSINESS.equals((Object)((ContacturlInfo)contactTypeObj).getType()) ? 1 : 0;
                originContactStartPosition = ContactUrlType.OTHER.equals((Object)((ContacturlInfo)contactTypeObj).getType()) ? 1 : 0;
            } else if (contactTypeObj instanceof ContactemailInfo) {
                originContactStartPosition = ContactFieldType.BUSINESS.equals((Object)((ContactemailInfo)contactTypeObj).getType()) ? 1 : 0;
            } else if (contactTypeObj instanceof ContactphoneInfo) {
                ContactPhoneType type = ((ContactphoneInfo)contactTypeObj).getType();
                switch (2.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        originContactStartPosition = 1;
                        break;
                    }
                    default: {
                        originContactStartPosition = 0;
                    }
                }
            }
        }
        ArrayList<T> mergeList = new ArrayList<T>();
        if (origin.size() > crm.size() && originContactStartPosition <= origin.size()) {
            mergeList.addAll(crm);
            mergeList.addAll(origin.subList(originContactStartPosition, origin.size()));
        } else {
            mergeList.addAll(crm);
        }
        return mergeList;
    }

    private <T> List<T> internalGetMergeResult(List<T> originContacts, List<T> crms, int maxSize) {
        ContactFieldType type;
        LinkedHashMap<Object, List> originTypeMap = new LinkedHashMap<Object, List>();
        LinkedHashMap<Object, List> crmTypeMap = new LinkedHashMap<Object, List>();
        for (T origin : originContacts) {
            if (origin instanceof ContactaddressInfo) {
                type = ((ContactaddressInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (origin instanceof ContactemailInfo) {
                type = ((ContactemailInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (origin instanceof ContactphoneInfo) {
                type = ((ContactphoneInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (origin instanceof ContactdateInfo) {
                type = ((ContactdateInfo)origin).getType();
                originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
                continue;
            }
            if (!(origin instanceof ContacturlInfo)) continue;
            type = ((ContacturlInfo)origin).getType();
            originTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(origin);
        }
        for (T inCRM : crms) {
            if (inCRM instanceof ContactaddressInfo) {
                type = ((ContactaddressInfo)inCRM).getType();
                crmTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inCRM);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (inCRM instanceof ContactemailInfo) {
                type = ((ContactemailInfo)inCRM).getType();
                crmTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inCRM);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (inCRM instanceof ContactphoneInfo) {
                type = ((ContactphoneInfo)inCRM).getType();
                crmTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inCRM);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (inCRM instanceof ContactdateInfo) {
                type = ((ContactdateInfo)inCRM).getType();
                crmTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inCRM);
                originTypeMap.computeIfAbsent(type, i -> new ArrayList());
                continue;
            }
            if (!(inCRM instanceof ContacturlInfo)) continue;
            type = ((ContacturlInfo)inCRM).getType();
            crmTypeMap.computeIfAbsent(type, i -> new ArrayList()).add(inCRM);
            originTypeMap.computeIfAbsent(type, i -> new ArrayList());
        }
        List mergeResult = originTypeMap.entrySet().stream().map(originEntry -> this.mergeCRMListToOriginListForSameType((List)crmTypeMap.get(originEntry.getKey()), (List)originEntry.getValue())).flatMap(i -> i.stream()).limit(maxSize).collect(Collectors.toList());
        return mergeResult;
    }

    private ContactInfoForRequest mergeContactRecordWithOriginContact(ContactInfoForRequest contactInfoInCRM, ContactInfoForRequest originContact) {
        List mergeAddresses = this.internalGetMergeResult(originContact.getAddresses(), contactInfoInCRM.getAddresses(), 6);
        originContact.setAddresses(mergeAddresses);
        List mergeEmails = this.internalGetMergeResult(originContact.getEmails(), contactInfoInCRM.getEmails(), 6);
        originContact.setEmails(mergeEmails);
        List mergePhones = this.internalGetMergeResult(originContact.getPhones(), contactInfoInCRM.getPhones(), 16);
        originContact.setPhones(mergePhones);
        List mergeDates = this.internalGetMergeResult(originContact.getDates(), contactInfoInCRM.getDates(), 4);
        originContact.setDates(mergeDates);
        List mergeUrls = this.internalGetMergeResult(originContact.getUrls(), contactInfoInCRM.getUrls(), 6);
        originContact.setUrls(mergeUrls);
        List mergeJobs = this.mergeCRMListToOriginListForSameType(contactInfoInCRM.getJobinfos(), originContact.getJobinfos()).stream().limit(6L).collect(Collectors.toList());
        originContact.setJobinfos(mergeJobs);
        List mergeNames = this.mergeCRMListToOriginListForSameType(contactInfoInCRM.getNames(), originContact.getNames()).stream().limit(4L).collect(Collectors.toList());
        originContact.setNames(mergeNames);
        originContact.setBirthday(contactInfoInCRM.getBirthday());
        originContact.setNickname(contactInfoInCRM.getNickname());
        originContact.setNote(StringUtils.isBlank((CharSequence)contactInfoInCRM.getNote()) ? "" : contactInfoInCRM.getNote());
        return originContact;
    }

    public void updateWCTModifyTimeForSync(String accountGuid, ContactCrmSyncInfoForCRM syncInfo, SyncContactsOfAccountsWithSalesforceJob.CrmSyncActionType crmActionType) {
        DateTime statusModifyTime;
        ContactStatusSyncInfo syncStatus;
        List syncStatusList = this.contactStatusForAccountDao.findSyncInfoByAccountAndSalesforceAccountAndContactId(accountGuid, syncInfo.getSyncCrmAccount(), syncInfo.getCrmID());
        ContactStatusSyncInfo contactStatusSyncInfo = syncStatus = syncStatusList.size() > 0 ? (ContactStatusSyncInfo)syncStatusList.get(0) : null;
        if (syncStatus == null) {
            return;
        }
        Contactstatusforaccount status = syncStatus.getContactStatusForAccount();
        String contactGuid = syncStatus.getContactGuid();
        DateTime contactContentModifyTime = syncStatus.getModifyTime() == null ? GlobalUtils.getEarliestTime() : syncStatus.getModifyTime();
        DateTime dateTime = statusModifyTime = status.getModifyTimeForCrmSync() == null ? GlobalUtils.getEarliestTime() : status.getModifyTimeForCrmSync();
        if (crmActionType == SyncContactsOfAccountsWithSalesforceJob.CrmSyncActionType.WCT_ADD || crmActionType == SyncContactsOfAccountsWithSalesforceJob.CrmSyncActionType.WCT_DELETE) {
            Contact contact = (Contact)this.contactDao.findOne((Serializable)((Object)contactGuid));
            contact.setModifyTimeForCrmSync(statusModifyTime);
            this.contactDao.saveAndFlush((Object)contact);
        } else if (crmActionType == SyncContactsOfAccountsWithSalesforceJob.CrmSyncActionType.WCT_UPDATE) {
            status.setModifyTimeForCrmSync(contactContentModifyTime);
            this.contactStatusForAccountDao.saveAndFlush((Object)status);
        }
    }
}

