/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.crm.BasicToken;
import com.penpower.worldcard.team.crm.CRMAuthenticationManager;
import com.penpower.worldcard.team.crm.NullCRMToken;
import com.penpower.worldcard.team.crm.salesforce.SalesForceOAuthTokenType;
import com.penpower.worldcard.team.crm.salesforce.SalesforceOAuthToken;
import com.penpower.worldcard.team.crm.salesforce.SalesforceUserAgentOAuthToken;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.CRMSettingsDto;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.exception.CRMOperationException;
import com.penpower.worldcard.team.service.AccountPrivateSettingService;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.SalesForceTokenService;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SalesForceTokenServiceImpl
implements SalesForceTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(SalesForceTokenServiceImpl.class);
    @Autowired
    private CRMAuthenticationManager salesforceAuthenticationManager;
    @Autowired
    private AccountPrivateSettingService accountPrivateSettingService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private CompanyGlobalInfoService companyGlobalInfoService;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public BasicToken retrieveToken(String userGuid, OkHttpClient client) throws IOException {
        String userCRMloginTokenString = this.accountPrivateSettingService.getUserCRMLoginToken(userGuid);
        AccountInfo account = this.accountService.getAccountInfo(userGuid, null);
        Globalinfocompany crmUrl = this.companyGlobalInfoService.getPropertiesByKey("SYSTEM_CRM_URL", account.getCompanyGuid());
        String domain = crmUrl == null ? "login.salesforce.com" : crmUrl.getConfigValue();
        SalesForceOAuthTokenType tokenType = this.accountPrivateSettingService.getUserCRMTokenType(userGuid);
        BasicToken basicToken = this.salesforceAuthenticationManager.getAccessToken(userCRMloginTokenString, tokenType);
        try {
            basicToken = this.tryToRefreshToken(userGuid, basicToken, tokenType, domain, client);
        }
        catch (CRMOperationException ex) {
            LOG.error("retrieve token failed...reset CRM settings....", (Throwable)ex);
            this.accountPrivateSettingService.resetUserCRMsettings(userGuid);
            throw ex;
        }
        return basicToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BasicToken tryToRefreshToken(String accountGuid, BasicToken basicToken, SalesForceOAuthTokenType tokenType, String domain, OkHttpClient client) throws IOException {
        boolean tokenValid = this.salesforceAuthenticationManager.testAccessToken(basicToken, tokenType, client);
        if (tokenValid) {
            return basicToken;
        }
        LOG.debug("Token invalid, Try to refresh token...........");
        if (SalesForceOAuthTokenType.USER_AGENT.equals((Object)tokenType)) {
            SalesforceUserAgentOAuthToken userAgentToken = (SalesforceUserAgentOAuthToken)basicToken;
            String refreshToken = userAgentToken.getRefresh_token();
            try {
                FormBody refreshTokenFormBody = new FormBody.Builder().add("grant_type", "refresh_token").add("refresh_token", refreshToken).add("client_id", "3MVG9A2kN3Bn17ht.gwAqdFxa15P7PR2Qq.UehIdGvredPOsMv6W3ukTgnHPuG4tILwlUHhlD9iMbViwTmvm9").add("client_secret", "5035759151164667231").add("format", "json").build();
                Request refreshTokenRequest = new Request.Builder().url(String.format("https://%s/services/oauth2/token", domain)).post((RequestBody)refreshTokenFormBody).build();
                LOG.debug("refresh user agent token.....");
                try (Response refreshTokenResponse = client.newCall(refreshTokenRequest).execute();){
                    if (!refreshTokenResponse.isSuccessful()) {
                        LOG.debug("refresh user agent token Failed.....");
                        this.accountPrivateSettingService.resetUserCRMsettings(accountGuid);
                        NullCRMToken nullCRMToken = new NullCRMToken();
                        return nullCRMToken;
                    }
                    String responseBodyString = OkHttpUtils.getResponseBodyString((Response)refreshTokenResponse);
                    Gson gson = new Gson();
                    userAgentToken = (SalesforceUserAgentOAuthToken)gson.fromJson(responseBodyString, SalesforceUserAgentOAuthToken.class);
                    userAgentToken.setRefresh_token(refreshToken);
                    LOG.debug("new UserAgentToken : {} ", (Object)userAgentToken);
                    SalesforceUserAgentOAuthToken salesforceUserAgentOAuthToken = userAgentToken;
                    return salesforceUserAgentOAuthToken;
                }
            }
            catch (IOException ex) {
                LOG.warn("Try to refresh user-agent salesforce token failed.", (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                LOG.warn("Try to refresh user-agent salesforce token failed.", (Throwable)ex);
                this.accountPrivateSettingService.resetUserCRMsettings(accountGuid);
                return new NullCRMToken();
            }
        }
        try {
            CRMSettingsDto CRMSettingsDto2 = this.accountPrivateSettingService.getUserCRMSettings(accountGuid);
            basicToken = this.salesforceAuthenticationManager.loginCRM(CRMSettingsDto2, domain, client);
            SalesforceOAuthToken userNamePasswordOAuthToken = (SalesforceOAuthToken)basicToken;
            Gson gson = new Gson();
            String userNamePasswordOAuthTokenJson = gson.toJson((Object)userNamePasswordOAuthToken);
            this.accountPrivateSettingService.setUserCRMloginToken(accountGuid, userNamePasswordOAuthTokenJson, SalesForceOAuthTokenType.USERNAME_PASSWORD);
            return basicToken;
        }
        catch (Exception ex) {
            LOG.warn("Try to re-login username-password salesforcetokenfailed.", (Throwable)ex);
            this.accountPrivateSettingService.resetUserCRMsettings(accountGuid);
            return new NullCRMToken();
        }
    }
}

