/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.FileSystemUtil;
import com.penpower.worldcard.team.backup.BackupControlFile;
import com.penpower.worldcard.team.backup.BackupFileManager;
import com.penpower.worldcard.team.dto.RestoreStoragInfos;
import com.penpower.worldcard.team.enums.BackupStatus;
import com.penpower.worldcard.team.exception.PermissionDeniedException;
import com.penpower.worldcard.team.service.RestoreInfoService;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.platform.linux.LinuxHardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

@Service
public class RestoreInfoServiceImpl
implements RestoreInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreInfoServiceImpl.class);

    public List<RestoreStoragInfos> getRestoreStorageInfos() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hardWare = si.getHardware();
        if (hardWare instanceof LinuxHardwareAbstractionLayer) {
            OperatingSystem os = si.getOperatingSystem();
            FileSystem fs = os.getFileSystem();
            OSFileStore[] OSFileStores = fs.getFileStores();
            ArrayList<String> correctMountPoints = new ArrayList<String>();
            for (OSFileStore osFileStore : OSFileStores) {
                LOG.debug("osFileStore getName: " + osFileStore.getName());
                LOG.debug("osFileStore getDescription: " + osFileStore.getDescription());
                LOG.debug("osFileStore getMount: " + osFileStore.getMount());
                LOG.debug("osFileStore getType: " + osFileStore.getType());
                LOG.debug("osFileStore getVolume: " + osFileStore.getVolume());
                LOG.debug("osFileStore getTotalSpace: " + osFileStore.getTotalSpace());
                LOG.debug("osFileStore getUsableSpace: " + osFileStore.getUsableSpace());
                String mountPoint = osFileStore.getMount();
                boolean containsUsbNameSuuffix = mountPoint.toUpperCase().contains("USB") || mountPoint.toUpperCase().contains("SHARE/EXTERNAL");
                LOG.debug("containsUsbNameSuuffix : {}", (Object)containsUsbNameSuuffix);
                if (!containsUsbNameSuuffix) continue;
                BackupFileManager manager = new BackupFileManager(mountPoint);
                Path backupFileRoot = manager.getBackupFilesRoot();
                try (Stream<Path> listStream = Files.list(backupFileRoot);){
                    boolean correctControlFile = false;
                    List backupFolders = listStream.sorted().filter(p -> Files.isDirectory(p, new LinkOption[0])).collect(Collectors.toList());
                    Collections.reverse(backupFolders);
                    LOG.debug("backupFolders : {} ", backupFolders);
                    for (Path backupFolder : backupFolders) {
                        Path controlFilePath = backupFolder.resolve("wct_backup.json");
                        LOG.debug("controlFilePath: {} ", (Object)controlFilePath);
                        if (Files.exists(controlFilePath, new LinkOption[0])) {
                            try {
                                FileReader fr = new FileReader(controlFilePath.toFile());
                                Throwable throwable = null;
                                try {
                                    Gson gson = Converters.registerDateTime((GsonBuilder)new GsonBuilder()).create();
                                    BackupControlFile controlFile = (BackupControlFile)gson.fromJson((Reader)fr, BackupControlFile.class);
                                    BackupStatus backupStatus = controlFile.getBackupStatus();
                                    LOG.debug("backupStatus : {} ", (Object)backupStatus);
                                    if (BackupStatus.FINISHED.equals((Object)backupStatus)) {
                                        correctControlFile = true;
                                        break;
                                    }
                                    FileSystemUtil.deleteDirectory((Path)backupFolder);
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (fr == null) continue;
                                    if (throwable != null) {
                                        try {
                                            fr.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    fr.close();
                                }
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        try {
                            FileSystemUtil.deleteDirectory((Path)backupFolder);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        correctControlFile = false;
                    }
                    if (!correctControlFile) continue;
                    correctMountPoints.add(mountPoint);
                }
                catch (Exception e) {
                    LOG.warn("failed to check mountpoint files...", (Throwable)e);
                }
            }
            ArrayList<RestoreStoragInfos> restoreStoragInfos = new ArrayList<RestoreStoragInfos>();
            LOG.debug("correctMountPoints : {} ", correctMountPoints);
            Iterator iterator = correctMountPoints.iterator();
            while (iterator.hasNext()) {
                String correctMountPoint;
                String mountPoint = correctMountPoint = (String)iterator.next();
                Path mountPath = Paths.get(mountPoint, new String[0]);
                LOG.debug("mountPath : {} ", (Object)mountPath);
                RestoreStoragInfos restoreStoragInfo = new RestoreStoragInfos();
                String deviceName = mountPath.getFileName().toString();
                restoreStoragInfo.setStorageName(deviceName);
                restoreStoragInfo.setStoragePath(mountPoint);
                BackupFileManager manager = new BackupFileManager(mountPath.toString());
                BackupControlFile controlFile = manager.readRestoreControlFileJsonObject();
                DateTime backupTime = controlFile.getBackupTime();
                long backupSizeBytes = controlFile.getBackupSizeBytes();
                String backupSize = FileSystemUtil.convertToStringRepresentation((long)backupSizeBytes);
                restoreStoragInfo.setBackupTime(backupTime);
                restoreStoragInfo.setBackupFileSize(backupSize);
                restoreStoragInfos.add(restoreStoragInfo);
            }
            return restoreStoragInfos;
        }
        throw new PermissionDeniedException("Windows platform doesn't support this features......");
    }

    public boolean backupFileVersionCanBeRestored(String backupfileApiVersion) {
        try {
            int backupfileApiVersionPart;
            int currentApiVersionPart;
            LOG.debug("currentApiVersion:{}, backupfileApiVersion:{}", (Object)"8.1.0.0", (Object)backupfileApiVersion);
            String[] currentApiVersions = "8.1.0.0".split("\\.");
            String[] backupfileApiVersions = backupfileApiVersion.split("\\.");
            if (currentApiVersions.length != backupfileApiVersions.length) {
                return false;
            }
            for (int i = 0; i < currentApiVersions.length && (currentApiVersionPart = Integer.valueOf(currentApiVersions[i]).intValue()) <= (backupfileApiVersionPart = Integer.valueOf(backupfileApiVersions[i]).intValue()); ++i) {
                if (currentApiVersionPart == backupfileApiVersionPart) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

