/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.JodaDateTime2QContactzAdapter;
import com.penpower.worldcard.team.Utils.LocalDateAdapter;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.QContactzTokenVerifyResponse;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.QContactzBatchContact;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.QContactzContactResponse;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.QContactzListContact;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.QContactzOriginContact;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.QContactzPictureContact;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzEmailContact;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzEventType;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzFieldType;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzImType;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzPhoneContact;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzPhoneType;
import com.penpower.worldcard.team.contactsystem.qcontactz.vo.contact.resourcetype.QContactzSourceContact;
import com.penpower.worldcard.team.dto.ContactIMInfo;
import com.penpower.worldcard.team.dto.ContactInfoForRequest;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactdateInfo;
import com.penpower.worldcard.team.dto.ContactemailInfo;
import com.penpower.worldcard.team.dto.ContactimageInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.dto.ContacturlInfo;
import com.penpower.worldcard.team.enums.ContactDateType;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactIMType;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.RecognizeSourceType;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.QContactzOperationService;
import com.penpower.worldcard.team.service.impl.QContactzOperationServiceImpl;
import com.penpower.worldcard.team.web.api.vo.ContactServerSyncInfoForContactServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QContactzOperationServiceImpl
implements QContactzOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(QContactzOperationServiceImpl.class);
    private static final String QCONTACTZ_API_VERSION = "1.2";
    private static final String QCONTACTZ_API_ENDPOINT = String.format("%smcsapi/api/v1/contacts", "http://localhost:8080/");
    private static final String QCONTACTZ_API_BEARER_TOKEN = "Bearer %s";
    private static final String QS_SORT_BY_UPDATED_TIME_DESC = "sortby=updated_on&sortorder=-1&is_active=%b&page=%d&limit=100&fields=_id,updated_on,user_id,is_active";
    private static final String QS_FILTER_ALL_ID = "sortby=_id&fields=_id&is_active=%b&page=%d&limit=100";
    private static final EnumSet<ContactFieldType> ES_MAIL = EnumSet.allOf(ContactFieldType.class);
    private static final EnumSet<ContactIMType> ES_IMS = EnumSet.of(ContactIMType.SKYPE, ContactIMType.QQ, ContactIMType.YAHOO, ContactIMType.GOOGLE_TALK);
    private static final EnumSet<ContactDateType> ES_DATE = EnumSet.allOf(ContactDateType.class);
    private final Gson gson;
    private final DateTimeFormatter dtf;
    @Autowired
    private ContactPrivateService contactPrivateService;
    private final Map<String, String> DTF_REGEX = new /* Unavailable Anonymous Inner Class!! */;
    private final Map<QContactzPhoneType, ContactPhoneType> MAP_PHONE = new /* Unavailable Anonymous Inner Class!! */;
    private final Map<QContactzFieldType, ContactFieldType> MAP_FIELD = new /* Unavailable Anonymous Inner Class!! */;
    private final Map<QContactzImType, ContactIMType> MAP_IM = new /* Unavailable Anonymous Inner Class!! */;

    public QContactzOperationServiceImpl() {
        this.gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JodaDateTime2QContactzAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
        this.dtf = DateTimeFormat.forPattern((String)"dd-MMM-yyyy").withLocale(Locale.ENGLISH);
    }

    private String transfer2QContactzType(ContactPhoneType type) {
        for (Map.Entry entry : this.MAP_PHONE.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    private String transfer2QContactzType(ContactFieldType type) {
        for (Map.Entry entry : this.MAP_FIELD.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    private String transfer2QContactzType(ContactUrlType type) {
        QContactzFieldType qType = null;
        switch (9.$SwitchMap$com$penpower$worldcard$team$enums$ContactUrlType[type.ordinal()]) {
            case 1: {
                qType = QContactzFieldType.OFFICE;
            }
        }
        return qType.toString();
    }

    private String transfer2QContactzType(ContactIMType type) {
        QContactzImType qType = null;
        switch (9.$SwitchMap$com$penpower$worldcard$team$enums$ContactIMType[type.ordinal()]) {
            case 1: {
                qType = QContactzImType.SKYPE;
                break;
            }
            case 2: {
                qType = QContactzImType.QQ;
                break;
            }
            case 3: {
                qType = QContactzImType.GOOGLE_TALK;
                break;
            }
            case 4: {
                qType = QContactzImType.YAHOO;
            }
        }
        return qType.toString();
    }

    private String transfer2QContactzType(ContactDateType type) {
        QContactzEventType qType = null;
        switch (9.$SwitchMap$com$penpower$worldcard$team$enums$ContactDateType[type.ordinal()]) {
            case 1: {
                qType = QContactzEventType.ANNIVERSARY;
                break;
            }
            case 2: {
                qType = QContactzEventType.OTHER;
            }
        }
        return qType.toString();
    }

    private QContactzOriginContact getContactRecordFromWctContact(ContactInfoForResponse contactInfo, QContactzOriginContact queryContactRecord, boolean isForSync) {
        List jobinfos;
        QContactzOriginContact qContactzOriginContact = new QContactzOriginContact();
        List names = contactInfo.getNames();
        if (CollectionUtils.isNotEmpty((Collection)names)) {
            ContactnameInfo name = (ContactnameInfo)names.get(0);
            qContactzOriginContact.setFname(name.getFirstName());
            qContactzOriginContact.setLname(name.getLastName());
            qContactzOriginContact.setMname(name.getMiddleName());
            qContactzOriginContact.setTitle(name.getPrefix());
        }
        if (CollectionUtils.isNotEmpty((Collection)(jobinfos = contactInfo.getJobinfos()))) {
            qContactzOriginContact.setCompanyName(((ContactjobinfoInfo)jobinfos.get(0)).getCompanyName());
        }
        List phoneRecords = qContactzOriginContact.getPhones();
        contactInfo.getPhones().stream().filter(phone -> this.MAP_PHONE.containsValue(phone.getType())).forEach(phone -> phoneRecords.add(new QContactzPhoneContact(this.transfer2QContactzType(phone.getType()), phone.getValue())));
        qContactzOriginContact.setPhones(phoneRecords);
        List addressRecords = qContactzOriginContact.getAddresses();
        Optional<ContactaddressInfo> homeAddrOption = contactInfo.getAddresses().stream().filter(adr -> ContactFieldType.HOME.equals((Object)adr.getType())).findFirst();
        if (!homeAddrOption.isPresent()) {
            addressRecords.add(new QContactzSourceContact(QContactzFieldType.HOME.toString(), ""));
        } else {
            addressRecords.add(new QContactzSourceContact(QContactzFieldType.HOME.toString(), homeAddrOption.get().GetFullAddress()));
        }
        Optional<ContactaddressInfo> buzAddrOption = contactInfo.getAddresses().stream().filter(adr -> ContactFieldType.BUSINESS.equals((Object)adr.getType())).findFirst();
        if (buzAddrOption.isPresent()) {
            addressRecords.add(new QContactzSourceContact(QContactzFieldType.OFFICE.toString(), buzAddrOption.get().GetFullAddress()));
        }
        qContactzOriginContact.setAddresses(addressRecords);
        List emailRecords = qContactzOriginContact.getEmails();
        contactInfo.getEmails().stream().filter(mail -> ES_MAIL.contains(mail.getType())).forEach(mail -> emailRecords.add(new QContactzEmailContact(this.transfer2QContactzType(mail.getType()), mail.getValue())));
        qContactzOriginContact.setEmails(emailRecords);
        List webPageRecords = qContactzOriginContact.getWebPages();
        contactInfo.getUrls().stream().filter(url -> ContactFieldType.BUSINESS.toString().equals(url.getType().toString())).forEach(url -> webPageRecords.add(new QContactzSourceContact(this.transfer2QContactzType(url.getType()), url.getValue())));
        qContactzOriginContact.setWebPages(webPageRecords);
        List imRecords = qContactzOriginContact.getIm();
        contactInfo.getIMs().stream().filter(im -> ES_IMS.contains(im.getType())).forEach(im -> imRecords.add(new QContactzSourceContact(this.transfer2QContactzType(im.getType()), im.getValue())));
        if (queryContactRecord != null) {
            queryContactRecord.getIm().stream().filter(im -> !EnumUtils.isValidEnum(QContactzImType.class, (String)im.getLabel())).forEach(im -> imRecords.add(im));
        }
        qContactzOriginContact.setIm(imRecords);
        List eventRecords = qContactzOriginContact.getEvents();
        DateTime birthday = contactInfo.getBirthday();
        if (birthday != null) {
            eventRecords.add(new QContactzSourceContact(QContactzEventType.BIRTH_DATE.toString(), this.dtf.print((ReadableInstant)birthday)));
        }
        contactInfo.getDates().stream().filter(date -> ES_DATE.contains(date.getType())).forEach(date -> eventRecords.add(new QContactzSourceContact(this.transfer2QContactzType(date.getType()), this.dtf.print((ReadableInstant)date.getValue()))));
        if (queryContactRecord != null) {
            queryContactRecord.getEvents().stream().filter(event -> !EnumUtils.isValidEnum(QContactzEventType.class, (String)event.getLabel())).forEach(event -> eventRecords.add(event));
        }
        qContactzOriginContact.setEvents(eventRecords);
        if (queryContactRecord != null) {
            List lSource;
            List lOther;
            List lAttach = queryContactRecord.getAttachments();
            if (CollectionUtils.isNotEmpty((Collection)lAttach)) {
                qContactzOriginContact.setAttachments(lAttach);
            }
            if (CollectionUtils.isNotEmpty((Collection)(lOther = queryContactRecord.getOthers()))) {
                qContactzOriginContact.setOthers(lOther);
            }
            if (CollectionUtils.isNotEmpty((Collection)(lSource = queryContactRecord.getSources()))) {
                qContactzOriginContact.setSources(lSource);
            }
        }
        qContactzOriginContact.setNickname(contactInfo.getNickname());
        qContactzOriginContact.setNote(contactInfo.getNote());
        return qContactzOriginContact;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existProxyError(String token, OkHttpClient client) {
        String contactServerId = this.insertEmptyContactRecord(token, client);
        boolean deleted = this.trashCotactRecord(token, Arrays.asList(contactServerId), client);
        if (!deleted) return false;
        String url = String.format("%s/%s", QCONTACTZ_API_ENDPOINT, contactServerId);
        Request request = new Request.Builder().addHeader("cache-control", "no-cache").addHeader("qcontactz-version", QCONTACTZ_API_VERSION).addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("existProxyError:{}, responseString:{}", (Object)url, (Object)responseString);
            if (!responseString.startsWith("<!DOCTYPE")) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOG.error("existProxyError Failed response: {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    public QContactzOriginContact insertContactRecord(ContactInfoForResponse contactInfo, String token, OkHttpClient client) {
        QContactzPictureContact pictureContact = this.updateContactProfile(contactInfo, token, client);
        QContactzOriginContact qContactzContactRecord = this.getContactRecordFromWctContact(contactInfo, null, false);
        if (pictureContact != null) {
            qContactzContactRecord.setProfilePicture(pictureContact.getProfilePicture());
            qContactzContactRecord.setId(pictureContact.getContactId());
        }
        String contactServerId = this.insertContactRecord(qContactzContactRecord, token, client);
        return this.findContactRecordByContactServerId(token, contactServerId, false, client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QContactzOriginContact updateContactRecord(ContactInfoForResponse contactInfo, String contactServerId, String token, QContactzOriginContact contactRecord, boolean isForSync, OkHttpClient client) {
        QContactzPictureContact pictureContact = this.updateContactProfile(contactInfo, token, client);
        QContactzOriginContact qContactzContactRecord = this.getContactRecordFromWctContact(contactInfo, contactRecord, isForSync);
        if (pictureContact != null) {
            qContactzContactRecord.setProfilePicture(pictureContact.getProfilePicture());
        }
        String updatedContactRecord = this.gson.toJson((Object)qContactzContactRecord);
        String url = String.format("%s/%s", QCONTACTZ_API_ENDPOINT, contactServerId);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)updatedContactRecord);
        Request request = new Request.Builder().addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).addHeader("qcontactz-version", QCONTACTZ_API_VERSION).url(url).put(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("updateContactRecord: {}, url: {}, responseString: {}", new Object[]{updatedContactRecord, url, responseString});
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzContactResponse contactResponse = (QContactzContactResponse)this.gson.fromJson(responseString, QContactzContactResponse.class);
            if (!contactResponse.isStatus()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzOriginContact qContactzOriginContact = this.findContactRecordByContactServerId(token, contactServerId, false, client);
            return qContactzOriginContact;
        }
        catch (Exception ex) {
            LOG.error("updateContactRecord failed {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean deleteContactRecord(String token, String contactServerId, OkHttpClient client) {
        String url = String.format("%s/%s", QCONTACTZ_API_ENDPOINT, contactServerId);
        Request request = new Request.Builder().addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).addHeader("qcontactz-version", QCONTACTZ_API_VERSION).url(url).delete().build();
        return this.deleteContactRecord(client, url, request);
    }

    public boolean trashCotactRecord(String token, List<String> contactServerId, OkHttpClient client) {
        String url = String.format("%s/batch_delete", QCONTACTZ_API_ENDPOINT);
        String trashContactRecord = this.gson.toJson((Object)new QContactzBatchContact(contactServerId));
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)trashContactRecord);
        Request request = new Request.Builder().addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).addHeader("qcontactz-version", QCONTACTZ_API_VERSION).url(url).post(requestBody).build();
        return this.deleteContactRecord(client, url, request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyAuthToken(String token, OkHttpClient client) {
        String responseKey = "status";
        Request request = new Request.Builder().addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).addHeader("Content-Type", "application/json").addHeader("qcontactz-version", QCONTACTZ_API_VERSION).url(QCONTACTZ_API_ENDPOINT).get().build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("verifyAuthToken: {}, response: {}", (Object)QCONTACTZ_API_ENDPOINT, (Object)responseString);
            if (!response.isSuccessful()) {
                LOG.error("verifyAuthToken failed {}", (Object)this.getErrorMessage(responseString));
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzTokenVerifyResponse verifyResponse = (QContactzTokenVerifyResponse)this.gson.fromJson(responseString, QContactzTokenVerifyResponse.class);
            if (!verifyResponse.isStatus()) {
                LOG.error("verifyAuthToken failed {}", (Object)this.getErrorMessage(responseString));
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            Map dataMap = verifyResponse.getData();
            if (dataMap.containsKey("status")) {
                boolean bl2 = (Boolean)dataMap.get("status");
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            LOG.error("verifyAuthToken failed {}", (Object)ex.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] findContactProfile(String token, String url, OkHttpClient client) {
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() != 200) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = response.body().bytes();
            return byArray;
        }
        catch (Exception ex) {
            LOG.error("findContactProfile failed {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QContactzPictureContact updateContactProfile(ContactInfoForResponse contactInfo, String token, OkHttpClient client) {
        Optional<ContactimageInfo> contactLogoOptional = contactInfo.getImages().stream().filter(image -> ContactImageType.LOGO.equals((Object)image.getType())).findFirst();
        if (!contactLogoOptional.isPresent()) {
            return null;
        }
        try {
            byte[] imageByte = this.contactPrivateService.getImageContent(contactInfo.getGuid(), ContactImageType.LOGO);
            String url = String.format("%s/picture", QCONTACTZ_API_ENDPOINT);
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"image/jpeg"), (byte[])imageByte);
            MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("profile_pic", contactInfo.getGuid() + ".jpg", fileBody).build();
            Request request = new Request.Builder().addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).addHeader("Content-Type", "image/jpeg").url(url).post((RequestBody)requestBody).build();
            try (Response response = client.newCall(request).execute();){
                String responseString = OkHttpUtils.getResponseBodyString((Response)response);
                LOG.debug("updateContactProfile: {}, responseString: {}", (Object)url, (Object)responseString);
                if (!response.isSuccessful()) {
                    throw new HttpConnectionException(this.getErrorMessage(responseString));
                }
                QContactzContactResponse contactResponse = (QContactzContactResponse)this.gson.fromJson(responseString, new /* Unavailable Anonymous Inner Class!! */.getType());
                if (!contactResponse.isStatus()) {
                    throw new HttpConnectionException(this.getErrorMessage(responseString));
                }
                QContactzPictureContact pictureContact = (QContactzPictureContact)contactResponse.getData();
                LOG.debug("id: {}, picture: {}", (Object)pictureContact.getContactId(), (Object)pictureContact.getProfilePicture());
                QContactzPictureContact qContactzPictureContact = pictureContact;
                return qContactzPictureContact;
            }
            catch (Exception ex) {
                LOG.error("updateContactProfile failed {}", (Object)ex.getMessage());
                throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
            }
        }
        catch (ItemNotFoundException | IOException ex) {
            LOG.error(ex.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QContactzOriginContact findContactRecordByContactServerId(String token, String contactServerId, boolean existProxyError, OkHttpClient client) {
        if (existProxyError && !this.isContactExist(token, client, contactServerId)) {
            return null;
        }
        String url = String.format("%s/%s", QCONTACTZ_API_ENDPOINT, contactServerId);
        Request request = new Request.Builder().addHeader("cache-control", "no-cache").addHeader("qcontactz-version", QCONTACTZ_API_VERSION).addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("findContactRecordByContactServerId: {}, responseString: {}", (Object)url, (Object)responseString);
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzContactResponse contactResponse = (QContactzContactResponse)this.gson.fromJson(responseString, new /* Unavailable Anonymous Inner Class!! */.getType());
            if (!contactResponse.isStatus()) {
                if (Integer.valueOf(contactResponse.getStatusCode()) != 11040) throw new HttpConnectionException(this.getErrorMessage(responseString));
                QContactzOriginContact qContactzOriginContact = null;
                return qContactzOriginContact;
            }
            QContactzOriginContact qContactzOriginContact = (QContactzOriginContact)contactResponse.getData();
            return qContactzOriginContact;
        }
        catch (Exception ex) {
            LOG.error("findContactRecordByContactServerId Failed response: {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<ContactServerSyncInfoForContactServer> findContactListRecord4Sync(String token, DateTime lastSyncCompletedTime, boolean deletedIncluded, OkHttpClient client) {
        ArrayList<ContactServerSyncInfoForContactServer> contactList = new ArrayList<ContactServerSyncInfoForContactServer>();
        if (deletedIncluded) {
            contactList.addAll(this.findContactListRecord(token, lastSyncCompletedTime, false, client));
        }
        contactList.addAll(this.findContactListRecord(token, lastSyncCompletedTime, true, client));
        contactList.sort(Comparator.comparing(ContactServerSyncInfoForContactServer::getModifiedTime));
        return contactList;
    }

    public ContactInfoForRequest findContactCreationVoFromQContactzRecord(String token, QContactzOriginContact contactRecord, OkHttpClient client) {
        ContactInfoForRequest contactResult = new ContactInfoForRequest();
        try {
            ContactnameInfo name = new ContactnameInfo();
            name.setLastName(contactRecord.getLname());
            name.setFirstName(contactRecord.getFname());
            name.setMiddleName(contactRecord.getMname());
            name.setPrefix(contactRecord.getTitle());
            name.setFirstNamePronunce("");
            name.setLastNamePronunce("");
            name.setSuffix("");
            name.setRecognizeSource(RecognizeSourceType.MANUAL);
            contactResult.getNames().add(name);
            contactResult.setNickname(contactRecord.getNickname());
            ContactjobinfoInfo jobInfo = new ContactjobinfoInfo();
            jobInfo.setCompanyName(contactRecord.getCompanyName());
            jobInfo.setDepartment("");
            jobInfo.setCompanyPronunce("");
            jobInfo.setRecognizeSource(RecognizeSourceType.MANUAL);
            contactResult.getJobinfos().add(jobInfo);
            int count = 0;
            for (QContactzPhoneContact phone : contactRecord.getPhones()) {
                if (count > 15) continue;
                contactResult.getPhones().add(new ContactphoneInfo(phone.getValue(), (ContactPhoneType)this.MAP_PHONE.get(QContactzPhoneType.valueOf((String)phone.getLabel())), RecognizeSourceType.MANUAL));
                ++count;
            }
            count = 0;
            for (QContactzSourceContact address : contactRecord.getAddresses()) {
                if (StringUtils.isEmpty((CharSequence)address.getValue())) continue;
                contactResult.getAddresses().add(new ContactaddressInfo("", "", "", address.getValue(), "", Integer.valueOf(count), (ContactFieldType)this.MAP_FIELD.get(QContactzFieldType.valueOf((String)address.getLabel())), RecognizeSourceType.MANUAL));
            }
            count = 0;
            for (QContactzEmailContact email : contactRecord.getEmails()) {
                if (count > 5) continue;
                contactResult.getEmails().add(new ContactemailInfo(email.getValue(), (ContactFieldType)this.MAP_FIELD.get(QContactzFieldType.valueOf((String)email.getLabel())), RecognizeSourceType.MANUAL));
                ++count;
            }
            count = 0;
            for (QContactzSourceContact webpage : contactRecord.getWebPages()) {
                if (count > 5) continue;
                contactResult.getUrls().add(new ContacturlInfo(webpage.getValue(), ContactUrlType.BUSINESS, RecognizeSourceType.MANUAL));
                ++count;
            }
            count = 0;
            for (QContactzSourceContact im : contactRecord.getIm()) {
                if (!ES_IMS.toString().contains(im.getLabel()) || count > 5) continue;
                contactResult.getIMs().add(new ContactIMInfo(im.getValue(), (ContactIMType)this.MAP_IM.get(QContactzImType.valueOf((String)im.getLabel())), RecognizeSourceType.MANUAL));
                ++count;
            }
            Optional<DateTime> birthday = contactRecord.getEvents().stream().filter(event -> event.getLabel().equals(QContactzEventType.BIRTH_DATE.toString())).map(birth -> this.dateTimeFormat(birth.getValue())).findFirst();
            if (birthday.isPresent()) {
                contactResult.setBirthday(birthday.get());
            }
            count = 0;
            for (QContactzSourceContact anniversary : contactRecord.getEvents()) {
                DateTime annual;
                if (!anniversary.getLabel().equals(QContactzEventType.ANNIVERSARY.toString()) || count > 3 || (annual = this.dateTimeFormat(anniversary.getValue())) == null) continue;
                contactResult.getDates().add(new ContactdateInfo(anniversary.getId(), ContactDateType.CELEBRATION, annual));
                ++count;
            }
            contactResult.setNote(contactRecord.getNote());
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        return contactResult;
    }

    private List<ContactServerSyncInfoForContactServer> findContactListRecord(String token, DateTime lastSyncCompletedTime, boolean isActive, OkHttpClient client) {
        int pageTotal;
        ArrayList<ContactServerSyncInfoForContactServer> contactList = new ArrayList<ContactServerSyncInfoForContactServer>();
        int pageOffset = 0;
        do {
            QContactzListContact contactListRecord = this.findContactRecordOrderByUpdatedonDesc(token, pageOffset, isActive, client);
            pageTotal = contactListRecord.getPages();
            if (contactListRecord.getCurrentCount() == 0) continue;
            contactList.addAll(contactListRecord.getDataList().stream().filter(contact -> contact.getUpdatedOn().isAfter((ReadableInstant)lastSyncCompletedTime)).map(c -> new ContactServerSyncInfoForContactServer(c.getId(), c.getActive() == false, c.getUpdatedOn(), c.getUserId())).collect(Collectors.toSet()));
        } while (pageTotal != 0 && ++pageOffset < pageTotal);
        return contactList;
    }

    private QContactzListContact findContactRecordOrderByUpdatedonDesc(String token, int pageOffset, boolean isActive, OkHttpClient client) {
        String queryString = String.format(QS_SORT_BY_UPDATED_TIME_DESC, isActive, pageOffset);
        return this.requestByQueryString(token, queryString, client);
    }

    private boolean isContactExist(String token, OkHttpClient client, String contactServerId) {
        boolean isExist = this.findContactIdListByPages(token, true, client, contactServerId);
        if (!isExist) {
            isExist = this.findContactIdListByPages(token, false, client, contactServerId);
        }
        return isExist;
    }

    private boolean findContactIdListByPages(String token, boolean isActive, OkHttpClient client, String contactServerId) {
        int pageTotal;
        boolean isExist = false;
        int pageOffset = 0;
        do {
            QContactzListContact contactListRecord = this.findContactIdList(token, isActive, pageOffset, client);
            pageTotal = contactListRecord.getPages();
            if (contactListRecord.getCurrentCount() == 0) continue;
            isExist = contactListRecord.getDataList().stream().anyMatch(record -> contactServerId.equals(record.getId()));
        } while (!isExist && pageTotal != 0 && ++pageOffset < pageTotal);
        return isExist;
    }

    private QContactzListContact findContactIdList(String token, boolean isActive, int pageOffset, OkHttpClient client) {
        String queryString = String.format(QS_FILTER_ALL_ID, isActive, pageOffset);
        return this.requestByQueryString(token, queryString, client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QContactzListContact requestByQueryString(String token, String queryString, OkHttpClient client) {
        String url = String.format("%s?%s", QCONTACTZ_API_ENDPOINT, queryString);
        Request request = new Request.Builder().addHeader("cache-control", "no-cache").addHeader("qcontactz-version", QCONTACTZ_API_VERSION).addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).url(url).get().build();
        try (Response response = client.newCall(request).execute();){
            QContactzListContact contactListRecord;
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("requestByQueryString:{}, responseString:{}", (Object)url, (Object)responseString);
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzContactResponse contactResponse = (QContactzContactResponse)this.gson.fromJson(responseString, new /* Unavailable Anonymous Inner Class!! */.getType());
            if (!contactResponse.isStatus()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzListContact qContactzListContact = contactListRecord = (QContactzListContact)contactResponse.getData();
            return qContactzListContact;
        }
        catch (Exception ex) {
            LOG.error("requestByQueryString Failed response: {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String insertEmptyContactRecord(String token, OkHttpClient client) {
        QContactzOriginContact qContactzContactRecord = new QContactzOriginContact();
        qContactzContactRecord.setActive(Boolean.valueOf(false));
        return this.insertContactRecord(qContactzContactRecord, token, client);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String insertContactRecord(QContactzOriginContact qContactzContactRecord, String token, OkHttpClient client) {
        String contactRecord = this.gson.toJson((Object)qContactzContactRecord);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)contactRecord);
        Request request = new Request.Builder().addHeader("Authorization", String.format(QCONTACTZ_API_BEARER_TOKEN, token)).addHeader("qcontactz-version", QCONTACTZ_API_VERSION).url(QCONTACTZ_API_ENDPOINT).post(requestBody).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("insertContactRecord: {}, url: {}, responseString: {}", new Object[]{contactRecord, QCONTACTZ_API_ENDPOINT, responseString});
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzContactResponse contactResponse = (QContactzContactResponse)this.gson.fromJson(responseString, new /* Unavailable Anonymous Inner Class!! */.getType());
            if (!contactResponse.isStatus()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            String createdContactId = (String)contactResponse.getData();
            LOG.debug("createdContactId:{}", (Object)createdContactId);
            String string = createdContactId;
            return string;
        }
        catch (Exception ex) {
            LOG.error("insertContactRecord failed {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteContactRecord(OkHttpClient client, String url, Request request) {
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request:{}, response:{}", (Object)url, (Object)responseString);
            if (!response.isSuccessful()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            QContactzContactResponse contactResponse = (QContactzContactResponse)this.gson.fromJson(responseString, QContactzContactResponse.class);
            if (!contactResponse.isStatus()) {
                throw new HttpConnectionException(this.getErrorMessage(responseString));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOG.error("deleteContactRecord failed {}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getErrorMessage(String responseString) {
        QContactzContactResponse response = (QContactzContactResponse)this.gson.fromJson(responseString, QContactzContactResponse.class);
        String error = String.format("[code]: %s, [message]: %s", response.getStatusCode(), response.getMessage());
        LOG.error("error: {}", (Object)error);
        return error;
    }

    private DateTime dateTimeFormat(String dateTimeString) {
        String format = null;
        for (Map.Entry entry : this.DTF_REGEX.entrySet()) {
            if (!dateTimeString.trim().toUpperCase().matches((String)entry.getKey())) continue;
            format = (String)entry.getValue();
        }
        if (format != null) {
            return DateTimeFormat.forPattern(format).withLocale(Locale.ENGLISH).parseDateTime(dateTimeString);
        }
        return null;
    }
}

