/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.penpower.worldcard.team.Utils.JodaDateTimeAdapter;
import com.penpower.worldcard.team.Utils.LocalDateAdapter;
import com.penpower.worldcard.team.Utils.OkHttpUtils;
import com.penpower.worldcard.team.contactsystem.office365.vo.Office365ErrorResponse;
import com.penpower.worldcard.team.contactsystem.office365.vo.Office365ErrorResponseDetail;
import com.penpower.worldcard.team.contactsystem.office365.vo.Office365PagingListResponse;
import com.penpower.worldcard.team.contactsystem.office365.vo.contact.Office365ContactForUpdate;
import com.penpower.worldcard.team.contactsystem.office365.vo.contact.Office365ContactOrigin;
import com.penpower.worldcard.team.contactsystem.office365.vo.contact.Office365DeltaQueryContact;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365EmailAddress;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365EmailType;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365Phone;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365PhoneType;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365PhysicalAddress;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365PhysicalAddressType;
import com.penpower.worldcard.team.contactsystem.office365.vo.resourcetype.Office365Website;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactServerSettingsWithTokenDto;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactimageInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.enums.ContactDateType;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.exception.HttpConnectionException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.Office365OperationService;
import com.penpower.worldcard.team.service.impl.Office365OperationServiceImpl;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Office365OperationServiceImpl
implements Office365OperationService {
    private static final int MAX_PHONE_SIZE = 14;
    private static final int MAX_EMAIL_ADDRESS_SIZE = 3;
    private static final int MAX_POSTAL_ADDRESS_SIZE = 3;
    private static final Logger LOG = LoggerFactory.getLogger(Office365OperationServiceImpl.class);
    public static final String CONTACT_SERVER_ID_EXTENDED_PROPERTIES_ID = "String {66f5a359-4659-4830-9070-00040ec6ac6e} Name contactServerId";
    private static final String FILTER_LASTMODIFIED_DATETIME_GREATER_THAN_FORMAT = "$filter=lastModifiedDateTime ge %s";
    private static final String OFFICE365_GRAPH_API_BETA_VERSION_ENDPOINT = "https://graph.microsoft.com/beta/me";
    private static final String ISO_8601_FORMATTER = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    @Autowired
    private ContactPrivateService contactPrivateService;
    private Gson gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JodaDateTimeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).create();
    private Gson gsonSerializedNull = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JodaDateTimeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new LocalDateAdapter()).serializeNulls().create();
    private MediaType JSON = MediaType.parse((String)"application/json;charset=UTF-8");

    private Office365ContactForUpdate getContactRecordFromWctContact(ContactInfoForResponse contactInfo, Office365ContactOrigin oldContactRecord, boolean isForSync) {
        int currentPhoneSize;
        DateTime anniversay;
        Optional<DateTime> celebrationOptional;
        Office365ContactForUpdate office365ContactRecord = new Office365ContactForUpdate();
        office365ContactRecord.setNickName(contactInfo.getNickname());
        office365ContactRecord.setPersonalNotes(contactInfo.getNote());
        office365ContactRecord.setBirthday(contactInfo.getBirthday());
        List contactaddressInfos = contactInfo.getAddresses();
        HashMap<ContactFieldType, Integer> numberOfAddressType = new HashMap<ContactFieldType, Integer>();
        numberOfAddressType.put(ContactFieldType.BUSINESS, 0);
        numberOfAddressType.put(ContactFieldType.HOME, 0);
        numberOfAddressType.put(ContactFieldType.OTHER, 0);
        ArrayList<Office365PhysicalAddress> physicalAddressRecords = new ArrayList<Office365PhysicalAddress>();
        block14: for (ContactaddressInfo address : contactaddressInfos) {
            ContactFieldType addressType = address.getType();
            if ((Integer)numberOfAddressType.get(addressType) == 1) continue;
            Office365PhysicalAddress physicalAddress = new Office365PhysicalAddress(address.getCity(), address.getCountryName(), address.getZip(), address.getState(), address.getStreet());
            switch (3.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[addressType.ordinal()]) {
                case 1: {
                    physicalAddress.setType(Office365PhysicalAddressType.business);
                    break;
                }
                case 2: {
                    physicalAddress.setType(Office365PhysicalAddressType.home);
                    break;
                }
                case 3: {
                    physicalAddress.setType(Office365PhysicalAddressType.other);
                    break;
                }
                default: {
                    continue block14;
                }
            }
            physicalAddressRecords.add(physicalAddress);
            int count = (Integer)numberOfAddressType.get(addressType) + 1;
            numberOfAddressType.replace(addressType, count);
        }
        office365ContactRecord.setPostalAddresses(physicalAddressRecords.stream().limit(3L).collect(Collectors.toList()));
        List office365EmailsRecords = contactInfo.getEmails().stream().filter(email -> ContactFieldType.BUSINESS.equals((Object)email.getType())).map(email -> {
            Office365EmailAddress emailAddress = new Office365EmailAddress(email.getValue(), email.getType().toString());
            emailAddress.setType(Office365EmailType.other);
            return emailAddress;
        }).limit(3L).collect(Collectors.toList());
        office365ContactRecord.setEmailAddresses(office365EmailsRecords);
        List names = contactInfo.getNames();
        if (CollectionUtils.isNotEmpty((Collection)names)) {
            ContactnameInfo contactnameInfo = (ContactnameInfo)names.get(0);
            String firstName = contactnameInfo.getFirstName() == null ? "" : contactnameInfo.getFirstName();
            String lastName = contactnameInfo.getLastName() == null ? "" : contactnameInfo.getLastName();
            String middleName = contactnameInfo.getMiddleName() == null ? "" : contactnameInfo.getMiddleName();
            office365ContactRecord.setGivenName(firstName);
            office365ContactRecord.setSurname(lastName);
            office365ContactRecord.setMiddleName(middleName);
            office365ContactRecord.setDisplayName(firstName + " " + lastName);
            office365ContactRecord.setFileAs("");
            office365ContactRecord.setGeneration(contactnameInfo.getPrefix());
            office365ContactRecord.setYomiGivenName(contactnameInfo.getFirstNamePronunce());
            office365ContactRecord.setYomiSurname(contactnameInfo.getLastNamePronunce());
        }
        if ((celebrationOptional = contactInfo.getDates().stream().filter(d -> d.getType().equals((Object)ContactDateType.CELEBRATION)).map(d -> d.getValue()).findFirst()).isPresent() && (anniversay = celebrationOptional.get()) != null) {
            LocalDate anniversayLocalDate = LocalDate.of(anniversay.getYear(), anniversay.getMonthOfYear(), anniversay.getDayOfMonth());
            office365ContactRecord.setWeddingAnniversary(anniversayLocalDate);
        }
        if (CollectionUtils.isNotEmpty((Collection)contactInfo.getJobinfos())) {
            ContactjobinfoInfo contactjobinfoInfo = (ContactjobinfoInfo)contactInfo.getJobinfos().get(0);
            office365ContactRecord.setCompanyName(contactjobinfoInfo.getCompanyName());
            office365ContactRecord.setJobTitle(contactjobinfoInfo.getJobTitle());
            office365ContactRecord.setDepartment(contactjobinfoInfo.getDepartment());
            office365ContactRecord.setYomiCompanyName(contactjobinfoInfo.getCompanyPronunce());
        } else {
            office365ContactRecord.setCompanyName(null);
            office365ContactRecord.setJobTitle(null);
            office365ContactRecord.setDepartment(null);
            office365ContactRecord.setYomiCompanyName(null);
        }
        List contactphoneInfos = contactInfo.getPhones();
        ArrayList<Office365Phone> phoneRecords = new ArrayList<Office365Phone>();
        HashMap<ContactPhoneType, Integer> numberOfPerPhoneType = new HashMap<ContactPhoneType, Integer>();
        numberOfPerPhoneType.put(ContactPhoneType.BBCALL, 0);
        numberOfPerPhoneType.put(ContactPhoneType.BUSINESS_FAX, 0);
        numberOfPerPhoneType.put(ContactPhoneType.BUSINESS_TEL, 0);
        numberOfPerPhoneType.put(ContactPhoneType.CELL, 0);
        numberOfPerPhoneType.put(ContactPhoneType.GOOGLE_VOICE, 0);
        numberOfPerPhoneType.put(ContactPhoneType.HOME_FAX, 0);
        numberOfPerPhoneType.put(ContactPhoneType.HOME_TEL, 0);
        numberOfPerPhoneType.put(ContactPhoneType.IPHONE, 0);
        numberOfPerPhoneType.put(ContactPhoneType.MAIN, 0);
        numberOfPerPhoneType.put(ContactPhoneType.OTHER_FAX, 0);
        numberOfPerPhoneType.put(ContactPhoneType.OTHER_TEL, 0);
        block15: for (ContactphoneInfo phone : contactphoneInfos) {
            Office365Phone phoneRecord = new Office365Phone(phone.getValue());
            ContactPhoneType phoneType = phone.getType();
            if (phoneType.equals((Object)ContactPhoneType.HOME_TEL) || phoneType.equals((Object)ContactPhoneType.BUSINESS_TEL) || phoneType.equals((Object)ContactPhoneType.OTHER_TEL) ? (Integer)numberOfPerPhoneType.get(phoneType) == 2 : (Integer)numberOfPerPhoneType.get(phoneType) == 1) continue;
            switch (3.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[phoneType.ordinal()]) {
                case 1: {
                    phoneRecord.setType(Office365PhoneType.pager);
                    break;
                }
                case 2: {
                    phoneRecord.setType(Office365PhoneType.businessFax);
                    break;
                }
                case 3: {
                    phoneRecord.setType(Office365PhoneType.business);
                    break;
                }
                case 4: {
                    phoneRecord.setType(Office365PhoneType.mobile);
                    break;
                }
                case 5: {
                    phoneRecord.setType(Office365PhoneType.homeFax);
                    break;
                }
                case 6: {
                    phoneRecord.setType(Office365PhoneType.home);
                    break;
                }
                case 7: {
                    phoneRecord.setType(Office365PhoneType.other);
                    break;
                }
                default: {
                    continue block15;
                }
            }
            phoneRecords.add(phoneRecord);
            int count = (Integer)numberOfPerPhoneType.get(phoneType) + 1;
            numberOfPerPhoneType.replace(phoneType, count);
        }
        office365ContactRecord.setPhones(phoneRecords.stream().limit(14L).collect(Collectors.toList()));
        List office365WebsiteRecords = contactInfo.getUrls().stream().filter(url -> url.getType().equals((Object)ContactUrlType.BUSINESS)).map(url -> new Office365Website(url.getValue(), url.getType().toString())).limit(1L).collect(Collectors.toList());
        office365ContactRecord.setWebsites(office365WebsiteRecords);
        if (isForSync && (currentPhoneSize = office365ContactRecord.getPhones().size()) < 14) {
            List otherPhones = oldContactRecord.getPhones().stream().filter(i -> i.getType().equals((Object)Office365PhoneType.assistant) || i.getType().equals((Object)Office365PhoneType.otherFax) || i.getType().equals((Object)Office365PhoneType.radio)).limit(14 - currentPhoneSize).collect(Collectors.toList());
            office365ContactRecord.getPhones().addAll(otherPhones);
        }
        return office365ContactRecord;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Office365ContactOrigin updateContactRecord(ContactInfoForResponse contactInfo, String conactIdentifier, String token, Office365ContactOrigin contactRecord, boolean isForSync, OkHttpClient client) throws Exception {
        Office365ContactForUpdate updatedContactRecord = this.getContactRecordFromWctContact(contactInfo, contactRecord, isForSync);
        String url = "https://graph.microsoft.com/beta/me/contacts/" + conactIdentifier;
        RequestBody body = RequestBody.create((MediaType)this.JSON, (String)this.gsonSerializedNull.toJson((Object)updatedContactRecord));
        Request request = new Request.Builder().patch(body).addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request={}, originResponse={}", (Object)url, (Object)responseString);
            if (response.isSuccessful()) {
                Office365ContactOrigin office365CreatedContact = (Office365ContactOrigin)this.gson.fromJson(responseString, Office365ContactOrigin.class);
                LOG.debug("Binding response to Office365ContactOrigin={}", (Object)office365CreatedContact);
                Office365ContactOrigin office365ContactOrigin = office365CreatedContact;
                return office365ContactOrigin;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String getErrorMessage(String responseString) {
        Office365ErrorResponseDetail errorResponse = ((Office365ErrorResponse)this.gson.fromJson(responseString, Office365ErrorResponse.class)).getError();
        String errorMessage = String.format("[code]:%s, [message]:%s", errorResponse.getCode(), errorResponse.getMessage());
        return errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Office365ContactOrigin insertContactRecord(ContactInfoForResponse contactInfo, String token, OkHttpClient client) throws Exception {
        Office365ContactForUpdate contactRecord = this.getContactRecordFromWctContact(contactInfo, null, false);
        String url = "https://graph.microsoft.com/beta/me/contacts";
        RequestBody body = RequestBody.create((MediaType)this.JSON, (String)this.gson.toJson((Object)contactRecord));
        Request request = new Request.Builder().post(body).addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request={}, originResponse={}", (Object)url, (Object)responseString);
            if (response.isSuccessful()) {
                Office365ContactOrigin office365CreatedContact = (Office365ContactOrigin)this.gson.fromJson(responseString, Office365ContactOrigin.class);
                LOG.debug("Binding response to Office365ContactOrigin={}", (Object)office365CreatedContact);
                Office365ContactOrigin office365ContactOrigin = office365CreatedContact;
                return office365ContactOrigin;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Office365ContactOrigin findContactRecordByContactServerId(String contactServerId, String token, OkHttpClient client) {
        String url = "https://graph.microsoft.com/beta/me/contacts/" + contactServerId;
        LOG.debug("url={}", (Object)url);
        Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request={}, originResponse={}", (Object)url, (Object)responseString);
            if (response.isSuccessful()) {
                Office365ContactOrigin office365ContactOrigin = (Office365ContactOrigin)this.gson.fromJson(responseString, Office365ContactOrigin.class);
                return office365ContactOrigin;
            }
            if (response.code() == 404 || response.code() == 400) {
                Office365ContactOrigin office365ContactOrigin = null;
                return office365ContactOrigin;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (Exception ex) {
            LOG.error("insertContactRecord Failed response={}", (Object)ex.getMessage());
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateContactLogoIfExist(String contactIdentifier, ContactInfoForResponse contactInfo, String token, OkHttpClient client) throws IOException {
        Optional<ContactimageInfo> contactLogoOptional = contactInfo.getImages().stream().filter(image -> ContactImageType.LOGO.equals((Object)image.getType())).findFirst();
        if (!contactLogoOptional.isPresent()) return false;
        try {
            byte[] imageByte = this.contactPrivateService.getImageContent(contactInfo.getGuid(), ContactImageType.LOGO);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"image/jpeg"), (byte[])imageByte);
            String url = "https://graph.microsoft.com/beta/me/contacts/" + contactIdentifier + "/photo/$value";
            Request request = new Request.Builder().put(body).addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).addHeader("Content-Type", "image/jpeg").url(url).build();
            try (Response response = client.newCall(request).execute();){
                String responseString = OkHttpUtils.getResponseBodyString((Response)response);
                LOG.debug("request={}, originResponse={}", (Object)url, (Object)responseString);
                if (response.isSuccessful()) {
                    LOG.debug("upload contact photo success");
                    boolean bl = true;
                    return bl;
                }
                LOG.error("upload contact photo failed={}", (Object)responseString);
                boolean bl = false;
                return bl;
            }
            catch (Exception ex) {
                LOG.error("upload contact Failed response={}", (Object)ex.getMessage());
                return false;
            }
        }
        catch (ItemNotFoundException ex) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteContactRecord(String contactIdentifier, String token, OkHttpClient client) {
        String url = "https://graph.microsoft.com/beta/me/contacts/" + contactIdentifier;
        Request request = new Request.Builder().delete().addHeader("Authorization", "Bearer " + token).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            LOG.debug("request={}, originResponse={}", (Object)url, (Object)responseString);
            if (response.isSuccessful()) {
                boolean bl = true;
                return bl;
            }
            if (responseString.contains("ErrorCannotDeleteObject") || responseString.contains("ErrorItemNotFound")) {
                LOG.debug("delete contact record success");
                boolean bl = false;
                return bl;
            }
            LOG.info("delete contact failed={}", (Object)responseString);
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (Exception ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Office365PagingListResponse<Office365ContactOrigin> findContactRecordsAfterSpecifiedTime(DateTime lastTime, String token, String nextUrl, OkHttpClient client) {
        if (StringUtils.isEmpty((CharSequence)nextUrl)) {
            nextUrl = "https://graph.microsoft.com/beta/me/contacts/?" + String.format(FILTER_LASTMODIFIED_DATETIME_GREATER_THAN_FORMAT, DateTimeFormat.forPattern((String)ISO_8601_FORMATTER).print((ReadableInstant)lastTime)) + "&$select=lastModifiedDateTime&$top=500";
        }
        Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(nextUrl).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            if (response.isSuccessful()) {
                Office365PagingListResponse result;
                1 typeToken = new /* Unavailable Anonymous Inner Class!! */;
                Office365PagingListResponse office365PagingListResponse = result = (Office365PagingListResponse)this.gson.fromJson(responseString, typeToken.getType());
                return office365PagingListResponse;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Office365PagingListResponse<Office365DeltaQueryContact> executeContactDeltaQuery(String token, String nextLink, OkHttpClient client) {
        if (StringUtils.isEmpty((CharSequence)nextLink)) {
            nextLink = "https://graph.microsoft.com/beta/me/contactFolders/contacts/contacts/delta?$select=lastModifiedDateTime";
        }
        Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Prefer", "odata.maxpagesize=500").addHeader("Authorization", "Bearer " + token).url(nextLink).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            if (response.isSuccessful()) {
                Office365PagingListResponse result;
                2 typeToken = new /* Unavailable Anonymous Inner Class!! */;
                Office365PagingListResponse office365PagingListResponse = result = (Office365PagingListResponse)this.gson.fromJson(responseString, typeToken.getType());
                return office365PagingListResponse;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Office365ContactOrigin findContactSimpleRecord(String contactServerId, String token, OkHttpClient client) {
        String url = "https://graph.microsoft.com/beta/me/contacts/" + contactServerId + "?$select=lastModifiedDateTime";
        Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            if (response.isSuccessful()) {
                Office365ContactOrigin office365ContactOrigin = (Office365ContactOrigin)this.gson.fromJson(responseString, Office365ContactOrigin.class);
                return office365ContactOrigin;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findContactFolderId(ContactServerSettingsWithTokenDto contactServerSetting, OkHttpClient client) {
        if (!contactServerSetting.getSupportContactServer().equals((Object)SupportContactServer.OFFICE365)) return null;
        String token = contactServerSetting.getBasicToken().getAccess_token();
        String url = "https://graph.microsoft.com/beta/me/contactFolders/contacts";
        Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(url).build();
        try (Response response = client.newCall(request).execute();){
            String responseString = OkHttpUtils.getResponseBodyString((Response)response);
            if (response.isSuccessful()) {
                String string = ((ContactFolderResponse)this.gson.fromJson(responseString, ContactFolderResponse.class)).getId();
                return string;
            }
            throw new HttpConnectionException(this.getErrorMessage(responseString));
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] findContactPhoto(String contactServerId, String token, OkHttpClient client) {
        String url = "https://graph.microsoft.com/beta/me/contacts/" + contactServerId + "/photo/$value";
        Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).addHeader("Content-Type", "image/jpeg").url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (response.code() == 200) {
                byte[] byArray = response.body().bytes();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException ex) {
            throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void testContactFolder(String token, OkHttpClient client) {
        block15: {
            String url = "https://graph.microsoft.com/beta/me/contacts?$top=1&$select=id";
            Request request = new Request.Builder().get().addHeader("Prefer", "IdType=\"ImmutableId\"").addHeader("Authorization", "Bearer " + token).url(url).build();
            try (Response response = client.newCall(request).execute();){
                if (response.isSuccessful()) {
                    break block15;
                }
                throw new HttpConnectionException("Not support outlook");
            }
            catch (IOException ex) {
                throw new HttpConnectionException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

