/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.SecurityUtils;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.AccountDao;
import com.penpower.worldcard.team.dao.NoticeDao;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.dto.NoticeDto;
import com.penpower.worldcard.team.entity.Account;
import com.penpower.worldcard.team.entity.Notice;
import com.penpower.worldcard.team.enums.NoticeReadStatus;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.notice.event.WebSocketNoticePublisher;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.CleanOutOBoundNoticesPerUserJob;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.web.api.vo.PageInfoVo;
import com.penpower.worldcard.team.websokcet.WebSocketNotifyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;
import org.jsoup.helper.StringUtil;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class NoticeServiceImpl
implements NoticeService {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Autowired
    private NoticeDao noticeDao;
    @Autowired
    private AccountDao accountDao;
    @Autowired
    @Qualifier(value="webSocketNoticePublisher")
    private WebSocketNoticePublisher webSocketNoticePublisher;
    @Autowired
    @Qualifier(value="databaseScheduleManager")
    private ScheduleManager scheduleManager;

    public List<NoticeDto> getAllNotice(NotifyCategory notifyCategory, NoticeReadStatus noticeReadStatus) {
        Boolean viewed;
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        String accountGuid = accountInfo.getGuid();
        List notices = new ArrayList();
        LOG.debug("accountGuid : {} ", (Object)accountGuid);
        if (NotifyCategory.ALL.equals((Object)notifyCategory)) {
            LOG.debug("NotifyCategory.ALL >>>>> ");
            if (NoticeReadStatus.ALL.equals((Object)noticeReadStatus)) {
                LOG.debug("NoticeReadStatus.ALL >>>>> ");
                notices = this.noticeDao.findByAccountGuid(accountGuid);
            } else {
                viewed = Boolean.valueOf(noticeReadStatus.getBooleanString());
                notices = this.noticeDao.findByAccountGuidAndIsviewed(accountGuid, viewed.booleanValue());
            }
        } else if (NoticeReadStatus.ALL.equals((Object)noticeReadStatus)) {
            notices = this.noticeDao.findByAccountGuidAndNotifyCategory(accountGuid, notifyCategory);
        } else {
            viewed = Boolean.valueOf(noticeReadStatus.getBooleanString());
            notices = this.noticeDao.findByAccountGuidAndNotifyCategoryAndIsviewed(accountGuid, notifyCategory, viewed.booleanValue());
        }
        List noticeDtos = this.convertNoticeToDto(notices);
        return noticeDtos;
    }

    private List<NoticeDto> convertNoticeToDto(List<Notice> notices) {
        List<NoticeDto> noticeDtos = notices.stream().filter(Objects::nonNull).map(notice -> {
            NoticeDto noticeDto = new NoticeDto();
            noticeDto.setGuid(notice.getGuid());
            noticeDto.setNotifyCategory(notice.getNotifyCategory());
            noticeDto.setNotifyTime(notice.getNotifyTime());
            noticeDto.setNotifyType(notice.getNotifyType());
            noticeDto.setViewed(notice.getIsViewed());
            Account senderAccount = notice.getSenderAccount();
            if (senderAccount == null) {
                noticeDto.setSenderGuid(null);
                noticeDto.setSenderName("SYSTEM");
            } else {
                noticeDto.setSenderGuid(senderAccount.getGuid());
                noticeDto.setSenderName(senderAccount.getDisplayName());
            }
            String notifyContent = notice.getNotifyContent();
            noticeDto.setNotifyContent(notifyContent);
            return noticeDto;
        }).collect(Collectors.toList());
        return noticeDtos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public String addNewNotice(NotifyCategory notifyCategory, NotifyType notifyType, String notifyContent, String receiverGuid, String senderGuid) {
        LOG.debug("add new notice... 1currtime={}, notifyType:[{}] , notifyContent:{}", new Object[]{DateTime.now(), notifyType, notifyContent});
        Account recAcnt = this.accountDao.findOne(receiverGuid);
        long totalNoticeCount = this.noticeDao.countByReceiverGuid(receiverGuid);
        this.triggerCleanNoticeTableJob(totalNoticeCount, receiverGuid);
        Notice notice = this.createNewNoticeItem(notifyCategory, notifyType, notifyContent, receiverGuid, senderGuid);
        Notice savedNotice = (Notice)this.noticeDao.saveAndFlush((Object)notice);
        this.webSocketNoticePublisher.publishNoticeEvent(WebSocketNotifyEvent.NOTICE_COUNT_CHANGED, Arrays.asList(receiverGuid));
        return savedNotice.getGuid();
    }

    private void triggerCleanNoticeTableJob(long totalNoticeCount, String receiverGuid) {
        LOG.debug("totalNoticeCount : {} ", (Object)totalNoticeCount);
        if (totalNoticeCount > 500L) {
            String groupName = "CLEAN_OUTOFBOUND_NOTICES_GROUP_" + receiverGuid;
            JobIdentify jobIdentify = new JobIdentify(groupName, CleanOutOBoundNoticesPerUserJob.class);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("accountGuid", receiverGuid);
            try {
                this.scheduleManager.startScheduleOnce(jobIdentify, null, dataMap);
            }
            catch (Exception ex) {
                LOG.warn("trigger clean notice table job failed.", (Throwable)ex);
            }
        }
    }

    private Notice createNewNoticeItem(NotifyCategory notifyCategory, NotifyType notifyType, String notifyContent, String receiverGuid, String senderGuid) {
        Notice notice = new Notice();
        notice.setGuid(UUIDGenerator.getRandomUUID());
        notice.setIsViewed(false);
        notice.setNotifyTime(new DateTime());
        notice.setNotifyCategory(notifyCategory);
        notice.setNotifyType(notifyType);
        Account account = this.accountDao.findOne(receiverGuid);
        notice.setAccount(account);
        notice.setCompanyGuid(account.getCompanyGuid());
        Account senderAccount = this.accountDao.findOne(Optional.ofNullable(senderGuid).orElse(""));
        notice.setSenderAccount(senderAccount);
        notice.setNotifyContent(notifyContent);
        return notice;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addNewNoticeToAllAdmins(NotifyCategory notifyCategory, NotifyType notifyType, String notifyCOntent, String senderGuid, String companyGuid) {
        List adminAccounts = null;
        adminAccounts = StringUtil.isNumeric((String)companyGuid) ? this.accountDao.findByStatusIn(Arrays.asList(UserStatus.ACTIVE)).stream().filter(a -> a.getRole().equals((Object)UserRole.ADMIN)).collect(Collectors.toList()) : this.accountDao.findByStatusIn(Arrays.asList(UserStatus.ACTIVE), companyGuid).stream().filter(a -> a.getRole().equals((Object)UserRole.ADMIN)).collect(Collectors.toList());
        List adminAccountGuids = adminAccounts.stream().map(a -> a.getGuid()).collect(Collectors.toList());
        this.addNewNoticeToUsers(notifyCategory, notifyType, notifyCOntent, adminAccountGuids, senderGuid, companyGuid);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addNewNoticeToUsers(NotifyCategory notifyCategory, NotifyType notifyType, String notifyContent, List<String> receiverGuids, String senderGuid, String companyGuid) {
        LOG.debug("addNewNoticeToUsers senderGuid A ={} receiverGuids ={}", (Object)senderGuid, receiverGuids);
        LOG.debug("addNewNoticeToUsers senderGuid B ={}", (Object)senderGuid);
        for (String receiverGuid : receiverGuids) {
            Account reciveAcnt = this.accountDao.findOne(receiverGuid);
            if (reciveAcnt == null || reciveAcnt.getCompanyGuid().compareTo(companyGuid) != 0) continue;
            NoticeService self = (NoticeService)AopContext.currentProxy();
            self.addNewNotice(notifyCategory, notifyType, notifyContent, receiverGuid, senderGuid);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteNotice(String noticeGuid) {
        this.noticeDao.delete((Serializable)((Object)noticeGuid));
    }

    public long getAccountUnviewedNoticeCount(NotifyCategory notifyCategory, String accountGuid, DateTime lastNoticeCountView) {
        if (NotifyCategory.ALL.equals((Object)notifyCategory)) {
            return this.noticeDao.countByReceiverGuidAndIsViewedAndNotifyTime(accountGuid, false, lastNoticeCountView);
        }
        return this.noticeDao.countByNotifyCategoryAndReceiverGuidAndIsViewedAndNotifyTime(accountGuid, notifyCategory, false, lastNoticeCountView);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteUserNoticeByCountLargerThan500(String accountGuid) {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"notifytime"});
        PageRequest page = new PageRequest(1, 500, sort);
        Page largerThan500NoticesPage = this.noticeDao.findByAccountGuidPage(accountGuid, (Pageable)page);
        LOG.debug("largerThan500Notices.getTotalPages() : {} ", (Object)largerThan500NoticesPage.getTotalPages());
        LOG.debug("largerThan500Notices.getTotalElements() : {} ", (Object)largerThan500NoticesPage.getTotalElements());
        int totalPages = largerThan500NoticesPage.getTotalPages();
        if (totalPages >= 2) {
            List largerThan500Notices = largerThan500NoticesPage.getContent();
            this.noticeDao.delete((Iterable)largerThan500Notices);
            this.noticeDao.flush();
        }
    }

    public PageInfoVo<List<NoticeDto>> getAllNoticeWithPageable(NotifyCategory notifyCategory, NoticeReadStatus noticeReadStatus, PageRequest pageRequest) {
        AccountInfo accountInfo = SecurityUtils.getCurrentLoginUser();
        String accountGuid = accountInfo.getGuid();
        List notices = new ArrayList();
        Page noticePageResult = this.getResultByNoticeReadStatusAndCategory(notifyCategory, noticeReadStatus, pageRequest, accountGuid);
        long totalCount = noticePageResult.getTotalElements();
        int totalPage = noticePageResult.getTotalPages();
        LOG.debug("noticePageResult.getTotalElements : {} ", (Object)noticePageResult.getTotalElements());
        notices = noticePageResult.getContent();
        List noticeDtos = this.convertNoticeToDto(notices);
        PageInfoVo pageInfoResult = new PageInfoVo(totalCount, totalPage, (Object)noticeDtos);
        return pageInfoResult;
    }

    private Page<Notice> getResultByNoticeReadStatusAndCategory(NotifyCategory notifyCategory, NoticeReadStatus noticeReadStatus, PageRequest pageRequest, String accountGuid) {
        Page noticePageResult;
        if (NotifyCategory.ALL.equals((Object)notifyCategory)) {
            if (NoticeReadStatus.ALL.equals((Object)noticeReadStatus)) {
                noticePageResult = this.noticeDao.findByAccountGuidPage(accountGuid, (Pageable)pageRequest);
            } else {
                Boolean viewed = Boolean.valueOf(noticeReadStatus.getBooleanString());
                noticePageResult = this.noticeDao.findByAccountGuidAndIsviewedPage(accountGuid, viewed.booleanValue(), (Pageable)pageRequest);
            }
        } else if (NoticeReadStatus.ALL.equals((Object)noticeReadStatus)) {
            noticePageResult = this.noticeDao.findByAccountGuidAndNotifyCategoryPage(accountGuid, notifyCategory, (Pageable)pageRequest);
        } else {
            Boolean viewed = Boolean.valueOf(noticeReadStatus.getBooleanString());
            noticePageResult = this.noticeDao.findByAccountGuidAndNotifyCategoryAndIsviewedPage(accountGuid, notifyCategory, viewed.booleanValue(), (Pageable)pageRequest);
        }
        return noticePageResult;
    }

    public String getNoticeContent(String noticeGuid) {
        Notice notice = (Notice)this.noticeDao.findOne((Serializable)((Object)noticeGuid));
        if (notice == null) {
            throw new ItemNotFoundException(String.format("Notice[guid=%s] not found.", noticeGuid));
        }
        String noticeContent = notice.getNotifyContent();
        return noticeContent;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void setNoticeViewed(String noticeGuid) {
        Notice notice = (Notice)this.noticeDao.findOne((Serializable)((Object)noticeGuid));
        notice.setIsViewed(true);
        this.noticeDao.save((Object)notice);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addNewNoticeToAllUsers(NotifyCategory notifyCategory, NotifyType notifyType, String notifyContent, String senderGuid, String companyGuid) {
        LOG.debug("send notice to all users , notifyType:[{}] ,notifyContent : {}", (Object)notifyType, (Object)notifyContent);
        if (!StringUtil.isBlank((String)companyGuid)) {
            LOG.debug("addNewNoticeToUsers senderGuid B ={}", (Object)senderGuid);
            List accounts = this.accountDao.findAllbyCompany(companyGuid);
            LOG.debug("addNewNoticeToUsers senderGuid  accounts SIZE= ={}", (Object)accounts.size());
            for (Account account : accounts) {
                NoticeService self = (NoticeService)AopContext.currentProxy();
                self.addNewNotice(notifyCategory, notifyType, notifyContent, account.getGuid(), senderGuid);
            }
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void addSystemNoticeToAdmin(NotifyCategory notifyCategory, NotifyType notifyType, String notifyContent, String companyGuid) {
        LOG.debug("send notice to all users , notifyType:[{}] ,notifyContent : {} companyguid={}", new Object[]{notifyType, notifyContent, companyGuid});
        List accounts = this.accountDao.findAllbyCompany(companyGuid);
        for (Account account : accounts) {
            LOG.debug("send notice to all users , account={}", (Object)account);
            if (account.getRole() != UserRole.ADMIN) continue;
            NoticeService self = (NoticeService)AopContext.currentProxy();
            self.addNewNotice(notifyCategory, notifyType, notifyContent, account.getGuid(), "");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void UpdateAllNoticewithCompany(String companyGuid) {
        this.noticeDao.updateAllNoticeWithCompany(companyGuid);
    }

    public String getLatestNotifyContent(String accountGuid) {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"notifytime"});
        PageRequest page = new PageRequest(0, 1, sort);
        Page result = this.noticeDao.findByReceiverGuidPage(accountGuid, (Pageable)page);
        if (CollectionUtils.isNotEmpty((Collection)result.getContent())) {
            return ((Notice)result.getContent().get(0)).getNotifyContent();
        }
        return "";
    }
}

