/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.Utils.StringUtil;
import com.penpower.worldcard.team.config.property.SystemConstantProperties;
import com.penpower.worldcard.team.dto.AccountInfo;
import com.penpower.worldcard.team.entity.Company;
import com.penpower.worldcard.team.enums.ADSyncRunningStaus;
import com.penpower.worldcard.team.enums.AccountLockCase;
import com.penpower.worldcard.team.enums.AccountSubscriptionStatus;
import com.penpower.worldcard.team.enums.AccountType;
import com.penpower.worldcard.team.enums.ActiveDirectoryNodeType;
import com.penpower.worldcard.team.enums.ActiveDirectoryTreeSearchOption;
import com.penpower.worldcard.team.enums.NotifyCategory;
import com.penpower.worldcard.team.enums.NotifyType;
import com.penpower.worldcard.team.enums.UserRole;
import com.penpower.worldcard.team.enums.UserStatus;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.ldap.ActiveDirectoryAccountInfo;
import com.penpower.worldcard.team.ldap.ActiveDirectoryUtils;
import com.penpower.worldcard.team.notice.content.SyncADOutofCountContent;
import com.penpower.worldcard.team.scheduler.JobIdentify;
import com.penpower.worldcard.team.scheduler.ScheduleManager;
import com.penpower.worldcard.team.scheduler.job.ADAccountSyncJob;
import com.penpower.worldcard.team.service.AccountService;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.CompanyService;
import com.penpower.worldcard.team.service.LdapService;
import com.penpower.worldcard.team.service.NoticeService;
import com.penpower.worldcard.team.service.SystemSettingService;
import com.penpower.worldcard.team.web.api.vo.AccountCreationVo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryAccountTreeInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryInfo;
import com.penpower.worldcard.team.web.api.vo.ActiveDirectoryTreeNodeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.joda.time.DateTime;
import org.quartz.JobDataMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Service;

@Service
public class LdapServiceImpl
implements LdapService {
    private static final Logger LOG = LoggerFactory.getLogger(LdapServiceImpl.class);
    private LdapTemplate ldapTemplate;
    @Autowired
    CompanyService companyService;
    @Autowired
    AccountService accountService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private SystemSettingService systemSettingService;
    @Autowired
    CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    @Qualifier(value="scheduleManager")
    private ScheduleManager inMemoryScheduleManager;

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public String mapFromAttributes(Attributes attributes) throws NamingException {
        return null;
    }

    public List<String> getAllPersonNames() {
        LOG.info("ldapTemplate:{}", (Object)this.ldapTemplate);
        return this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().where("objectclass").is("person"), (AttributesMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getLocalPartName(String loginAccount) {
        String[] localPartSplit = loginAccount.split("@");
        return localPartSplit[0];
    }

    public void startSyncOnce() {
        boolean inMemoryBackupJobRunning = this.inMemoryScheduleManager.jobRunning(ADAccountSyncJob.class);
        ADSyncRunningStaus adSyncRunningStaus = (ADSyncRunningStaus)ADAccountSyncJob.ADSYNC_RUNNING_STATUS.get();
        boolean JobRunning = ADSyncRunningStaus.RUNNING.equals((Object)adSyncRunningStaus);
        LOG.debug("JobRunning : {} ", (Object)JobRunning);
        if (inMemoryBackupJobRunning || JobRunning) {
            LOG.debug("JobRunning : job running inMemoryBackupJobRunning= {} , JobRunning ={} ", (Object)inMemoryBackupJobRunning, (Object)JobRunning);
            return;
        }
        JobIdentify jobIdentify = new JobIdentify("AD_SYNC_JOB", ADAccountSyncJob.class);
        JobDataMap dataMap = new JobDataMap();
        DateTime launchTime = new DateTime().plusSeconds(2);
        this.inMemoryScheduleManager.startScheduleOnce(jobIdentify, launchTime.toDate(), dataMap);
    }

    public void syncWithADServer() {
        List companys = this.companyService.FindAllCompany();
        boolean IsUpdated = false;
        for (Company company : companys) {
            if (this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_WITH_AD", SystemConstantProperties.DEFAULT_SYNC_WITH_AD, company.getGuid()).compareToIgnoreCase(Boolean.TRUE.toString()) != 0) continue;
            String ADServer = this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_SERVER", "", company.getGuid());
            String loginPassword = this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_PASSWORD", "", company.getGuid());
            String baseDN = this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_BASEDN", "", company.getGuid());
            String accountName = this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_ACCOUNTNAME", "", company.getGuid());
            if (StringUtil.IsStringNullorEmpty((String)baseDN) || StringUtil.IsStringNullorEmpty((String)accountName) || StringUtil.IsStringNullorEmpty((String)loginPassword) || StringUtil.IsStringNullorEmpty((String)ADServer)) continue;
            ActiveDirectoryUtils activeDirectoryUtils = null;
            ActiveDirectoryInfo activeDirectoryInfo = new ActiveDirectoryInfo(ADServer, baseDN, accountName, loginPassword);
            try {
                activeDirectoryUtils = new ActiveDirectoryUtils(activeDirectoryInfo);
            }
            catch (Exception ex) {
                LOG.error("Invalid ad import params.", (Throwable)ex);
                throw new RequestArgumentNotValidException("Invalid ad import params.", (Throwable)ex);
            }
            String accountNameLocalPart = this.getLocalPartName(activeDirectoryInfo.getLoginAccount());
            LOG.debug("accountNameLocalPart : {} ", (Object)accountNameLocalPart);
            try {
                activeDirectoryUtils.authenticate(accountNameLocalPart, activeDirectoryInfo.getLoginPassword());
            }
            catch (Exception ex) {
                LOG.error("ActiveDirectory authenticate failed.", (Throwable)ex);
                String syncADFailList = this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_FAIL_LIST", "", company.getGuid());
                if (syncADFailList.compareTo("LDAP_SYNC_AUTH_FAIL") != 0) {
                    this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.LDAP_SYNC_AUTH_FAIL, "", null, company.getGuid());
                    this.companyGlobalInfoService.createNewProperties("SYNC_AD_FAIL_LIST", "LDAP_SYNC_AUTH_FAIL", company.getGuid());
                }
                return;
            }
            activeDirectoryUtils.setCtxBaseDn(activeDirectoryInfo.getAdServerBaseDn());
            List allActiveDirectoryAccounts = activeDirectoryUtils.getAllUserAccountNames();
            LOG.debug("allActiveDirectoryAccounts : {}", (Object)allActiveDirectoryAccounts);
            List accounts = this.accountService.GetAccountByADBaseDN(baseDN, company.getGuid());
            LOG.debug("accounts : {}", (Object)accounts);
            ArrayList<String> accountSetToTemplate = new ArrayList<String>();
            for (AccountInfo account : accounts) {
                boolean bFound = false;
                for (ActiveDirectoryAccountInfo adaccount : allActiveDirectoryAccounts) {
                    if (StringUtil.IsStringNullorEmpty((String)account.getActivedirectoryguid())) {
                        if (adaccount.getAccountName().compareTo(account.getEmail()) != 0) continue;
                        account.setActivedirectoryguid(adaccount.getGuid());
                        this.accountService.UpdateAccountADGuid(account.getGuid(), adaccount.getGuid());
                        bFound = true;
                        break;
                    }
                    if (adaccount.getGuid().compareToIgnoreCase(account.getActivedirectoryguid()) != 0) continue;
                    bFound = true;
                    LOG.debug("sync_with_ADServer checkname currAccountname={} < adaccountname ={} ", (Object)account.getEmail(), (Object)adaccount.getAccountName());
                    if (account.getEmail().compareTo(adaccount.getAccountName()) == 0) break;
                    try {
                        LOG.debug("sync_with_ADServer UpdateAccountEmail name={} < guid ={} ", (Object)adaccount.getAccountName(), (Object)account.getGuid());
                        this.accountService.UpdateAccountEmail(account.getGuid(), adaccount.getAccountName());
                    }
                    catch (ConstraintViolationException e) {
                        LOG.debug("sync_with_ADServer ConstraintViolationException e={}", (Object)e.getMessage());
                    }
                    catch (Exception ee) {
                        LOG.debug("sync_with_ADServer Exception ee={}", (Object)ee.getMessage());
                    }
                    break;
                }
                if (bFound || account.getStatus() == UserStatus.RESIGNED) continue;
                accountSetToTemplate.add(account.getGuid());
            }
            LOG.debug("sync_with_ADServer updateSubscriptionStatus TEMPLATE_INVALIDATE :accountSetToTemplate= {}", accountSetToTemplate);
            if (accountSetToTemplate.size() > 0 && this.accountService.updateSubscriptionStatus(accountSetToTemplate, AccountSubscriptionStatus.TEMPLATE_INVALIDATE, company.getGuid(), AccountLockCase.AD_SYNC, false)) {
                IsUpdated = true;
            }
            ArrayList<String> accountSetToValidate = new ArrayList<String>();
            ArrayList<String> outofcountAdAccountlist = new ArrayList<String>();
            ArrayList<String> createdAccounts = new ArrayList<String>();
            for (ActiveDirectoryAccountInfo adaccount : allActiveDirectoryAccounts) {
                AccountInfo currAccount = null;
                boolean bFound = false;
                for (AccountInfo account : accounts) {
                    LOG.debug("sync_with_ADServer \tadaccount.GETNAME={},account.getEmail={} account.adguid={}\t", new Object[]{adaccount.getAccountName(), account.getEmail(), account.getActivedirectoryguid()});
                    if (!StringUtil.IsStringNullorEmpty((String)account.getActivedirectoryguid())) {
                        if (adaccount.getGuid().compareToIgnoreCase(account.getActivedirectoryguid()) != 0) continue;
                        LOG.debug("sync_with_ADServer \tgetAccountSubscriptionStatus ={}", (Object)account.getAccountSubscriptionStatus());
                        if (account.getAccountSubscriptionStatus() == AccountSubscriptionStatus.IN_SUBSCRIPTION || account.getStatus() == UserStatus.RESIGNED) {
                            bFound = true;
                        }
                        currAccount = account;
                        break;
                    }
                    if (adaccount.getAccountName().compareTo(account.getEmail()) != 0) continue;
                    LOG.debug("sync_with_ADServer \tgetAccountSubscriptionStatus ={}", (Object)account.getAccountSubscriptionStatus());
                    if (account.getAccountSubscriptionStatus() == AccountSubscriptionStatus.IN_SUBSCRIPTION || account.getStatus() == UserStatus.RESIGNED) {
                        bFound = true;
                    }
                    currAccount = account;
                    break;
                }
                if (bFound) continue;
                int count = this.systemSettingService.getLicenseCount(company.getGuid(), false);
                LOG.debug("sync_with_ADServer getLicenseCount: {} ", (Object)count);
                if (count <= 0) {
                    outofcountAdAccountlist.add(adaccount.getAccountName());
                    LOG.debug("sync_with_ADServer LicenseCountMaxExceededException count={} ", (Object)count);
                    continue;
                }
                long currentAccountCount = this.accountService.getAccountCount(company.getGuid());
                LOG.debug("sync_with_ADServer currentAccountCount ={},accountSetToValidateSIZE={},createdAccountsSIZE={}", new Object[]{currentAccountCount, accountSetToValidate.size(), createdAccounts.size()});
                if (currentAccountCount + (long)accountSetToValidate.size() >= (long)count) {
                    LOG.debug("sync_with_ADServer \tADD outofcountAdAccountlist ={}", (Object)adaccount.getAccountName());
                    outofcountAdAccountlist.add(adaccount.getAccountName());
                    LOG.debug("sync_with_ADServer LicenseCountMaxExceededException count={} < currountCount ={} ", (Object)count, (Object)currentAccountCount);
                    continue;
                }
                if (currAccount != null) {
                    accountSetToValidate.add(currAccount.getGuid());
                    continue;
                }
                AccountInfo account = null;
                try {
                    account = this.accountService.getAccountInfo(null, adaccount.getAccountName());
                    LOG.debug("account : {} ", (Object)account);
                    if (account != null) {
                        continue;
                    }
                }
                catch (ItemNotFoundException ex) {
                    LOG.debug("No account found , can be created.");
                }
                try {
                    AccountCreationVo accountCreationVo = new AccountCreationVo();
                    accountCreationVo.setEmail(adaccount.getAccountName());
                    accountCreationVo.setExportAbility(false);
                    accountCreationVo.setName(adaccount.getAccountName());
                    accountCreationVo.setRole(UserRole.ADMIN);
                    accountCreationVo.setBoss("");
                    accountCreationVo.setStatus(UserStatus.ACTIVE);
                    accountCreationVo.setSecretary(false);
                    accountCreationVo.setAccountType(AccountType.AD);
                    accountCreationVo.setAdServer(ADServer);
                    accountCreationVo.setAdServerBaseDn(baseDN);
                    accountCreationVo.setPrintAbility(false);
                    accountCreationVo.setRole(UserRole.NORMAL_USER);
                    accountCreationVo.setAdAccountMail(adaccount.getMail());
                    accountCreationVo.setActivedirectoryguid(adaccount.getGuid());
                    String newAccountGuid = this.accountService.createAccount(accountCreationVo, company.getGuid(), false);
                    LOG.debug("sync_with_ADServer \tADD createdAccounts ={}", (Object)adaccount.getAccountName());
                    createdAccounts.add(newAccountGuid);
                    IsUpdated = true;
                }
                catch (Exception e) {
                    LOG.error("sync_with_ADServer createaccount :exception= {}", (Object)e.getMessage());
                    break;
                }
            }
            LOG.debug("sync_with_ADServer updateSubscriptionStatus IN_SUBSCRIPTION :accountSetToTemplate= {}", accountSetToValidate);
            if (this.accountService.updateSubscriptionStatus(accountSetToValidate, AccountSubscriptionStatus.IN_SUBSCRIPTION, company.getGuid(), AccountLockCase.NO, false)) {
                IsUpdated = true;
            }
            String syncADFailList = this.companyGlobalInfoService.getStringByKeyWithDefault("SYNC_AD_FAIL_LIST", "", company.getGuid());
            long currentAccountCount = this.accountService.getAccountCount(company.getGuid());
            SyncADOutofCountContent syncADOutofCountContent = new SyncADOutofCountContent();
            syncADOutofCountContent.setAccountLimit((int)currentAccountCount);
            syncADOutofCountContent.setOutofcountAdAccounts(outofcountAdAccountlist);
            String syncADOutofCountContentString = GlobalUtils.getJsonString((Object)syncADOutofCountContent);
            LOG.debug("sync_with_ADServer outofcountAdAccountlistsize ={} IsUpdated ={} ,syncADFailList ={} ,syncADOutofCountContentString ={}", new Object[]{outofcountAdAccountlist.size(), IsUpdated, syncADFailList, syncADOutofCountContentString});
            if (outofcountAdAccountlist.size() <= 0 || !IsUpdated && syncADFailList.compareToIgnoreCase(syncADOutofCountContentString) == 0) continue;
            this.companyGlobalInfoService.createNewProperties("SYNC_AD_FAIL_LIST", syncADOutofCountContentString, company.getGuid());
            this.noticeService.addNewNoticeToAllAdmins(NotifyCategory.SYSTEM, NotifyType.LDAP_SYNC_FAIL, syncADOutofCountContentString, null, company.getGuid());
        }
        LOG.debug("sync_with_ADServer success");
    }

    public ActiveDirectoryAccountTreeInfo getAdAccountTree(ActiveDirectoryInfo activeDirectoryInfo, List<ActiveDirectoryTreeSearchOption> options) {
        ActiveDirectoryUtils activeDirectoryUtils = null;
        try {
            activeDirectoryUtils = new ActiveDirectoryUtils(activeDirectoryInfo);
        }
        catch (Exception ex) {
            LOG.error("Invalid ad import params.={}", (Object)ex.getMessage());
            throw new RequestArgumentNotValidException("Invalid ad import params.", (Throwable)ex);
        }
        String accountNameLocalPart = this.getLocalPartName(activeDirectoryInfo.getLoginAccount());
        LOG.debug("accountNameLocalPart : {} ", (Object)accountNameLocalPart);
        activeDirectoryUtils.authenticate(accountNameLocalPart, activeDirectoryInfo.getLoginPassword());
        ActiveDirectoryAccountTreeInfo result = new ActiveDirectoryAccountTreeInfo();
        ActiveDirectoryTreeNodeInfo nodeInfo = activeDirectoryUtils.getNodeInfo(activeDirectoryInfo.getAdServerBaseDn());
        if (nodeInfo == null) {
            throw new ItemNotFoundException("Can not find node by baseDn: " + activeDirectoryInfo.getAdServerBaseDn());
        }
        result.setNodeInfo(nodeInfo);
        List<ActiveDirectoryAccountInfo> accounts = new ArrayList();
        List<ActiveDirectoryTreeNodeInfo> treeNodes = new ArrayList();
        if (nodeInfo.getIsRoot().booleanValue() && options.contains(ActiveDirectoryTreeSearchOption.ACCOUNT)) {
            accounts = activeDirectoryUtils.getTreeNodes(activeDirectoryInfo.getAdServerBaseDn(), Arrays.asList(ActiveDirectoryTreeSearchOption.ACCOUNT), 2);
        } else if (options.contains(ActiveDirectoryTreeSearchOption.ACCOUNT)) {
            accounts = activeDirectoryUtils.getTreeNodes(activeDirectoryInfo.getAdServerBaseDn(), Arrays.asList(ActiveDirectoryTreeSearchOption.ACCOUNT), 1);
        }
        if (options.contains(ActiveDirectoryTreeSearchOption.TREE)) {
            treeNodes = activeDirectoryUtils.getTreeNodes(activeDirectoryInfo.getAdServerBaseDn(), Arrays.asList(ActiveDirectoryTreeSearchOption.TREE), 1);
        }
        if (options.contains(ActiveDirectoryTreeSearchOption.ACCOUNT) && CollectionUtils.isNotEmpty((Collection)nodeInfo.getGroupMembersBaseDn())) {
            boolean accoutsHasChanged = false;
            boolean treeNodesHasChanged = false;
            for (String groupMember : nodeInfo.getGroupMembersBaseDn()) {
                ActiveDirectoryTreeNodeInfo accountNode = activeDirectoryUtils.getNodeInfo(groupMember);
                if (accountNode == null) continue;
                if (ActiveDirectoryNodeType.USER.equals((Object)accountNode.getNodeType())) {
                    accounts.add((ActiveDirectoryAccountInfo)accountNode);
                    accoutsHasChanged = true;
                    continue;
                }
                treeNodes.add(accountNode);
                treeNodesHasChanged = true;
            }
            if (accoutsHasChanged) {
                accounts.sort((p1, p2) -> ((ActiveDirectoryAccountInfo)p1).getAccountName().compareTo(((ActiveDirectoryAccountInfo)p2).getAccountName()));
            }
            if (treeNodesHasChanged) {
                treeNodes.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
            }
        }
        result.setAccounts(accounts);
        result.setTreeNodes(treeNodes);
        return result;
    }
}

