/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.mchange.v1.lang.BooleanUtils;
import com.penpower.worldcard.team.Utils.NetworkUtil;
import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.IpAllowedInfoDao;
import com.penpower.worldcard.team.dto.IpAllowedInfoDto;
import com.penpower.worldcard.team.entity.Globalinfocompany;
import com.penpower.worldcard.team.entity.Ipallowedinfo;
import com.penpower.worldcard.team.enums.IpConstraintType;
import com.penpower.worldcard.team.exception.ItemAlreadyExistsException;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.exception.RequestArgumentNotValidException;
import com.penpower.worldcard.team.service.CompanyGlobalInfoService;
import com.penpower.worldcard.team.service.GlobalInfoService;
import com.penpower.worldcard.team.service.IpConstraintService;
import com.penpower.worldcard.team.web.api.vo.IpAllowedInfoCreationVo;
import com.penpower.worldcard.team.web.api.vo.IpAllowedInfoUpdateVo;
import java.net.SocketException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IpConstraintServiceImpl
implements IpConstraintService {
    private static final Logger LOG = LoggerFactory.getLogger(IpConstraintServiceImpl.class);
    private static final String LOCALHOST_REMOTE_IP = "0:0:0:0:0:0:0:1";
    @Autowired
    private IpAllowedInfoDao ipAllowedInfoDao;
    @Autowired
    CompanyGlobalInfoService companyGlobalInfoService;
    @Autowired
    private GlobalInfoService globalInfoService;

    public List<IpAllowedInfoDto> getIpAllowedInfos(String companyGuid) {
        List ipAllowedInfos = this.ipAllowedInfoDao.findAllByOrderByCreatetimeAsc(companyGuid);
        List<IpAllowedInfoDto> ipAllowedInfosVo = ipAllowedInfos.stream().map(info -> new IpAllowedInfoDto(info)).collect(Collectors.toList());
        return ipAllowedInfosVo;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public String createIpAllowedInfo(IpAllowedInfoCreationVo creationVo, String companyGuid) {
        Ipallowedinfo ipAllowedInfo = new Ipallowedinfo();
        String ipBegin = creationVo.getIpBegin();
        String ipEnd = StringUtils.isBlank((CharSequence)creationVo.getIpEnd()) ? ipBegin : creationVo.getIpEnd();
        ipAllowedInfo.setCompanyGuid(companyGuid);
        ipAllowedInfo.setGuid(UUIDGenerator.getRandomUUID());
        ipAllowedInfo.setIpbegin(ipBegin);
        ipAllowedInfo.setIpend(ipEnd);
        ipAllowedInfo.setIpbeginlong((double)NetworkUtil.ipAddressToLong((String)ipBegin));
        ipAllowedInfo.setIpendlong((double)NetworkUtil.ipAddressToLong((String)ipEnd));
        ipAllowedInfo.setNote(creationVo.getNote());
        ipAllowedInfo.setIpconstrainttype(creationVo.getIpConstraintType());
        ipAllowedInfo.setCreatetime(new DateTime());
        Ipallowedinfo saveipAllowedInfo = (Ipallowedinfo)this.ipAllowedInfoDao.saveAndFlush((Object)ipAllowedInfo);
        return saveipAllowedInfo.getGuid();
    }

    public IpAllowedInfoDto getIpAllowedInfo(String guid) {
        Ipallowedinfo ipAllowedInfo = this.ipAllowedInfoDao.findOne(guid);
        return new IpAllowedInfoDto(ipAllowedInfo);
    }

    public void verifyIpAllowedInfoExist(String guid) {
        Ipallowedinfo ipAllowedInfo = this.ipAllowedInfoDao.findOne(guid);
        if (ipAllowedInfo == null) {
            throw new ItemNotFoundException(String.format("Can't find ipAllowed information by guid[%s].", guid));
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void updateIpAllowedInfo(IpAllowedInfoUpdateVo updateVo) {
        Ipallowedinfo ipAllowedInfo = this.ipAllowedInfoDao.findOne(updateVo.getGuid());
        String ipBegin = updateVo.getIpBegin();
        String ipEnd = StringUtils.isBlank((CharSequence)updateVo.getIpEnd()) ? ipBegin : updateVo.getIpEnd();
        ipAllowedInfo.setIpbegin(ipBegin);
        ipAllowedInfo.setIpend(ipEnd);
        ipAllowedInfo.setIpbeginlong((double)NetworkUtil.ipAddressToLong((String)ipBegin));
        ipAllowedInfo.setIpendlong((double)NetworkUtil.ipAddressToLong((String)ipEnd));
        ipAllowedInfo.setIpconstrainttype(updateVo.getIpConstraintType());
        ipAllowedInfo.setNote(updateVo.getNote());
        this.ipAllowedInfoDao.save((Object)ipAllowedInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void verifyIpAllowedInfoVo(IpAllowedInfoCreationVo ipAllowedInfoVo, String companyGuid) {
        long sameIpRuleCount;
        IpConstraintType ipConstraitType = ipAllowedInfoVo.getIpConstraintType();
        String ipBegin = ipAllowedInfoVo.getIpBegin();
        String ipEnd = ipAllowedInfoVo.getIpEnd();
        if (IpConstraintType.BY_SPECIFIC.equals((Object)ipConstraitType)) {
            if (!StringUtils.isBlank((CharSequence)ipEnd)) throw new RequestArgumentNotValidException("When IpConstraintType is BY_SPECIFIC, ipEnd must be set to null or empty");
            ipEnd = ipBegin;
        } else if (StringUtils.isBlank((CharSequence)ipEnd)) {
            throw new RequestArgumentNotValidException("ipEnd can not be empty");
        }
        try {
            if (NetworkUtil.isIpBeginGreaterThanIpEnd((String)ipBegin, (String)ipEnd)) {
                throw new RequestArgumentNotValidException("ipBegin can not be greater than ipEnd");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new RequestArgumentNotValidException("Request ip is not a well-formed ip");
        }
        boolean ipSameWithOrigin = false;
        if (ipAllowedInfoVo instanceof IpAllowedInfoUpdateVo) {
            IpAllowedInfoUpdateVo ipAllowedInfoUpdateVo = (IpAllowedInfoUpdateVo)ipAllowedInfoVo;
            IpConstraintType newIpConstraintType = ipAllowedInfoUpdateVo.getIpConstraintType();
            String newIpBegin = ipAllowedInfoUpdateVo.getIpBegin();
            String newIpEnd = IpConstraintType.BY_SPECIFIC.equals((Object)newIpConstraintType) ? newIpBegin : ipAllowedInfoUpdateVo.getIpEnd();
            Ipallowedinfo oldIpAllowedInfo = this.ipAllowedInfoDao.findOne(ipAllowedInfoUpdateVo.getGuid());
            IpConstraintType oldIpConstraintType = oldIpAllowedInfo.getIpconstrainttype();
            String oldIpBegin = oldIpAllowedInfo.getIpbegin();
            String oldIpEnd = oldIpAllowedInfo.getIpend();
            if (oldIpBegin.equals(newIpBegin) && oldIpEnd.equals(newIpEnd) && oldIpConstraintType.equals((Object)newIpConstraintType)) {
                ipSameWithOrigin = true;
            }
        }
        if ((sameIpRuleCount = this.ipAllowedInfoDao.sameIpRuleCount(ipBegin, ipEnd, ipConstraitType, companyGuid)) != 1L || ipSameWithOrigin) return;
        if (!IpConstraintType.BY_RANGE.equals((Object)ipConstraitType)) throw new ItemAlreadyExistsException("IP already exist", ipBegin);
        throw new ItemAlreadyExistsException("IP Range already exist", ipBegin, ipEnd);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void deleteIpAllowedInfo(String guid) {
        this.ipAllowedInfoDao.delete(guid);
    }

    public boolean getIpNeedToConstraint(String companyGuid) {
        Globalinfocompany ipConstraintType = this.companyGlobalInfoService.getPropertiesByKey("IP_NEED_TO_CONSTRAINT", companyGuid);
        if (ipConstraintType == null) {
            this.companyGlobalInfoService.createNewProperties("IP_NEED_TO_CONSTRAINT", "false", companyGuid);
            return BooleanUtils.parseBoolean((String)"false");
        }
        return BooleanUtils.parseBoolean((String)ipConstraintType.getConfigValue());
    }

    public void UpdateipConstraintWithCompany(String companyGuid) {
        this.ipAllowedInfoDao.UpdateipAllConstraintWithCompany(companyGuid);
    }

    public boolean isIpValid(String remoteIp, String companyGuid) {
        if (LOCALHOST_REMOTE_IP.equals(remoteIp)) {
            return true;
        }
        try {
            if (NetworkUtil.isRemoteIpAddressSameWithServer((String)remoteIp)) {
                return true;
            }
        }
        catch (SocketException e) {
            LOG.error("Get internet interface error", (Throwable)e);
        }
        long ipMatchRulesCount = this.ipAllowedInfoDao.ipMatchAllowedInfoRulesCount((double)NetworkUtil.ipAddressToLong((String)remoteIp), companyGuid);
        LOG.debug("ipMatchRulesCount:{}", (Object)ipMatchRulesCount);
        return ipMatchRulesCount > 0L;
    }
}

