/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.UUIDGenerator;
import com.penpower.worldcard.team.dao.ForgetPasswordSessionDao;
import com.penpower.worldcard.team.entity.ForgetPasswordSession;
import com.penpower.worldcard.team.service.ForgetPasswordSessionService;
import org.apache.commons.lang3.RandomStringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ForgetPasswordSessionServiceImpl
implements ForgetPasswordSessionService {
    private static final Logger LOG = LoggerFactory.getLogger(ForgetPasswordSessionServiceImpl.class);
    @Autowired
    private ForgetPasswordSessionDao forgetPasswordSessionDao;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public ForgetPasswordSession createNewSession(String email) {
        ForgetPasswordSession session = new ForgetPasswordSession();
        session.setEmail(email);
        session.setGuid(UUIDGenerator.getRandomUUID());
        session.setCreateDate(new DateTime());
        session.setToken(RandomStringUtils.randomAlphanumeric((int)25));
        ForgetPasswordSession newSession = (ForgetPasswordSession)this.forgetPasswordSessionDao.saveAndFlush((Object)session);
        return newSession;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, readOnly=false)
    public void removeAllSession(String email) {
        this.forgetPasswordSessionDao.deleteByEmail(email);
    }

    public ForgetPasswordSession getLatestSession(String email) {
        ForgetPasswordSession session = this.forgetPasswordSessionDao.findFirstByEmailOrderByCreatedateDesc(email);
        LOG.debug("find first session by email order by create date desc : {} ", (Object)session);
        return session;
    }
}

