/*
 * Decompiled with CFR 0.152.
 */
package com.penpower.worldcard.team.service.impl;

import com.penpower.worldcard.team.Utils.GlobalUtils;
import com.penpower.worldcard.team.contactsystem.CustomExchangeService;
import com.penpower.worldcard.team.contactsystem.exchange.vo.contact.ExchangeContactBasicInfo;
import com.penpower.worldcard.team.contactsystem.exchange.vo.contact.ExchangeContactWithPicture;
import com.penpower.worldcard.team.dto.ContactInfoForResponse;
import com.penpower.worldcard.team.dto.ContactServerSettingsDtoFull;
import com.penpower.worldcard.team.dto.ContactaddressInfo;
import com.penpower.worldcard.team.dto.ContactimageInfo;
import com.penpower.worldcard.team.dto.ContactjobinfoInfo;
import com.penpower.worldcard.team.dto.ContactnameInfo;
import com.penpower.worldcard.team.dto.ContactphoneInfo;
import com.penpower.worldcard.team.enums.ContactDateType;
import com.penpower.worldcard.team.enums.ContactFieldType;
import com.penpower.worldcard.team.enums.ContactImageType;
import com.penpower.worldcard.team.enums.ContactPhoneType;
import com.penpower.worldcard.team.enums.ContactUrlType;
import com.penpower.worldcard.team.enums.SupportContactServer;
import com.penpower.worldcard.team.exception.ItemNotFoundException;
import com.penpower.worldcard.team.service.ContactPrivateService;
import com.penpower.worldcard.team.service.ExchangeOperationService;
import com.penpower.worldcard.team.service.impl.ExchangeOperationServiceImpl;
import com.penpower.worldcard.team.web.api.vo.ContactServerSyncInfoForContactServer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.DefaultExtendedPropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.EmailAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.MapiPropertyType;
import microsoft.exchange.webservices.data.core.enumeration.property.PhoneNumberKey;
import microsoft.exchange.webservices.data.core.enumeration.property.PhysicalAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.SortDirection;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.FileAsMapping;
import microsoft.exchange.webservices.data.core.service.item.Contact;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.ContactSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.complex.PhysicalAddressEntry;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExchangeOperationServiceImpl
implements ExchangeOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(ExchangeOperationServiceImpl.class);
    public static final ExtendedPropertyDefinition CONTACT_ID_PROPERTY_DEFINITION = new ExtendedPropertyDefinition(12299, MapiPropertyType.Binary);
    public static final ExtendedPropertyDefinition COMPANY_PRONOUNCE_PROPERTY_DEFINITION = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32814, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition PREFIX_PROPERTY_DEFINITION = new ExtendedPropertyDefinition(14853, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition FIRSTNAME_PRONOUNCE_PROPERTY_DEFINITION = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32812, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition LASTNAME_PRONOUNCE_PROPERTY_DEFINITION = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32813, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition BUSINESS_HOME_PAGE_PROPERTY_DEFINITION = new ExtendedPropertyDefinition(14929, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail1DisplayName = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32896, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail1AddressType = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32898, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail1Address = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32899, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail1OriginalDisplayName = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32900, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail1OriginalEntryId = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32901, MapiPropertyType.Binary);
    public static final ExtendedPropertyDefinition pidLidEmail2DisplayName = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32912, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail2AddressType = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32914, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail2Address = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32915, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail2OriginalDisplayName = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32916, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail2OriginalEntryId = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32917, MapiPropertyType.Binary);
    public static final ExtendedPropertyDefinition pidLidEmail3DisplayName = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32928, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail3AddressType = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32930, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail3Address = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32931, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail3OriginalDisplayName = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32932, MapiPropertyType.String);
    public static final ExtendedPropertyDefinition pidLidEmail3OriginalEntryId = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Address, 32933, MapiPropertyType.Binary);
    private static final PropertySet EWS_DEFAULT_PROPERTYSET = new PropertySet(BasePropertySet.FirstClassProperties);
    private static final PropertySet EWS_SIMPLE_PROPERTYSET = new PropertySet();
    private static final String CARD_FRONT_FILENAME = "front.jpg";
    private static final String CARD_REAR_FILENAME = "rear.jpg";
    @Autowired
    private ContactPrivateService contactPrivateService;

    public ExchangeOperationServiceImpl() throws Exception {
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)CONTACT_ID_PROPERTY_DEFINITION);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)PREFIX_PROPERTY_DEFINITION);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)COMPANY_PRONOUNCE_PROPERTY_DEFINITION);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)FIRSTNAME_PRONOUNCE_PROPERTY_DEFINITION);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)LASTNAME_PRONOUNCE_PROPERTY_DEFINITION);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)BUSINESS_HOME_PAGE_PROPERTY_DEFINITION);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)ContactSchema.HasPicture);
        EWS_DEFAULT_PROPERTYSET.add((PropertyDefinitionBase)ContactSchema.Attachments);
        EWS_DEFAULT_PROPERTYSET.setRequestedBodyType(BodyType.Text);
        EWS_DEFAULT_PROPERTYSET.addRange(Arrays.asList(pidLidEmail1DisplayName, pidLidEmail1AddressType, pidLidEmail1Address, pidLidEmail1OriginalDisplayName, pidLidEmail1OriginalEntryId));
        EWS_DEFAULT_PROPERTYSET.addRange(Arrays.asList(pidLidEmail2DisplayName, pidLidEmail2AddressType, pidLidEmail2Address, pidLidEmail2OriginalDisplayName, pidLidEmail2OriginalEntryId));
        EWS_DEFAULT_PROPERTYSET.addRange(Arrays.asList(pidLidEmail3DisplayName, pidLidEmail3AddressType, pidLidEmail3Address, pidLidEmail3OriginalDisplayName, pidLidEmail3OriginalEntryId));
        EWS_SIMPLE_PROPERTYSET.add((PropertyDefinitionBase)CONTACT_ID_PROPERTY_DEFINITION);
        EWS_SIMPLE_PROPERTYSET.add((PropertyDefinitionBase)ItemSchema.LastModifiedTime);
    }

    private String getExchangeIdEncodeSearchKey(String contactServerId) throws DecoderException {
        return Base64.getEncoder().encodeToString(Hex.decodeHex((char[])contactServerId.toCharArray()));
    }

    public ExchangeContactBasicInfo createContactRecord(ContactInfoForResponse contactInfo, CustomExchangeService exchangeService) throws Exception {
        Contact contact = new Contact((ExchangeService)exchangeService);
        contact = this.getExchangeContactFromWCTContactInfo(contact, contactInfo);
        contact.save();
        contact.load(EWS_SIMPLE_PROPERTYSET);
        Optional<byte[]> contactServerIdByteOptional = contact.getExtendedProperties().getItems().stream().filter(i -> i.getPropertyDefinition().equals((Object)CONTACT_ID_PROPERTY_DEFINITION)).map(i -> (byte[])i.getValue()).findFirst();
        String contactServerId = Hex.encodeHexString((byte[])contactServerIdByteOptional.get());
        DateTime contactServerModifyTime = new DateTime((Object)contact.getLastModifiedTime());
        return new ExchangeContactBasicInfo(contactServerId, contactServerModifyTime, false, (Item)contact);
    }

    public ExchangeContactBasicInfo findContactRecord(String contactServerId, boolean needFindDeletedItem, CustomExchangeService exchangeService) throws Exception {
        SearchFilter.IsEqualTo searchFilter = new SearchFilter.IsEqualTo((PropertyDefinitionBase)CONTACT_ID_PROPERTY_DEFINITION, (Object)this.getExchangeIdEncodeSearchKey(contactServerId));
        ItemView itemView = new ItemView(1);
        itemView.setPropertySet(EWS_SIMPLE_PROPERTYSET);
        FindItemsResults contactResults = exchangeService.findItems(WellKnownFolderName.Contacts, (SearchFilter)searchFilter, itemView);
        if (CollectionUtils.isNotEmpty((Collection)contactResults.getItems())) {
            Item item = (Item)contactResults.getItems().get(0);
            DateTime lastModifiedTime = new DateTime((Object)item.getLastModifiedTime());
            return new ExchangeContactBasicInfo(contactServerId, lastModifiedTime, false, item);
        }
        if (needFindDeletedItem) {
            FindItemsResults deletedResults = exchangeService.findItems(WellKnownFolderName.DeletedItems, (SearchFilter)searchFilter, itemView);
            if (CollectionUtils.isNotEmpty((Collection)deletedResults.getItems())) {
                Item item = (Item)deletedResults.getItems().get(0);
                DateTime lastModifiedTime = new DateTime((Object)item.getLastModifiedTime());
                return new ExchangeContactBasicInfo(contactServerId, lastModifiedTime, true, item);
            }
            FindItemsResults recoverableResults = exchangeService.findItems(WellKnownFolderName.RecoverableItemsDeletions, (SearchFilter)searchFilter, itemView);
            if (CollectionUtils.isNotEmpty((Collection)recoverableResults.getItems())) {
                Item item = (Item)recoverableResults.getItems().get(0);
                DateTime lastModifiedTime = new DateTime((Object)item.getLastModifiedTime());
                return new ExchangeContactBasicInfo(contactServerId, lastModifiedTime, true, item);
            }
        }
        return null;
    }

    public boolean deleteContactRecord(Item item, CustomExchangeService exchangeService) throws Exception {
        item.delete(DeleteMode.MoveToDeletedItems);
        return true;
    }

    public List<ContactServerSyncInfoForContactServer> findModifiedContactRecordsSyncInfosAfterSpecifiedTime(DateTime lastTime, boolean needFindDeletedItem, String exchangeAccountUniqueId, CustomExchangeService exchangeService) throws Exception {
        ArrayList<ContactServerSyncInfoForContactServer> syncInfos = new ArrayList<ContactServerSyncInfoForContactServer>();
        SearchFilter.IsGreaterThan searchFilter = new SearchFilter.IsGreaterThan((PropertyDefinitionBase)ItemSchema.LastModifiedTime, (Object)lastTime.toString());
        syncInfos.addAll(this.searchExchangeContact(WellKnownFolderName.Contacts, searchFilter, exchangeAccountUniqueId, exchangeService));
        if (needFindDeletedItem) {
            syncInfos.addAll(this.searchExchangeContact(WellKnownFolderName.DeletedItems, searchFilter, exchangeAccountUniqueId, exchangeService));
            syncInfos.addAll(this.searchExchangeContact(WellKnownFolderName.RecoverableItemsDeletions, searchFilter, exchangeAccountUniqueId, exchangeService));
        }
        LOG.debug("getExchangeModifiedContactRecordsAfterSpecifiedTime={}", syncInfos);
        syncInfos.sort((p1, p2) -> p1.getModifiedTime().compareTo((ReadableInstant)p2.getModifiedTime()));
        return syncInfos;
    }

    private List<ContactServerSyncInfoForContactServer> searchExchangeContact(WellKnownFolderName foldername, SearchFilter.IsGreaterThan searchFilter, String account, CustomExchangeService exchangeService) throws Exception {
        ArrayList<ContactServerSyncInfoForContactServer> syncInfos = new ArrayList<ContactServerSyncInfoForContactServer>();
        Integer pageOffset = 0;
        while (pageOffset != null) {
            ItemView view = new ItemView(100, pageOffset.intValue());
            view.getOrderBy().add((PropertyDefinitionBase)ItemSchema.LastModifiedTime, SortDirection.Ascending);
            view.setPropertySet(EWS_SIMPLE_PROPERTYSET);
            FindItemsResults results = exchangeService.findItems(foldername, (SearchFilter)searchFilter, view);
            for (Item item : results.getItems()) {
                if (!(item instanceof Contact)) continue;
                String contactServerId = null;
                try {
                    Optional<byte[]> contactServerIdByteOptional = item.getExtendedProperties().getItems().stream().filter(i -> i.getPropertyDefinition().equals((Object)CONTACT_ID_PROPERTY_DEFINITION)).map(i -> (byte[])i.getValue()).findFirst();
                    contactServerId = Hex.encodeHexString((byte[])contactServerIdByteOptional.get());
                }
                catch (Exception ex) {
                    LOG.error("can't find contact server unique id", (Throwable)ex);
                    continue;
                }
                DateTime dateTime = item.getLastModifiedTime() == null ? GlobalUtils.getEarliestTime() : new DateTime((Object)item.getLastModifiedTime());
                switch (1.$SwitchMap$microsoft$exchange$webservices$data$core$enumeration$property$WellKnownFolderName[foldername.ordinal()]) {
                    case 1: {
                        syncInfos.add(new ContactServerSyncInfoForContactServer(contactServerId, false, dateTime, account));
                        break;
                    }
                    case 2: {
                        syncInfos.add(new ContactServerSyncInfoForContactServer(contactServerId, true, dateTime, account));
                        break;
                    }
                    case 3: {
                        syncInfos.add(new ContactServerSyncInfoForContactServer(contactServerId, true, dateTime, account));
                        break;
                    }
                }
            }
            pageOffset = results.getNextPageOffset();
        }
        return syncInfos;
    }

    public ExchangeContactBasicInfo updateContactRecord(Item item, ContactInfoForResponse contactInfo, CustomExchangeService exchangeService) throws Exception {
        Contact contact = (Contact)item;
        contact.load(EWS_DEFAULT_PROPERTYSET);
        contact = this.getExchangeContactFromWCTContactInfo(contact, contactInfo);
        contact.update(ConflictResolutionMode.AlwaysOverwrite);
        contact.load(EWS_SIMPLE_PROPERTYSET);
        Optional<byte[]> contactServerIdByteOptional = contact.getExtendedProperties().getItems().stream().filter(i -> i.getPropertyDefinition().equals((Object)CONTACT_ID_PROPERTY_DEFINITION)).map(i -> (byte[])i.getValue()).findFirst();
        String contactServerId = Hex.encodeHexString((byte[])contactServerIdByteOptional.get());
        DateTime contactServerModifyTime = new DateTime((Object)contact.getLastModifiedTime());
        return new ExchangeContactBasicInfo(contactServerId, contactServerModifyTime, false, (Item)contact);
    }

    private Contact getExchangeContactFromWCTContactInfo(Contact contact, ContactInfoForResponse contactInfo) throws Exception {
        Optional<Date> celebrationOptional;
        List names;
        boolean needRemoveEmail3;
        contact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Business, null);
        contact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Home, null);
        contact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Other, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.Pager, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessFax, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessPhone, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessPhone2, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.MobilePhone, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomeFax, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomePhone, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomePhone2, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.PrimaryPhone, null);
        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.OtherTelephone, null);
        contact.setBirthday(null);
        contact.setWeddingAnniversary(null);
        contact.setGivenName("");
        contact.setSurname(null);
        contact.setMiddleName(null);
        contact.setDisplayName("");
        contact.setSubject("");
        contact.setFileAs(FileAsMapping.GivenNameSpaceSurname);
        contact.setCompanyName(null);
        contact.setJobTitle(null);
        contact.setDepartment(null);
        contact.setNickName(contactInfo.getNickname());
        contact.setBody(new MessageBody(BodyType.Text, contactInfo.getNote()));
        List contactaddressInfos = contactInfo.getAddresses();
        for (ContactaddressInfo address : contactaddressInfos) {
            ContactFieldType type = address.getType();
            PhysicalAddressEntry paEntry1 = new PhysicalAddressEntry();
            paEntry1.setStreet(address.getStreet());
            paEntry1.setCity(address.getCity());
            paEntry1.setState(address.getState());
            paEntry1.setPostalCode(address.getZip());
            paEntry1.setCountryOrRegion(address.getCountryName());
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactFieldType[type.ordinal()]) {
                case 1: {
                    if (contact.getPhysicalAddresses().contains((Object)PhysicalAddressKey.Business)) break;
                    contact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Business, paEntry1);
                    break;
                }
                case 2: {
                    if (contact.getPhysicalAddresses().contains((Object)PhysicalAddressKey.Home)) break;
                    contact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Home, paEntry1);
                    break;
                }
                case 3: {
                    if (contact.getPhysicalAddresses().contains((Object)PhysicalAddressKey.Other)) break;
                    contact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Other, paEntry1);
                    break;
                }
            }
        }
        List emails = contactInfo.getEmails().stream().filter(e -> e.getType().equals((Object)ContactFieldType.BUSINESS)).map(e -> new EmailAddress(e.getValue())).limit(3L).collect(Collectors.toList());
        int wctEmailSize = emails.size();
        for (int i = 0; i < wctEmailSize; ++i) {
            contact.getEmailAddresses().setEmailAddress(EmailAddressKey.values()[i], (EmailAddress)emails.get(i));
        }
        boolean needRemoveEmail1 = wctEmailSize == 0;
        boolean needRemoveEmail2 = wctEmailSize == 0 || wctEmailSize == 1;
        boolean bl = needRemoveEmail3 = wctEmailSize == 0 || wctEmailSize == 1 || wctEmailSize == 2;
        if (needRemoveEmail1) {
            contact.removeExtendedProperty(pidLidEmail1DisplayName);
            contact.removeExtendedProperty(pidLidEmail1AddressType);
            contact.removeExtendedProperty(pidLidEmail1Address);
            contact.removeExtendedProperty(pidLidEmail1OriginalDisplayName);
            contact.removeExtendedProperty(pidLidEmail1OriginalEntryId);
        }
        if (needRemoveEmail2) {
            contact.removeExtendedProperty(pidLidEmail2DisplayName);
            contact.removeExtendedProperty(pidLidEmail2AddressType);
            contact.removeExtendedProperty(pidLidEmail2Address);
            contact.removeExtendedProperty(pidLidEmail2OriginalDisplayName);
            contact.removeExtendedProperty(pidLidEmail2OriginalEntryId);
        }
        if (needRemoveEmail3) {
            contact.removeExtendedProperty(pidLidEmail3DisplayName);
            contact.removeExtendedProperty(pidLidEmail3AddressType);
            contact.removeExtendedProperty(pidLidEmail3Address);
            contact.removeExtendedProperty(pidLidEmail3OriginalDisplayName);
            contact.removeExtendedProperty(pidLidEmail3OriginalEntryId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(names = contactInfo.getNames()))) {
            ContactnameInfo contactnameInfo = (ContactnameInfo)names.get(0);
            contact.setGivenName(contactnameInfo.getFirstName());
            contact.setSurname(contactnameInfo.getLastName());
            contact.setMiddleName(contactnameInfo.getMiddleName());
            contact.setDisplayName(contactnameInfo.getFirstName() + " " + contactnameInfo.getLastName());
            contact.setSubject(contactnameInfo.getFirstName() + " " + contactnameInfo.getLastName());
            contact.setFileAs(FileAsMapping.GivenNameSpaceSurname);
            if (StringUtils.isNotEmpty((CharSequence)contactnameInfo.getPrefix())) {
                contact.setExtendedProperty(PREFIX_PROPERTY_DEFINITION, (Object)contactnameInfo.getPrefix());
            } else {
                contact.removeExtendedProperty(PREFIX_PROPERTY_DEFINITION);
            }
            if (StringUtils.isNotEmpty((CharSequence)contactnameInfo.getFirstNamePronunce())) {
                contact.setExtendedProperty(FIRSTNAME_PRONOUNCE_PROPERTY_DEFINITION, (Object)contactnameInfo.getFirstNamePronunce());
            } else {
                contact.removeExtendedProperty(FIRSTNAME_PRONOUNCE_PROPERTY_DEFINITION);
            }
            if (StringUtils.isNotEmpty((CharSequence)contactnameInfo.getLastNamePronunce())) {
                contact.setExtendedProperty(LASTNAME_PRONOUNCE_PROPERTY_DEFINITION, (Object)contactnameInfo.getLastNamePronunce());
            } else {
                contact.removeExtendedProperty(LASTNAME_PRONOUNCE_PROPERTY_DEFINITION);
            }
        } else {
            contact.removeExtendedProperty(PREFIX_PROPERTY_DEFINITION);
            contact.removeExtendedProperty(FIRSTNAME_PRONOUNCE_PROPERTY_DEFINITION);
            contact.removeExtendedProperty(LASTNAME_PRONOUNCE_PROPERTY_DEFINITION);
        }
        DateTime birthDay = contactInfo.getBirthday();
        if (birthDay != null) {
            contact.setBirthday(new Date(birthDay.getMillis()));
        }
        if ((celebrationOptional = contactInfo.getDates().stream().filter(d -> d.getType().equals((Object)ContactDateType.CELEBRATION)).map(d -> new Date(d.getValue().getMillis())).findFirst()).isPresent()) {
            contact.setWeddingAnniversary(celebrationOptional.get());
        }
        if (CollectionUtils.isNotEmpty((Collection)contactInfo.getJobinfos())) {
            ContactjobinfoInfo contactjobinfoInfo = (ContactjobinfoInfo)contactInfo.getJobinfos().get(0);
            contact.setCompanyName(contactjobinfoInfo.getCompanyName());
            contact.setJobTitle(contactjobinfoInfo.getJobTitle());
            contact.setDepartment(contactjobinfoInfo.getDepartment());
            if (StringUtils.isNotEmpty((CharSequence)contactjobinfoInfo.getCompanyPronunce())) {
                contact.setExtendedProperty(COMPANY_PRONOUNCE_PROPERTY_DEFINITION, (Object)contactjobinfoInfo.getCompanyPronunce());
            } else {
                contact.removeExtendedProperty(COMPANY_PRONOUNCE_PROPERTY_DEFINITION);
            }
        } else {
            contact.removeExtendedProperty(COMPANY_PRONOUNCE_PROPERTY_DEFINITION);
        }
        List contactimageInfos = contactInfo.getImages();
        contact.getAttachments().clear();
        for (ContactimageInfo contactimageInfo : contactimageInfos) {
            ContactImageType type = contactimageInfo.getType();
            byte[] imageByte = null;
            try {
                imageByte = this.contactPrivateService.getImageContent(contactInfo.getGuid(), type);
            }
            catch (ItemNotFoundException ex) {
                continue;
            }
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactImageType[type.ordinal()]) {
                case 1: {
                    contact.getAttachments().addFileAttachment(CARD_FRONT_FILENAME, imageByte);
                    break;
                }
                case 2: {
                    contact.setContactPicture(imageByte);
                    break;
                }
                case 3: {
                    contact.getAttachments().addFileAttachment(CARD_REAR_FILENAME, imageByte);
                    break;
                }
            }
        }
        List contactphoneInfos = contactInfo.getPhones();
        block25: for (int i = 0; i < contactphoneInfos.size(); ++i) {
            ContactPhoneType contactPhoneType = ((ContactphoneInfo)contactphoneInfos.get(i)).getType();
            String phoneNumber = ((ContactphoneInfo)contactphoneInfos.get(i)).getValue();
            switch (1.$SwitchMap$com$penpower$worldcard$team$enums$ContactPhoneType[contactPhoneType.ordinal()]) {
                case 1: {
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.Pager)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.Pager, phoneNumber);
                    continue block25;
                }
                case 2: {
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.BusinessFax)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessFax, phoneNumber);
                    continue block25;
                }
                case 3: {
                    if (!contact.getPhoneNumbers().contains((Object)PhoneNumberKey.BusinessPhone)) {
                        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessPhone, phoneNumber);
                        continue block25;
                    }
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.BusinessPhone2)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessPhone2, phoneNumber);
                    continue block25;
                }
                case 4: {
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.MobilePhone)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.MobilePhone, phoneNumber);
                    continue block25;
                }
                case 5: {
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.HomeFax)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomeFax, phoneNumber);
                    continue block25;
                }
                case 6: {
                    if (!contact.getPhoneNumbers().contains((Object)PhoneNumberKey.HomePhone)) {
                        contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomePhone, phoneNumber);
                        continue block25;
                    }
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.HomePhone2)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomePhone2, phoneNumber);
                    continue block25;
                }
                case 7: {
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.PrimaryPhone)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.PrimaryPhone, phoneNumber);
                    continue block25;
                }
                case 8: {
                    if (contact.getPhoneNumbers().contains((Object)PhoneNumberKey.OtherTelephone)) continue block25;
                    contact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.OtherTelephone, phoneNumber);
                    continue block25;
                }
            }
        }
        Optional<String> personalUrl = contactInfo.getUrls().stream().filter(url -> url.getType().equals((Object)ContactUrlType.BUSINESS)).map(url -> url.getValue()).findFirst();
        if (personalUrl.isPresent()) {
            contact.setExtendedProperty(BUSINESS_HOME_PAGE_PROPERTY_DEFINITION, (Object)personalUrl.get());
        } else {
            contact.removeExtendedProperty(BUSINESS_HOME_PAGE_PROPERTY_DEFINITION);
        }
        return contact;
    }

    public ExchangeContactWithPicture findContactRecordDetailWithPicture(String contactServerId, CustomExchangeService exchangeService) throws Exception {
        Item item;
        FindItemsResults results = exchangeService.findItems(WellKnownFolderName.Contacts, (SearchFilter)new SearchFilter.IsEqualTo((PropertyDefinitionBase)CONTACT_ID_PROPERTY_DEFINITION, (Object)this.getExchangeIdEncodeSearchKey(contactServerId)), new ItemView(1));
        if (CollectionUtils.isNotEmpty((Collection)results.getItems()) && (item = (Item)results.getItems().get(0)) instanceof Contact) {
            Contact contact = Contact.bind((ExchangeService)exchangeService, (ItemId)item.getId(), (PropertySet)EWS_DEFAULT_PROPERTYSET);
            if (contact.getContactPictureAttachment() != null) {
                contact.getContactPictureAttachment().load();
                byte[] imageContent = contact.getContactPictureAttachment().getContent();
                if (imageContent != null && imageContent.length > 0) {
                    return new ExchangeContactWithPicture(contact, imageContent, true);
                }
            }
            return new ExchangeContactWithPicture(contact, null, false);
        }
        return null;
    }

    public CustomExchangeService getExchangeCredentialOfService(ContactServerSettingsDtoFull contactServerSetting) throws URISyntaxException {
        CustomExchangeService exchangeService = null;
        if (SupportContactServer.EXCHANGE.equals((Object)contactServerSetting.getSupportContactServer())) {
            exchangeService = new CustomExchangeService();
            String serverUrl = String.format("https://%s/EWS/Exchange.asmx", contactServerSetting.getServerUrl());
            exchangeService.setUrl(new URI(serverUrl));
            String account = contactServerSetting.getAccount();
            String password = contactServerSetting.getPassword();
            if (GlobalUtils.isAdAccountPattern((String)contactServerSetting.getAccount())) {
                LOG.debug("account={} is ad account Pattern", (Object)contactServerSetting.getAccount());
                String separator = "\\";
                String[] accountAndDomain = account.split(Pattern.quote(separator));
                exchangeService.setCredentials((ExchangeCredentials)new WebCredentials(accountAndDomain[1], password, accountAndDomain[0]));
            } else {
                exchangeService.setCredentials((ExchangeCredentials)new WebCredentials(account, password));
            }
            exchangeService.setTimeout(900000);
            return exchangeService;
        }
        return null;
    }
}

